/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.encryption.client.service;

import com.anfcorp.stores.encryption.client.service.StoresSecurityException;
import com.anfcorp.stores.encryption.client.service.StoresSecurityService;
import com.anfcorp.stores.encryption.client.service.StoresSecurityServiceImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;

public class StoresSecurityHelper {
    private static StoresSecurityHelper storesSecurityHelper = null;
    private StoresSecurityService secureService = new StoresSecurityServiceImpl();

    private StoresSecurityHelper() {
    }

    public static StoresSecurityHelper getInstance() {
        if (storesSecurityHelper == null) {
            storesSecurityHelper = new StoresSecurityHelper();
            return storesSecurityHelper;
        }
        return storesSecurityHelper;
    }

    public String hash(String strToHash) throws StoresSecurityException {
        return this.secureService.hash(strToHash);
    }

    public SecretKeySpec getKeySpec(File file) throws StoresSecurityException {
        return this.secureService.getKeySpec(file);
    }

    public String encrypt(List<SecretKeySpec> secretKeySpecList, String strToEncrypt) throws StoresSecurityException {
        return this.secureService.encrypt(secretKeySpecList, strToEncrypt);
    }

    public String decrypt(List<SecretKeySpec> secretKeySpecList, String strToDecrypt) throws StoresSecurityException {
        return this.secureService.decrypt(secretKeySpecList, strToDecrypt);
    }

    public ArrayList<SecretKeySpec> getKeySpecList(File file) throws StoresSecurityException {
        return this.secureService.getKeySpecList(file);
    }
}

