/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.utils.CSSDataURLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDataURL {
    private IMimeType m_aMimeType;
    private final boolean m_bBase64Encoded;
    private final byte[] m_aContent;
    private final Charset m_aCharset;
    private String m_sContent;

    @Nonnull
    public static Charset getCharsetFromMimeTypeOrDefault(@Nullable IMimeType iMimeType) {
        Charset charset = MimeTypeHelper.getCharsetFromMimeType((IMimeType)iMimeType);
        return charset != null ? charset : CSSDataURLHelper.DEFAULT_CHARSET;
    }

    public CSSDataURL() {
        this((IMimeType)CSSDataURLHelper.DEFAULT_MIME_TYPE.getClone(), false, new byte[0], CSSDataURLHelper.DEFAULT_CHARSET, "");
    }

    public CSSDataURL(@Nonnull IMimeType iMimeType, boolean bl, @Nonnull byte[] byArray) {
        this(iMimeType, bl, byArray, CSSDataURL.getCharsetFromMimeTypeOrDefault(iMimeType), null);
    }

    public CSSDataURL(@Nonnull IMimeType iMimeType, boolean bl, @Nonnull byte[] byArray, @Nonnull Charset charset, @Nullable String string) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        ValueEnforcer.notNull((Object)byArray, (String)"Content");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        Charset charset2 = MimeTypeHelper.getCharsetFromMimeType((IMimeType)iMimeType);
        if (charset2 == null) {
            this.m_aMimeType = !charset.equals(CSSDataURLHelper.DEFAULT_CHARSET) ? ((MimeType)iMimeType.getClone()).addParameter("charset", charset.name()) : iMimeType;
        } else {
            if (!charset2.equals(charset)) {
                throw new IllegalArgumentException("The provided charset '" + charset.name() + "' differs from the charset in the MIME type: '" + charset2.name() + "'");
            }
            this.m_aMimeType = iMimeType;
        }
        this.m_bBase64Encoded = bl;
        this.m_aContent = ArrayHelper.getCopy((byte[])byArray);
        this.m_aCharset = charset;
        this.m_sContent = string;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    public boolean isBase64Encoded() {
        return this.m_bBase64Encoded;
    }

    @Nonnegative
    public int getContentLength() {
        return this.m_aContent.length;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aContent);
    }

    public void writeContentBytes(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        outputStream.write(this.m_aContent, 0, this.m_aContent.length);
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public String getContentAsString() {
        if (this.m_sContent == null) {
            this.m_sContent = new String(this.m_aContent, this.m_aCharset);
        }
        return this.m_sContent;
    }

    @Nonnull
    public String getContentAsBase64EncodedString() {
        byte[] byArray = Base64.encodeBytesToBytes((byte[])this.m_aContent);
        return new String(byArray, this.m_aCharset);
    }

    @Nonnull
    public String getContentAsString(@Nonnull Charset charset) {
        if (this.m_aCharset.equals(charset)) {
            return this.getContentAsString();
        }
        return new String(this.m_aContent, charset);
    }

    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("data:");
        if (bl) {
            if (!this.m_aMimeType.equals((Object)CSSDataURLHelper.DEFAULT_MIME_TYPE)) {
                if (this.m_aMimeType.getAsStringWithoutParameters().equals(CSSDataURLHelper.DEFAULT_MIME_TYPE.getAsStringWithoutParameters())) {
                    stringBuilder.append(this.m_aMimeType.getParametersAsString(CSSDataURLHelper.MIME_QUOTING));
                } else {
                    stringBuilder.append(this.m_aMimeType.getAsString(CSSDataURLHelper.MIME_QUOTING));
                }
            }
        } else {
            stringBuilder.append(this.m_aMimeType.getAsString(CSSDataURLHelper.MIME_QUOTING));
        }
        if (this.m_bBase64Encoded && (this.m_aContent.length > 0 || !bl)) {
            stringBuilder.append(";base64");
        }
        stringBuilder.append(',');
        if (this.m_aContent.length > 0) {
            if (this.m_bBase64Encoded) {
                stringBuilder.append(this.getContentAsBase64EncodedString());
            } else {
                stringBuilder.append(this.getContentAsString());
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSDataURL cSSDataURL = (CSSDataURL)object;
        return this.m_aMimeType.equals((Object)cSSDataURL.m_aMimeType) && this.m_bBase64Encoded == cSSDataURL.m_bBase64Encoded && EqualsHelper.equals((Object)this.m_aContent, (Object)cSSDataURL.m_aContent) && this.m_aCharset.equals(cSSDataURL.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aMimeType).append(this.m_bBase64Encoded).append(this.m_aContent).append((Object)this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mimeType", (Object)this.m_aMimeType).append("base64Encoded", this.m_bBase64Encoded).append("content.length", this.m_aContent.length).append("charset", (Object)this.m_aCharset).append("hasStringContent", this.m_sContent != null).getToString();
    }
}

