/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DdlBuilderFactory;
import org.jumpmind.db.platform.DmlStatementFactory;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.util.Statistics;

public class StructureDataWriter
implements IDataWriter {
    protected IDatabasePlatform platform;
    protected Table currentTable;
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();
    protected Map<Long, List<String>> payloadMap = new HashMap<Long, List<String>>();
    protected PayloadType payloadType = PayloadType.SQL;
    protected long currentBatch;
    protected String targetDatabaseName;
    protected boolean useQuotedIdentifiers;
    protected boolean useJdbcTimestampFormat;
    protected boolean useUpsertStatements;
    protected BinaryEncoding binaryEncoding;

    public StructureDataWriter(IDatabasePlatform platform, String targetDatabaseName, PayloadType payloatType, boolean useQuotedIdentifiers, BinaryEncoding binaryEncoding, boolean useJdbcTimestampFormat, boolean useUpsertStatements) {
        this.platform = platform;
        this.payloadType = payloatType;
        this.targetDatabaseName = targetDatabaseName;
        this.useQuotedIdentifiers = useQuotedIdentifiers;
        this.binaryEncoding = binaryEncoding;
        this.useJdbcTimestampFormat = useJdbcTimestampFormat;
        this.useUpsertStatements = useUpsertStatements;
    }

    @Override
    public void open(DataContext context) {
    }

    @Override
    public void close() {
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }

    @Override
    public void start(Batch batch) {
        ArrayList payloadData = new ArrayList();
        this.currentBatch = batch.getBatchId();
        this.statistics.put(batch, new Statistics());
        this.payloadMap.put(this.currentBatch, payloadData);
    }

    @Override
    public boolean start(Table table) {
        this.currentTable = this.platform.getTableFromCache(table.getOldCatalog(), table.getOldSchema(), table.getName(), false);
        if (this.currentTable != null) {
            this.currentTable = this.currentTable.copyAndFilterColumns(table.getColumnNames(), table.getPrimaryKeyColumnNames(), true, false);
            this.currentTable.setSchema(table.getSchema());
            this.currentTable.setCatalog(table.getCatalog());
            this.currentTable.setName(table.getName());
            return true;
        }
        return false;
    }

    @Override
    public void write(CsvData data) {
        String sql = null;
        switch (data.getDataEventType()) {
            case UPDATE: {
                sql = this.buildSql(this.useUpsertStatements ? DmlStatement.DmlType.UPSERT : DmlStatement.DmlType.UPDATE, data.getParsedData("rowData"), this.currentTable.getColumns());
                break;
            }
            case INSERT: {
                sql = this.buildSql(this.useUpsertStatements ? DmlStatement.DmlType.UPSERT : DmlStatement.DmlType.INSERT, data.getParsedData("rowData"), this.currentTable.getColumns());
                break;
            }
            case DELETE: {
                sql = this.buildSql(DmlStatement.DmlType.DELETE, data.getParsedData("pkData"), this.currentTable.getPrimaryKeyColumns());
                break;
            }
            case SQL: {
                sql = data.getParsedData("rowData")[0];
                break;
            }
            case CREATE: {
                IDdlBuilder builder = DdlBuilderFactory.getInstance().create(this.targetDatabaseName);
                sql = builder.createTable(this.currentTable);
                break;
            }
        }
        if (sql != null) {
            this.payloadMap.get(this.currentBatch).add(sql);
        }
    }

    protected String buildSql(DmlStatement.DmlType dmlType, String[] values, Column[] columns) {
        DmlStatementOptions options = new DmlStatementOptions(dmlType, this.currentTable).quotedIdentifiers(this.useQuotedIdentifiers);
        DmlStatement statement = DmlStatementFactory.getInstance().create(this.targetDatabaseName, options);
        Object[] objects = this.platform.getObjectValues(this.binaryEncoding, values, columns, false, false);
        Row row = new Row(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            row.put(columns[i].getName(), objects[i]);
        }
        return statement.buildDynamicSql(this.binaryEncoding, row, false, this.useJdbcTimestampFormat);
    }

    @Override
    public void end(Table table) {
    }

    @Override
    public void end(Batch batch, boolean inError) {
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }

    public Map<Long, List<String>> getPayloadMap() {
        return this.payloadMap;
    }

    public void setPayloadMap(Map<Long, List<String>> payloadMap) {
        this.payloadMap = payloadMap;
    }

    public static enum PayloadType {
        CSV,
        SQL;

    }
}

