/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.util.Statistics;

public class DynamicDefaultDatabaseWriter
extends DefaultDatabaseWriter {
    protected IDatabasePlatform targetPlatform;
    protected ISqlTransaction targetTransaction;
    protected String tablePrefix;

    public DynamicDefaultDatabaseWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix) {
        super(symmetricPlatform);
        this.tablePrefix = prefix.toLowerCase();
        this.targetPlatform = targetPlatform;
    }

    public DynamicDefaultDatabaseWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix, DatabaseWriterSettings settings) {
        super(symmetricPlatform, null, settings);
        this.tablePrefix = prefix.toLowerCase();
        this.targetPlatform = targetPlatform;
    }

    public DynamicDefaultDatabaseWriter(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix, IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings) {
        super(symmetricPlatform, conflictResolver, settings);
        this.tablePrefix = prefix.toLowerCase();
        this.targetPlatform = targetPlatform;
    }

    protected boolean isSymmetricTable(Table table) {
        return table != null && table.getNameLowerCase().startsWith(this.tablePrefix);
    }

    protected boolean isSymmetricTable(String tableName) {
        return tableName.toLowerCase().startsWith(this.tablePrefix);
    }

    public boolean isLoadOnly() {
        return !this.platform.equals(this.targetPlatform);
    }

    @Override
    public IDatabasePlatform getPlatform(Table table) {
        if (table == null) {
            table = this.targetTable;
        }
        return table == null || this.platform == this.targetPlatform || this.isSymmetricTable(table) ? this.platform : this.targetPlatform;
    }

    @Override
    public IDatabasePlatform getPlatform(String table) {
        table = table == null ? this.targetTable.getNameLowerCase() : table.toLowerCase();
        return table == null || this.platform == this.targetPlatform || this.isSymmetricTable(table) ? this.platform : this.targetPlatform;
    }

    @Override
    public IDatabasePlatform getPlatform() {
        return this.targetTable == null || this.platform == this.targetPlatform || this.isSymmetricTable(this.targetTable) ? this.platform : this.targetPlatform;
    }

    @Override
    public IDatabasePlatform getTargetPlatform() {
        return this.targetPlatform == null ? this.platform : this.targetPlatform;
    }

    @Override
    public ISqlTransaction getTransaction() {
        return this.targetTable == null || this.targetTransaction == null || this.isSymmetricTable(this.targetTable) ? this.transaction : this.targetTransaction;
    }

    @Override
    public ISqlTransaction getTransaction(Table table) {
        if (this.targetTransaction == null) {
            return this.transaction;
        }
        if (table == null) {
            table = this.targetTable;
        }
        return table == null || this.isSymmetricTable(table) ? this.transaction : this.targetTransaction;
    }

    @Override
    public ISqlTransaction getTransaction(String table) {
        if (this.targetTransaction == null) {
            return this.transaction;
        }
        if (table == null) {
            table = this.targetTable.getNameLowerCase();
        }
        return table == null || this.isSymmetricTable(table) ? this.transaction : this.targetTransaction;
    }

    @Override
    public ISqlTransaction getTargetTransaction() {
        return this.targetTransaction == null ? this.transaction : this.targetTransaction;
    }

    @Override
    public void open(DataContext context) {
        super.open(context);
        if (this.isLoadOnly()) {
            this.targetTransaction = this.targetPlatform.getSqlTemplate().startSqlTransaction(!this.targetPlatform.supportsTransactions());
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.isLoadOnly() && this.targetTransaction != null) {
            this.targetTransaction.close();
        }
    }

    @Override
    protected void commit(boolean earlyCommit) {
        super.commit(earlyCommit);
        if (this.isLoadOnly() && this.targetTransaction != null) {
            try {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                this.targetTransaction.commit();
                if (!earlyCommit) {
                    this.notifyFiltersBatchCommitted();
                } else {
                    this.notifyFiltersEarlyCommit();
                }
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
            }
        }
    }

    @Override
    protected void rollback() {
        super.rollback();
        if (this.isLoadOnly() && this.targetTransaction != null) {
            try {
                ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                this.targetTransaction.rollback();
                this.notifyFiltersBatchRolledback();
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
            }
        }
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

