/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TableColumnSourceReferences;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.TableNotFoundException;
import org.jumpmind.exception.ParseException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.ConflictException;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DefaultDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.IgnoreBatchException;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseWriter
implements IDataWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabaseWriter.class);
    public static final String CONFLICT_ERROR = "DatabaseWriter.ConflictError";
    public static final String TRANSACTION_ABORTED = "DatabaseWriter.TransactionAborted";
    public static final String CONFLICT_IGNORE = "DatabaseWriter.ConflictIgnore";
    protected boolean lastUseConflictDetection = true;
    protected boolean lastApplyChangesOnly = false;
    protected boolean isRequiresSavePointsInTransaction = false;
    protected Table sourceTable;
    protected Table targetTable;
    protected Map<String, Table> targetTables = new HashMap<String, Table>();
    protected CsvData lastData;
    protected Batch batch;
    protected DataContext context;
    protected long uncommittedCount = 0L;
    protected DatabaseWriterSettings writerSettings;
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();
    protected IDatabaseWriterConflictResolver conflictResolver;
    protected Set<String> missingTables = new HashSet<String>();
    protected Map<String, TableColumnSourceReferences> targetColumnSourceReferencesMap = new HashMap<String, TableColumnSourceReferences>();

    public AbstractDatabaseWriter() {
        this(null, null);
    }

    public AbstractDatabaseWriter(DatabaseWriterSettings settings) {
        this(null, settings);
    }

    public AbstractDatabaseWriter(IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings) {
        this.conflictResolver = conflictResolver == null ? new DefaultDatabaseWriterConflictResolver() : conflictResolver;
        this.writerSettings = settings == null ? new DatabaseWriterSettings() : settings;
    }

    @Override
    public void open(DataContext context) {
        this.context = context;
    }

    @Override
    public void start(Batch batch) {
        this.batch = batch;
        this.batch.setBulkLoaderFlag(false);
        this.statistics.put(batch, new Statistics());
        this.statistics.get(batch).set("STARTTIME", new Date().getTime());
    }

    @Override
    public boolean start(Table table) {
        if (table == null) {
            throw new NullPointerException("Cannot load a null table");
        }
        this.lastData = null;
        this.sourceTable = table;
        this.targetTable = this.lookupTableAtTarget(this.sourceTable);
        this.sourceTable.copyColumnTypesFrom(this.targetTable);
        if (this.targetTable == null && this.hasFilterThatHandlesMissingTable(table)) {
            this.targetTable = table;
        }
        this.refreshTargetColumnReferencesMap();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(CsvData data) {
        this.context.remove(CONFLICT_ERROR);
        if (this.sourceTable != null && this.targetTable == null && data.requiresTable() && (this.writerSettings.isIgnoreMissingTables() || this.batch.getBatchId() == -9999L || "config".equals(this.batch.getChannelId()))) {
            String qualifiedName = this.sourceTable.getFullyQualifiedTableName();
            if (!this.missingTables.add(qualifiedName)) return;
            log.info("Did not find the {} table in the target database", (Object)qualifiedName);
            return;
        } else {
            Table lastTable;
            this.context.put(CONFLICT_ERROR, null);
            if (data.requiresTable() && this.sourceTable != null && this.targetTable == null && data.getDataEventType() != DataEventType.SQL && (lastTable = this.context.getLastParsedTable()) != null && lastTable.getFullyQualifiedTableNameLowerCase().equals(this.sourceTable.getFullyQualifiedTableNameLowerCase())) {
                this.start(lastTable);
            }
            if (this.targetTable != null || !data.requiresTable() || this.targetTable == null && data.getDataEventType() == DataEventType.SQL) {
                try {
                    this.statistics.get(this.batch).increment("STATEMENTCOUNT");
                    this.statistics.get(this.batch).increment("LINENUMBER");
                    if (!this.filterBefore(data)) return;
                    switch (data.getDataEventType()) {
                        case UPDATE: 
                        case INSERT: {
                            if (this.sourceTable.getColumnCount() == data.getParsedData("rowData").length) break;
                            throw new ParseException(String.format("The (%s) table's column count (%d) does not match the data's column count (%d)", this.sourceTable.getName(), this.sourceTable.getColumnCount(), data.getParsedData("rowData").length));
                        }
                        case DELETE: {
                            if (this.sourceTable.getPrimaryKeyColumnCount() == data.getParsedData("pkData").length) break;
                            throw new ParseException(String.format("The (%s) table's pk column count (%d) does not match the data's pk column count (%d)", this.sourceTable.getName(), this.sourceTable.getPrimaryKeyColumnCount(), data.getParsedData("pkData").length));
                        }
                    }
                    if (this.isRequiresSavePointsInTransaction && this.conflictResolver != null) {
                        Statistics batchStatistics = this.getStatistics().get(this.getBatch());
                        long statementCount = batchStatistics.get("STATEMENTCOUNT");
                        ResolvedData resolvedData = this.getWriterSettings().getResolvedData(statementCount);
                        if (resolvedData != null) {
                            if (resolvedData.isIgnoreRow()) {
                                this.statistics.get(this.batch).increment("IGNOREROWCOUNT");
                                return;
                            } else {
                                Conflict conflict = new Conflict();
                                conflict.setDetectType(Conflict.DetectConflict.USE_PK_DATA);
                                conflict.setResolveType(Conflict.ResolveConflict.FALLBACK);
                                this.conflictResolver.attemptToResolve(resolvedData, data, this, conflict);
                            }
                            return;
                        }
                    }
                    LoadStatus loadStatus = LoadStatus.SUCCESS;
                    switch (data.getDataEventType()) {
                        case UPDATE: {
                            loadStatus = this.update(data, this.writerSettings.isApplyChangesOnly(), true);
                            break;
                        }
                        case INSERT: {
                            loadStatus = this.insert(data);
                            break;
                        }
                        case DELETE: {
                            loadStatus = this.delete(data, true);
                            break;
                        }
                        case BSH: {
                            this.script(data);
                            break;
                        }
                        case SQL: {
                            this.sql(data);
                            break;
                        }
                        case CREATE: {
                            this.create(data);
                            break;
                        }
                    }
                    if (loadStatus == LoadStatus.CONFLICT) {
                        if (this.conflictResolver == null) throw new ConflictException(data, this.targetTable, false, this.writerSettings.pickConflict(this.targetTable, this.batch), (Exception)this.context.get(CONFLICT_ERROR));
                        this.conflictResolver.needsResolved(this, data, loadStatus);
                    }
                    ++this.uncommittedCount;
                    this.lastData = data;
                    this.filterAfter(data);
                    this.checkForEarlyCommit();
                    return;
                }
                catch (IgnoreBatchException ex) {
                    this.rollback();
                    throw ex;
                }
                catch (RuntimeException ex) {
                    Statistics batchStatistics = this.getStatistics().get(this.getBatch());
                    long statementCount = batchStatistics.get("STATEMENTCOUNT");
                    ResolvedData resolvedData = this.getWriterSettings().getResolvedData(statementCount);
                    if (this.conflictResolver != null && this.conflictResolver.isIgnoreRow(this, data)) {
                        this.statistics.get(this.batch).increment("IGNOREROWCOUNT");
                        return;
                    }
                    if (this.conflictResolver != null && resolvedData != null) {
                        Conflict conflict = new Conflict();
                        conflict.setDetectType(Conflict.DetectConflict.USE_PK_DATA);
                        conflict.setResolveType(Conflict.ResolveConflict.FALLBACK);
                        this.conflictResolver.attemptToResolve(resolvedData, data, this, conflict);
                        return;
                    }
                    if (this.filterError(data, ex)) {
                        if (ex instanceof SqlException) throw ex;
                        this.logFailureDetails(ex, data, false);
                        throw ex;
                    }
                    ++this.uncommittedCount;
                    this.statistics.get(this.batch).increment("IGNOREROWCOUNT");
                    this.checkForEarlyCommit();
                    if (!Boolean.TRUE.equals(this.context.get(TRANSACTION_ABORTED))) return;
                    this.context.put(CONFLICT_IGNORE, true);
                    throw ex;
                }
            } else {
                if (this.sourceTable == null) throw new SqlException("The target table was not specified");
                this.statistics.get(this.batch).increment("STATEMENTCOUNT");
                this.statistics.get(this.batch).increment("LINENUMBER");
                throw new TableNotFoundException(String.format("Could not find the target table '%s'", this.sourceTable.getFullyQualifiedTableName()));
            }
        }
    }

    protected void checkForEarlyCommit() {
        if (this.uncommittedCount >= this.writerSettings.getMaxRowsBeforeCommit()) {
            this.commit(true);
            long sleep = this.writerSettings.getCommitSleepInterval();
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    log.warn("{}", (Object)e.getMessage());
                }
            }
        }
    }

    protected void commit(boolean earlyCommit) {
        this.uncommittedCount = 0L;
    }

    protected void rollback() {
        this.uncommittedCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean filterError(CsvData data, Exception ex) {
        boolean process = true;
        List<IDatabaseWriterErrorHandler> filters = this.writerSettings.getDatabaseWriterErrorHandlers();
        if (filters != null) {
            try {
                this.statistics.get(this.batch).startTimer("FILTERMILLIS");
                for (IDatabaseWriterErrorHandler filter : filters) {
                    process &= filter.handleError(this.context, this.targetTable, data, ex);
                }
            }
            finally {
                this.statistics.get(this.batch).stopTimer("FILTERMILLIS");
            }
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean filterBefore(CsvData data) {
        boolean process = true;
        List<IDatabaseWriterFilter> filters = this.writerSettings.getDatabaseWriterFilters();
        if (filters != null) {
            try {
                this.statistics.get(this.batch).startTimer("FILTERMILLIS");
                for (IDatabaseWriterFilter filter : filters) {
                    process &= filter.beforeWrite(this.context, this.sourceTable, data);
                }
                Table oldTargetTable = this.targetTable;
                if (this.sourceTable != null) {
                    this.targetTable = this.lookupTableAtTarget(this.sourceTable);
                }
                if (this.targetTable != null && !this.targetTable.equals((Object)oldTargetTable)) {
                    this.targetTableWasChangedByFilter(oldTargetTable);
                }
            }
            finally {
                this.statistics.get(this.batch).stopTimer("FILTERMILLIS");
            }
        }
        return process;
    }

    protected void targetTableWasChangedByFilter(Table oldTargetTable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFiltersEarlyCommit() {
        List<IDatabaseWriterFilter> filters = this.writerSettings.getDatabaseWriterFilters();
        if (filters != null) {
            try {
                this.statistics.get(this.batch).startTimer("FILTERMILLIS");
                for (IDatabaseWriterFilter filter : filters) {
                    filter.earlyCommit(this.context);
                }
            }
            finally {
                this.statistics.get(this.batch).stopTimer("FILTERMILLIS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFiltersBatchComplete() {
        List<IDatabaseWriterFilter> filters = this.writerSettings.getDatabaseWriterFilters();
        if (filters != null) {
            try {
                this.statistics.get(this.batch).startTimer("FILTERMILLIS");
                for (IDatabaseWriterFilter filter : filters) {
                    filter.batchComplete(this.context);
                }
            }
            finally {
                this.statistics.get(this.batch).stopTimer("FILTERMILLIS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFiltersBatchCommitted() {
        List<IDatabaseWriterFilter> filters = this.writerSettings.getDatabaseWriterFilters();
        if (filters != null) {
            try {
                this.statistics.get(this.batch).startTimer("FILTERMILLIS");
                for (IDatabaseWriterFilter filter : filters) {
                    filter.batchCommitted(this.context);
                }
            }
            finally {
                this.statistics.get(this.batch).stopTimer("FILTERMILLIS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFiltersBatchRolledback() {
        List<IDatabaseWriterFilter> filters = this.writerSettings.getDatabaseWriterFilters();
        if (filters != null) {
            try {
                this.statistics.get(this.batch).startTimer("FILTERMILLIS");
                for (IDatabaseWriterFilter filter : filters) {
                    filter.batchRolledback(this.context);
                }
            }
            finally {
                this.statistics.get(this.batch).stopTimer("FILTERMILLIS");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void filterAfter(CsvData data) {
        List<IDatabaseWriterFilter> filters = this.writerSettings.getDatabaseWriterFilters();
        if (filters != null) {
            try {
                this.statistics.get(this.batch).startTimer("FILTERMILLIS");
                for (IDatabaseWriterFilter filter : filters) {
                    filter.afterWrite(this.context, this.sourceTable, data);
                }
            }
            finally {
                this.statistics.get(this.batch).stopTimer("FILTERMILLIS");
            }
        }
    }

    protected abstract LoadStatus insert(CsvData var1);

    protected abstract LoadStatus delete(CsvData var1, boolean var2);

    protected abstract LoadStatus update(CsvData var1, boolean var2, boolean var3);

    protected abstract boolean create(CsvData var1);

    protected abstract boolean sql(CsvData var1);

    protected abstract void logFailureDetails(Throwable var1, CsvData var2, boolean var3);

    protected abstract void logFailureDetails(Throwable var1, CsvData var2, boolean var3, Object[] var4);

    protected String[] getRowData(CsvData data, String dataType) {
        String[] targetValues = new String[this.targetTable.getColumnCount()];
        String[] originalValues = data.getParsedData(dataType);
        if (originalValues == null) {
            return null;
        }
        TableColumnSourceReferences columnReferences = this.getTargetColumnReferencesMap();
        for (TableColumnSourceReferences.ColumnSourceReferenceEntry referenceEntry : columnReferences) {
            if (referenceEntry.sourceColumnNo() >= originalValues.length) continue;
            targetValues[referenceEntry.targetColumnNo()] = originalValues[referenceEntry.sourceColumnNo()];
        }
        return targetValues;
    }

    protected TableColumnSourceReferences getTargetColumnReferencesMap() {
        String key = TableColumnSourceReferences.generateSearchKey((Table)this.sourceTable, (Table)this.targetTable);
        TableColumnSourceReferences columnReferences = this.targetColumnSourceReferencesMap.get(key);
        if (columnReferences == null) {
            return this.buildTargetColumnReferencesMap(key);
        }
        return columnReferences;
    }

    protected TableColumnSourceReferences buildTargetColumnReferencesMap(String key) {
        TableColumnSourceReferences columnReferences = new TableColumnSourceReferences(this.sourceTable, this.targetTable);
        this.targetColumnSourceReferencesMap.put(key, columnReferences);
        return columnReferences;
    }

    protected void refreshTargetColumnReferencesMap() {
        if (this.targetTable == null) {
            return;
        }
        String key = TableColumnSourceReferences.generateSearchKey((Table)this.sourceTable, (Table)this.targetTable);
        TableColumnSourceReferences columnReferences = this.targetColumnSourceReferencesMap.get(key);
        if (columnReferences == null || !columnReferences.isMatchingTables(this.sourceTable, this.targetTable)) {
            this.buildTargetColumnReferencesMap(key);
            return;
        }
    }

    protected void clearTargetColumnReferencesMap() {
        this.targetColumnSourceReferencesMap.clear();
    }

    protected void bindVariables(Map<String, Object> variables) {
        variables.put("SOURCE_NODE_ID", this.batch.getSourceNodeId());
        variables.put("TARGET_NODE_ID", this.batch.getTargetNodeId());
        variables.put("log", log);
        variables.put("context", (Object)this.context);
        variables.putAll(this.context.getContext());
    }

    protected boolean script(CsvData data) {
        try {
            this.statistics.get(this.batch).startTimer("LOADMILLIS");
            String script = data.getParsedData("rowData")[0];
            HashMap<String, Object> variables = new HashMap<String, Object>();
            this.bindVariables(variables);
            Interpreter interpreter = new Interpreter();
            if (variables != null) {
                for (String variableName : variables.keySet()) {
                    interpreter.set(variableName, variables.get(variableName));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("About to run: {}", (Object)script);
            }
            interpreter.eval(script);
            this.statistics.get(this.batch).increment("SCRIPTCOUNT");
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    protected Map<String, String> getLookupDataMap(CsvData data, Conflict conflict) {
        Map<String, String> keyData = null;
        if (data.getDataEventType() == DataEventType.INSERT) {
            keyData = data.toColumnNameValuePairs(this.sourceTable.getColumnNames(), "rowData");
        } else if (conflict.getDetectType() != Conflict.DetectConflict.USE_PK_DATA) {
            keyData = data.toColumnNameValuePairs(this.sourceTable.getColumnNames(), "oldData");
        }
        if (keyData == null || keyData.size() == 0) {
            keyData = data.toKeyColumnValuePairs(this.sourceTable);
        }
        return keyData;
    }

    protected String getPkDataFor(CsvData data, Column column) {
        String[] values = data.getParsedData("pkData");
        if (values != null) {
            Column[] columns = this.targetTable.getColumns();
            int index = -1;
            for (Column column2 : columns) {
                if (column2.isPrimaryKey()) {
                    ++index;
                }
                if (!column2.equals((Object)column)) continue;
                if (index < values.length) {
                    return values[index];
                }
                return null;
            }
        } else {
            return data.getParsedData("rowData")[this.targetTable.getColumnIndex(column)];
        }
        return null;
    }

    @Override
    public void end(Table table) {
    }

    @Override
    public void end(Batch batch, boolean inError) {
        this.lastData = null;
        if (batch.isIgnored()) {
            this.getStatistics().get(batch).increment("IGNORECOUNT");
        }
        if (!inError) {
            this.notifyFiltersBatchComplete();
            this.commit(false);
        } else {
            this.rollback();
        }
    }

    @Override
    public void close() {
        this.targetColumnSourceReferencesMap.clear();
    }

    protected boolean hasFilterThatHandlesMissingTable(Table table) {
        if (this.writerSettings.getDatabaseWriterFilters() != null) {
            for (IDatabaseWriterFilter filter : this.writerSettings.getDatabaseWriterFilters()) {
                if (!filter.handlesMissingTable(this.context, table)) continue;
                return true;
            }
        }
        return false;
    }

    protected void allowInsertIntoAutoIncrementColumns(boolean value, Table table) {
    }

    protected Table lookupTableAtTarget(Table sourceTable) {
        return sourceTable;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public DataContext getContext() {
        return this.context;
    }

    public IDatabaseWriterConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public void setConflictResolver(IDatabaseWriterConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }

    public DatabaseWriterSettings getWriterSettings() {
        return this.writerSettings;
    }

    public static enum LoadStatus {
        SUCCESS,
        CONFLICT;

    }
}

