/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.ColumnsToRowsKeyColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class ColumnsToRowsValueColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "columnsToRowsValue";
    protected static final String OPTION_CHANGES_ONLY = "changesOnly";
    protected static final String OPTION_IGNORE_NULLS = "ignoreNulls";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public String transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreRowException, IgnoreColumnException {
        String contextBase = ColumnsToRowsKeyColumnTransform.getContextBase(column.getTransformId());
        Map reverseMap = (Map)context.get(contextBase + "Map");
        String pkColumnName = (String)context.get(contextBase + "PKColumn");
        if (reverseMap == null) {
            throw new RuntimeException("Reverse map not found in context as key " + contextBase + "Map  Unable to transform.");
        }
        if (pkColumnName == null) {
            throw new RuntimeException("Primary key column name not found in context as key " + contextBase + "PKColumn  Unable to transform.");
        }
        String expr = column.getTransformExpression();
        boolean isChangesOnly = false;
        boolean isIgnoreNulls = false;
        if (expr != null) {
            isChangesOnly = expr.indexOf("changesOnly=true") != -1;
            isIgnoreNulls = expr.indexOf("ignoreNulls=true") != -1;
        }
        String pkValue = data.getTargetKeyValues().get(pkColumnName);
        String value = null;
        if (pkValue != null) {
            value = (String)reverseMap.get(pkValue);
            if (value != null) {
                String srcOldValue;
                String srcNewValue = data.getSourceValues().get(value);
                String string = srcOldValue = data.getOldSourceValues() != null ? data.getOldSourceValues().get(value) : null;
                if (isIgnoreNulls && DataEventType.INSERT == data.getSourceDmlType() && StringUtils.trimToNull((String)srcNewValue) == null) {
                    throw new IgnoreRowException();
                }
                if (DataEventType.UPDATE == data.getSourceDmlType()) {
                    if (isChangesOnly && StringUtils.trimToEmpty((String)srcNewValue).equals(StringUtils.trimToEmpty((String)srcOldValue))) {
                        throw new IgnoreRowException();
                    }
                    if (isIgnoreNulls && StringUtils.trimToNull((String)srcNewValue) == null) {
                        data.setTargetDmlType(DataEventType.DELETE);
                    }
                }
                return srcNewValue;
            }
            throw new RuntimeException("Unable to locate column name for pk value " + pkValue);
        }
        throw new RuntimeException("Unable to locate column with pk name " + pkColumnName + " in target values.  Did you mark it as PK?");
    }
}

