/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.statistic;

import com.jumpmind.symmetric.console.service.IProConsoleService;
import com.jumpmind.symmetric.statistic.IThroughputStatisticManager;
import com.jumpmind.symmetric.statistic.TableStat;
import com.jumpmind.symmetric.statistic.TableStats;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.statistic.ChannelStats;
import org.jumpmind.symmetric.statistic.StatisticManager;

public class ThroughputStatisticManager
extends StatisticManager
implements IThroughputStatisticManager {
    private Map<Date, Map<String, ChannelStats>> channelStatsInMemory = new LinkedHashMap<Date, Map<String, ChannelStats>>();
    private Set<String> reloadChannelsCache = new HashSet<String>();
    private long reloadChannelCacheTime;
    private long reloadChannelCacheTimeoutInMs = 900000L;
    private long symmetricRowsIn;
    private long symmetricRowsOut;
    private long symmetricBytesIn;
    private long symmetricBytesOut;
    private long reloadRowsIn;
    private long reloadRowsOut;
    private long reloadBytesIn;
    private long reloadBytesOut;
    private long cdcRowsIn;
    private long cdcRowsOut;
    private long cdcBytesIn;
    private long cdcBytesOut;
    private long throughputMinutes;
    private boolean isExtrapolated;
    private Map<String, ChannelStats> cdcChannelTotals = new HashMap<String, ChannelStats>();
    private Map<String, ChannelStats> reloadChannelTotals = new HashMap<String, ChannelStats>();
    private Map<String, ChannelStats> systemChannelTotals = new HashMap<String, ChannelStats>();
    private ISymmetricEngine engine;
    private boolean isInitialized;
    private TableStats tableStats;
    IProConsoleService proConsoleService;

    public ThroughputStatisticManager(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getNodeService(), engine.getConfigurationService(), engine.getStatisticService(), engine.getClusterService());
        this.engine = engine;
        this.checkInitialized();
        this.tableStats = new TableStats(new Date());
    }

    protected void checkInitialized() {
        if (!this.isInitialized && this.engine.isInitialized() && this.nodeService.findIdentityNodeId() != null) {
            Calendar end = Calendar.getInstance();
            Calendar start = Calendar.getInstance();
            start.add(11, -24);
            this.channelStatsInMemory = this.statisticService.getChannelStatsForPeriod(start.getTime(), end.getTime(), this.nodeService.findIdentityNodeId(), 1440);
            this.isInitialized = true;
        }
    }

    protected void saveAdditionalStats(Date endTime, ChannelStats stats) {
        this.checkInitialized();
        if (this.channelStatsInMemory.get(endTime) == null) {
            this.channelStatsInMemory.put(endTime, new HashMap());
        }
        ChannelStats incrementalStat = new ChannelStats(stats.getNodeId(), stats.getHostName(), stats.getStartTime(), stats.getEndTime(), stats.getChannelId());
        incrementalStat.add(stats);
        this.channelStatsInMemory.get(endTime).put(incrementalStat.getChannelId(), incrementalStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        super.flush();
        try {
            this.tableStats.setEndTime(new Date());
            for (Map.Entry<String, Map<String, TableStat>> entry : this.tableStats.getTableCounts().entrySet()) {
                for (Map.Entry<String, TableStat> dmlEntry : entry.getValue().entrySet()) {
                    this.getProConsoleService().saveTableStats(entry.getKey(), dmlEntry.getKey(), dmlEntry.getValue().getExtractedCount(), dmlEntry.getValue().getLoadedCount(), this.tableStats.getStartTime(), this.tableStats.getEndTime());
                }
            }
        }
        catch (Exception e2) {
            this.log.info("Unable to save table stats ", (Throwable)e2);
        }
        finally {
            this.tableStats = new TableStats(new Date());
        }
    }

    @Override
    public void deleteStats(Date start, Date end, String nodeId) {
        this.engine.getStatisticService().deleteChannelStatsForPeriod(start, end, nodeId);
        this.channelStatsInMemory = this.statisticService.getChannelStatsForPeriod(start, end, this.nodeService.findIdentityNodeId(), 1440);
        this.getThroughput(86400000L);
    }

    @Override
    public long getThroughput(Long rangeInMs) {
        this.symmetricBytesOut = 0L;
        this.symmetricBytesIn = 0L;
        this.symmetricRowsOut = 0L;
        this.symmetricRowsIn = 0L;
        this.reloadBytesOut = 0L;
        this.reloadBytesIn = 0L;
        this.reloadRowsOut = 0L;
        this.reloadRowsIn = 0L;
        this.cdcBytesOut = 0L;
        this.cdcBytesIn = 0L;
        this.cdcRowsOut = 0L;
        this.cdcRowsIn = 0L;
        this.cdcChannelTotals.clear();
        this.reloadChannelTotals.clear();
        this.systemChannelTotals.clear();
        this.checkInitialized();
        Date startTime = new Date();
        Date endTime = new Date(System.currentTimeMillis() - 300000L);
        Date rangeDate = new Date(startTime.getTime() - rangeInMs);
        for (Map.Entry<Date, Map<String, ChannelStats>> entry : this.channelStatsInMemory.entrySet()) {
            for (Map.Entry<String, ChannelStats> channelEntry : entry.getValue().entrySet()) {
                if (!rangeDate.before(channelEntry.getValue().getStartTime())) continue;
                String channelId = channelEntry.getKey();
                ChannelStats stats = channelEntry.getValue();
                if (channelId.equals("config") || channelId.equals("heartbeat") || channelId.equals("monitor") || channelId.equals("system")) {
                    this.symmetricRowsIn += stats.getDataLoaded();
                    this.symmetricRowsOut += stats.getDataSent();
                    this.symmetricBytesIn += stats.getDataBytesLoaded();
                    this.symmetricBytesOut += stats.getDataBytesSent();
                    this.addStats(this.systemChannelTotals, stats, channelId);
                    continue;
                }
                if (this.getReloadChannels().contains(channelId)) {
                    this.reloadRowsIn += stats.getDataLoaded();
                    this.reloadRowsOut += stats.getDataSent();
                    this.reloadBytesIn += stats.getDataBytesLoaded();
                    this.reloadBytesOut += stats.getDataBytesSent();
                    this.addStats(this.reloadChannelTotals, stats, channelId);
                    continue;
                }
                this.cdcRowsIn += stats.getDataLoaded();
                if (this.log.isDebugEnabled() && this.cdcRowsOut != stats.getDataSent() && stats.getDataSent() > 0L && this.cdcRowsOut > 0L) {
                    this.log.debug("Adding {} rows to cdc out {}", (Object)stats.getDataSent(), (Object)this.cdcRowsOut);
                }
                this.cdcRowsOut += stats.getDataSent();
                this.cdcBytesIn += stats.getDataBytesLoaded();
                this.cdcBytesOut += stats.getDataBytesSent();
                this.addStats(this.cdcChannelTotals, stats, channelId);
                if (stats.getStartTime() != null && stats.getStartTime().before(startTime)) {
                    startTime = stats.getStartTime();
                }
                if (stats.getEndTime() == null || !stats.getEndTime().after(endTime)) continue;
                endTime = stats.getEndTime();
            }
            if (!this.log.isDebugEnabled() || this.cdcRowsIn <= 0L && this.cdcRowsOut <= 0L) continue;
            this.log.debug("Throughput: Date-" + String.valueOf(entry.getKey()) + ", Rows Out: " + this.cdcRowsOut + ", Rows In: " + this.cdcRowsIn);
        }
        this.throughputMinutes = Long.max((endTime.getTime() - startTime.getTime()) / 60000L, 0L);
        long missingMinutes = rangeInMs / 60000L - this.throughputMinutes;
        if (this.throughputMinutes != 0L && missingMinutes > 10L) {
            this.cdcRowsIn = (long)((float)this.cdcRowsIn + (float)missingMinutes * ((float)this.cdcRowsIn / ((float)this.throughputMinutes * 1.0f)));
            this.cdcRowsOut = (long)((float)this.cdcRowsOut + (float)missingMinutes * ((float)this.cdcRowsOut / ((float)this.throughputMinutes * 1.0f)));
            this.cdcBytesIn = (long)((float)this.cdcBytesIn + (float)missingMinutes * ((float)this.cdcBytesIn / ((float)this.throughputMinutes * 1.0f)));
            this.cdcBytesOut = (long)((float)this.cdcBytesOut + (float)missingMinutes * ((float)this.cdcBytesOut / ((float)this.throughputMinutes * 1.0f)));
            this.isExtrapolated = true;
        } else {
            this.isExtrapolated = false;
        }
        return this.cdcRowsOut + this.cdcRowsIn;
    }

    protected void addStats(Map<String, ChannelStats> totals, ChannelStats stats, String channelId) {
        ChannelStats totalStats = totals.get(channelId);
        if (totalStats == null) {
            totalStats = new ChannelStats(stats.getNodeId(), stats.getHostName(), stats.getStartTime(), stats.getEndTime(), stats.getChannelId());
            totals.put(channelId, totalStats);
        }
        totalStats.add(stats);
    }

    public void incrementTableRows(Map<String, Map<String, Long>> tableCounts, boolean loaded) {
        if (this.tableStats == null) {
            this.tableStats = new TableStats(new Date());
        }
        if (tableCounts != null) {
            for (Map.Entry<String, Map<String, Long>> entry : tableCounts.entrySet()) {
                if (entry.getKey().toLowerCase().startsWith(this.engine.getSymmetricDialect().getTablePrefix())) continue;
                Map<String, TableStat> tableEntry = this.tableStats.getTableCounts().get(entry.getKey());
                if (tableEntry == null) {
                    ConcurrentHashMap<String, TableStat> dmlMap = new ConcurrentHashMap<String, TableStat>();
                    for (Map.Entry<String, Long> dmlEntry : entry.getValue().entrySet()) {
                        dmlMap.put(dmlEntry.getKey(), new TableStat(loaded ? 0L : dmlEntry.getValue(), loaded ? dmlEntry.getValue() : 0L));
                    }
                    this.tableStats.getTableCounts().put(entry.getKey(), dmlMap);
                    continue;
                }
                for (Map.Entry<String, Long> dmlEntry : entry.getValue().entrySet()) {
                    TableStat stat = tableEntry.get(dmlEntry.getKey());
                    if (stat == null) {
                        this.tableStats.getTableCounts().get(entry.getKey()).put(dmlEntry.getKey(), new TableStat(loaded ? 0L : dmlEntry.getValue(), loaded ? dmlEntry.getValue() : 0L));
                        continue;
                    }
                    if (loaded) {
                        stat.incrementLoadedCount(dmlEntry.getValue());
                    } else {
                        stat.incrementExtractedCount(dmlEntry.getValue());
                    }
                    this.tableStats.getTableCounts().get(entry.getKey()).put(dmlEntry.getKey(), stat);
                }
            }
        }
    }

    @Override
    public long getSymmetricRowsIn() {
        return this.symmetricRowsIn;
    }

    @Override
    public long getSymmetricRowsOut() {
        return this.symmetricRowsOut;
    }

    @Override
    public long getSymmetricBytesIn() {
        return this.symmetricBytesIn;
    }

    @Override
    public long getSymmetricBytesOut() {
        return this.symmetricBytesOut;
    }

    @Override
    public long getReloadRowsIn() {
        return this.reloadRowsIn;
    }

    @Override
    public long getReloadRowsOut() {
        return this.reloadRowsOut;
    }

    @Override
    public long getReloadBytesIn() {
        return this.reloadBytesIn;
    }

    @Override
    public long getReloadBytesOut() {
        return this.reloadBytesOut;
    }

    @Override
    public long getCdcRowsIn() {
        return this.cdcRowsIn;
    }

    @Override
    public long getCdcRowsOut() {
        return this.cdcRowsOut;
    }

    @Override
    public long getCdcBytesIn() {
        return this.cdcBytesIn;
    }

    @Override
    public long getCdcBytesOut() {
        return this.cdcBytesOut;
    }

    @Override
    public long getThroughputMinutes() {
        return this.throughputMinutes;
    }

    @Override
    public boolean isExtrapolated() {
        return this.isExtrapolated;
    }

    @Override
    public Map<String, ChannelStats> getCdcChannelTotals() {
        return this.cdcChannelTotals;
    }

    @Override
    public Map<String, ChannelStats> getReloadChannelTotals() {
        return this.reloadChannelTotals;
    }

    @Override
    public Map<String, ChannelStats> getSystemChannelTotals() {
        return this.systemChannelTotals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getReloadChannels() {
        Set<String> reloadChannels = this.reloadChannelsCache;
        if (System.currentTimeMillis() - this.reloadChannelCacheTime >= this.reloadChannelCacheTimeoutInMs || this.reloadChannelsCache.size() == 0) {
            ThroughputStatisticManager throughputStatisticManager = this;
            synchronized (throughputStatisticManager) {
                this.reloadChannelsCache.clear();
                for (Map.Entry entry : this.configurationService.getChannels(false).entrySet()) {
                    if (!((Channel)entry.getValue()).isReloadFlag()) continue;
                    this.reloadChannelsCache.add((String)entry.getKey());
                }
                this.reloadChannelCacheTime = System.currentTimeMillis();
                reloadChannels = this.reloadChannelsCache;
            }
        }
        return reloadChannels;
    }

    private IProConsoleService getProConsoleService() {
        if (this.proConsoleService == null) {
            this.proConsoleService = (IProConsoleService)this.engine.getExtensionService().getExtensionPoint(IProConsoleService.class);
        }
        return this.proConsoleService;
    }

    public String getMostRecentActiveTableSynced() {
        return this.getProConsoleService().getMostRecentActiveTableSynced();
    }

    public Map<Integer, Date> getTotalLoadedRows() {
        return this.getProConsoleService().getTotalLoadedRows();
    }
}

