/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.security;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePasswordFilter
implements IBuiltInExtensionPoint,
ISymmetricEngineAware,
INodePasswordFilter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected long lastLogTime;
    protected ISecurityService securityService;
    protected boolean shouldEncrypt;
    protected Pattern nonPrintable = Pattern.compile("[^\\x20-\\x7E]");
    protected Set<String> failNodeIds1 = new HashSet<String>();
    protected Set<String> failNodeIds2 = new HashSet<String>();

    public String onNodeSecuritySave(String password, String nodeId) {
        if (password != null && this.shouldEncrypt) {
            return "enc:" + this.securityService.encrypt(password);
        }
        return password;
    }

    public String onNodeSecurityRender(String password, String nodeId) {
        if (password != null && password.startsWith("enc:")) {
            try {
                String plainText = this.securityService.decrypt(password.substring("enc:".length()));
                if (this.nonPrintable.matcher(plainText).find()) {
                    String message = "Failed to decrypt node password for nodes {} because non-printable characters found";
                    if (this.failNodeIds1.add(nodeId)) {
                        this.log.error(message, (Object)nodeId);
                        this.lastLogTime = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.lastLogTime > 60000L) {
                        this.log.error(message, this.failNodeIds1);
                        this.lastLogTime = System.currentTimeMillis();
                    }
                    password = null;
                } else {
                    password = plainText;
                    this.failNodeIds1.remove(nodeId);
                    this.failNodeIds2.remove(nodeId);
                }
            }
            catch (Exception e2) {
                String message = "Failed to decrypt node password for nodes {}";
                if (this.failNodeIds2.add(nodeId)) {
                    this.log.error(message + ": " + e2.getClass().getName() + (String)(e2.getMessage() == null ? "" : ": " + e2.getMessage()), (Object)nodeId);
                    this.lastLogTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.lastLogTime > 60000L) {
                    this.log.error(message, this.failNodeIds2);
                    this.lastLogTime = System.currentTimeMillis();
                }
                password = null;
            }
        }
        return password;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.securityService = engine.getSecurityService();
        this.shouldEncrypt = engine.getParameterService().is("node.password.encrypt.enable");
    }
}

