/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.route;

import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import com.jumpmind.symmetric.console.service.TableGroupHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGroupRouter
extends AbstractDataRouter
implements IBuiltInExtensionPoint,
ISymmetricEngineAware,
IDataRouter {
    private static final Logger log = LoggerFactory.getLogger(TableGroupRouter.class);
    ISymmetricEngine engine;
    ITableGroupService tableGroupService;
    ITriggerRouterService triggerRouterService;
    IDatabasePlatform targetPlatform;
    BinaryEncoding binaryEncoding;

    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        if (initialLoad) {
            return this.toNodeIds(nodes, null);
        }
        this.tableGroupService = (ITableGroupService)this.engine.getExtensionService().getExtensionPoint(ITableGroupService.class);
        this.triggerRouterService = this.engine.getTriggerRouterService();
        this.targetPlatform = this.engine.getSymmetricDialect().getTargetPlatform();
        this.binaryEncoding = this.engine.getSymmetricDialect().getBinaryEncoding();
        Map<String, List<TableGroupHier>> tableGroupHierMap = this.tableGroupService.getTableGroupHierByTableName(triggerRouter.getRouter().getNodeGroupLink().getSourceNodeGroupId(), triggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId(), false);
        List<TableGroupHier> tableGroupHierList = tableGroupHierMap.get(dataMetaData.getTable().getFullyQualifiedTableName());
        if (tableGroupHierList == null) {
            tableGroupHierList = tableGroupHierMap.get(dataMetaData.getTable().getName());
        }
        TableGroupHelper helper = new TableGroupHelper(this.engine);
        HashSet<String> returnNodes = new HashSet<String>();
        Data dataCopy = dataMetaData.getData();
        Set<String> insertNodes = helper.getTargetNodesForNewAssignment(tableGroupHierList, tableGroupHierMap, context, dataMetaData, nodes, initialLoad, initialLoadSelectUsed);
        returnNodes.addAll(insertNodes);
        dataMetaData.setData(dataCopy);
        Set<String> deleteNodes = helper.getTargetNodesForAssignmentRemoval(tableGroupHierList, tableGroupHierMap, context, dataMetaData, nodes, initialLoad, initialLoadSelectUsed);
        returnNodes.addAll(deleteNodes);
        if (dataCopy.getDataEventType() == DataEventType.UPDATE && helper.isOverlap(insertNodes, deleteNodes)) {
            log.info("Update captured for table " + dataCopy.getTableName() + " and no nodes were found to remove this data from, sending deletes to all other nodes not part of the new update.");
            for (String nodeId : this.toNodeIds(nodes, null)) {
                if (insertNodes.contains(nodeId)) continue;
                returnNodes.add(nodeId);
            }
        }
        if (dataCopy.getDataEventType() == DataEventType.DELETE && returnNodes.size() == 0) {
            returnNodes.addAll(this.toNodeIds(nodes, null));
        }
        dataMetaData.setData(dataCopy);
        return returnNodes;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }
}

