/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.log;

import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.log.h;
import com.jumpmind.symmetric.log.i;
import com.jumpmind.symmetric.log.j;
import com.jumpmind.symmetric.log.l;
import com.jumpmind.symmetric.log.z;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedMiner
implements h {
    private final Logger log = LoggerFactory.getLogger((String)new hh(new long[]{8886704204307295887L, -5675360542843720959L, -728619952665306708L, -3843516293604016341L, -2325079167859626931L, -19937061507662264L, 8971852687259326998L}).toString());
    protected ISymmetricEngine engine;
    protected ISqlTemplate sqlTemplate;
    protected Map<String, l> logTriggerMap;
    protected Iterator<l> logIterator;
    protected l logTrigger;
    protected Data nextData;
    protected long timeStartId;
    protected long timeEndId;
    protected long timeCurrentId;
    protected long tableNumericStartId;
    protected long tableNumericEndId;
    protected long totalRowsScanned;
    protected ISqlReadCursor<Row> cursor;
    protected IDatabasePlatform targetPlatform;
    protected DatabaseInfo databaseInfo;
    protected Table currentTable;
    protected String currentFullyQualifiedTableName;
    protected boolean isNumericCaptureColumn;
    protected String numericCaptureColumnName;
    protected boolean hasReadNumericCaptureData;
    protected ISqlTransaction transaction;
    protected Map<String, j> openTransactionsByTable;

    public TimeBasedMiner(ISymmetricEngine engine) {
        this.engine = engine;
        this.sqlTemplate = engine.getTargetDialect().getTargetPlatform().getSqlTemplate();
        this.targetPlatform = engine.getTargetDialect().getTargetPlatform();
        this.databaseInfo = this.targetPlatform.getDatabaseInfo();
        this.openTransactionsByTable = new HashMap<String, j>();
    }

    @Override
    public void open() throws z {
        List<l> orderedLogTriggers = this.getLogTriggersInForeignKeyOrder();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Scanning for {} tables: [{}]", (Object)orderedLogTriggers.size(), (Object)l.a(orderedLogTriggers));
        }
        this.logIterator = orderedLogTriggers.iterator();
        this.nextCursor();
    }

    protected void nextCursor() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.logIterator.hasNext()) {
            while (this.logIterator.hasNext()) {
                int[] rangeTypes;
                Object[] rangeValues;
                this.logTrigger = this.logIterator.next();
                if (StringUtils.isEmpty((CharSequence)this.logTrigger.a().getTimeBasedCaptureColumn())) continue;
                TriggerHistory history = this.logTrigger.b();
                Table table = this.engine.getTargetDialect().getTargetPlatform().getTableFromCache(history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), false);
                Column captureColumn = table.getColumnWithName(this.logTrigger.a().getTimeBasedCaptureColumn());
                if (captureColumn == null) {
                    this.log.info("Unable to find column " + this.logTrigger.a().getTimeBasedCaptureColumn() + " on table " + table.getFullyQualifiedTableName());
                    continue;
                }
                if (TypeMap.isNumericType((int)captureColumn.getJdbcTypeCode())) {
                    this.isNumericCaptureColumn = true;
                    this.currentTable = table;
                    this.currentFullyQualifiedTableName = table.getFullyQualifiedTableName();
                    this.tableNumericStartId = this.engine.getContextService().getLong(this.getContextNextIdName());
                    if (this.tableNumericStartId == 0L) {
                        this.tableNumericStartId = this.getTableMaxId();
                    }
                    this.tableNumericEndId = this.tableNumericStartId + 50000L;
                    this.hasReadNumericCaptureData = false;
                    this.numericCaptureColumnName = captureColumn.getName();
                    this.log.debug("Starting numeric mining for table " + this.currentFullyQualifiedTableName + " with pk=" + this.tableNumericStartId);
                } else {
                    this.isNumericCaptureColumn = false;
                }
                String sql = this.getChangeTableSql(history, this.logTrigger, table, this.isNumericCaptureColumn);
                if (this.log.isDebugEnabled()) {
                    if (this.isNumericCaptureColumn) {
                        this.log.debug("Running SQL: {} [{}, {}]", new Object[]{sql, this.tableNumericStartId, this.tableNumericEndId});
                    } else {
                        this.log.debug("Running SQL: {} [{}, {}]", new Object[]{sql, new Date(this.timeStartId), new Date(this.timeEndId)});
                    }
                }
                if (this.isNumericCaptureColumn) {
                    rangeValues = new Object[]{this.tableNumericStartId, this.tableNumericEndId};
                    rangeTypes = new int[]{2, 2};
                } else {
                    rangeValues = new Object[]{new Date(this.timeStartId), new Date(this.timeEndId)};
                    rangeTypes = new int[]{93, 93};
                }
                this.cursor = this.sqlTemplate.queryForCursor(sql, (ISqlRowMapper)new RowMapper(), rangeValues, rangeTypes);
                return;
            }
        } else {
            this.cursor = null;
            this.timeCurrentId = this.timeEndId;
        }
    }

    protected long getTableMaxId() {
        String tableName = Table.getFullyQualifiedTableName((String)this.currentTable.getCatalog(), (String)this.currentTable.getSchema(), (String)this.currentTable.getName(), (String)this.targetPlatform.getDatabaseInfo().getDelimiterToken(), (String)this.targetPlatform.getDatabaseInfo().getCatalogSeparator(), (String)this.targetPlatform.getDatabaseInfo().getSchemaSeparator());
        StringBuilder sql = new StringBuilder("select max(").append(this.currentTable.getPrimaryKeyColumnNames()[0]).append(") from ").append(tableName);
        return this.sqlTemplate.queryForLong(sql.toString(), new Object[0]);
    }

    protected String getChangeTableSql(TriggerHistory history, l logTrigger, Table table, boolean isNumericCaptureColumn) {
        StringBuilder columnNames = new StringBuilder();
        for (String columnName : history.getParsedColumnNames()) {
            if (columnNames.length() != 0) {
                columnNames.append(", ");
            }
            columnNames.append("\"").append(columnName).append("\"");
        }
        table = table.copyAndFilterColumns(history.getParsedColumnNames(), history.getParsedPkColumnNames(), true, false);
        String quote = this.databaseInfo.getDelimiterToken() == null ? "" : this.databaseInfo.getDelimiterToken();
        DmlStatementOptions options = new DmlStatementOptions(DmlStatement.DmlType.SELECT_ALL, table).databaseInfo(this.targetPlatform.getDatabaseInfo()).quotedIdentifiers(true);
        DmlStatement dmlStatement = this.targetPlatform.createDmlStatement(options);
        StringBuffer sql = new StringBuffer(dmlStatement.getSql());
        sql.append(" where ").append(quote).append(logTrigger.a().getTimeBasedCaptureColumn()).append(quote).append(" >= ? and ").append(quote).append(logTrigger.a().getTimeBasedCaptureColumn()).append(quote).append(" < ?");
        return sql.toString();
    }

    @Override
    public boolean hasData() throws z {
        while (this.cursor != null) {
            Row row = (Row)this.cursor.next();
            if (row != null) {
                Data data;
                DataEventType eventType;
                ++this.totalRowsScanned;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Row: {}", (Object)row);
                }
                if (this.isNumericCaptureColumn) {
                    long pk = row.getLong(this.numericCaptureColumnName);
                    row.getLong(this.numericCaptureColumnName);
                    this.tableNumericEndId = pk;
                    this.hasReadNumericCaptureData = true;
                }
                if (!this.logTrigger.a(eventType = DataEventType.INSERT)) continue;
                String sourceNodeId = null;
                String pkData = this.convertToCsv(row, this.logTrigger.b().getParsedPkColumnNames());
                String rowData = null;
                if (!eventType.equals((Object)DataEventType.DELETE)) {
                    rowData = this.convertToCsv(row, this.logTrigger.b().getParsedColumnNames());
                }
                if (!this.logTrigger.a(data = new Data(this.logTrigger.b().getSourceTableName(), eventType, rowData, pkData, this.logTrigger.b(), this.logTrigger.a().getChannelId(), null, sourceNodeId))) continue;
                this.nextData = data;
                return true;
            }
            if (this.isNumericCaptureColumn) {
                this.savePositionAndCommitByTable();
            }
            this.nextCursor();
        }
        return false;
    }

    @Override
    public Data readData() {
        return this.nextData;
    }

    @Override
    public void setLogTriggerMap(Map<String, l> logTriggerMap) {
        this.logTriggerMap = logTriggerMap;
    }

    @Override
    public void setStartId(long id) {
        this.timeStartId = id;
        this.timeCurrentId = id;
    }

    @Override
    public void setEndId(long id) {
        this.timeEndId = id;
    }

    @Override
    public void setOpenTransactions(Collection<j> openTransactions) {
    }

    @Override
    public void close() {
        this.timeCurrentId = 0L;
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Override
    public long getTotalRowsScanned() {
        return this.totalRowsScanned;
    }

    @Override
    public long getCurrentId() {
        if (this.timeCurrentId == 0L) {
            this.timeCurrentId = new Date().getTime();
        }
        return this.timeCurrentId;
    }

    @Override
    public Collection<j> getOpenTransactions() {
        return this.openTransactionsByTable.values();
    }

    @Override
    public boolean isWaitsForCommit() {
        return false;
    }

    @Override
    public boolean handlesSaveOfNextID() {
        return false;
    }

    protected String getContextNextIdName() {
        StringBuilder sb = new StringBuilder("log.miner.next.id").append(".").append(this.currentFullyQualifiedTableName);
        return sb.toString();
    }

    public void savePositionAndCommitByTable() {
        this.engine.getContextService().save(this.transaction, this.getContextNextIdName(), String.valueOf(this.hasReadNumericCaptureData ? this.tableNumericEndId + 1L : this.tableNumericStartId));
        this.transaction.commit();
    }

    @Override
    public void savePositionAndCommit(ISqlTransaction transaction) {
        this.engine.getContextService().save(transaction, "log.miner.next.id", String.valueOf(this.timeEndId));
        transaction.commit();
    }

    protected List<l> getLogTriggersInForeignKeyOrder() {
        this.log.debug("Looking up foreign keys to order tables");
        ArrayList<Table> tables = new ArrayList<Table>();
        for (l l2 : this.logTriggerMap.values()) {
            Table table = this.engine.getTargetDialect().getPlatform().getTableFromCache(l2.b().getSourceCatalogName(), l2.b().getSourceSchemaName(), l2.b().getSourceTableName(), true);
            if (table != null) {
                tables.add(table);
                continue;
            }
            if (l2.a().getSourceTableName().contains("*")) continue;
            this.log.warn("Unable to find metadata for table {}.{}.{}", new Object[]{l2.a().getSourceCatalogName(), l2.a().getSourceSchemaName(), l2.a().getSourceTableName()});
        }
        TreeMap<String, Table> tablesMap = new TreeMap<String, Table>();
        for (Table table : tables) {
            tablesMap.put(table.getFullyQualifiedTableName(), table);
        }
        ArrayList<l> arrayList = new ArrayList<l>();
        for (Table table : Database.sortByForeignKeys(tables)) {
            arrayList.add(this.logTriggerMap.get(table.getFullyQualifiedTableName()));
        }
        return arrayList;
    }

    protected String convertToCsv(Row row, String[] columnNames) {
        StringBuilder sb = new StringBuilder();
        if (columnNames != null) {
            for (String name : columnNames) {
                Object object;
                if (sb.length() != 0) {
                    sb.append(",");
                }
                if ((object = row.get((Object)name)) == null) continue;
                if (object instanceof String) {
                    object = object.toString().replace("\\", "\\\\").replace("\"", "\\\"");
                } else if (object instanceof Boolean) {
                    object = (Boolean)object != false ? "1" : "0";
                } else if (object instanceof byte[]) {
                    object = new String(Base64.encodeBase64((byte[])((byte[])object)));
                }
                sb.append("\"").append(object.toString()).append("\"");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean needsIncomingTransactions() {
        return false;
    }

    @Override
    public void setIncomingTransactions(Map<String, i> incomingTransactions) {
    }

    @Override
    public Set<String> getIncomingMinedTransactionIds() {
        return null;
    }

    @Override
    public void setTransaction(ISqlTransaction transaction) {
        this.transaction = transaction;
    }
}

