/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.jumpmind.symmetric.db.bulk.h;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
extends h {
    private static final Logger P = LoggerFactory.getLogger(a.class);
    protected boolean a = false;
    protected String F;
    protected String G;
    protected String H;
    protected String I;
    protected String J;
    protected String K;
    Map<String, String> L = new LinkedHashMap<String, String>();
    protected List<String> M = new ArrayList<String>();
    protected List<String> N = new ArrayList<String>();
    protected AmazonS3 O;

    public a(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, Channel channel, String prefix, DatabaseWriterSettings settings, IParameterService parameterService, ISecurityService securityService, IStagingManager stagingManager) {
        super(symmetricPlatform, targetPlatform, channel, prefix, stagingManager, null, null, parameterService, securityService, settings);
        String secretKey;
        String region = parameterService.getString("target.db.aws.region");
        String bucket = parameterService.getString("target.db.aws.bucket");
        String folder = parameterService.getString("target.db.aws.folder");
        String accessKey = parameterService.getString("s3.load.aws.access.key");
        if (accessKey != null && accessKey.startsWith("enc:")) {
            accessKey = securityService.decrypt(accessKey.substring("enc:".length()));
        }
        if ((secretKey = parameterService.getString("s3.load.aws.secret.key")) != null && secretKey.startsWith("enc:")) {
            secretKey = securityService.decrypt(secretKey.substring("enc:".length()));
        }
        this.F = accessKey;
        this.G = secretKey;
        this.H = region;
        this.I = bucket;
        this.J = folder;
        this.K = parameterService.getString("s3.load.format");
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.F, this.G);
        this.O = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withRegion(this.H)).build();
    }

    protected Table lookupTableAtTarget(Table sourceTable) {
        if (this.isSymmetricTable(sourceTable)) {
            return super.lookupTableAtTarget(sourceTable);
        }
        return sourceTable;
    }

    @Override
    public void bulkWrite(CsvData data) {
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        DataEventType dataEventType = data.getDataEventType();
        if ((dataEventType == DataEventType.INSERT || dataEventType == DataEventType.UPDATE) && this.targetTable != null) {
            if (this.isSymmetricTable(this.targetTable)) {
                this.writeDefault(data);
            } else {
                Object formattedData;
                if (!this.K.equals("csv") && !this.K.equals("json")) {
                    P.warn("Improper file extension: " + this.K);
                }
                this.N.add(this.getSourceTable().getName());
                String[] rowData = this.getRowData(data, "rowData");
                if (this.K.equals("json")) {
                    formattedData = "\t{\n";
                    for (int i2 = 0; i2 < rowData.length; ++i2) {
                        formattedData = (String)formattedData + "\t\t\"" + this.getSourceTable().getColumns()[i2].getName() + "\": \"" + rowData[i2] + "\",\n";
                    }
                    formattedData = ((String)formattedData).substring(0, ((String)formattedData).length() - 2) + "\n\t},\n";
                } else {
                    formattedData = CsvUtils.escapeCsvData((String[])rowData, (char)'\n', (char)'\"', (int)2, (String)"\\N");
                }
                this.M.add((String)formattedData);
                this.L.put(this.getSourceTable().getName(), (String)formattedData);
                this.a = true;
            }
        }
        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
        ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Table table) {
        try {
            if (this.a) {
                String prevTableName = null;
                for (int z2 = 0; z2 < this.N.size(); ++z2) {
                    if (this.N.get(z2).equals(prevTableName)) continue;
                    this.b(this.N.get(z2));
                    prevTableName = this.N.get(z2);
                }
            }
        }
        finally {
            super.end(table);
        }
    }

    protected void b(String tableName) {
        byte[] byteData = null;
        File uploadFile = new File("placeholder." + this.K);
        try (FileOutputStream outputStream = new FileOutputStream(uploadFile, true);){
            if (this.K.equals("json")) {
                String lastRow = this.M.remove(this.M.size() - 1);
                this.M.add(lastRow.substring(0, lastRow.length() - 2));
                outputStream.write("[\n".getBytes(Charset.defaultCharset()));
            }
            for (int x2 = 0; x2 < this.M.size(); ++x2) {
                if (!this.N.get(x2).equals(tableName)) continue;
                byteData = this.M.get(x2).getBytes(Charset.defaultCharset());
                outputStream.write(byteData);
            }
            if (this.K.equals("json")) {
                outputStream.write("\n]".getBytes(Charset.defaultCharset()));
            }
        }
        catch (IOException e2) {
            P.error("Failed to use Amazon S3 database writer ", (Throwable)e2);
        }
        String csvName = String.format("%010d", this.getBatch().getBatchId());
        String awsKeyName = this.J + "/" + tableName.toLowerCase() + "/" + csvName + "." + this.K;
        this.O.putObject(this.I, awsKeyName, uploadFile);
        try {
            this.a(uploadFile.toPath());
        }
        catch (IOException e3) {
            P.error("Failed to delete upload file in Amazon S3 Database Writer", (Throwable)e3);
        }
    }

    public void a(Path path) throws IOException {
        Files.delete(path);
    }

    @Override
    public void b() throws SQLException {
    }

    @Override
    public void a() throws SQLException {
    }

    @Override
    public void c() throws SQLException {
    }
}

