/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.opensearch;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.Signer;
import com.jumpmind.symmetric.db.opensearch.e;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.http.HttpHost;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
extends AbstractBulkDatabaseWriter {
    private static final Logger i = LoggerFactory.getLogger(a.class);
    protected boolean a;
    protected BulkRequest b = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
    protected boolean c = false;
    private static final String j = "^(truncate)( table)?.*";
    private static final String k = "^(delete from).*";
    protected boolean d;
    protected String e;
    protected String f;
    protected String g;
    protected RestHighLevelClient h;

    public a(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String tablePrefix, DatabaseWriterSettings settings, IParameterService parameterService, ISecurityService securityService) {
        super(symmetricPlatform, targetPlatform, tablePrefix, settings);
        String secretKey;
        String urlEndpoint = ((e)targetPlatform).a();
        String region = parameterService.getString("target.db.aws.region");
        String activeKey = parameterService.getString("target.db.aws.active.key");
        if (activeKey != null && activeKey.startsWith("enc:")) {
            activeKey = securityService.decrypt(activeKey.substring("enc:".length()));
        }
        if ((secretKey = parameterService.getString("target.db.aws.secret.key")) != null && secretKey.startsWith("enc:")) {
            secretKey = securityService.decrypt(secretKey.substring("enc:".length()));
        }
        this.e = activeKey;
        this.f = secretKey;
        this.g = region;
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.e, this.f);
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCreds);
        AWS4Signer signer = new AWS4Signer();
        signer.setServiceName("es");
        signer.setRegionName(this.g);
        com.amazonaws.http.a interceptor = new com.amazonaws.http.a("es", (Signer)signer, (AWSCredentialsProvider)credentialsProvider);
        this.h = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)urlEndpoint)}).setHttpClientConfigCallback(hacb -> hacb.addInterceptorLast(interceptor)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sql(CsvData data) {
        try {
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            String[] parsedData = data.getParsedData("rowData");
            String script = parsedData[0];
            List sqlStatements = this.getSqlStatements(script);
            long count = 0L;
            for (String sql : sqlStatements) {
                Object newTransaction = null;
                try {
                    GetIndexRequest validateIndex;
                    Table table = this.targetTable != null ? this.targetTable : this.sourceTable;
                    sql = FormatUtils.replace((String)"nodeId", (String)this.batch.getTargetNodeId(), (String)sql);
                    if (table == null) continue;
                    sql = FormatUtils.replace((String)"catalogName", (String)this.quoteString(table.getCatalog()), (String)sql);
                    sql = FormatUtils.replace((String)"schemaName", (String)this.quoteString(table.getSchema()), (String)sql);
                    sql = FormatUtils.replace((String)"tableName", (String)this.quoteString(table.getName()), (String)sql);
                    DatabaseInfo info = this.getPlatform().getDatabaseInfo();
                    String quote = this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? info.getDelimiterToken() : "";
                    sql = FormatUtils.replace((String)"fullTableName", (String)table.getQualifiedTableName(quote, info.getCatalogSeparator(), info.getSchemaSeparator()), (String)sql);
                    String old38CompatibilityTable = "sym_node";
                    Table indexTable = this.sourceTable;
                    if ("reload".equals(this.batch.getChannelId()) && sql.matches(j) && !table.getNameLowerCase().equals("sym_node")) {
                        validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
                        try {
                            if (Boolean.FALSE.equals(this.d)) {
                                this.d = this.h.indices().exists(validateIndex, RequestOptions.DEFAULT);
                            }
                            if (!this.d) continue;
                            DeleteIndexRequest deleterequest = new DeleteIndexRequest(indexTable.getNameLowerCase());
                            CreateIndexRequest createrequest = new CreateIndexRequest(indexTable.getNameLowerCase());
                            try {
                                this.h.indices().delete(deleterequest, RequestOptions.DEFAULT);
                                this.h.indices().create(createrequest, RequestOptions.DEFAULT);
                                continue;
                            }
                            catch (IOException e2) {
                                throw new RuntimeException(e2);
                            }
                        }
                        catch (IOException e3) {
                            i.error("Failed to purge in OpenSearch", (Throwable)e3);
                            throw new RuntimeException(e3);
                        }
                    }
                    if (!"reload".equals(this.batch.getChannelId()) || !sql.matches(k) || sql.toUpperCase().contains("WHERE") || table.getNameLowerCase().equals("sym_node")) continue;
                    validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
                    try {
                        Boolean indexExists = this.h.indices().exists(validateIndex, RequestOptions.DEFAULT);
                        if (!Boolean.TRUE.equals(indexExists)) continue;
                        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexTable.getNameLowerCase()});
                        request.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
                        this.h.deleteByQuery(request, RequestOptions.DEFAULT);
                    }
                    catch (IOException e4) {
                        i.error("Failed to purge in OpenSearch", (Throwable)e4);
                        throw new RuntimeException(e4);
                    }
                }
                finally {
                    if (newTransaction == null) continue;
                    newTransaction.close();
                }
            }
            ((Statistics)this.statistics.get(this.batch)).increment("SQLCOUNT");
            ((Statistics)this.statistics.get(this.batch)).increment("SQLROWSAFFECTEDCOUNT", count);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    protected void bulkWrite(CsvData data) {
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        DataEventType dataEventType = data.getDataEventType();
        if (this.targetTable != null || dataEventType.equals((Object)DataEventType.CREATE)) {
            this.a = false;
            if (!this.batch.getBinaryEncoding().equals((Object)BinaryEncoding.NONE) && this.targetTable != null) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.a = true;
                    break;
                }
            }
            Table table = this.sourceTable;
            GetIndexRequest validateIndex = new GetIndexRequest(new String[]{table.getNameLowerCase()});
            switch (dataEventType) {
                case INSERT: {
                    try {
                        if (Boolean.FALSE.equals(this.d)) {
                            this.d = this.h.indices().exists(validateIndex, RequestOptions.DEFAULT);
                        }
                        if (this.d) {
                            String[] rowData = data.getParsedData("rowData");
                            if (data.getDataEventType() == DataEventType.DELETE) {
                                rowData = data.getParsedData("oldData");
                            }
                            List lookupKeys = null;
                            lookupKeys = this.targetTable.getPrimaryKeyColumnsAsList();
                            StringBuilder primaryKeys = new StringBuilder();
                            XContentBuilder builder = XContentFactory.jsonBuilder();
                            builder.startObject();
                            for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
                                builder.field(table.getColumnNames()[i2].toLowerCase(), rowData[i2]);
                                for (Column col : lookupKeys) {
                                    if (!table.getColumnNames()[i2].equals(col.getName())) continue;
                                    primaryKeys.append(rowData[i2]);
                                    primaryKeys.append(",");
                                }
                            }
                            builder.endObject();
                            this.b.add(new IndexRequest(table.getNameLowerCase()).source(builder).id(primaryKeys.substring(0, primaryKeys.length() - 1)));
                            this.c = true;
                            break;
                        }
                        i.error("Index " + table.getNameLowerCase() + " does not exist.");
                        break;
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                default: {
                    this.context.put("bulkWriterToUse", (Object)"default");
                    super.write(data);
                }
            }
        }
        ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
        ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
    }

    protected boolean create(CsvData data) {
        String xml = null;
        try {
            Table indexTable = this.sourceTable;
            this.getTargetTransaction().commit();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            xml = data.getParsedData("rowData")[0];
            StringReader reader = new StringReader(xml);
            Database db2 = DatabaseXmlUtil.read((Reader)reader, (boolean)false);
            if (this.writerSettings.isCreateTableAlterCaseToMatchDatabaseDefault()) {
                this.getTargetPlatform().alterCaseToMatchDatabaseDefaultCase(db2);
            }
            this.getTargetPlatform().makePlatformSpecific(db2);
            GetIndexRequest validateIndex = new GetIndexRequest(new String[]{indexTable.getNameLowerCase()});
            if (Boolean.FALSE.equals(this.d)) {
                this.d = this.h.indices().exists(validateIndex, RequestOptions.DEFAULT);
            }
            if (this.d) {
                boolean bl2 = false;
                return bl2;
            }
            i.info("About to create index using the following definition: {}", (Object)xml);
            CreateIndexRequest createrequest = new CreateIndexRequest(indexTable.getNameLowerCase());
            try {
                this.h.indices().create(createrequest, RequestOptions.DEFAULT);
            }
            catch (IOException e2) {
                i.error("Failed to create in OpenSearch", (Throwable)e2);
                throw new RuntimeException(e2);
            }
            this.getTargetPlatform().resetCachedTableModel();
            ((Statistics)this.statistics.get(this.batch)).increment("CREATECOUNT");
            boolean bl3 = true;
            return bl3;
        }
        catch (RuntimeException ex2) {
            i.error("Failed to alter table using the following xml: " + xml, (Throwable)ex2);
            throw ex2;
        }
        catch (IOException e1) {
            i.error("Failed to alter in OpenSearch", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        finally {
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
        }
    }

    public boolean start(Table table) {
        return super.start(table);
    }

    public void end(Table table) {
        try {
            if (this.c) {
                this.a();
            }
        }
        finally {
            super.end(table);
        }
    }

    protected void a() {
        try {
            this.h.bulk(this.b, RequestOptions.DEFAULT);
        }
        catch (IOException e2) {
            i.error("Failed to use bulk database writer in OpenSearch", (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }
}

