/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.mongo;

import com.jumpmind.symmetric.console.impl.fT;
import com.jumpmind.symmetric.console.model.TableGroupHier;
import com.jumpmind.symmetric.db.mongo.f;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.CsvDataHier;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.DynamicDefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.service.IParameterService;

public class c
extends DynamicDefaultDatabaseWriter {
    MongoClient a = null;
    MongoDatabase b = null;
    MongoCollection<Document> c = null;
    Map<String, MongoCollection<Document>> d = null;
    Map<String, List<TableGroupHier>> e;
    fT f;
    Map<String, Table> g;
    IParameterService h;

    public c(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String prefix, IDatabaseWriterConflictResolver conflictResolver, DatabaseWriterSettings settings, Map<String, List<TableGroupHier>> tableGroupHierMap, IParameterService parameterService) {
        super(symmetricPlatform, targetPlatform, prefix, conflictResolver, settings);
        this.e = tableGroupHierMap;
        this.f = new fT(tableGroupHierMap);
        this.h = parameterService;
    }

    protected Table lookupTableAtTarget(Table sourceTable) {
        if (sourceTable != null && this.isSymmetricTable(sourceTable)) {
            return super.lookupTableAtTarget(sourceTable);
        }
        this.targetTables.put(sourceTable.getTableKey(), sourceTable);
        return sourceTable;
    }

    public boolean start(Table table) {
        this.b = this.a.getDatabase(table.getCatalog() == null ? ((f)this.targetPlatform).getDefaultCatalog() : table.getCatalog());
        this.c = this.b.getCollection(table.getName());
        if (this.f.a(table)) {
            if (this.d == null) {
                this.d = new HashMap<String, MongoCollection<Document>>();
            }
            this.d.put(table.getName(), this.c);
        }
        return super.start(table);
    }

    public void start(Batch batch) {
        super.start(batch);
        this.a = ((f)this.targetPlatform).a(true);
        if (this.d != null) {
            this.d.clear();
        }
        this.g = new HashMap<String, Table>();
    }

    protected AbstractDatabaseWriter.LoadStatus insert(CsvData data) {
        if (this.f.a(data)) {
            if (this.f.b()) {
                this.g.put(this.targetTable.getFullyQualifiedTableNameLowerCase(), this.targetTable);
            }
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        if (this.isSymmetricTable(this.targetTable)) {
            return super.insert(data);
        }
        Map dataColumnNamePairs = data.toColumnNameValuePairs(this.targetTable.getColumnNames(), "rowData");
        dataColumnNamePairs.remove("_id");
        this.a(true);
        Map<String, Object> newMap = dataColumnNamePairs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e2 -> e2.getValue()));
        Document document = new Document(newMap);
        this.c.insertOne((Object)document);
        this.a(false);
        return AbstractDatabaseWriter.LoadStatus.SUCCESS;
    }

    protected AbstractDatabaseWriter.LoadStatus update(CsvData data, boolean applyChangesOnly, boolean useConflictDetection) {
        if (this.f.a(data)) {
            if (this.f.b()) {
                this.g.put(this.targetTable.getFullyQualifiedTableNameLowerCase(), this.targetTable);
            }
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        if (this.isSymmetricTable(this.targetTable)) {
            return super.update(data, applyChangesOnly, useConflictDetection);
        }
        Bson updateOperation = null;
        for (Map.Entry entry : data.toColumnNameValuePairs(this.targetTable.getColumnNames(), "rowData").entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("_id")) continue;
            updateOperation = updateOperation == null ? Updates.set((String)((String)entry.getKey()), (Object)((String)entry.getValue())) : Updates.combine((Bson[])new Bson[]{updateOperation, Updates.set((String)((String)entry.getKey()), (Object)((String)entry.getValue()))});
        }
        this.a(true);
        UpdateResult updateResult = this.c.updateOne(this.a(data), updateOperation);
        this.a(false);
        return updateResult.getModifiedCount() > 0L ? AbstractDatabaseWriter.LoadStatus.SUCCESS : AbstractDatabaseWriter.LoadStatus.CONFLICT;
    }

    protected AbstractDatabaseWriter.LoadStatus delete(CsvData data, boolean useConflictDetection) {
        if (this.f.a(data)) {
            if (this.f.b()) {
                this.g.put(this.targetTable.getFullyQualifiedTableNameLowerCase(), this.targetTable);
            }
            return AbstractDatabaseWriter.LoadStatus.SUCCESS;
        }
        if (this.isSymmetricTable(this.targetTable)) {
            return super.delete(data, useConflictDetection);
        }
        this.a(true);
        DeleteResult deleteResult = this.c.deleteOne(this.a(data));
        return deleteResult.getDeletedCount() > 0L ? AbstractDatabaseWriter.LoadStatus.SUCCESS : AbstractDatabaseWriter.LoadStatus.CONFLICT;
    }

    protected Bson a(CsvData data) {
        ArrayList<Object> pkFilters = new ArrayList<Object>();
        for (Map.Entry entry : data.toKeyColumnValuePairs(this.targetTable).entrySet()) {
            if (((String)entry.getKey()).equals("_id")) {
                pkFilters.add(new Document((String)entry.getKey(), (Object)new ObjectId((String)entry.getValue())));
                continue;
            }
            pkFilters.add(Filters.eq((String)((String)entry.getKey()), (Object)((String)entry.getValue())));
        }
        return Filters.and(pkFilters);
    }

    protected void prepare() {
        if (this.isSymmetricTable(this.targetTable)) {
            super.prepare();
        }
    }

    public int prepareAndExecute(String sql, CsvData data) {
        if (this.isSymmetricTable(this.targetTable)) {
            return super.prepareAndExecute(sql, data);
        }
        return 1;
    }

    protected int execute(CsvData data, String[] values) {
        if (this.isSymmetricTable(this.targetTable)) {
            return super.execute(data, values);
        }
        return 1;
    }

    public void end(Batch batch, boolean inError) {
        for (CsvDataHier hier : this.f.a()) {
            Document document;
            Map<String, Object> dataMap = this.f.a(this.e, this.targetTables, hier, null);
            DataEventType eventType = hier.getCsvData().getDataEventType();
            this.c = this.d.get(hier.getTable());
            ArrayList<Object> pkFilters = new ArrayList<Object>();
            Table rootTable = this.g.get(Table.getFullyQualifiedTableName((String)hier.getCatalogLowerCase(), (String)hier.getSchemaLowerCase(), (String)hier.getTableLowerCase()));
            for (Map.Entry entry : hier.getCsvData().toKeyColumnValuePairs(rootTable).entrySet()) {
                if (((String)entry.getKey()).equals("_id")) {
                    pkFilters.add(new Document((String)entry.getKey(), (Object)new ObjectId((String)entry.getValue())));
                    continue;
                }
                pkFilters.add(Filters.eq((String)((String)entry.getKey()), (Object)((String)entry.getValue())));
            }
            if (eventType.equals((Object)DataEventType.INSERT)) {
                document = new Document(dataMap);
                this.c.replaceOne(Filters.and(pkFilters), (Object)document, new ReplaceOptions().upsert(true));
                continue;
            }
            if (eventType.equals((Object)DataEventType.UPDATE)) {
                document = new Document(dataMap);
                this.c.replaceOne(Filters.and(pkFilters), (Object)document);
                continue;
            }
            if (!eventType.equals((Object)DataEventType.DELETE)) continue;
            this.c.deleteOne(Filters.and(pkFilters));
        }
        super.end(batch, inError);
    }

    protected void allowInsertIntoAutoIncrementColumns(boolean value, Table table) {
    }

    protected boolean create(CsvData data) {
        return true;
    }

    protected void a(boolean value) {
        if (value) {
            this.h.saveParameter("dataloader.use.primary.keys.from.source", (Object)"true", "system");
            this.writerSettings.setUsePrimaryKeysFromSource(true);
        } else {
            this.h.saveParameter("dataloader.use.primary.keys.from.source", (Object)"false", "system");
            this.writerSettings.setUsePrimaryKeysFromSource(false);
        }
        this.h.rereadParameters();
    }
}

