/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.console.impl.gT;
import com.jumpmind.symmetric.console.impl.gU;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class h
extends AbstractBulkDatabaseWriter {
    private static final Logger a = LoggerFactory.getLogger(h.class);
    protected IStagingManager b;
    protected IStagedResource c;
    protected boolean d;
    protected boolean e;
    protected int f = 0;
    protected long g = 0L;
    protected boolean h;
    protected Table i = null;
    protected Table j = null;
    protected String k = null;
    protected String l;
    protected String m;
    protected String n;
    protected String o;
    protected String p = "''";
    protected int q;
    protected long r;
    protected String s;
    protected String t;
    protected String u;
    protected String v;
    protected String w;
    protected String x;
    protected gT y;
    protected String z;
    protected String A;
    protected String B;
    protected String C;
    protected gU D;
    protected boolean E;

    public abstract void b() throws SQLException;

    public abstract void a() throws SQLException;

    public abstract void c() throws SQLException;

    public h(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, Channel channel, String tablePrefix, IStagingManager stagingManager, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, IParameterService parameterService, ISecurityService securityService, DatabaseWriterSettings settings) {
        super(symmetricPlatform, targetPlatform, tablePrefix);
        this.b = stagingManager;
        this.writerSettings = settings;
        this.writerSettings.setDatabaseWriterFilters(filters);
        this.writerSettings.setDatabaseWriterErrorHandlers(errorHandlers);
        this.writerSettings.setCreateTableFailOnError(false);
        this.q = channel.getMaxBatchSize();
        this.r = parameterService.getLong("bulk.load.max.bytes.before.flush", -1L);
        this.s = parameterService.getString("cloud.bulk.load.s3.bucket");
        this.t = parameterService.getString("cloud.bulk.load.s3.access.key");
        String secretKey = parameterService.getString("cloud.bulk.load.s3.secret.key");
        if (secretKey != null && secretKey.startsWith("enc:")) {
            secretKey = securityService.decrypt(secretKey.substring("enc:".length()));
        }
        this.u = secretKey;
        this.v = parameterService.getString("cloud.bulk.load.s3.endpoint");
        this.x = parameterService.getString("cloud.bulk.load.s3.region", "us-east-1");
        this.z = parameterService.getString("cloud.bulk.load.azure.account.name");
        this.A = parameterService.getString("cloud.bulk.load.azure.account.key");
        this.B = parameterService.getString("cloud.bulk.load.azure.blob.container", "symmetricds");
        this.l = parameterService.getString("cloud.bulk.row.terminator", "\r\n");
        this.m = parameterService.getString("cloud.bulk.field.terminator", "|");
        this.n = parameterService.getString("cloud.bulk.field.quote", "\u00bf");
        this.o = parameterService.getString("cloud.bulk.codepage", "");
        String token = parameterService.getString("cloud.bulk.load.azure.sas.token");
        if (token != null && token.startsWith("enc:")) {
            token = securityService.decrypt(token.substring("enc:".length()));
        }
        this.C = token;
        if (this.z == null) {
            this.z = this.B;
        }
        if (this.A == null) {
            this.A = this.C;
        }
    }

    public void d() {
        this.c.close();
        ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
        this.y = new gT();
        this.y.a(this.c, this.s, this.t, this.u, this.v, this.x);
    }

    public void e() {
        this.D = new gU();
        this.D.a(this.z, this.A, this.B, this.c, this.k);
    }

    public void f() {
        if (this.y != null) {
            this.y.b(this.s);
        }
    }

    public void g() {
        if (this.D != null) {
            this.D.a();
        }
    }

    public boolean start(Table table) {
        this.i = table;
        if (super.start(table)) {
            if (this.lookupTableAtTarget(this.sourceTable) == null) {
                return true;
            }
            this.h = false;
            if (this.targetTable != null) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isAutoIncrement()) continue;
                    this.h = true;
                    break;
                }
            }
            if (this.sourceTable != null && this.targetTable == null) {
                Column[] qualifiedName = this.sourceTable.getFullyQualifiedTableName();
                if (this.writerSettings.isIgnoreMissingTables()) {
                    if (this.missingTables.add(qualifiedName)) {
                        a.info("Did not find the {} table in the target database. This might have been part of a sql command (truncate) but will work if the fully qualified name was in the sql provided", (Object)qualifiedName);
                    }
                } else {
                    throw new SymmetricException("Could not load the %s table.  It is not in the target database", new Object[]{qualifiedName});
                }
            }
            this.d = false;
            if (this.batch.getBinaryEncoding() != BinaryEncoding.HEX && this.targetTable != null) {
                for (Column column : this.targetTable.getColumns()) {
                    if (!column.isOfBinaryType()) continue;
                    this.d = true;
                    break;
                }
            }
            this.j = this.getPlatform(table).getTableFromCache(this.sourceTable.getCatalog(), this.sourceTable.getSchema(), this.sourceTable.getName(), false);
            if (this.sourceTable != null && this.j != null) {
                this.e = false;
                if (this.sourceTable.getColumnNames().length != this.j.getColumnNames().length) {
                    this.e = true;
                } else {
                    String[] csvNames = this.sourceTable.getColumnNames();
                    String[] columnNames = this.j.getColumnNames();
                    for (int i2 = 0; i2 < csvNames.length; ++i2) {
                        if (csvNames[i2].equals(columnNames[i2])) continue;
                        this.e = true;
                        break;
                    }
                }
            }
            if (this.c == null) {
                this.i();
            }
            return true;
        }
        return false;
    }

    public void end(Table table) {
        try {
            this.h();
            if (this.c != null) {
                this.c.close();
                this.c.delete();
            }
        }
        finally {
            super.end(table);
        }
    }

    public void bulkWrite(CsvData data) {
        block29: {
            DataEventType dataEventType = data.getDataEventType();
            if (this.filterBefore(data)) {
                try {
                    switch (dataEventType) {
                        case INSERT: {
                            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
                            try {
                                int i2;
                                String[] parsedData = data.getParsedData("rowData");
                                if (this.d) {
                                    Column[] columns = this.targetTable.getColumns();
                                    for (i2 = 0; i2 < columns.length; ++i2) {
                                        if (!columns[i2].isOfBinaryType() || this.batch.getBinaryEncoding() != BinaryEncoding.BASE64 || parsedData[i2] == null) continue;
                                        parsedData[i2] = new String(Hex.encodeHex((byte[])Base64.decodeBase64((byte[])parsedData[i2].getBytes(Charset.defaultCharset()))));
                                    }
                                }
                                OutputStream out = this.c.getOutputStream();
                                if (this.e) {
                                    Map mapData = data.toColumnNameValuePairs(this.sourceTable.getColumnNames(), "rowData");
                                    String[] columnNames = this.j.getColumnNames();
                                    for (int i3 = 0; i3 < columnNames.length; ++i3) {
                                        String columnData = (String)mapData.get(columnNames[i3]);
                                        if (columnData != null) {
                                            if (columnData.length() == 0 && this.E) {
                                                out.write(this.p.getBytes(Charset.defaultCharset()));
                                                this.g += (long)this.p.getBytes(Charset.defaultCharset()).length;
                                            } else {
                                                String escapedColumnValue = this.a(columnData);
                                                out.write(escapedColumnValue.getBytes(Charset.defaultCharset()));
                                                this.g += (long)escapedColumnValue.getBytes(Charset.defaultCharset()).length;
                                            }
                                        } else {
                                            String escapedNullColumnValue = this.a(columnData);
                                            if (escapedNullColumnValue != null) {
                                                out.write(escapedNullColumnValue.getBytes(Charset.defaultCharset()));
                                                this.g += (long)escapedNullColumnValue.getBytes(Charset.defaultCharset()).length;
                                            }
                                        }
                                        if (i3 + 1 >= columnNames.length) continue;
                                        out.write(this.m.getBytes(Charset.defaultCharset()));
                                        this.g += (long)this.m.getBytes(Charset.defaultCharset()).length;
                                    }
                                } else {
                                    for (i2 = 0; i2 < parsedData.length; ++i2) {
                                        if (parsedData[i2] != null) {
                                            if (parsedData[i2].length() == 0 && this.E) {
                                                out.write(this.p.getBytes(Charset.defaultCharset()));
                                                this.g += (long)this.p.getBytes(Charset.defaultCharset()).length;
                                            } else if (parsedData[i2] != null) {
                                                String escapedColumnValue = this.a(parsedData[i2]);
                                                out.write(escapedColumnValue.getBytes(Charset.defaultCharset()));
                                                this.g += (long)escapedColumnValue.getBytes(Charset.defaultCharset()).length;
                                            }
                                        } else {
                                            String escapedNullColumnValue = this.a(parsedData[i2]);
                                            if (escapedNullColumnValue != null) {
                                                out.write(escapedNullColumnValue.getBytes(Charset.defaultCharset()));
                                                this.g += (long)escapedNullColumnValue.getBytes(Charset.defaultCharset()).length;
                                            }
                                        }
                                        if (i2 + 1 >= parsedData.length) continue;
                                        out.write(this.m.getBytes(Charset.defaultCharset()));
                                        this.g += (long)this.m.getBytes(Charset.defaultCharset()).length;
                                    }
                                }
                                out.write(this.l.getBytes(Charset.defaultCharset()));
                                this.g += (long)this.l.getBytes(Charset.defaultCharset()).length;
                                ++this.f;
                                break;
                            }
                            catch (Exception ex2) {
                                throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
                            }
                            finally {
                                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                                ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
                                ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
                                ((Statistics)this.statistics.get(this.batch)).increment("BYTECOUNT");
                            }
                        }
                        default: {
                            this.h();
                            this.context.put("bulkWriterToUse", (Object)"default");
                            this.writeDefault(data);
                        }
                    }
                    if (this.f >= this.q && this.q > 0 || this.g >= this.r && this.r > 0L) {
                        this.h();
                    }
                    this.filterAfter(data);
                }
                catch (RuntimeException e2) {
                    if (!this.filterError(data, e2)) break block29;
                    throw e2;
                }
            }
        }
    }

    protected void h() {
        if (this.f > 0) {
            this.c.close();
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            try {
                this.b();
                this.a();
                this.c.delete();
                this.i();
            }
            catch (Throwable ex2) {
                throw this.getPlatform().getSqlTemplate().translate(ex2);
            }
            finally {
                ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
                this.c.delete();
                this.f = 0;
                this.g = 0L;
            }
        }
    }

    protected void i() {
        this.k = this.i.getName() + this.getBatch().getBatchId() + ".csv";
        this.c = this.b.create(new Object[]{"bulkloaddir", this.k});
    }

    protected String a(String columnValue) {
        return columnValue;
    }
}

