/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.db.bulk.c;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;

public class AseBulkDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory {
    private ISymmetricEngine engine;
    private ISecurityService securityService;

    public AseBulkDataLoaderFactory(ISymmetricEngine engine) {
        this.engine = engine;
        this.parameterService = engine.getParameterService();
        this.securityService = engine.getSecurityService();
    }

    public String getTypeName() {
        return "ase_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        String dbPassword;
        int maxRowsBeforeFlush = channel.getMaxBatchSize();
        String prefix = "";
        if (this.parameterService.is("load.only")) {
            prefix = "target.";
        }
        String dbUrl = this.parameterService.getString(prefix + "db.url");
        String dbUser = this.parameterService.getString(prefix + "db.user");
        if (dbUser != null && dbUser.startsWith("enc:")) {
            dbUser = this.securityService.decrypt(dbUser.substring("enc:".length()));
        }
        if ((dbPassword = this.parameterService.getString(prefix + "db.password")) != null && dbPassword.startsWith("enc:")) {
            dbPassword = this.securityService.decrypt(dbPassword.substring("enc:".length()));
        }
        String bcpPath = this.parameterService.getString("ase.bulk.load.bcp.cmd");
        String rowTerminator = StringEscapeUtils.unescapeJava((String)this.parameterService.getString("ase.bulk.load.row.terminator"));
        String fieldTerminator = StringEscapeUtils.unescapeJava((String)this.parameterService.getString("ase.bulk.load.field.terminator"));
        boolean useSourceStaging = this.parameterService.is("bcp.bulk.load.use.source.staging");
        return new c(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), this.engine.getStagingManager(), filters, maxRowsBeforeFlush, this.buildParameterDatabaseWriterSettings(conflictSettings), bcpPath, dbUser, dbPassword, dbUrl, fieldTerminator, rowTerminator, useSourceStaging);
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "ase".equals(platform.getName());
    }
}

