/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.graph;

import com.jumpmind.symmetric.console.impl.bF;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.statistic.ChannelStats;
import org.jumpmind.vaadin.ui.common.Colors;
import org.jumpmind.vaadin.ui.common.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.chartjs.ChartJs;
import org.vaadin.addons.chartjs.config.ChartConfig;
import org.vaadin.addons.chartjs.config.LineChartConfig;
import org.vaadin.addons.chartjs.data.Dataset;
import org.vaadin.addons.chartjs.data.LineDataset;
import org.vaadin.addons.chartjs.options.InteractionMode;
import org.vaadin.addons.chartjs.options.Position;
import org.vaadin.addons.chartjs.options.Tooltips;
import org.vaadin.addons.chartjs.options.scale.Axis;
import org.vaadin.addons.chartjs.options.scale.CategoryScale;
import org.vaadin.addons.chartjs.options.scale.LinearScale;
import org.vaadin.addons.chartjs.options.types.LineChartOptions;

public class ChannelStatsGraph
extends HorizontalLayout {
    private static final long n = 1L;
    Logger a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String[] b = Colors.colors();
    protected Map<String, Checkbox> c;
    protected ISymmetricEngine d;
    protected ChartJs e;
    protected List<String> f = new ArrayList<String>();
    protected LineChartConfig g;
    protected I h;
    protected int i = 60;
    protected String j;
    protected TreeMap<Date, Map<String, ChannelStats>> k;
    protected boolean l;
    boolean m = true;

    public ChannelStatsGraph(I controller) {
        this.h = controller;
        this.setWidthFull();
        this.j = ChannelStatsGraph.getDataTypes()[9];
        this.g = new LineChartConfig();
        this.g.data().labelsAsList(this.f);
        ((LineChartOptions)((LineChartOptions)((LineChartOptions)((LineChartOptions)((Tooltips)((LineChartOptions)((LineChartOptions)this.g.options().animation().duration(0).and()).legend().and()).tooltips().mode(InteractionMode.NEAREST).callbacks().label("tooltipItem.yLabel").and()).and()).hover().mode(InteractionMode.DATASET).and()).scales().add(Axis.X, ((CategoryScale)((CategoryScale)new CategoryScale().display(true).ticks().fontSize(9).and()).scaleLabel().display(true).and()).position(Position.BOTTOM)).add(Axis.Y, ((LinearScale)((LinearScale)new LinearScale().display(true).scaleLabel().display(true).and()).ticks().beginAtZero(true).fontSize(9).and()).position(Position.LEFT)).and()).maintainAspectRatio(false)).done();
        this.e = new ChartJs((ChartConfig)this.g);
        this.e.setSizeFull();
        this.e.getElement().getStyle().set("margin-left", "15px");
        this.addAndExpand(new Component[]{this.e});
        this.c();
    }

    public void selectAll() {
        Collection<Checkbox> boxes = this.c.values();
        for (Checkbox checkBox : boxes) {
            checkBox.setValue((Object)true);
        }
    }

    public void selectNone() {
        Collection<Checkbox> boxes = this.c.values();
        for (Checkbox checkBox : boxes) {
            checkBox.setValue((Object)false);
        }
    }

    private void c() {
        List<Channel> channels = bF.b(this.h.getSymmetricEngine(), as.a.BOTH);
        Map<String, Checkbox> oldLegend = this.c;
        this.c = new LinkedHashMap<String, Checkbox>();
        VerticalLayout layout = new VerticalLayout();
        layout.getStyle().set("margin", "16px 0 0 0");
        layout.setSizeUndefined();
        int index = 0;
        boolean defaultSetting = channels.size() < 30;
        for (Channel channel : channels) {
            if (channel == null || this.l && !channel.isFileSyncFlag()) continue;
            Checkbox checkBox = new Checkbox(channel.getChannelId());
            if (oldLegend != null && oldLegend.get(channel.getChannelId()) != null) {
                checkBox.setValue((Object)((Boolean)oldLegend.get(channel.getChannelId()).getValue()));
            } else {
                checkBox.setValue((Object)defaultSetting);
            }
            checkBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.refresh(this.k, false));
            HorizontalLayout checkBoxLayout = new HorizontalLayout();
            checkBoxLayout.add(new Component[]{new Label("<div style='width: 10px; height: 10px; margin: 3px; display: inline_block; opacity:0.9; border: 1px solid gray; vertical-align: bottom; border-radius: 2px; background-color: " + b[index % b.length] + "'></div>")});
            checkBoxLayout.add(new Component[]{checkBox});
            layout.add(new Component[]{checkBoxLayout});
            this.c.put(channel.getChannelId(), checkBox);
            ++index;
        }
        if (this.getComponentCount() == 2) {
            this.remove(new Component[]{this.getComponentAt(1)});
        }
        Scroller wrapper = new Scroller();
        wrapper.setHeightFull();
        wrapper.setWidth("12em");
        wrapper.setContent((Component)layout);
        this.add(new Component[]{wrapper});
    }

    protected List<Channel> a() {
        ArrayList<Channel> channels = new ArrayList<Channel>(this.h.getSymmetricEngine().getConfigurationService().getChannels(false).values());
        Collections.sort(channels, new Comparator<Channel>(){

            @Override
            public int compare(Channel o1, Channel o2) {
                return o1.getChannelId().compareTo(o2.getChannelId());
            }
        });
        if (this.l) {
            ArrayList<Channel> fileSyncChannels = new ArrayList<Channel>();
            for (Channel channel : channels) {
                if (!channel.isFileSyncFlag()) continue;
                fileSyncChannels.add(channel);
            }
            return fileSyncChannels;
        }
        return channels;
    }

    public String getName() {
        return this.h.getMessage("By Channel", new Object[0]);
    }

    public void refreshChart(TreeMap<Date, Map<String, ChannelStats>> orderedMap, boolean refreshLegend) {
        this.k = orderedMap;
        ISymmetricEngine engine = this.h.getSymmetricEngine();
        if (engine != null && engine.isStarted() && (!engine.equals(this.d) || this.c == null || this.a().size() != this.c.size())) {
            if (refreshLegend) {
                this.c();
            }
            this.d = engine;
        }
        ChartSeriesInfo seriesInfo = this.b();
        ArrayList<LineDataset> datasets = new ArrayList<LineDataset>();
        this.f.clear();
        if (seriesInfo.getLabels().length > 0) {
            String[] labels = seriesInfo.getLabels();
            String[] colors = seriesInfo.getColors();
            for (int i2 = 0; i2 < labels.length; ++i2) {
                String channel = labels[i2];
                String color = colors[i2];
                LineDataset dataset = new LineDataset();
                this.a(dataset, channel, color);
                datasets.add(dataset);
                if (orderedMap != null) {
                    for (Date time : orderedMap.keySet()) {
                        ChannelStats stats = orderedMap.get(time).get(channel);
                        dataset.addData(Double.valueOf(this.a(stats)));
                        if (this.f.size() >= orderedMap.size()) continue;
                        this.f.add(as.formatDate(this.h, time, true));
                    }
                    ChannelStats stats = (ChannelStats)engine.getStatisticManager().getWorkingChannelStats().get(channel);
                    dataset.addData(Double.valueOf(this.a(stats)));
                    if (this.f.size() > orderedMap.size()) continue;
                    this.f.add(as.formatDate(this.h, new Date(), true));
                    continue;
                }
                Date end = new Date();
                Calendar startCal = Calendar.getInstance();
                startCal.add(12, -this.i);
                startCal.set(13, 0);
                startCal.set(14, 0);
                startCal.set(12, this.a(startCal.get(12)));
                int interval = this.i / 120 * 5;
                interval = interval < 5 ? 5 : interval;
                Date periodStart = startCal.getTime();
                while (periodStart.before(end)) {
                    dataset.addData(Integer.valueOf(0));
                    if (i2 == 0) {
                        this.f.add(as.formatDate(this.h, periodStart, true));
                    }
                    periodStart = DateUtils.addMinutes((Date)periodStart, (int)interval);
                }
            }
        }
        this.g.data().clear();
        for (LineDataset dataset : datasets) {
            this.g.data().addDataset((Dataset)dataset);
        }
        this.e.update();
    }

    protected int a(int value) {
        return 5 * new BigDecimal((double)value / 5.0).setScale(2, RoundingMode.HALF_DOWN).intValue();
    }

    protected void a(LineDataset ds2, String label, String color) {
        ds2.label(label);
        ds2.lineTension(0.0);
        ds2.pointRadius(new Integer[]{0});
        ds2.borderColor(color);
        ds2.backgroundColor(color);
        ds2.fill(true);
        ds2.borderWidth(1);
    }

    protected double a(ChannelStats stat) {
        double doubleValue = 0.0;
        if (stat != null) {
            if ("Routed Rows".equals(this.j)) {
                doubleValue = stat.getDataRouted();
            } else if ("Unrouted Rows".equals(this.j)) {
                doubleValue = stat.getDataUnRouted();
            } else if ("Extracted Rows".equals(this.j)) {
                doubleValue = stat.getDataExtracted();
            } else if ("Extracted Bytes".equals(this.j)) {
                doubleValue = stat.getDataBytesExtracted();
            } else if ("Extracted Errors".equals(this.j)) {
                doubleValue = stat.getDataExtractedErrors();
            } else if ("Routed Events".equals(this.j)) {
                doubleValue = stat.getDataEventInserted();
            } else if ("Sent Rows".equals(this.j)) {
                doubleValue = stat.getDataSent();
            } else if ("Sent Bytes ".equals(this.j)) {
                doubleValue = stat.getDataBytesSent();
            } else if ("Sent Errors".equals(this.j)) {
                doubleValue = stat.getDataSentErrors();
            } else if ("Loaded Rows".equals(this.j)) {
                doubleValue = stat.getDataLoaded();
            } else if ("Loaded Bytes ".equals(this.j)) {
                doubleValue = stat.getDataBytesLoaded();
            } else if ("Loaded Errors".equals(this.j)) {
                doubleValue = stat.getDataLoadedErrors();
            }
        }
        return doubleValue;
    }

    public static String[] getDataTypes() {
        return new String[]{"Routed Rows", "Routed Events", "Unrouted Rows", "Extracted Rows", "Extracted Bytes", "Extracted Errors", "Sent Rows", "Sent Bytes ", "Sent Errors", "Loaded Rows", "Loaded Bytes ", "Loaded Errors"};
    }

    public void applicationClosing() {
    }

    protected ChartSeriesInfo b() {
        ArrayList<String> selectedChannels = new ArrayList<String>();
        ArrayList<String> selectedColors = new ArrayList<String>();
        int availableColors = b.length;
        int index = 0;
        if (this.c != null) {
            for (Checkbox checkBox : this.c.values()) {
                if (((Boolean)checkBox.getValue()).booleanValue() && index < availableColors) {
                    selectedChannels.add(checkBox.getLabel());
                    selectedColors.add(b[index]);
                }
                ++index;
            }
        }
        ChartSeriesInfo seriesInfo = new ChartSeriesInfo(selectedChannels.toArray(new String[selectedChannels.size()]), selectedColors.toArray(new String[selectedColors.size()]));
        return seriesInfo;
    }

    public boolean isOkToExit(Runnable exitClosure) {
        return true;
    }

    public void refresh(TreeMap<Date, Map<String, ChannelStats>> orderedMap, boolean refreshLegend) {
        this.refreshChart(orderedMap, refreshLegend);
    }

    public void setPeriodsInMinutes(int periodsInMinutes) {
        this.i = periodsInMinutes;
    }

    public int getPeriodsInMinutes() {
        return this.i;
    }

    public void setDataTypeToDisplay(String dataTypeToDisplay) {
        this.j = dataTypeToDisplay;
    }

    public String getDataTypeToDisplay() {
        return this.j;
    }

    public void setFileSyncOnly(boolean fileSyncOnly) {
        this.l = fileSyncOnly;
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$refreshLegend$3fab9f70$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/graph/ChannelStatsGraph") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)event -> this.refresh(this.k, false);
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }

    protected class ChartSeriesInfo {
        private String[] b;
        private String[] c;

        public ChartSeriesInfo(String[] labels, String[] colors) {
            this.b = labels;
            this.c = colors;
        }

        public String[] getLabels() {
            return this.b;
        }

        public void setLabels(String[] labels) {
            this.b = labels;
        }

        public String[] getColors() {
            return this.c;
        }

        public void setColors(String[] colors) {
            this.c = colors;
        }
    }
}

