/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.server.Command;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.events.AceValueChanged;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class l
implements ComponentEventListener<AceValueChanged> {
    private static final long serialVersionUID = 1L;
    private AceEditor editor;
    private Map<String, Class<?>> variableMap;
    private Map<String, Class<?>> methodMap;
    private int cursor;
    private boolean addPeriod;
    private boolean setCursorPosition;

    public l(AceEditor editor, Map<String, Class<?>> variableMap) {
        this.editor = editor;
        this.editor.setAutoComplete(true);
        this.variableMap = new HashMap();
        for (String variable : variableMap.keySet()) {
            this.variableMap.put(variable.substring(0, variable.indexOf(" ")), variableMap.get(variable));
        }
        this.methodMap = new HashMap();
        editor.addSyncCompletedListener((ComponentEventListener & Serializable)event -> {
            if (this.addPeriod) {
                editor.addTextAtCurrentPosition(".");
                this.addPeriod = false;
                editor.sync();
                this.setCursorPosition = true;
            }
        });
        editor.addValueChangeListener((ComponentEventListener & Serializable)event -> {
            this.cursor = this.getCursorPosition();
        });
        editor.addSelectionChangeListener((ComponentEventListener & Serializable)event -> {
            if (this.setCursorPosition && event.getSelection().getEndIndex() != this.cursor) {
                this.editor.setCursorPosition(this.cursor);
            }
            this.setCursorPosition = false;
        });
        Shortcuts.addShortcutListener((Component)editor, (Command & Serializable)() -> {
            this.addPeriod = true;
            editor.sync();
        }, (Key)Key.PERIOD, (KeyModifier[])new KeyModifier[0]);
    }

    public void onComponentEvent(AceValueChanged event) {
        List<Object> suggestions = new ArrayList();
        String text = this.editor.getValue();
        int cursor = this.getCursorPosition();
        if (cursor > 1 && text.charAt(cursor - 1) == '.') {
            String previousWord = this.getPreviousWord(text, cursor);
            String[] words = previousWord.split("\\.");
            for (int i2 = 0; i2 < words.length; ++i2) {
                String word = this.removeParametersIfMethodName(words[i2]);
                Map<String, Class<?>> classMap = this.methodMap;
                if (i2 == 0) {
                    classMap = this.variableMap;
                }
                if (!classMap.keySet().contains(word)) break;
                Class<?> returnType = classMap.get(word);
                if (i2 < words.length - 1) {
                    this.updateMethodMap(returnType);
                    continue;
                }
                suggestions = this.getSuggestions(returnType);
            }
        }
        suggestions.sort(null);
        this.editor.addStaticWordCompleter(suggestions);
    }

    private int getCursorPosition() {
        String value = this.editor.getValue();
        int cursorRow = this.editor.getCursorPosition().getRow();
        int cursorColumn = this.editor.getCursorPosition().getColumn();
        int row = 0;
        int column = 0;
        int index = 0;
        for (char c2 : value.toCharArray()) {
            if (row == cursorRow && column == cursorColumn) {
                return index;
            }
            if (c2 == '\n') {
                ++row;
                column = 0;
            } else {
                ++column;
            }
            ++index;
        }
        if (row == cursorRow && column == cursorColumn) {
            return index;
        }
        return -1;
    }

    private String getPreviousWord(String text, int cursor) {
        int i2;
        for (i2 = cursor - 1; i2 >= 0 && i2 != 0 && text.substring(i2 - 1, i2).matches("[a-zA-Z0-9$_().]"); --i2) {
        }
        return text.substring(i2, cursor - 1);
    }

    private String removeParametersIfMethodName(String methodName) {
        int closingParen;
        int openingParen;
        if (methodName.contains("(") && methodName.endsWith(")") && (openingParen = methodName.indexOf("(")) < (closingParen = methodName.indexOf(")"))) {
            return methodName.substring(0, openingParen + 1) + methodName.substring(closingParen);
        }
        return methodName;
    }

    private void updateMethodMap(Class<?> returnType) {
        Method[] methods = returnType.getMethods();
        this.methodMap.clear();
        for (Method method : methods) {
            String methodName = method.getName();
            String methodReturnType = method.getReturnType().getName();
            try {
                this.methodMap.put(methodName + "()", Class.forName(methodReturnType));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private List<String> getSuggestions(Class<?> returnType) {
        Method[] methods;
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Method method : methods = returnType.getMethods()) {
            suggestions.add(method.getName() + "()");
        }
        return suggestions;
    }
}

