/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.service.IProConsoleService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.service.IUpdateService;

public class at
extends Dialog {
    private IProConsoleService consoleService;
    private IUpdateService updateService;
    private I controller;
    private long reminderInterval;
    private String latestVersion;
    private H3 message;
    boolean hasNewestVersionChanged = false;
    private static final String[] ITEMS = new String[]{"Tomorrow", "Next Week", "Next Month", "in 6 Months", "Never"};
    private static final long serialVersionUID = 1L;

    public at(I controller) {
        this.controller = controller;
        this.consoleService = controller.getProConsoleService();
        this.updateService = controller.getSymmetricEngine().getUpdateService();
        TypedProperties settings = this.consoleService.getSettings(controller.getConsoleUser().getUserId());
        VerticalLayout updateReminderLayout = new VerticalLayout();
        HorizontalLayout textLayout = new HorizontalLayout();
        HorizontalLayout comboBoxLayout = new HorizontalLayout();
        this.message = new H3("");
        this.latestVersion = this.updateService.getLatestVersion();
        this.message.getElement().setProperty("innerHTML", String.format("<b>SymmetricDS version <span style=\"color:%s;\">%s</span> is now available!</b>", "#ef8030", this.latestVersion));
        textLayout.add(new Component[]{this.message});
        textLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.message});
        if (!this.latestVersion.equalsIgnoreCase(settings.get("pro.console.newest.version"))) {
            this.hasNewestVersionChanged = true;
        }
        HashMap<String, Long> stringToTimeMap = new HashMap<String, Long>();
        int j2 = 0;
        stringToTimeMap.put(ITEMS[j2++], 86400000L);
        stringToTimeMap.put(ITEMS[j2++], 604800000L);
        stringToTimeMap.put(ITEMS[j2++], 2419200000L);
        stringToTimeMap.put(ITEMS[j2++], 14515200000L);
        stringToTimeMap.put(ITEMS[j2++], -1L);
        ArrayList<String> itemList = new ArrayList<String>();
        for (int i2 = 0; i2 < ITEMS.length; ++i2) {
            itemList.add(ITEMS[i2]);
        }
        this.reminderInterval = Long.parseLong(settings.get("pro.console.remind.interval"));
        itemList.add("Later");
        String selectedItem = "Later";
        for (String item : ITEMS) {
            if (!((Long)stringToTimeMap.get(item)).equals(this.reminderInterval)) continue;
            selectedItem = item;
            itemList.remove("Later");
        }
        Select remindIntervalField = new Select();
        remindIntervalField.setItems(itemList);
        remindIntervalField.setWidth("140px");
        remindIntervalField.setValue((Object)selectedItem);
        remindIntervalField.setEmptySelectionAllowed(false);
        Anchor download = new Anchor();
        download.setHref(this.updateService.getDownloadUrl());
        download.setTarget("_blank");
        download.add(new Component[]{new Button("Download")});
        Button dismiss = new Button("Dismiss", (ComponentEventListener & Serializable)event -> {
            String string = (String)remindIntervalField.getValue();
            if (!string.equalsIgnoreCase("Later")) {
                this.reminderInterval = (Long)stringToTimeMap.get(string);
            }
            TypedProperties newSettings = this.consoleService.getSettings(controller.getConsoleUser().getUserId());
            newSettings.setProperty("pro.console.remind.interval", this.reminderInterval);
            newSettings.setProperty("pro.console.last.remind.time", new Date().toString());
            newSettings.setProperty("pro.console.newest.version", this.latestVersion);
            this.consoleService.saveSettings(newSettings, controller.getConsoleUser().getUserId());
            this.close();
        });
        Span nextRemind = new Span("Remind me again:");
        comboBoxLayout.add(new Component[]{nextRemind});
        comboBoxLayout.add(new Component[]{remindIntervalField});
        comboBoxLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{nextRemind, remindIntervalField});
        updateReminderLayout.setHeight("150px");
        updateReminderLayout.setWidth("400px");
        updateReminderLayout.add(new Component[]{textLayout});
        updateReminderLayout.add(new Component[]{comboBoxLayout});
        updateReminderLayout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{textLayout, comboBoxLayout});
        this.add(new Component[]{updateReminderLayout});
        this.getFooter().add(new Component[]{download, dismiss});
    }

    public long getReminderInterval() {
        return this.reminderInterval;
    }

    public boolean hasLatestVersionChanged() {
        return this.hasNewestVersionChanged;
    }

    public long getLastReminded() {
        TypedProperties settings = this.consoleService.getSettings(this.controller.getConsoleUser().getUserId());
        SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        long value = 0L;
        try {
            String date = settings.get("pro.console.last.remind.time");
            value = format.parse(date).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

