/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.c;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToLongConverter;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.vaadin.ui.common.Label;

public class al
extends c {
    private static final long serialVersionUID = 1L;
    private boolean isNumeric;
    private Select<FilterCriterion.FilterOption> options;
    private TextField startText;
    private TextField endText;
    private Binder<?> startBinder;
    private boolean startBinderValid = false;
    private Binder<Long> endBinder;
    private boolean endBinderValid = false;

    public al(String propertyId, boolean isNumeric) {
        this.setSpacing(true);
        this.propertyId = propertyId;
        this.isNumeric = isNumeric;
        this.title = StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)propertyId), (String)" "));
        this.titleLabel = new Label("<b>" + this.title + "</b>");
        this.titleLabel.setWidth("100px");
        this.titleLabel.getStyle().set("margin-top", "8px");
        this.add(new Component[]{this.titleLabel});
        ArrayList<FilterCriterion.FilterOption> optionList = new ArrayList<FilterCriterion.FilterOption>();
        optionList.add(FilterCriterion.FilterOption.EQUALS);
        optionList.add(FilterCriterion.FilterOption.NOT_EQUALS);
        optionList.add(FilterCriterion.FilterOption.CONTAINS);
        optionList.add(FilterCriterion.FilterOption.NOT_CONTAINS);
        if (isNumeric) {
            optionList.add(FilterCriterion.FilterOption.GREATER);
            optionList.add(FilterCriterion.FilterOption.GREATER_EQUAL);
            optionList.add(FilterCriterion.FilterOption.LESS);
            optionList.add(FilterCriterion.FilterOption.LESS_EQUAL);
            optionList.add(FilterCriterion.FilterOption.BETWEEN);
        }
        this.options = new Select();
        this.options.setItems(optionList);
        this.options.setEmptySelectionAllowed(false);
        this.options.setValue((Object)FilterCriterion.FilterOption.EQUALS);
        this.options.setWidth("200px");
        this.add(new Component[]{this.options});
        HorizontalLayout fieldLayout = new HorizontalLayout();
        this.startText = new TextField();
        this.startText.setWidth("200px");
        if (isNumeric) {
            this.startBinder = new Binder();
            this.startBinder.forField((HasValue)this.startText).asRequired("Please Enter a Value").withConverter((Converter)new StringToLongConverter("Please Enter a Valid Number")).withValidator((SerializablePredicate & Serializable)value -> {
                if (((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN)) {
                    if (!this.startText.isEmpty() && !this.endText.isEmpty()) {
                        try {
                            this.startBinderValid = value <= Long.parseLong(this.endText.getValue());
                        }
                        catch (NumberFormatException e2) {
                            this.startBinderValid = false;
                        }
                    } else {
                        this.startBinderValid = true;
                    }
                } else {
                    this.startBinderValid = true;
                }
                if (((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN) && this.startBinderValid != this.endBinderValid) {
                    this.endBinder.validate();
                }
                return this.startBinderValid;
            }, "Please Enter a Valid Number Range").bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
        } else {
            this.startBinder = new Binder();
            this.startBinder.forField((HasValue)this.startText).asRequired("Please Enter a Value").bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
        }
        this.startText.setRequiredIndicatorVisible(false);
        fieldLayout.add(new Component[]{this.startText});
        if (isNumeric) {
            this.endBinder = new Binder();
            this.endText = new TextField();
            this.endText.setVisible(false);
            this.endText.setPlaceholder("End");
            this.endText.setWidth("200px");
            this.endBinder.forField((HasValue)this.endText).asRequired("Please Enter a Value").withConverter((Converter)new StringToLongConverter("Please Enter a Valid Number")).withValidator((SerializablePredicate & Serializable)value -> {
                if (!this.startText.isEmpty() && !this.endText.isEmpty()) {
                    try {
                        this.endBinderValid = Long.parseLong(this.startText.getValue()) <= value;
                    }
                    catch (NumberFormatException e2) {
                        this.endBinderValid = false;
                    }
                } else {
                    this.endBinderValid = true;
                }
                if (this.startBinderValid != this.endBinderValid) {
                    this.startBinder.validate();
                }
                return this.endBinderValid;
            }, "Please Enter a Valid Number Range").bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
                value = newValue;
            });
            this.endText.setRequiredIndicatorVisible(false);
            fieldLayout.add(new Component[]{this.endText});
        }
        this.options.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (((FilterCriterion.FilterOption)event.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN)) {
                this.endText.setVisible(true);
                this.startText.setPlaceholder("Start");
                if (!this.endText.getValue().isEmpty()) {
                    this.endBinder.validate();
                }
            } else {
                if (isNumeric) {
                    this.endText.setVisible(false);
                }
                this.startText.setPlaceholder("");
                if (!this.startText.getValue().isEmpty()) {
                    this.startBinder.validate();
                }
            }
        });
        this.add(new Component[]{fieldLayout});
        this.add(new Component[]{this.applyButton});
    }

    @Override
    public void onFilterApplied() {
        if (this.startText.getValue().isEmpty()) {
            this.startText.setRequiredIndicatorVisible(true);
        }
        if (this.isNumeric && this.endText.getValue().isEmpty()) {
            this.endText.setRequiredIndicatorVisible(true);
        }
        if (this.startBinder.validate().isOk() & (!((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN) || this.endBinder.validate().isOk())) {
            FilterCriterion filterCriterion = new FilterCriterion();
            filterCriterion.setPropertyId(this.propertyId);
            ArrayList<Object> values = new ArrayList<Object>();
            if (this.isNumeric) {
                values.add(Long.parseLong(this.startText.getValue()));
                if (((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN)) {
                    values.add(Long.parseLong(this.endText.getValue()));
                }
            } else {
                values.add(this.startText.getValue());
            }
            filterCriterion.setValues(values);
            filterCriterion.setOption((FilterCriterion.FilterOption)this.options.getValue());
            this.window.applyFilter(filterCriterion);
        }
        this.startText.setRequiredIndicatorVisible(false);
        if (this.isNumeric) {
            this.endText.setRequiredIndicatorVisible(false);
        }
    }
}

