/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.UI;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.config.ITriggerCreationListener;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerHistory;

public class ai
implements M.a<Object> {
    I controller;
    UI ui;
    Collection<TriggerHistory> triggerHists;
    String targetExternalId;
    boolean force;
    boolean rebuildAll;
    boolean lockNotAcquired;
    Lock lock;

    public ai(I controller, UI ui, Collection<TriggerHistory> triggerHists, String targetExternalId, boolean force, boolean rebuildAll) {
        this.controller = controller;
        this.ui = ui;
        this.triggerHists = triggerHists;
        this.targetExternalId = targetExternalId;
        this.force = force;
        this.rebuildAll = rebuildAll;
    }

    @Override
    public Object doWork() {
        ISymmetricEngine engine = this.controller.getSymmetricEngine();
        String engineName = engine.getEngineName();
        String event = "Reconfigure table for capture";
        if (this.triggerHists != null) {
            List listenerList = this.controller.getSymmetricEngine().getExtensionService().getExtensionPointList(ITriggerCreationListener.class);
            if (engineName != null && engineName.equals(this.controller.getSymmetricEngine().getEngineName())) {
                for (ITriggerCreationListener l2 : listenerList) {
                    l2.syncTriggersStarted();
                }
            }
            int histCount = 0;
            for (TriggerHistory triggerHist : this.triggerHists) {
                ++histCount;
                Table dbTable = new Table(triggerHist.getSourceCatalogName(), triggerHist.getSourceSchemaName(), triggerHist.getSourceTableName());
                if (!engine.getTriggerRouterService().syncTriggers(dbTable, this.force)) {
                    this.lockNotAcquired = true;
                    this.lock = (Lock)this.controller.getSymmetricEngine().getClusterService().findLocks().get("SyncTriggers");
                    return null;
                }
                if (engineName == null || !engineName.equals(this.controller.getSymmetricEngine().getEngineName())) continue;
                for (ITriggerCreationListener l3 : listenerList) {
                    l3.triggerChecked(this.triggerHists.size(), histCount);
                }
            }
            if (engineName != null && engineName.equals(this.controller.getSymmetricEngine().getEngineName())) {
                for (ITriggerCreationListener l4 : listenerList) {
                    l4.syncTriggersEnded();
                }
            }
            if (this.rebuildAll) {
                event = "Reconfigure all tables for capture";
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)this.targetExternalId)) {
                this.lockNotAcquired = !engine.getTriggerRouterService().syncTriggers(this.targetExternalId, this.force);
            } else if (this.force) {
                this.lockNotAcquired = !engine.forceTriggerRebuild();
            } else {
                boolean bl2 = this.lockNotAcquired = !engine.syncTriggers();
            }
            if (this.lockNotAcquired) {
                this.lock = (Lock)this.controller.getSymmetricEngine().getClusterService().findLocks().get("SyncTriggers");
            }
        }
        Node identity = this.controller.getSymmetricEngine().getNodeService().findIdentity();
        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), event, identity.getNodeId(), identity.getNodeId(), null, "forced=" + this.force + (String)(StringUtils.isBlank((CharSequence)this.targetExternalId) ? "" : ", targetExternalId=" + this.targetExternalId)));
        return null;
    }

    @Override
    public void doUI(Object data) {
        if (this.lockNotAcquired) {
            as.notifySyncTriggersLockNotAcquired(this.lock);
        }
    }
}

