/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.ui.c;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M<T>
extends Dialog {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(M.class);
    a<T> worker;
    c backgroundService;
    String failureMessage;
    Span percentComplete;
    ProgressBar progressBar;

    public M(String caption, a<T> worker, c backgroundService) {
        this(caption, worker, backgroundService, null, true, false);
    }

    public M(String caption, a<T> worker, c backgroundService, String failureMessage) {
        this(caption, worker, backgroundService, failureMessage, true, false);
    }

    public M(String caption, a<T> worker, c backgroundService, String failureMessage, boolean showDismissButton, boolean showProgressBar) {
        this(caption, null, worker, backgroundService, failureMessage, showDismissButton, showProgressBar);
    }

    public M(String caption, String description, a<T> worker, c backgroundService, String failureMessage, boolean showDismissButton, boolean showProgressBar) {
        this.backgroundService = backgroundService;
        this.worker = worker;
        this.failureMessage = failureMessage;
        this.setWidth("400px");
        this.setHeight("230px");
        this.setModal(true);
        this.setHeaderTitle("Working...");
        VerticalLayout content = new VerticalLayout();
        content.setWidthFull();
        this.add(new Component[]{content});
        HorizontalLayout middle = new HorizontalLayout();
        middle.setSizeFull();
        middle.setWidth(null);
        middle.setSpacing(true);
        middle.setMargin(true);
        if (!showProgressBar) {
            middle.add(new Component[]{as.getSpinnerIcon("24px", "inherit")});
            if (StringUtils.isNotBlank((CharSequence)caption)) {
                span = new Span(caption);
                middle.add(new Component[]{span});
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)caption)) {
                span = new Span(caption);
                middle.addAndExpand(new Component[]{span});
            }
            this.percentComplete = new Span("0%");
            this.progressBar = new ProgressBar();
            this.progressBar.getStyle().set("width", "initial");
            this.progressBar.getStyle().set("min-width", "120px");
            this.progressBar.setValue(0.0);
            middle.add(new Component[]{this.percentComplete, this.progressBar});
            middle.getStyle().set("margin-left", "0");
        }
        content.addAndExpand(new Component[]{middle});
        content.setHeight("45%");
        if (StringUtils.isNotBlank((CharSequence)description)) {
            Span descriptionSpan = new Span(description);
            descriptionSpan.getStyle().set("font-size", "var(--lumo-font-size-s)").set("display", "block").set("margin-top", "30px");
            this.add(new Component[]{descriptionSpan});
        }
        if (showDismissButton) {
            Button dismiss = new Button("Dismiss");
            dismiss.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            dismiss.addClickShortcut(Key.ENTER, new KeyModifier[0]);
            dismiss.addClickListener((ComponentEventListener & Serializable)event -> this.close());
            this.getFooter().add(new Component[]{dismiss});
        } else {
            this.setCloseOnEsc(false);
            this.setCloseOnOutsideClick(false);
        }
    }

    public void show() {
        this.open();
        this.backgroundService.b(new G<T>(){

            @Override
            public T onBackgroundDataRefresh(ISymmetricEngine engine) {
                return M.this.worker.doWork();
            }

            @Override
            public void onBackgroundUIRefresh(T work) {
                M.this.worker.doUI(work);
                Optional ui = M.this.getUI();
                if (ui.isPresent()) {
                    as.securelyAccessUI((UI)ui.get(), (Command & Serializable)() -> M.this.close());
                }
                M.this.close();
            }

            @Override
            public void onUIError(Throwable ex2) {
                if (M.this.failureMessage != null) {
                    CommonUiUtils.notify((String)M.this.failureMessage);
                } else {
                    CommonUiUtils.notifyError();
                }
                Optional ui = M.this.getUI();
                if (ui.isPresent()) {
                    as.securelyAccessUI((UI)ui.get(), (Command & Serializable)() -> M.this.close());
                }
            }
        });
    }

    public void updateProgress(int stepNumber, int totalSteps) {
        UI ui = this.progressBar.getUI().orElse(UI.getCurrent());
        if (ui != null) {
            float value = Math.min((float)stepNumber / (float)totalSteps, 0.99f);
            ui.access((Command & Serializable)() -> {
                this.progressBar.setValue((double)value);
                this.percentComplete.setText(Math.round(value * 100.0f) + "%");
            });
        }
    }

    public static interface a<T> {
        public T doWork();

        public void doUI(T var1);
    }
}

