/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.jumpmind.symmetric.console.model.AbstractSubsetRule;
import com.jumpmind.symmetric.console.model.ColumnRule;
import com.jumpmind.symmetric.console.model.LookupRule;
import com.jumpmind.symmetric.console.model.SubselectRule;
import com.jumpmind.symmetric.console.ui.canvas.AbstractSidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvas;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasLink;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasSourceToTargetLayout;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTable;
import com.jumpmind.symmetric.console.ui.canvas.ISidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.TransformDataScreen;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.X;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.o;
import com.jumpmind.symmetric.console.ui.common.s;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.details.Details;
import com.vaadin.flow.component.details.DetailsVariant;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import de.f0rce.ace.AceEditor;
import de.f0rce.ace.enums.AceMode;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Table;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.vaadin.tatu.TwinColSelect;

public class SubsetDataScreen
extends AbstractSidebarScreen {
    private static final long serialVersionUID = 1L;
    private boolean canSubsetFirst;
    private boolean canSubsetSecond;
    private Set<String> expandedRuleNameSet = new HashSet<String>();
    private Span newRuleSpan;
    private VerticalLayout emptyLayout;
    private HorizontalLayout rulesHeader;
    private VerticalLayout rulesLayout;
    private Button collapseAllButton;
    private boolean autoExpand = true;

    public SubsetDataScreen(I controller, ConfigCanvas canvas) {
        super(controller, canvas, controller.getMessage("Subset Data", new Object[0]), controller.getMessage("Optionally define subsets of data that get routed to different target endpoints.", new Object[0]));
        o infoIcon = new o(controller.getContextPath(), VaadinIcon.INFO_CIRCLE_O, o.a.MEDIUM);
        infoIcon.getCircleDiv().setHeight("48px");
        infoIcon.getCircleDiv().setWidth("48px");
        this.newRuleSpan = new Span(controller.getMessage(this.readOnly || this.errorMessageVisible ? "No subset rules are configured." : "Create a new rule to define specific data that gets pulled from tables.", new Object[0]));
        this.newRuleSpan.addClassName("less-contrast");
        ConfigCanvasEndpoint firstEndpoint = canvas.getFirstEndpoint();
        ConfigCanvasEndpoint secondEndpoint = canvas.getSecondEndpoint();
        this.canSubsetFirst = this.canSubset(firstEndpoint, secondEndpoint);
        this.canSubsetSecond = this.canSubset(secondEndpoint, firstEndpoint) && !firstEndpoint.getId().equals(secondEndpoint.getId());
        this.emptyLayout = new VerticalLayout();
        this.emptyLayout.setSizeFull();
        this.emptyLayout.addAndExpand(new Component[]{new Span()});
        this.emptyLayout.add(new Component[]{infoIcon, this.newRuleSpan, this.createNewRuleDiv(true)});
        this.emptyLayout.addAndExpand(new Component[]{new Span()});
        this.emptyLayout.setDefaultHorizontalComponentAlignment(FlexComponent.Alignment.CENTER);
        this.emptyLayout.addClassName("subtle-border");
        this.emptyLayout.getStyle().set("margin-left", "0").set("border-style", "dashed");
        this.collapseAllButton = new Button(controller.getMessage("Collapse all", new Object[0]), (ComponentEventListener & Serializable)event -> {
            this.expandedRuleNameSet.clear();
            this.autoExpand = false;
            this.refreshRulesLayout();
        });
        this.collapseAllButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        this.collapseAllButton.setEnabled(false);
        this.rulesHeader = new HorizontalLayout(new Component[]{this.createNewRuleDiv(false)});
        this.rulesHeader.addAndExpand(new Component[]{new Span()});
        this.rulesHeader.add(new Component[]{this.collapseAllButton});
        this.rulesHeader.setWidthFull();
        this.rulesHeader.getStyle().set("padding", "0 12px").set("border-bottom", "1px solid var(--lumo-contrast-20pct)");
        this.rulesLayout = new VerticalLayout(new Component[]{this.rulesHeader});
        this.rulesLayout.setMaxHeight("90%");
        this.rulesLayout.setSpacing(false);
        this.rulesLayout.addClassName("subtle-border");
        this.rulesLayout.getStyle().set("margin-left", "0").set("padding", "0");
        this.rulesLayout.setVisible(false);
        this.refreshRulesLayout();
        this.add(new Component[]{this.emptyLayout, this.rulesLayout});
    }

    private Div createNewRuleDiv(boolean primary) {
        Button newRuleButton = new Button(this.controller.getMessage("New Subset Rule", new Object[0]), (Component)new Icon(VaadinIcon.PLUS), (ComponentEventListener & Serializable)event -> new SubsetRuleDialog().open());
        newRuleButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{primary ? ButtonVariant.LUMO_PRIMARY : ButtonVariant.LUMO_TERTIARY});
        Div newRuleDiv = new Div(new Component[]{newRuleButton});
        if (this.readOnly) {
            newRuleButton.setEnabled(false);
            Tooltip.forComponent((Component)newRuleDiv).setText(this.controller.getMessage("Requires write permission", new Object[0]));
        } else if (this.errorMessageVisible) {
            newRuleButton.setEnabled(false);
            Tooltip.forComponent((Component)newRuleDiv).setText(this.controller.getMessage("Requires valid connection details", new Object[0]));
        } else if (!this.canSubsetFirst && !this.canSubsetSecond) {
            this.newRuleSpan.setText(this.controller.getMessage("Subsetting must be configured post-deployment for the selected endpoint types.", new Object[0]));
            newRuleButton.setEnabled(false);
        } else {
            newRuleButton.setEnabled(true);
            Tooltip.forComponent((Component)newRuleDiv).setText(this.controller.getMessage("Open the Define Subset Rule dialog", new Object[0]));
        }
        return newRuleDiv;
    }

    private boolean canSubset(ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint) {
        s.a sourceType = sourceEndpoint.getType();
        return (sourceType == null || !sourceType.isWriteOnly() && !sourceType.equals(s.SQLITE) && !sourceType.equals(s.MONGO) && !sourceType.equals(s.COSMOS)) && sourceEndpoint.getTableCount(targetEndpoint.getGuid()) > 0;
    }

    private void refreshRulesLayout() {
        this.rulesLayout.removeAll();
        this.rulesLayout.add(new Component[]{this.rulesHeader});
        ConfigCanvasEndpoint firstEndpoint = this.canvas.getFirstEndpoint();
        ConfigCanvasEndpoint secondEndpoint = this.canvas.getSecondEndpoint();
        List<AbstractSubsetRule> outgoingRuleList = firstEndpoint.getSubsetRuleList(secondEndpoint.getGuid());
        List<AbstractSubsetRule> incomingRuleList = secondEndpoint.getSubsetRuleList(firstEndpoint.getGuid());
        List<AbstractSubsetRule> ruleList = firstEndpoint.getGuid().equals(secondEndpoint.getGuid()) ? outgoingRuleList : Stream.concat(outgoingRuleList.stream(), incomingRuleList.stream()).toList();
        if (!ruleList.isEmpty()) {
            VerticalLayout innerRulesLayout = new VerticalLayout();
            innerRulesLayout.setMargin(false);
            innerRulesLayout.setPadding(false);
            innerRulesLayout.setSpacing(false);
            this.collapseAllButton.setEnabled(this.autoExpand || !this.expandedRuleNameSet.isEmpty());
            for (int i2 = 0; i2 < ruleList.size(); ++i2) {
                AbstractSubsetRule rule = ruleList.get(i2);
                if (this.autoExpand && i2 < 3) {
                    this.expandedRuleNameSet.add(rule.getName());
                }
                HorizontalLayout ruleHeader = new HorizontalLayout();
                if (!this.readOnly) {
                    o deleteIcon = new o(this.controller.getContextPath(), VaadinIcon.CLOSE_SMALL);
                    deleteIcon.getElement().addEventListener("click", (DomEventListener & Serializable)e2 -> {}).addEventData("event.stopPropagation()");
                    deleteIcon.addClickListener(() -> {
                        ConfigCanvasEndpoint endpoint;
                        if (outgoingRuleList.contains(rule)) {
                            endpoint = firstEndpoint;
                            outgoingRuleList.remove(rule);
                        } else {
                            endpoint = secondEndpoint;
                            incomingRuleList.remove(rule);
                        }
                        this.refreshRulesLayout();
                        this.canvas.redrawDiagramIfStateChanged(endpoint);
                    });
                    Tooltip.forComponent((Component)deleteIcon).setText(this.controller.getMessage("Remove this rule", new Object[0]));
                    ruleHeader.add(new Component[]{deleteIcon});
                }
                Span typeSpan = new Span();
                if (rule instanceof ColumnRule) {
                    typeSpan.setText(this.controller.getMessage("Subset by Column", new Object[0]));
                } else if (rule instanceof LookupRule) {
                    typeSpan.setText(this.controller.getMessage("Subset by Table", new Object[0]));
                } else {
                    typeSpan.setText(this.controller.getMessage("Subset by SQL", new Object[0]));
                }
                typeSpan.addClassNames(new String[]{"less-contrast", "font-bold"});
                int tableCount = rule.getTableSet().size();
                Span tableCountSpan = tableCount == 1 ? new Span(this.controller.getMessage("1 table", new Object[0])) : new Span(this.controller.getMessage("%d tables", tableCount));
                tableCountSpan.addClassName("less-contrast");
                ruleHeader.add(new Component[]{typeSpan, this.canvas.getLinkLayout(outgoingRuleList.contains(rule), false), tableCountSpan});
                ruleHeader.setWidthFull();
                ruleHeader.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
                ruleHeader.getStyle().set("padding-left", "12px");
                FlexLayout parameterLayout = new FlexLayout();
                parameterLayout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
                if (rule instanceof ColumnRule) {
                    ColumnRule columnRule = (ColumnRule)rule;
                    Label columnNameBadge = this.createBadge(this.controller.getMessage("Column name: <b>%s</b>", columnRule.getColumnName()));
                    String represents = columnRule.getRepresents();
                    if (represents != null && represents.startsWith(":")) {
                        represents = represents.substring(1);
                    }
                    Label representsBadge = this.createBadge(this.controller.getMessage("Represents: <b>%s</b>", represents));
                    parameterLayout.add(new Component[]{columnNameBadge, representsBadge});
                } else if (rule instanceof LookupRule) {
                    LookupRule lookupRule = (LookupRule)rule;
                    Label tableNameBadge = this.createBadge(this.controller.getMessage("Table name: <b>%s</b>", lookupRule.getLookupTableName()));
                    Label lookupColumnNameBadge = this.createBadge(this.controller.getMessage("Lookup column name: <b>%s</b>", lookupRule.getLookupColumnName()));
                    Label externalIdColumnNameBadge = this.createBadge(this.controller.getMessage("External ID column name: <b>%s</b>", lookupRule.getExternalIdColumnName()));
                    Label replicatedColumnNameBadge = this.createBadge(this.controller.getMessage("Replicated column name: <b>%s</b>", lookupRule.getReplicatedColumnName()));
                    parameterLayout.add(new Component[]{tableNameBadge, lookupColumnNameBadge, externalIdColumnNameBadge, replicatedColumnNameBadge});
                } else {
                    parameterLayout.add(new Component[]{this.createBadge(this.controller.getMessage("SQL: <b>%s</b>", ((SubselectRule)rule).getSubselect()))});
                }
                Label ruleNameLabel = new Label(this.controller.getMessage("Rule Name: <b>%s</b>", rule.getName()));
                ruleNameLabel.addClassName("less-contrast");
                ruleNameLabel.getStyle().set("padding-left", "8px");
                HorizontalLayout ruleNameLayout = new HorizontalLayout(new Component[]{ruleNameLabel});
                ruleNameLayout.setPadding(false);
                if (!this.readOnly && !this.errorMessageVisible) {
                    Icon editIcon = new Icon(VaadinIcon.EDIT);
                    editIcon.setSize("20px");
                    editIcon.setColor("var(--lumo-primary-text-color)");
                    editIcon.getStyle().set("margin-top", "4px").set("cursor", "pointer");
                    editIcon.setTooltipText(this.controller.getMessage("Edit this rule's name", new Object[0]));
                    ruleNameLayout.add(new Component[]{editIcon});
                    TextField ruleNameField = new TextField(this.controller.getMessage("Rule Name", new Object[0]));
                    ruleNameField.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
                    ruleNameField.setValueChangeMode(ValueChangeMode.EAGER);
                    ruleNameField.setManualValidation(true);
                    ruleNameField.setValue(rule.getName());
                    ruleNameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        String ruleName = (String)event.getValue();
                        if (ruleName.length() > 47) {
                            ruleNameField.setErrorMessage(this.controller.getMessage("Rule Name cannot exceed 47 characters", new Object[0]));
                            ruleNameField.setInvalid(true);
                        } else if (ruleName.length() == 0) {
                            ruleNameField.setErrorMessage(this.controller.getMessage("Rule Name cannot be empty", new Object[0]));
                            ruleNameField.setInvalid(true);
                        } else {
                            ruleNameField.setInvalid(false);
                        }
                    });
                    Shortcuts.addShortcutListener((Component)ruleNameField, (ShortcutEventListener & Serializable)event -> ruleNameField.blur(), (Key)Key.ENTER, (KeyModifier[])new KeyModifier[0]);
                    ruleNameField.addBlurListener((ComponentEventListener & Serializable)event -> {
                        boolean ruleNameChanged;
                        String ruleName = rule.getName();
                        String newRuleName = ruleNameField.getValue();
                        boolean ruleNameAlreadyInvalid = ruleNameField.isInvalid();
                        boolean bl2 = ruleNameChanged = !ruleName.equals(newRuleName);
                        if (!(ruleNameAlreadyInvalid || ruleNameChanged && !this.isRuleNameUnique(newRuleName))) {
                            ruleNameField.setInvalid(false);
                            if (ruleNameChanged) {
                                String originalRuleName = rule.getOriginalName();
                                if (originalRuleName == null) {
                                    rule.setOriginalName(ruleName);
                                } else if (originalRuleName.equals(newRuleName)) {
                                    rule.setOriginalName(null);
                                }
                            }
                            rule.setName(newRuleName);
                            ruleNameLabel.setText(this.controller.getMessage("Rule Name: <b>%s</b>", newRuleName));
                            ruleNameLayout.removeAll();
                            ruleNameLayout.add(new Component[]{ruleNameLabel, editIcon});
                            this.canvas.enableShortcuts(true);
                            if (ruleNameChanged) {
                                this.canvas.redrawDiagramIfStateChanged(outgoingRuleList.contains(rule) ? firstEndpoint : secondEndpoint);
                            }
                        } else {
                            if (!ruleNameAlreadyInvalid) {
                                ruleNameField.setErrorMessage(this.controller.getMessage("Rule Name must be unique", new Object[0]));
                                ruleNameField.setInvalid(true);
                            }
                            ruleNameField.focus();
                        }
                    });
                    this.canvas.addListenersToToggleDeleteShortcut((Focusable<?>)ruleNameField);
                    editIcon.addClickListener((ComponentEventListener & Serializable)event -> {
                        this.canvas.enableShortcuts(false);
                        ruleNameLayout.removeAll();
                        ruleNameLayout.add(new Component[]{ruleNameField});
                        ruleNameField.focus();
                    });
                }
                VerticalLayout ruleLayout = new VerticalLayout(new Component[]{parameterLayout, ruleNameLayout});
                ruleLayout.setSpacing(false);
                ruleLayout.getStyle().set("padding", "0 8px 8px 8px");
                Details ruleDetails = new Details((Component)ruleHeader, (Component)ruleLayout);
                ruleDetails.setWidthFull();
                ruleDetails.addThemeVariants((ThemeVariant[])new DetailsVariant[]{DetailsVariant.REVERSE});
                ruleDetails.setOpened(this.expandedRuleNameSet.contains(rule.getName()));
                ruleDetails.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
                    if (event.isOpened()) {
                        this.expandedRuleNameSet.add(rule.getName());
                    } else {
                        this.expandedRuleNameSet.remove(rule.getName());
                    }
                    this.collapseAllButton.setEnabled(!this.expandedRuleNameSet.isEmpty());
                });
                Hr divider = new Hr();
                if (ruleList.indexOf(rule) == ruleList.size() - 1) {
                    divider.getStyle().set("margin", "0 16px 32px 16px");
                } else {
                    divider.getStyle().set("margin", "0 16px");
                }
                innerRulesLayout.add(new Component[]{ruleDetails, divider});
            }
            Scroller scroller = new Scroller((Component)innerRulesLayout);
            scroller.setSizeFull();
            scroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
            scroller.getStyle().set("padding", "0").set("margin", "0");
            this.rulesLayout.add(new Component[]{scroller});
            this.emptyLayout.setVisible(false);
            this.rulesLayout.setVisible(true);
        } else {
            this.rulesLayout.setVisible(false);
            this.emptyLayout.setVisible(true);
        }
    }

    private Label createBadge(String text) {
        Label badge = new Label(text);
        badge.getElement().getThemeList().add((Object)"badge contrast");
        badge.addClassName("subtle-border");
        badge.getStyle().set("max-width", "98%").set("padding", "0.4em calc(0.5em + var(--lumo-border-radius-s) / 4)");
        return badge;
    }

    private boolean isRuleNameUnique(String ruleName) {
        HashSet ruleNameSet = new HashSet();
        for (ConfigCanvasEndpoint endpoint : this.canvas.getEndpointList()) {
            for (ConfigCanvasLink link : endpoint.getLinkList()) {
                ruleNameSet.addAll(link.getSubsetRuleList().stream().map(r2 -> r2.getName()).collect(Collectors.toList()));
            }
        }
        return !ruleNameSet.contains(ruleName);
    }

    @Override
    public int getProgressStepperIndex() {
        return 3;
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public boolean isPreviousEnabled() {
        return true;
    }

    @Override
    public ISidebarScreen next() {
        this.canvas.getProgressStepper().setStepComplete(this.getProgressStepperIndex());
        return new TransformDataScreen(this.controller, this.canvas);
    }

    @Override
    public boolean last() {
        this.canvas.getProgressStepper().setStepComplete(this.getProgressStepperIndex());
        return true;
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_subset_rule_configuration";
    }

    class SubsetRuleDialog
    extends X {
        private static final long serialVersionUID = 1L;
        private final String OUTGOING = "outgoing";
        private final String INCOMING = "incoming";
        private final String EXTERNAL_ID = "EXTERNAL_ID";
        private final String NODE_ID = "NODE_ID";
        private final String NODE_GROUP_ID = " NODE_GROUP_ID";
        private ConfigCanvasEndpoint sourceEndpoint;
        private ConfigCanvasEndpoint targetEndpoint;
        private String tablePrefix;
        private TextField ruleName;
        private Select<String> nodeLink;
        private String selectedNodeLink;
        private RadioButtonGroup<String> subsetOptions;
        private TextField columnName;
        private Select<String> represents;
        private VerticalLayout columnLayout;
        private VerticalLayout subsetLayout;
        private List<ConfigCanvasTable> tables;
        private Set<ConfigCanvasTable> selectedTables;
        private Set<ConfigCanvasTable> viewableTables;
        private Label tableSelectionLabel;
        private ConfigCanvasSourceToTargetLayout sourceToTargetLayout;
        private TwinColSelect<ConfigCanvasTable> tableSelector;
        private boolean refreshingTableSelector;
        private VerticalLayout tableSelectionLayout;
        private RadioButtonGroup<String> relatedTableOptions;
        private ComboBox<LookupDetails> relatedTableName;
        private ComboBox<String> externalIdColumnName;
        private VerticalLayout lookupLayout;
        private MenuBar dataVariableMenu;
        private AceEditor subselect;
        private VerticalLayout subselectLayout;
        private VerticalLayout relatedTableLayout;
        private Button nextButton;
        private Tooltip nextTooltip;
        private M<Object> metadataDialog;

        public SubsetRuleDialog() {
            super(SubsetDataScreen.this.controller.getMessage("Define Subset Rule", new Object[0]), SubsetDataScreen.this.controller.getContextPath(), null, SubsetDataScreen.this.controller.getMessage("Close the dialog without saving the new rule", new Object[0]));
            this.OUTGOING = "outgoing";
            this.INCOMING = "incoming";
            this.EXTERNAL_ID = "EXTERNAL_ID";
            this.NODE_ID = "NODE_ID";
            this.NODE_GROUP_ID = " NODE_GROUP_ID";
            this.tables = new ArrayList<ConfigCanvasTable>();
            this.selectedTables = new HashSet<ConfigCanvasTable>();
            this.viewableTables = new TreeSet<ConfigCanvasTable>((t0, t1) -> t0.getName().toLowerCase().compareTo(t1.getName().toLowerCase()));
            this.tableSelector = new TwinColSelect();
            this.nextButton = as.createPrimaryButton(SubsetDataScreen.this.controller.getMessage("Next", new Object[0]));
            this.tablePrefix = SubsetDataScreen.this.controller.getSymmetricEngine() != null ? SubsetDataScreen.this.controller.getSymmetricEngine().getTablePrefix() : "sym_";
            this.setHeight("770px");
            this.setWidth("1400px");
            this.setCloseOnOutsideClick(false);
            this.ruleName = new TextField(SubsetDataScreen.this.controller.getMessage("Rule Name", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> {
                if (((String)event.getValue()).length() > 47) {
                    this.ruleName.setErrorMessage(SubsetDataScreen.this.controller.getMessage("Rule Name cannot exceed 47 characters", new Object[0]));
                    this.ruleName.setInvalid(true);
                } else {
                    this.ruleName.setInvalid(false);
                }
                this.refreshNextButton(this.isNextEnabled());
            });
            this.ruleName.setWidth("40%");
            this.ruleName.getStyle().set("padding-bottom", "16px");
            this.ruleName.setPlaceholder(SubsetDataScreen.this.controller.getMessage("My rule name", new Object[0]));
            this.ruleName.setValueChangeMode(ValueChangeMode.EAGER);
            this.ruleName.setManualValidation(true);
            this.nodeLink = new Select();
            this.nodeLink.setLabel(SubsetDataScreen.this.controller.getMessage("Node Link", new Object[0]));
            this.nodeLink.setPlaceholder(SubsetDataScreen.this.controller.getMessage("Choose a node link", new Object[0]));
            this.nodeLink.setWidth("40%");
            this.nodeLink.getStyle().set("padding-bottom", "16px");
            if (!SubsetDataScreen.this.canSubsetFirst) {
                this.nodeLink.setReadOnly(true);
                this.nodeLink.setItems((Object[])new String[]{"incoming"});
                this.nodeLink.setValue((Object)"incoming");
                this.sourceEndpoint = SubsetDataScreen.this.canvas.getSecondEndpoint();
                this.targetEndpoint = SubsetDataScreen.this.canvas.getFirstEndpoint();
            } else if (!SubsetDataScreen.this.canSubsetSecond) {
                this.nodeLink.setReadOnly(true);
                this.nodeLink.setItems((Object[])new String[]{"outgoing"});
                this.nodeLink.setValue((Object)"outgoing");
                this.sourceEndpoint = SubsetDataScreen.this.canvas.getFirstEndpoint();
                this.targetEndpoint = SubsetDataScreen.this.canvas.getSecondEndpoint();
            } else {
                this.nodeLink.setItems((Object[])new String[]{"outgoing", "incoming"});
                Hr linkDivider = new Hr();
                linkDivider.getStyle().set("margin", "0 32px");
                this.nodeLink.addComponents((Object)"outgoing", new Component[]{linkDivider});
            }
            this.nodeLink.setRenderer(new ComponentRenderer((SerializableFunction & Serializable)link -> SubsetDataScreen.this.canvas.getLinkLayout(link.equals("outgoing"), false)));
            String sameTableOption = SubsetDataScreen.this.controller.getMessage("Subset by a column on <b>the same table</b> to determine target endpoints.", new Object[0]);
            String relatedTableOption = SubsetDataScreen.this.controller.getMessage("Subset by a column on <b>a related table</b> to determine target endpoints.", new Object[0]);
            this.nodeLink.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.sourceEndpoint = ((String)event.getValue()).equals("outgoing") ? SubsetDataScreen.this.canvas.getFirstEndpoint() : SubsetDataScreen.this.canvas.getSecondEndpoint();
                this.targetEndpoint = ((String)event.getValue()).equals("outgoing") ? SubsetDataScreen.this.canvas.getSecondEndpoint() : SubsetDataScreen.this.canvas.getFirstEndpoint();
                this.refreshNextButton(this.isNextEnabled());
                if (this.sourceEndpoint.getType().equals(s.REDSHIFT) || this.targetEndpoint.getType().equals(s.REDSHIFT)) {
                    String selectedOption = (String)this.subsetOptions.getValue();
                    this.subsetOptions.getListDataView().refreshAll();
                    if (relatedTableOption.equals(selectedOption) && this.sourceEndpoint.getType().equals(s.REDSHIFT)) {
                        this.subsetOptions.setValue((Object)sameTableOption);
                    } else {
                        this.subsetOptions.setValue((Object)selectedOption);
                    }
                }
            });
            Span subsetSpan = new Span(SubsetDataScreen.this.controller.getMessage("How would you like to subset tables?", new Object[0]));
            subsetSpan.addClassName("less-contrast");
            subsetSpan.getStyle().set("padding-top", "16px").set("font-size", "var(--lumo-font-size-l)");
            this.subsetOptions = new RadioButtonGroup();
            this.subsetOptions.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.subsetOptions.setRenderer(new ComponentRenderer((SerializableFunction & Serializable)option -> {
                Label label = new Label(option);
                label.addClassName("less-contrast");
                return label;
            }));
            this.subsetOptions.getStyle().set("padding-bottom", "24px");
            this.subsetOptions.setItems((Object[])new String[]{sameTableOption, relatedTableOption});
            this.subsetOptions.setItemEnabledProvider((SerializablePredicate & Serializable)item -> !relatedTableOption.equals(item) || this.sourceEndpoint == null || !this.sourceEndpoint.getType().equals(s.REDSHIFT));
            this.subsetOptions.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.refreshColumnLayout();
                this.refreshNextButton(this.isNextEnabled());
            });
            this.columnName = new TextField();
            this.columnName.setPlaceholder(SubsetDataScreen.this.controller.getMessage("Enter a column", new Object[0]));
            this.columnName.setWidth("250px");
            this.columnName.setValueChangeMode(ValueChangeMode.EAGER);
            this.columnName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.columnName.setInvalid(false);
                this.refreshNextButton(this.isNextEnabled());
            });
            this.columnName.setManualValidation(true);
            this.represents = new Select();
            this.represents.setLabel(SubsetDataScreen.this.controller.getMessage("Represents", new Object[0]));
            this.represents.setPlaceholder(SubsetDataScreen.this.controller.getMessage("Choose a value", new Object[0]));
            ArrayList<String> columnRepresentsList = new ArrayList<String>();
            columnRepresentsList.add("EXTERNAL_ID");
            columnRepresentsList.add("NODE_ID");
            columnRepresentsList.add(" NODE_GROUP_ID");
            this.represents.setItems(columnRepresentsList);
            this.represents.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.refreshNextButton(this.isNextEnabled()));
            this.columnLayout = new VerticalLayout();
            this.columnLayout.setMargin(false);
            this.columnLayout.setPadding(false);
            this.columnLayout.setSpacing(false);
            this.subsetLayout = new VerticalLayout(new Component[]{this.ruleName, this.nodeLink, subsetSpan, this.subsetOptions, this.columnLayout});
            this.subsetLayout.setSizeFull();
            this.subsetLayout.setMargin(false);
            this.subsetLayout.setSpacing(false);
            this.relatedTableOptions = new RadioButtonGroup();
            this.relatedTableOptions.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            this.relatedTableOptions.setRenderer(new ComponentRenderer((SerializableFunction & Serializable)option -> {
                Label label = new Label(option);
                label.addClassName("less-contrast");
                return label;
            }));
            this.relatedTableOptions.getStyle().set("padding-bottom", "16px");
            String oneTableOption = SubsetDataScreen.this.controller.getMessage("Join to <b>one</b> external table to determine target endpoints.", new Object[0]);
            String multipleTablesOption = SubsetDataScreen.this.controller.getMessage("Join to <b>multiple</b> external tables to determine target endpoints.", new Object[0]);
            this.relatedTableOptions.setItems((Object[])new String[]{oneTableOption, multipleTablesOption});
            this.relatedTableOptions.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                boolean oneTable = ((String)event.getValue()).equals(oneTableOption);
                this.lookupLayout.setVisible(oneTable);
                this.subselectLayout.setVisible(!oneTable);
                this.refreshNextButton(this.isNextEnabled());
            });
            this.tableSelectionLabel = new Label();
            this.tableSelectionLabel.addClassName("less-contrast");
            this.tableSelectionLabel.getStyle().set("padding", "0 0 8px 8px");
            this.buildLookupLayout();
            this.buildSubselectLayout();
            this.relatedTableLayout = new VerticalLayout(new Component[]{this.relatedTableOptions, this.lookupLayout, this.subselectLayout});
            this.relatedTableLayout.setVisible(false);
            this.mainLayout.add(new Component[]{this.subsetLayout, this.relatedTableLayout});
            this.mainLayout.setSpacing(false);
            this.mainLayout.getStyle().set("margin", "0");
            Anchor helpAnchor = SubsetDataScreen.this.canvas.createHelpAnchor(SubsetDataScreen.this.getDocAnchor());
            helpAnchor.getStyle().set("margin-right", "auto");
            Button cancelButton = new Button(SubsetDataScreen.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
            cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            cancelButton.getStyle().set("margin-right", "10px");
            cancelButton.setTooltipText(SubsetDataScreen.this.controller.getMessage("Close the dialog without saving the new rule", new Object[0]));
            final Button previousButton = new Button(SubsetDataScreen.this.controller.getMessage("Previous", new Object[0]));
            previousButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            previousButton.getStyle().set("margin-right", "10px");
            previousButton.setVisible(false);
            previousButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.tableSelectionLayout.isVisible()) {
                    this.tableSelectionLayout.setVisible(false);
                    this.subsetLayout.setVisible(true);
                    previousButton.setVisible(false);
                } else {
                    this.relatedTableLayout.setVisible(false);
                    this.tableSelectionLayout.setVisible(true);
                }
                this.nextButton.setText(SubsetDataScreen.this.controller.getMessage("Next", new Object[0]));
                this.refreshNextButton(this.isNextEnabled());
            });
            previousButton.setTooltipText(SubsetDataScreen.this.controller.getMessage("Go back to the previous screen", new Object[0]));
            this.nextButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (this.nextButton.getText().equals(SubsetDataScreen.this.controller.getMessage("Next", new Object[0]))) {
                    if (this.subsetLayout.isVisible()) {
                        if (!SubsetDataScreen.this.isRuleNameUnique(this.ruleName.getValue())) {
                            this.ruleName.setErrorMessage(SubsetDataScreen.this.controller.getMessage("Rule Name must be unique", new Object[0]));
                            this.ruleName.setInvalid(true);
                            return;
                        }
                        this.selectedTables.clear();
                        if (((String)this.subsetOptions.getValue()).equals(SubsetDataScreen.this.controller.getMessage("Subset by a column on <b>the same table</b> to determine target endpoints.", new Object[0]))) {
                            this.tableSelectionLabel.setText(SubsetDataScreen.this.controller.getMessage("Choose tables that will be impacted by this subset rule. The below tables all have a column named <b>%s</b>.", this.columnName.getValue()));
                        } else {
                            this.tableSelectionLabel.setText(SubsetDataScreen.this.controller.getMessage("Choose tables that will be impacted by this subset rule. The below tables all have a foreign key that references a column named <b>%s</b>.", this.columnName.getValue()));
                        }
                        if (this.tableSelectionLayout == null || !((String)this.nodeLink.getValue()).equals(this.selectedNodeLink)) {
                            this.selectedNodeLink = (String)this.nodeLink.getValue();
                            if (this.tableSelectionLayout != null) {
                                this.remove(new Component[]{this.tableSelectionLayout});
                            }
                            this.buildTableSelectionLayout();
                            this.mainLayout.add(new Component[]{this.tableSelectionLayout});
                        }
                        this.refreshCatalogs();
                        this.refreshSchemas();
                        this.metadataDialog = new M<Object>(SubsetDataScreen.this.controller.getMessage("Loading table metadata...", new Object[0]), new M.a<Object>(){

                            @Override
                            public Object doWork() {
                                boolean joiningRelatedTable = !((String)SubsetRuleDialog.this.subsetOptions.getValue()).equals(SubsetDataScreen.this.controller.getMessage("Subset by a column on <b>the same table</b> to determine target endpoints.", new Object[0]));
                                Set<ConfigCanvasTable> tableSet = SubsetRuleDialog.this.sourceEndpoint.getAllTables(SubsetRuleDialog.this.targetEndpoint.getGuid());
                                int tableCount = tableSet.size();
                                int i2 = 0;
                                for (ConfigCanvasTable table : tableSet) {
                                    String catalog = table.getCatalog();
                                    String schema = table.getSchema();
                                    String tableName = table.getName();
                                    Table dbTable = SubsetRuleDialog.this.sourceEndpoint.getDatabasePlatform().getDdlReader().readTable(catalog, schema, tableName);
                                    if (joiningRelatedTable) {
                                        table.removeAllForeignKeys();
                                        if (dbTable != null) {
                                            table.addForeignKeys(dbTable.getForeignKeys());
                                        }
                                    }
                                    table.removeAllColumns();
                                    if (dbTable != null) {
                                        table.addColumns(dbTable.getColumnsAsList());
                                    }
                                    SubsetRuleDialog.this.metadataDialog.updateProgress(++i2, tableCount);
                                }
                                return null;
                            }

                            @Override
                            public void doUI(Object data) {
                                SubsetRuleDialog.this.refreshTableSelector();
                                boolean joiningRelatedTable = !((String)SubsetRuleDialog.this.subsetOptions.getValue()).equals(SubsetDataScreen.this.controller.getMessage("Subset by a column on <b>the same table</b> to determine target endpoints.", new Object[0]));
                                List<ConfigCanvasTable> allMatchingTables = SubsetRuleDialog.this.getTables(false);
                                if (!allMatchingTables.isEmpty()) {
                                    if (SubsetRuleDialog.this.viewableTables.isEmpty()) {
                                        Select<String> schemaSelect;
                                        ConfigCanvasTable matchingTable = allMatchingTables.get(0);
                                        Select<String> catalogSelect = SubsetRuleDialog.this.sourceToTargetLayout.getCatalogSelect(true);
                                        if (catalogSelect.isVisible()) {
                                            String catalog = (String)StringUtils.defaultIfBlank((CharSequence)matchingTable.getCatalog(), (CharSequence)SubsetRuleDialog.this.sourceEndpoint.getDefaultCatalog());
                                            catalogSelect.setValue((Object)catalog);
                                        }
                                        if ((schemaSelect = SubsetRuleDialog.this.sourceToTargetLayout.getSchemaSelect(true)).isVisible()) {
                                            String schema = (String)StringUtils.defaultIfBlank((CharSequence)matchingTable.getSchema(), (CharSequence)SubsetRuleDialog.this.sourceEndpoint.getDefaultSchema());
                                            schemaSelect.setValue((Object)schema);
                                        }
                                        SubsetRuleDialog.this.refreshTableSelector();
                                    }
                                    SubsetRuleDialog.this.subsetLayout.setVisible(false);
                                    SubsetRuleDialog.this.tableSelectionLayout.setVisible(true);
                                    previousButton.setVisible(true);
                                    if (!joiningRelatedTable) {
                                        SubsetRuleDialog.this.nextButton.setText("Finish");
                                    }
                                    SubsetRuleDialog.this.refreshNextButton(!SubsetRuleDialog.this.selectedTables.isEmpty());
                                } else {
                                    SubsetRuleDialog.this.columnName.setErrorMessage(SubsetDataScreen.this.controller.getMessage(joiningRelatedTable ? "No tables were found with a foreign key that references this column" : "No tables were found with this column", new Object[0]));
                                    SubsetRuleDialog.this.columnName.setInvalid(true);
                                }
                            }
                        }, SubsetDataScreen.this.controller.getBackgroundRefresherService(), null, false, true);
                        this.metadataDialog.show();
                    } else {
                        this.tableSelectionLayout.setVisible(false);
                        this.relatedTableLayout.setVisible(true);
                        this.refreshLookupLayout();
                        this.refreshSubselectLayout();
                        this.nextButton.setText("Finish");
                        this.refreshNextButton(this.isNextEnabled());
                    }
                } else {
                    AbstractSubsetRule rule;
                    if (((String)this.subsetOptions.getValue()).equals(sameTableOption)) {
                        rule = new ColumnRule(this.selectedTables, this.ruleName.getValue(), this.columnName.getValue(), ":" + (String)this.represents.getValue());
                    } else if (this.lookupLayout.isVisible()) {
                        LookupDetails lookupDetails = (LookupDetails)this.relatedTableName.getValue();
                        rule = new LookupRule(this.selectedTables, this.ruleName.getValue(), lookupDetails.getLookupTable().getFullyQualifiedSourceTableName(), lookupDetails.getLocalColumnName(), (String)this.externalIdColumnName.getValue(), this.columnName.getValue());
                    } else {
                        rule = new SubselectRule(this.selectedTables, this.ruleName.getValue(), this.subselect.getValue());
                    }
                    List<AbstractSubsetRule> ruleList = this.sourceEndpoint.getSubsetRuleList(this.targetEndpoint.getGuid());
                    ruleList.add(rule);
                    SubsetDataScreen.this.refreshRulesLayout();
                    SubsetDataScreen.this.canvas.redrawDiagramIfStateChanged(this.sourceEndpoint);
                    this.close();
                }
            });
            Div nextDiv = new Div(new Component[]{this.nextButton});
            this.nextTooltip = Tooltip.forComponent((Component)nextDiv).withText(SubsetDataScreen.this.controller.getMessage("Proceed to the next screen", new Object[0]));
            this.getFooter().add(new Component[]{helpAnchor, cancelButton, previousButton, nextDiv});
            this.subsetOptions.setValue((Object)sameTableOption);
            this.tableSelector.addSelectionListener((MultiSelectionListener & Serializable)event -> {
                if (!this.refreshingTableSelector) {
                    this.selectedTables.addAll(event.getAddedSelection());
                    this.selectedTables.removeAll(event.getRemovedSelection());
                    this.refreshNextButton(!this.selectedTables.isEmpty());
                    this.tableSelector.setItems(this.viewableTables);
                }
            });
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> SubsetDataScreen.this.canvas.toggleDeleteShortcut(!event.isOpened()));
        }

        private void refreshColumnLayout() {
            this.columnLayout.removeAll();
            if (this.subsetOptions.getValue() != null) {
                boolean useSameTable = ((String)this.subsetOptions.getValue()).equals(SubsetDataScreen.this.controller.getMessage("Subset by a column on <b>the same table</b> to determine target endpoints.", new Object[0]));
                H5 header = new H5(SubsetDataScreen.this.controller.getMessage(useSameTable ? "Subset by Columns Rule" : "Subset Using a Related Table", new Object[0]));
                header.addClassName("less-contrast");
                Span description = new Span(SubsetDataScreen.this.controller.getMessage(useSameTable ? "Specify a column that represents a value. The column name will be used to find tables for you to select from." : "Specify a column on a related table to join to. The column name will be used to find tables for you to select from.", new Object[0]));
                description.addClassName("less-contrast");
                this.columnName.setLabel(SubsetDataScreen.this.controller.getMessage(useSameTable ? "Column name" : "Join Column Name", new Object[0]));
                if (useSameTable) {
                    HorizontalLayout layout = new HorizontalLayout();
                    layout.add(new Component[]{this.columnName, this.represents});
                    this.columnLayout.add(new Component[]{header, description, layout});
                } else {
                    this.columnLayout.add(new Component[]{header, description, this.columnName});
                }
            }
        }

        private void buildTableSelectionLayout() {
            this.sourceToTargetLayout = new ConfigCanvasSourceToTargetLayout(SubsetDataScreen.this.controller, this.sourceEndpoint, this.targetEndpoint, null, null, true, false, false){
                private static final long serialVersionUID = 1L;

                @Override
                protected void initCatalogSchemaFields(boolean source, Select<String> catalogSelect, Select<String> schemaSelect) {
                    if (source) {
                        catalogSelect.setValue((Object)SubsetRuleDialog.this.sourceEndpoint.getDefaultCatalog());
                        catalogSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                            if (event.isFromClient()) {
                                SubsetRuleDialog.this.refreshSchemas();
                                SubsetRuleDialog.this.refreshTableSelector();
                            }
                        });
                        schemaSelect.setValue((Object)SubsetRuleDialog.this.sourceEndpoint.getDefaultSchema());
                        schemaSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> SubsetRuleDialog.this.refreshTableSelector());
                    }
                }

                @Override
                protected void initFilterField(boolean source, TextField filterField, HorizontalLayout filterLayout) {
                    super.initFilterField(source, filterField, filterLayout);
                    filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        filterField.setValue((String)event.getValue());
                        SubsetRuleDialog.this.refreshTableSelector();
                    });
                }
            };
            this.sourceToTargetLayout.init();
            this.tableSelector.setItems(this.viewableTables);
            this.tableSelector.setHeight(null);
            this.tableSelector.getStyle().set("padding", "0 8px 8px 8px");
            this.tableSelector.setItemLabelGenerator((ItemLabelGenerator & Serializable)table -> table.getName());
            TwinColSelect.TwinColSelectI18n tableSelectorI18n = TwinColSelect.TwinColSelectI18n.getDefault();
            tableSelectorI18n.setAddAllToSelected(SubsetDataScreen.this.controller.getMessage("Select all tables", new Object[0]));
            tableSelectorI18n.setAddToSelected(SubsetDataScreen.this.controller.getMessage("Select tables", new Object[0]));
            tableSelectorI18n.setRemoveFromSelected(SubsetDataScreen.this.controller.getMessage("Deselect tables", new Object[0]));
            tableSelectorI18n.setRemoveAllFromSelected(SubsetDataScreen.this.controller.getMessage("Deselect all tables", new Object[0]));
            tableSelectorI18n.setToggleSelection(SubsetDataScreen.this.controller.getMessage("Toggle table selection", new Object[0]));
            this.tableSelector.setI18n(tableSelectorI18n);
            this.tableSelectionLayout = new VerticalLayout(new Component[]{this.tableSelectionLabel, this.sourceToTargetLayout, this.tableSelector});
            this.tableSelectionLayout.setSizeFull();
            this.tableSelectionLayout.setMargin(false);
            this.tableSelectionLayout.setSpacing(false);
            this.tableSelectionLayout.setVisible(false);
            this.tableSelectionLayout.expand(new Component[]{this.tableSelector});
        }

        private void refreshTableSelector() {
            String availableFilter = this.sourceToTargetLayout.getFilter(true);
            String selectedFilter = this.sourceToTargetLayout.getFilter(false);
            this.viewableTables.clear();
            this.tables = this.getTables(true);
            for (ConfigCanvasTable table : this.tables) {
                String tableName = table.getName();
                if (Strings.CI.startsWith((CharSequence)tableName, (CharSequence)this.tablePrefix) || this.selectedTables.contains(table) || CommonUiUtils.isFilteredOut((String)tableName, (String)availableFilter)) continue;
                this.viewableTables.add(table);
            }
            HashSet<ConfigCanvasTable> viewableSelectedTables = new HashSet<ConfigCanvasTable>();
            for (ConfigCanvasTable table : this.selectedTables) {
                String tableName = table.getName();
                if (Strings.CI.startsWith((CharSequence)tableName, (CharSequence)this.tablePrefix) || CommonUiUtils.isFilteredOut((String)tableName, (String)selectedFilter)) continue;
                this.viewableTables.add(table);
                viewableSelectedTables.add(table);
            }
            this.refreshingTableSelector = true;
            this.tableSelector.setValue(viewableSelectedTables);
            this.tableSelector.getListDataView().refreshAll();
            this.refreshingTableSelector = false;
        }

        public void refreshSchemas() {
            Select<String> schemaSelect = this.sourceToTargetLayout.getSchemaSelect(true);
            String oldValue = (String)schemaSelect.getValue();
            List<String> schemaList = this.getSchemas();
            Collections.sort(schemaList, String.CASE_INSENSITIVE_ORDER);
            schemaSelect.setItems(schemaList);
            FormLayout catalogSchemaLayout = this.sourceToTargetLayout.getCatalogSchemaLayout(true);
            if (schemaList.size() == 0) {
                schemaSelect.setVisible(false);
                catalogSchemaLayout.setVisible(this.sourceToTargetLayout.getCatalogSelect(true).isVisible());
            } else {
                schemaSelect.setVisible(true);
                schemaSelect.setValue((Object)(schemaList.contains(oldValue) ? oldValue : schemaList.get(0)));
                catalogSchemaLayout.setVisible(true);
            }
            this.sourceToTargetLayout.getArrowIcon().getStyle().set("margin-top", catalogSchemaLayout.isVisible() ? "125px" : "70px");
        }

        public List<String> getSchemas() {
            String selectedCatalog = this.sourceToTargetLayout.getSelectedCatalog(true);
            ArrayList<String> schemas = new ArrayList<String>();
            for (ConfigCanvasTable table : this.sourceEndpoint.getAllTables(this.targetEndpoint.getGuid())) {
                String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                String schema = (String)StringUtils.defaultIfBlank((CharSequence)table.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                if (schemas.contains(schema) || !Strings.CS.equals(selectedCatalog, catalog)) continue;
                schemas.add(schema);
            }
            schemas.removeIf(Objects::isNull);
            return schemas;
        }

        public void refreshCatalogs() {
            Select<String> catalogSelect = this.sourceToTargetLayout.getCatalogSelect(true);
            List<String> catalogList = this.getCatalogs();
            Collections.sort(catalogList, String.CASE_INSENSITIVE_ORDER);
            catalogSelect.setItems(catalogList);
            FormLayout catalogSchemaLayout = this.sourceToTargetLayout.getCatalogSchemaLayout(true);
            if (catalogList.size() == 0) {
                catalogSelect.setVisible(false);
                catalogSchemaLayout.setVisible(this.sourceToTargetLayout.getSchemaSelect(true).isVisible());
            } else {
                catalogSelect.setVisible(true);
                catalogSelect.setValue((Object)catalogList.get(0));
                catalogSchemaLayout.setVisible(true);
            }
            this.sourceToTargetLayout.getArrowIcon().getStyle().set("margin-top", catalogSchemaLayout.isVisible() ? "125px" : "70px");
        }

        public List<String> getCatalogs() {
            ArrayList<String> catalogList = new ArrayList<String>();
            for (ConfigCanvasTable table : this.sourceEndpoint.getAllTables(this.targetEndpoint.getGuid())) {
                String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                if (catalogList.contains(catalog)) continue;
                catalogList.add(catalog);
            }
            catalogList.removeIf(Objects::isNull);
            return catalogList;
        }

        public List<ConfigCanvasTable> getTables(boolean filterByCatalogSchema) {
            String selectedCatalog = this.sourceToTargetLayout.getSelectedCatalog(true);
            String selectedSchema = this.sourceToTargetLayout.getSelectedSchema(true);
            ArrayList<ConfigCanvasTable> tables = new ArrayList<ConfigCanvasTable>();
            boolean joiningRelatedTable = !((String)this.subsetOptions.getValue()).equals(SubsetDataScreen.this.controller.getMessage("Subset by a column on <b>the same table</b> to determine target endpoints.", new Object[0]));
            block0: for (ConfigCanvasTable table : this.sourceEndpoint.getAllTables(this.targetEndpoint.getGuid())) {
                String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
                String schema = (String)StringUtils.defaultIfBlank((CharSequence)table.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
                if (filterByCatalogSchema && (!Strings.CS.equals(selectedCatalog, catalog) || !Strings.CS.equals(selectedSchema, schema))) continue;
                if (joiningRelatedTable) {
                    boolean addedTable = false;
                    String foreignColumnName = this.columnName.getValue();
                    for (ConfigCanvasTable.ConfigCanvasForeignKey foreignKey : table.getForeignKeys()) {
                        for (ConfigCanvasTable.ConfigCanvasForeignKey.ConfigCanvasReference reference : foreignKey.getReferences()) {
                            if (!reference.getForeignColumnName().equalsIgnoreCase(foreignColumnName)) continue;
                            tables.add(table);
                            addedTable = true;
                            break;
                        }
                        if (!addedTable) continue;
                        continue block0;
                    }
                    continue;
                }
                if (!table.hasColumnWithName(this.columnName.getValue())) continue;
                tables.add(table);
            }
            Collections.sort(tables, (t0, t1) -> t0.getName().toLowerCase().compareTo(t1.getName().toLowerCase()));
            return tables;
        }

        private void buildLookupLayout() {
            H5 header = new H5(SubsetDataScreen.this.controller.getMessage("Subset by Lookup Table Rule", new Object[0]));
            header.addClassName("less-contrast");
            Span description = new Span(SubsetDataScreen.this.controller.getMessage("Choose a table and column to look up the target endpoint's external ID from.", new Object[0]));
            description.addClassName("less-contrast");
            this.relatedTableName = new ComboBox(SubsetDataScreen.this.controller.getMessage("Table Name", new Object[0]));
            this.relatedTableName.setPlaceholder(SubsetDataScreen.this.controller.getMessage("Choose a table", new Object[0]));
            this.relatedTableName.setWidth("400px");
            this.relatedTableName.getStyle().set("padding-right", "16px");
            this.relatedTableName.setItemLabelGenerator((ItemLabelGenerator & Serializable)lookupDetails -> lookupDetails.getLookupTable().getFullyQualifiedSourceTableName());
            this.relatedTableName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                ConfigCanvasTable table;
                ComboBox.ItemFilter & Serializable columnNameFilter = (ComboBox.ItemFilter & Serializable)(columnName, filter) -> !CommonUiUtils.isFilteredOut((String)columnName, (String)filter);
                ConfigCanvasTable configCanvasTable = table = event.getValue() != null ? ((LookupDetails)event.getValue()).getLookupTable() : null;
                if (table != null && table.getColumnCount() == 0) {
                    table.addColumns(this.sourceEndpoint.getDatabasePlatform().getDdlReader().readTable(table.getCatalog(), table.getSchema(), table.getName()).getColumnsAsList());
                }
                String selectedColumnName = (String)this.externalIdColumnName.getValue();
                ArrayList columnNameList = table != null ? table.getColumnNames() : new ArrayList();
                columnNameList.sort(String.CASE_INSENSITIVE_ORDER);
                this.externalIdColumnName.setItems((ComboBox.ItemFilter)columnNameFilter, columnNameList);
                this.externalIdColumnName.setValue((Object)(columnNameList.contains(selectedColumnName) ? selectedColumnName : null));
                this.refreshNextButton(this.isNextEnabled());
            });
            this.externalIdColumnName = new ComboBox(SubsetDataScreen.this.controller.getMessage("External ID Column Name", new Object[0]));
            this.externalIdColumnName.setPlaceholder(SubsetDataScreen.this.controller.getMessage("Choose a column", new Object[0]));
            this.externalIdColumnName.setWidth("250px");
            this.externalIdColumnName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.refreshNextButton(this.isNextEnabled()));
            HorizontalLayout fieldLayout = new HorizontalLayout(new Component[]{this.relatedTableName, this.externalIdColumnName});
            fieldLayout.setMargin(false);
            fieldLayout.setPadding(false);
            fieldLayout.setSpacing(false);
            this.lookupLayout = new VerticalLayout(new Component[]{header, description, fieldLayout});
            this.lookupLayout.setMargin(false);
            this.lookupLayout.setPadding(false);
            this.lookupLayout.setSpacing(false);
        }

        private void buildSubselectLayout() {
            H5 header = new H5(SubsetDataScreen.this.controller.getMessage("Subset by Subselect SQL Rule", new Object[0]));
            header.addClassName("less-contrast");
            Span description = new Span(SubsetDataScreen.this.controller.getMessage("Write a SQL select statement which returns a result set of the node IDs that need routed to. Column names preceded with a colon character \":\" can be used in the SQL expression and will be replaced with row column data.", new Object[0]));
            description.addClassName("less-contrast");
            description.getStyle().set("padding-bottom", "8px");
            MenuBar builtInVariableMenu = new MenuBar();
            MenuItem builtInVariables = builtInVariableMenu.addItem(SubsetDataScreen.this.controller.getMessage("Built-in Variables", new Object[0]));
            builtInVariables.add(new Component[]{as.getDropdownIcon()});
            ArrayList<String> variables = new ArrayList<String>();
            variables.add(SubsetDataScreen.this.controller.getMessage(":DATA_EVENT_TYPE - String", new Object[0]));
            variables.add(SubsetDataScreen.this.controller.getMessage(":EXTERNAL_DATA - String", new Object[0]));
            variables.add(SubsetDataScreen.this.controller.getMessage(":NODE_GROUP_ID - String", new Object[0]));
            variables.add(SubsetDataScreen.this.controller.getMessage(":TABLE_NAME - String", new Object[0]));
            for (String variable : variables) {
                ((SubMenu)builtInVariables.getSubMenu()).addItem(variable, (ComponentEventListener & Serializable)event -> {
                    String text = this.subselect.getValue();
                    MenuItem item = (MenuItem)event.getSource();
                    String var = item.getText().substring(0, item.getText().indexOf(" "));
                    if (text != null) {
                        this.subselect.replaceTextAtCurrentSelection(var);
                    } else {
                        this.subselect.setValue(var);
                    }
                });
            }
            this.dataVariableMenu = new MenuBar();
            Button validateButton = new Button(SubsetDataScreen.this.controller.getMessage("Validate", new Object[0]), (ComponentEventListener & Serializable)event -> {
                try {
                    CCJSqlParserUtil.parse((String)(SubsetDataScreen.this.controller.getMessage("select c.node_id from sym_node c where c.node_group_id = :NODE_GROUP_ID and c.enabled = 1 and", new Object[0]) + " " + this.subselect.getValue()));
                    CommonUiUtils.notify((String)"", (String)SubsetDataScreen.this.controller.getMessage("Valid SQL Script", new Object[0]));
                }
                catch (JSQLParserException e2) {
                    String message = e2.getCause().getMessage();
                    if (message != null) {
                        CommonUiUtils.notify((String)"", (String)message);
                    }
                    CommonUiUtils.notify((String)"", (String)SubsetDataScreen.this.controller.getMessage("Invalid SQL Script", new Object[0]));
                }
            });
            validateButton.getStyle().set("margin", "2px 0 0 0");
            validateButton.setTooltipText(SubsetDataScreen.this.controller.getMessage("Verify that the subselect SQL is valid", new Object[0]));
            HorizontalLayout menuLayout = new HorizontalLayout(new Component[]{builtInVariableMenu, this.dataVariableMenu, validateButton});
            menuLayout.getStyle().set("padding-bottom", "8px");
            Span helperText = new Span(SubsetDataScreen.this.controller.getMessage("select c.node_id from sym_node c where c.node_group_id = :NODE_GROUP_ID and c.enabled = 1 and", new Object[0]));
            helperText.addClassName("less-contrast");
            this.subselect = as.createAceEditor();
            this.subselect.setMode(AceMode.sql);
            this.subselect.setWidthFull();
            this.subselect.setHeight("320px");
            this.subselect.addBlurListener((ComponentEventListener & Serializable)event -> this.refreshNextButton(this.isNextEnabled()));
            this.subselectLayout = new VerticalLayout(new Component[]{header, description, menuLayout, helperText, this.subselect});
            this.subselectLayout.setWidth("75%");
            this.subselectLayout.setMargin(false);
            this.subselectLayout.setPadding(false);
            this.subselectLayout.setSpacing(false);
        }

        private void refreshLookupLayout() {
            ComboBox.ItemFilter & Serializable lookupDetailsFilter = (ComboBox.ItemFilter & Serializable)(lookupDetails, filter) -> !CommonUiUtils.isFilteredOut((String)lookupDetails.getLookupTable().getFullyQualifiedSourceTableName(), (String)filter);
            Set<LookupDetails> commonLookupDetailsSet = null;
            for (ConfigCanvasTable table : this.selectedTables) {
                if (commonLookupDetailsSet == null) {
                    commonLookupDetailsSet = this.getLookupDetails(table);
                    continue;
                }
                commonLookupDetailsSet.retainAll(this.getLookupDetails(table));
            }
            this.relatedTableName.setItems((ComboBox.ItemFilter)lookupDetailsFilter, commonLookupDetailsSet);
            this.relatedTableName.clear();
            if (commonLookupDetailsSet.isEmpty()) {
                this.relatedTableOptions.setValue((Object)SubsetDataScreen.this.controller.getMessage("Join to <b>multiple</b> external tables to determine target endpoints.", new Object[0]));
                this.relatedTableOptions.setReadOnly(true);
            } else {
                this.relatedTableOptions.setValue((Object)SubsetDataScreen.this.controller.getMessage("Join to <b>one</b> external table to determine target endpoints.", new Object[0]));
                this.relatedTableOptions.setReadOnly(false);
            }
        }

        private void refreshSubselectLayout() {
            List<Object> commonColumnNames = new ArrayList<String>();
            for (ConfigCanvasTable configCanvasTable : this.selectedTables) {
                if (commonColumnNames.isEmpty()) {
                    commonColumnNames.addAll(configCanvasTable.getColumnNames());
                    continue;
                }
                commonColumnNames.retainAll(configCanvasTable.getColumnNames());
                if (!commonColumnNames.isEmpty()) continue;
                break;
            }
            ArrayList<CallSite> oldColumnNames = new ArrayList<CallSite>();
            for (String string : commonColumnNames) {
                oldColumnNames.add((CallSite)((Object)("OLD_" + string)));
            }
            commonColumnNames.addAll(oldColumnNames);
            commonColumnNames = commonColumnNames.stream().map(name -> ":" + name.toUpperCase()).collect(Collectors.toList());
            Collections.sort(commonColumnNames);
            MenuItem menuItem = this.dataVariableMenu.addItem(SubsetDataScreen.this.controller.getMessage("Data Variables", new Object[0]));
            menuItem.add(new Component[]{as.getDropdownIcon()});
            for (String string : commonColumnNames) {
                ((SubMenu)menuItem.getSubMenu()).addItem(string.toUpperCase(), (ComponentEventListener & Serializable)event -> {
                    String text = this.subselect.getValue();
                    MenuItem item = (MenuItem)event.getSource();
                    if (text != null) {
                        this.subselect.replaceTextAtCurrentSelection(item.getText());
                    } else {
                        this.subselect.setValue(item.getText());
                    }
                });
            }
            this.dataVariableMenu.setVisible(!commonColumnNames.isEmpty());
        }

        private Set<LookupDetails> getLookupDetails(ConfigCanvasTable table) {
            String joinColumnName = this.columnName.getValue();
            String defaultCatalog = this.sourceEndpoint.getDefaultCatalog();
            String defaultSchema = this.sourceEndpoint.getDefaultSchema();
            TreeSet<LookupDetails> lookupDetailsSet = new TreeSet<LookupDetails>();
            for (ConfigCanvasTable.ConfigCanvasForeignKey foreignKey : table.getForeignKeys()) {
                for (ConfigCanvasTable.ConfigCanvasForeignKey.ConfigCanvasReference reference : foreignKey.getReferences()) {
                    if (!reference.getForeignColumnName().equalsIgnoreCase(joinColumnName)) continue;
                    String catalog = Strings.CS.equals(foreignKey.getForeignTableCatalog(), defaultCatalog) ? null : foreignKey.getForeignTableCatalog();
                    String schema = Strings.CS.equals(foreignKey.getForeignTableSchema(), defaultSchema) ? null : foreignKey.getForeignTableSchema();
                    lookupDetailsSet.add(new LookupDetails(reference.getLocalColumnName(), catalog, schema, foreignKey.getForeignTableName()));
                }
            }
            return lookupDetailsSet;
        }

        private boolean isNextEnabled() {
            if (this.subsetLayout.isVisible()) {
                return StringUtils.isNotBlank((CharSequence)this.ruleName.getValue()) && !this.ruleName.isInvalid() && !this.nodeLink.isEmpty() && StringUtils.isNotBlank((CharSequence)this.columnName.getValue()) && (!this.represents.isAttached() || !this.represents.isEmpty());
            }
            if (this.lookupLayout.isVisible()) {
                return !this.relatedTableName.isEmpty() && !this.externalIdColumnName.isEmpty();
            }
            return StringUtils.isNotBlank((CharSequence)this.subselect.getValue());
        }

        private void refreshNextButton(boolean enabled) {
            if (enabled) {
                this.nextButton.setEnabled(true);
                if (this.nextButton.getText().equals(SubsetDataScreen.this.controller.getMessage("Next", new Object[0]))) {
                    this.nextTooltip.setText(SubsetDataScreen.this.controller.getMessage("Proceed to the next screen", new Object[0]));
                } else {
                    this.nextTooltip.setText(SubsetDataScreen.this.controller.getMessage("Save the new rule and close the dialog", new Object[0]));
                }
            } else {
                this.nextButton.setEnabled(false);
                this.nextTooltip.setText(SubsetDataScreen.this.controller.getMessage("This rule's details are incomplete or invalid", new Object[0]));
            }
        }

        class LookupDetails
        implements Comparable<LookupDetails> {
            private String localColumnName;
            private ConfigCanvasTable lookupTable;

            public LookupDetails(String localColumnName, String lookupCatalogName, String lookupSchemaName, String lookupTableName) {
                this.localColumnName = localColumnName;
                this.lookupTable = new ConfigCanvasTable(lookupCatalogName, lookupSchemaName, lookupTableName);
            }

            public String getLocalColumnName() {
                return this.localColumnName;
            }

            public ConfigCanvasTable getLookupTable() {
                return this.lookupTable;
            }

            @Override
            public int compareTo(LookupDetails other) {
                return this.lookupTable.getFullyQualifiedSourceTableName().toLowerCase().compareTo(other.getLookupTable().getFullyQualifiedSourceTableName().toLowerCase());
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                String lookupCatalogName = this.lookupTable.getCatalog();
                result = 31 * result + (lookupCatalogName == null ? 0 : lookupCatalogName.hashCode());
                String lookupSchemaName = this.lookupTable.getSchema();
                result = 31 * result + (lookupSchemaName == null ? 0 : lookupSchemaName.hashCode());
                String lookupTableName = this.lookupTable.getName();
                result = 31 * result + (lookupTableName == null ? 0 : lookupTableName.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof LookupDetails)) {
                    return false;
                }
                LookupDetails other = (LookupDetails)obj;
                String lookupCatalogName = this.lookupTable.getCatalog();
                ConfigCanvasTable otherLookupTable = other.getLookupTable();
                String otherLookupCatalogName = otherLookupTable.getCatalog();
                if (lookupCatalogName == null ? otherLookupCatalogName != null : !lookupCatalogName.equals(otherLookupCatalogName)) {
                    return false;
                }
                String lookupSchemaName = this.lookupTable.getSchema();
                String otherLookupSchemaName = otherLookupTable.getSchema();
                if (lookupSchemaName == null ? otherLookupSchemaName != null : !lookupSchemaName.equals(otherLookupSchemaName)) {
                    return false;
                }
                String lookupTableName = this.lookupTable.getName();
                String otherLookupTableName = otherLookupTable.getName();
                return !(lookupTableName == null ? otherLookupTableName != null : !lookupTableName.equals(otherLookupTableName));
            }
        }
    }
}

