/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jumpmind.symmetric.console.ui.canvas.AbstractSidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvas;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasEndpoint;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasLink;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasSourceToTargetLayout;
import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvasTable;
import com.jumpmind.symmetric.console.ui.canvas.ISidebarScreen;
import com.jumpmind.symmetric.console.ui.canvas.SubsetDataScreen;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.S;
import com.jumpmind.symmetric.console.ui.common.X;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.o;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.tatu.TwinColSelect;

public class SelectTablesScreen
extends AbstractSidebarScreen {
    private static final long serialVersionUID = 1L;
    private SelectTablesLayout outgoingLayout;
    private SelectTablesLayout incomingLayout;

    public SelectTablesScreen(I controller, ConfigCanvas canvas) {
        super(controller, canvas, controller.getMessage("Select Tables", new Object[0]), controller.getMessage("Determine which link between endpoints to transfer tables between.", new Object[0]));
        if (!canvas.isInitialSetup() && !canvas.isAddingNewReplication()) {
            canvas.getProgressStepper().setStepInactive(3);
            canvas.getProgressStepper().setStepInactive(4);
        }
        ConfigCanvasEndpoint sourceEndpoint = canvas.getFirstEndpoint();
        ConfigCanvasEndpoint targetEndpoint = canvas.getSecondEndpoint();
        if (sourceEndpoint.getType() == null || !sourceEndpoint.getType().isWriteOnly()) {
            this.outgoingLayout = new SelectTablesLayout(sourceEndpoint, targetEndpoint);
            this.add(new Component[]{this.outgoingLayout});
        }
        if (!(targetEndpoint.getType() != null && targetEndpoint.getType().isWriteOnly() || sourceEndpoint.getId().equals(targetEndpoint.getId()))) {
            this.incomingLayout = new SelectTablesLayout(targetEndpoint, sourceEndpoint);
            this.add(new Component[]{this.incomingLayout});
        }
        canvas.setSelectedLink(sourceEndpoint.getGuid(), targetEndpoint.getGuid());
    }

    @Override
    public int getProgressStepperIndex() {
        return 2;
    }

    @Override
    public boolean isNextEnabled() {
        ConfigCanvasEndpoint sourceEndpoint = this.canvas.getFirstEndpoint();
        ConfigCanvasEndpoint targetEndpoint = this.canvas.getSecondEndpoint();
        return this.canvas.getFirstEndpoint().getTableCount(targetEndpoint.getGuid()) > 0 || this.canvas.getSecondEndpoint().getTableCount(sourceEndpoint.getGuid()) > 0;
    }

    @Override
    public boolean isPreviousVisible() {
        return this.canvas.hasPreviousScreen();
    }

    @Override
    public boolean isPreviousEnabled() {
        return true;
    }

    @Override
    public ISidebarScreen next() {
        new M<Void>(this.controller.getMessage("Verifying configuration...", new Object[0]), new M.a<Void>(){
            private Map<String, Set<ConfigCanvasTable>> missingSourceTableMap = new HashMap<String, Set<ConfigCanvasTable>>();

            @Override
            public Void doWork() {
                ConfigCanvasEndpoint sourceEndpoint = SelectTablesScreen.this.canvas.getFirstEndpoint();
                ConfigCanvasEndpoint targetEndpoint = SelectTablesScreen.this.canvas.getSecondEndpoint();
                if (SelectTablesScreen.this.outgoingLayout != null) {
                    this.checkForMissingSourceTables(sourceEndpoint, targetEndpoint);
                }
                if (SelectTablesScreen.this.incomingLayout != null) {
                    this.checkForMissingSourceTables(targetEndpoint, sourceEndpoint);
                }
                return null;
            }

            private void checkForMissingSourceTables(ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint) {
                String targetEndpointGuid = targetEndpoint.getGuid();
                Set<ConfigCanvasTable> missingSourceTableSet = sourceEndpoint.getMissingSourceTableSet(targetEndpointGuid, true);
                if (!missingSourceTableSet.isEmpty()) {
                    this.missingSourceTableMap.put(sourceEndpoint.getGuid() + targetEndpointGuid, missingSourceTableSet);
                }
            }

            @Override
            public void doUI(Void data) {
                if (!this.missingSourceTableMap.isEmpty()) {
                    new MissingTableDialog(this.missingSourceTableMap).open();
                } else {
                    SelectTablesScreen.this.canvas.getProgressStepper().setStepComplete(SelectTablesScreen.this.getProgressStepperIndex());
                    SelectTablesScreen.this.canvas.nextScreen(new SubsetDataScreen(SelectTablesScreen.this.controller, SelectTablesScreen.this.canvas));
                }
            }
        }, this.controller.getBackgroundRefresherService(), null, false, false).show();
        return null;
    }

    @Override
    public boolean last() {
        ConfigCanvasEndpoint targetEndpoint;
        ConfigCanvasEndpoint sourceEndpoint = this.canvas.getFirstEndpoint();
        if (sourceEndpoint.getTableCount((targetEndpoint = this.canvas.getSecondEndpoint()).getGuid()) > 0 || targetEndpoint.getTableCount(sourceEndpoint.getGuid()) > 0) {
            this.canvas.getProgressStepper().setStepComplete(this.getProgressStepperIndex());
        } else {
            this.canvas.getProgressStepper().setStepInactive(this.getProgressStepperIndex());
        }
        return true;
    }

    @Override
    public String getNextButtonTooltip() {
        return this.controller.getMessage(this.isNextEnabled() ? "Proceed to the next screen" : "Select at least one table first", new Object[0]);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_table_configuration";
    }

    class SelectTablesLayout
    extends Scroller {
        private static final long serialVersionUID = 1L;
        private ConfigCanvasEndpoint sourceEndpoint;
        private ConfigCanvasEndpoint targetEndpoint;
        private Component sourceEndpointIcon;
        private Span sourceEndpointIdSpan;
        private Icon arrowIcon;
        private Component targetEndpointIcon;
        private Span targetEndpointIdSpan;
        private VerticalLayout tableLayout;
        private Button viewButton;
        private Tooltip viewTooltip;
        private Button removeButton;
        private Tooltip removeTooltip;

        public SelectTablesLayout(ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint) {
            String addDivTooltipText;
            this.sourceEndpoint = sourceEndpoint;
            this.targetEndpoint = targetEndpoint;
            this.sourceEndpointIcon = as.getEndpointIcon(SelectTablesScreen.this.controller.getContextPath(), sourceEndpoint.getType());
            this.targetEndpointIcon = as.getEndpointIcon(SelectTablesScreen.this.controller.getContextPath(), targetEndpoint.getType());
            String sourceEndpointId = sourceEndpoint.getId();
            this.sourceEndpointIdSpan = new Span(sourceEndpointId);
            this.sourceEndpointIdSpan.addClassName("less-contrast");
            this.arrowIcon = new Icon(VaadinIcon.ARROW_RIGHT);
            this.arrowIcon.addClassName("less-contrast");
            String targetEndpointId = targetEndpoint.getId();
            this.targetEndpointIdSpan = new Span(targetEndpointId);
            this.targetEndpointIdSpan.addClassName("less-contrast");
            HorizontalLayout linkLayout = new HorizontalLayout(new Component[]{this.sourceEndpointIcon, this.sourceEndpointIdSpan, this.arrowIcon, this.targetEndpointIcon, this.targetEndpointIdSpan});
            linkLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.CENTER);
            this.tableLayout = new VerticalLayout();
            this.tableLayout.setPadding(false);
            this.tableLayout.setMargin(false);
            this.viewButton = new Button(SelectTablesScreen.this.controller.getMessage("View", new Object[0]), (ComponentEventListener & Serializable)e2 -> new ViewTablesDialog(sourceEndpoint, targetEndpoint).open());
            this.viewButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            Div viewDiv = new Div(new Component[]{this.viewButton});
            this.viewTooltip = Tooltip.forComponent((Component)viewDiv);
            this.removeButton = new Button(SelectTablesScreen.this.controller.getMessage("Remove", new Object[0]), (ComponentEventListener & Serializable)e2 -> new RemoveTablesDialog(this, sourceEndpoint, targetEndpoint).open());
            this.removeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            this.removeButton.setEnabled(!SelectTablesScreen.this.readOnly);
            Div removeDiv = new Div(new Component[]{this.removeButton});
            this.removeTooltip = Tooltip.forComponent((Component)removeDiv);
            Button addButton = new Button(SelectTablesScreen.this.controller.getMessage("Add", new Object[0]), (ComponentEventListener & Serializable)e2 -> new AddTablesDialog(this, sourceEndpoint, targetEndpoint).open());
            addButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            Div addDiv = new Div(new Component[]{addButton});
            if (!SelectTablesScreen.this.readOnly && !SelectTablesScreen.this.errorMessageVisible) {
                addDivTooltipText = SelectTablesScreen.this.controller.getMessage("Open the Add Tables dialog for '%s' to '%s'", sourceEndpointId, targetEndpointId);
            } else {
                addButton.setEnabled(false);
                addDivTooltipText = SelectTablesScreen.this.readOnly ? SelectTablesScreen.this.controller.getMessage("Requires write permission", new Object[0]) : SelectTablesScreen.this.controller.getMessage("Requires valid connection details", new Object[0]);
            }
            Tooltip.forComponent((Component)addDiv).setText(addDivTooltipText);
            VerticalLayout leftLayout = new VerticalLayout(new Component[]{linkLayout, this.tableLayout});
            leftLayout.getStyle().set("max-width", "70%");
            HorizontalLayout mainLayout = new HorizontalLayout(new Component[]{leftLayout});
            mainLayout.addAndExpand(new Component[]{new Span()});
            mainLayout.add(new Component[]{viewDiv, removeDiv, addDiv});
            mainLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{viewDiv, removeDiv, addDiv});
            this.setContent((Component)mainLayout);
            this.setWidthFull();
            this.setMaxHeight("42%");
            this.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
            this.addClassName("subtle-border-disabled");
            this.getStyle().set("padding", "0 8px 0 0").set("margin-left", "0");
            this.refresh();
        }

        public void refresh() {
            this.tableLayout.removeAll();
            List<ConfigCanvasLink.ConfigCanvasTableGroup> tableGroupList = this.sourceEndpoint.getTableGroupList(this.targetEndpoint.getGuid());
            int tableCount = tableGroupList.size();
            if (tableCount > 0) {
                this.sourceEndpointIcon.getStyle().remove("filter");
                this.sourceEndpointIdSpan.removeClassName("less-contrast");
                this.arrowIcon.removeClassName("less-contrast");
                this.targetEndpointIcon.getStyle().remove("filter");
                this.targetEndpointIdSpan.removeClassName("less-contrast");
                this.viewButton.setEnabled(true);
                this.viewTooltip.setText(SelectTablesScreen.this.controller.getMessage("Open the View Tables dialog for '%s' to '%s'", this.sourceEndpoint.getId(), this.targetEndpoint.getId()));
                this.removeButton.setEnabled(!SelectTablesScreen.this.readOnly);
                this.removeTooltip.setText(SelectTablesScreen.this.readOnly ? SelectTablesScreen.this.controller.getMessage("Requires write permission", new Object[0]) : SelectTablesScreen.this.controller.getMessage("Open the Remove Tables dialog for '%s' to '%s'", this.sourceEndpoint.getId(), this.targetEndpoint.getId()));
                for (int i2 = 0; i2 < tableCount; ++i2) {
                    this.addLayoutForTableGroup(tableGroupList.get(i2), i2);
                }
                this.removeClassName("subtle-border-disabled");
                this.addClassName("subtle-border");
            } else {
                this.sourceEndpointIcon.getStyle().set("filter", "grayscale(1)");
                this.sourceEndpointIdSpan.addClassName("less-contrast");
                this.arrowIcon.addClassName("less-contrast");
                this.targetEndpointIcon.getStyle().set("filter", "grayscale(1)");
                this.targetEndpointIdSpan.addClassName("less-contrast");
                this.viewButton.setEnabled(false);
                this.viewTooltip.setText(SelectTablesScreen.this.controller.getMessage(SelectTablesScreen.this.readOnly ? "No tables selected" : "Select at least one table first", new Object[0]));
                this.removeButton.setEnabled(false);
                this.removeTooltip.setText(SelectTablesScreen.this.controller.getMessage(SelectTablesScreen.this.readOnly ? "Requires write permission" : "Select at least one table first", new Object[0]));
                this.addLayoutForTableGroup(null, 0);
                this.removeClassName("subtle-border");
                this.addClassName("subtle-border-disabled");
            }
        }

        private void addLayoutForTableGroup(ConfigCanvasLink.ConfigCanvasTableGroup tableGroup, int index) {
            Label label = new Label();
            label.addClassName("less-contrast");
            if (tableGroup != null) {
                int tableCount = tableGroup.getTableSet().size();
                Object labelText = SelectTablesScreen.this.controller.getMessage("Sending <b>%d</b> table", tableCount);
                if (tableCount > 1) {
                    labelText = (String)labelText + "s";
                }
                boolean hasChannel = !tableGroup.getChannelId().equals("default");
                boolean hasTriggerIdPrefix = StringUtils.isNotBlank((CharSequence)tableGroup.getTriggerIdPrefix());
                String targetCatalog = (String)StringUtils.defaultIfBlank((CharSequence)tableGroup.getTargetCatalog(), (CharSequence)this.targetEndpoint.getDefaultCatalog());
                String targetSchema = (String)StringUtils.defaultIfBlank((CharSequence)tableGroup.getTargetSchema(), (CharSequence)this.targetEndpoint.getDefaultSchema());
                boolean hasTargetCatalog = StringUtils.isNotBlank((CharSequence)targetCatalog);
                boolean hasTargetSchema = StringUtils.isNotBlank((CharSequence)targetSchema);
                if (hasChannel || hasTriggerIdPrefix || hasTargetCatalog || hasTargetSchema) {
                    labelText = (String)labelText + " (";
                    if (hasChannel) {
                        labelText = (String)labelText + SelectTablesScreen.this.controller.getMessage("Channel", new Object[0]) + ": <b>" + tableGroup.getChannelId() + "</b>, ";
                    }
                    if (hasTriggerIdPrefix) {
                        labelText = (String)labelText + SelectTablesScreen.this.controller.getMessage("Capture ID Prefix", new Object[0]) + ": <b>" + tableGroup.getTriggerIdPrefix() + "</b>, ";
                    }
                    if (hasTargetCatalog) {
                        labelText = (String)labelText + SelectTablesScreen.this.controller.getMessage("Target Catalog", new Object[0]) + ": <b>" + targetCatalog + "</b>, ";
                    }
                    if (hasTargetSchema) {
                        labelText = (String)labelText + SelectTablesScreen.this.controller.getMessage("Target Schema", new Object[0]) + ": <b>" + targetSchema + "</b>, ";
                    }
                    labelText = ((String)labelText).substring(0, ((String)labelText).length() - 2) + ")";
                }
                label.setText((String)labelText);
                HorizontalLayout tableGroupLayout = new HorizontalLayout(new Component[]{label});
                if (!SelectTablesScreen.this.readOnly) {
                    label.getStyle().set("padding-left", "8px");
                    o deleteIcon = new o(SelectTablesScreen.this.controller.getContextPath(), VaadinIcon.CLOSE_SMALL);
                    deleteIcon.addClickListener(() -> {
                        String sourceEndpointGuid = this.sourceEndpoint.getGuid();
                        String targetEndpointGuid = this.targetEndpoint.getGuid();
                        this.sourceEndpoint.removeTables(targetEndpointGuid, index);
                        this.targetEndpoint.setIncomingTableCountForLink(sourceEndpointGuid, this.sourceEndpoint.getTableCount(targetEndpointGuid));
                        if (this.sourceEndpoint.getTransformList(targetEndpointGuid).isEmpty()) {
                            this.targetEndpoint.setIncomingTransformedForLink(sourceEndpointGuid, false);
                        }
                        if (this.sourceEndpoint.getTableCount(targetEndpointGuid) == 0 && this.targetEndpoint.getTableCount(sourceEndpointGuid) == 0) {
                            SelectTablesScreen.this.canvas.getProgressStepper().setStepActive(SelectTablesScreen.this.getProgressStepperIndex());
                            SelectTablesScreen.this.canvas.getNextButton().setEnabled(false);
                            SelectTablesScreen.this.canvas.setNextButtonTooltip(SelectTablesScreen.this.controller.getMessage("Select at least one table first", new Object[0]));
                        }
                        SelectTablesScreen.this.canvas.refreshEndpoints();
                        SelectTablesScreen.this.canvas.redrawDiagram();
                        this.refresh();
                    });
                    Tooltip.forComponent((Component)deleteIcon).setText(SelectTablesScreen.this.controller.getMessage("Remove table(s)", new Object[0]));
                    tableGroupLayout.addComponentAsFirst((Component)deleteIcon);
                }
                tableGroupLayout.setPadding(false);
                tableGroupLayout.setMargin(false);
                tableGroupLayout.setSpacing(false);
                this.tableLayout.add(new Component[]{tableGroupLayout});
            } else {
                label.setText(SelectTablesScreen.this.controller.getMessage("No tables selected", new Object[0]));
                this.tableLayout.add(new Component[]{label});
            }
        }
    }

    class MissingTableDialog
    extends Dialog {
        private static final long serialVersionUID = 1L;
        private S missingTableLayout;

        public MissingTableDialog(Map<String, Set<ConfigCanvasTable>> missingSourceTableMap) {
            this.setHeaderTitle(SelectTablesScreen.this.controller.getMessage("Tables Missing from Database", new Object[0]));
            this.setHeight("700px");
            this.setWidth("1000px");
            this.addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
            this.setCloseOnEsc(false);
            this.setCloseOnOutsideClick(false);
            final Button confirmButton = as.createPrimaryButton(SelectTablesScreen.this.controller.getMessage("Confirm", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.onConfirmButtonClick());
            this.missingTableLayout = new S(SelectTablesScreen.this.controller, SelectTablesScreen.this.canvas, List.of(SelectTablesScreen.this.canvas.getFirstEndpoint(), SelectTablesScreen.this.canvas.getSecondEndpoint()), missingSourceTableMap, SelectTablesScreen.this.controller.getMessage("The following tables couldn't be found in the source database. It won't be possible to configure subset rules or column transforms for these tables. Would you like to keep their configuration or remove it?", new Object[0])){
                private static final long serialVersionUID = 1L;

                @Override
                protected void optionSelected(boolean removeTables) {
                    confirmButton.setTooltipText(this.controller.getMessage(removeTables ? "Remove the table configuration and close the dialog" : "Keep the table configuration and close the dialog", new Object[0]));
                }
            };
            this.missingTableLayout.setSizeFull();
            this.missingTableLayout.getStyle().set("border-top", "1px solid var(--lumo-contrast-20pct)");
            this.add(new Component[]{this.missingTableLayout});
            this.getFooter().add(new Component[]{confirmButton});
        }

        private void onConfirmButtonClick() {
            if (this.missingTableLayout.removeTablesIfNecessary()) {
                if (SelectTablesScreen.this.outgoingLayout != null) {
                    SelectTablesScreen.this.outgoingLayout.refresh();
                }
                if (SelectTablesScreen.this.incomingLayout != null) {
                    SelectTablesScreen.this.incomingLayout.refresh();
                }
                SelectTablesScreen.this.canvas.refreshEndpoints();
                SelectTablesScreen.this.canvas.redrawDiagram();
            }
            this.close();
            if (SelectTablesScreen.this.isNextEnabled()) {
                SelectTablesScreen.this.canvas.getProgressStepper().setStepComplete(SelectTablesScreen.this.getProgressStepperIndex());
                SelectTablesScreen.this.canvas.nextScreen(new SubsetDataScreen(SelectTablesScreen.this.controller, SelectTablesScreen.this.canvas));
            } else {
                SelectTablesScreen.this.canvas.getNextButton().setEnabled(false);
                SelectTablesScreen.this.canvas.setNextButtonTooltip(SelectTablesScreen.this.controller.getMessage("Select at least one table first", new Object[0]));
            }
        }
    }

    class AddTablesDialog
    extends X {
        private static final long serialVersionUID = 1L;
        private final Logger log;
        private ISymmetricEngine engine;
        private List<ConfigCanvasTable> tables;
        private Set<ConfigCanvasTable> selectedTables;
        private Set<ConfigCanvasTable> viewableTables;
        private SelectTablesLayout selectTablesLayout;
        private ConfigCanvasEndpoint sourceEndpoint;
        private ConfigCanvasEndpoint targetEndpoint;
        private String tablePrefix;
        private Select<String> channelSelect;
        private TextField captureIdPrefixField;
        private Checkbox includeForeignKeyParentTablesCheckbox;
        private ConfigCanvasSourceToTargetLayout sourceToTargetLayout;
        private TwinColSelect<ConfigCanvasTable> tableSelector;
        private boolean refreshingTableSelector;
        private boolean foreignKeysSupported;
        private boolean createTableWithoutForeignKeys;
        private VerticalLayout tableSelectionLayout;
        private VerticalLayout foreignKeyLayout;
        private Set<ConfigCanvasTable> missingParentTableSet;
        private FlexLayout missingParentTableLayout;
        private VerticalLayout bidirectionalLayout;
        private boolean bidirectionalSelected;
        private VerticalLayout bidirectionalArrowLayout;
        private Button previousButton;
        private Button nextButton;
        private Tooltip nextTooltip;

        public AddTablesDialog(SelectTablesLayout selectTablesLayout, final ConfigCanvasEndpoint sourceEndpoint, final ConfigCanvasEndpoint targetEndpoint) {
            super(SelectTablesScreen.this.controller.getMessage("Add Tables", new Object[0]), SelectTablesScreen.this.controller.getContextPath(), null, SelectTablesScreen.this.controller.getMessage("Close the dialog without adding any tables", new Object[0]));
            this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            this.tables = new ArrayList<ConfigCanvasTable>();
            this.selectedTables = new HashSet<ConfigCanvasTable>();
            this.viewableTables = new TreeSet<ConfigCanvasTable>((t0, t1) -> t0.getName().toLowerCase().compareTo(t1.getName().toLowerCase()));
            this.tableSelector = new TwinColSelect();
            this.missingParentTableSet = new HashSet<ConfigCanvasTable>();
            this.selectTablesLayout = selectTablesLayout;
            this.sourceEndpoint = sourceEndpoint;
            this.targetEndpoint = targetEndpoint;
            this.engine = SelectTablesScreen.this.controller.getSymmetricEngine();
            this.tablePrefix = this.engine != null ? this.engine.getTablePrefix() : "sym_";
            this.setHeight("900px");
            this.setWidth("1400px");
            this.setCloseOnOutsideClick(false);
            ArrayList<String> channelIdList = new ArrayList<String>();
            if (this.engine != null) {
                boolean hideSystemChannels = this.engine.getParameterService().is("console.web.hide.system.info");
                List channels = this.engine.getConfigurationService().getNodeChannels(false);
                for (NodeChannel nodeChannel : channels) {
                    Channel channel;
                    String channelId = nodeChannel.getChannelId();
                    boolean include = !channelId.equals("config") && !channelId.equals("heartbeat") && !channelId.equals("system");
                    if (!(include &= !hideSystemChannels || !channelId.equals("dynamic") && !channelId.equals("monitor")) || (channel = nodeChannel.getChannel()).isFileSyncFlag() || channel.isReloadFlag()) continue;
                    channelIdList.add(channelId);
                }
            } else {
                channelIdList.add("default");
                channelIdList.addAll(SelectTablesScreen.this.canvas.getContext().getImportedChannelIdSet());
            }
            if (channelIdList.size() > 1) {
                Collections.sort(channelIdList, String.CASE_INSENSITIVE_ORDER);
                this.channelSelect = new Select();
                this.channelSelect.setLabel(SelectTablesScreen.this.controller.getMessage("Channel", new Object[0]));
                this.channelSelect.setEmptySelectionAllowed(false);
                this.channelSelect.setItems(channelIdList);
                this.channelSelect.setValue((Object)"default");
            }
            this.captureIdPrefixField = new TextField(SelectTablesScreen.this.controller.getMessage("Capture ID Prefix", new Object[0]));
            this.includeForeignKeyParentTablesCheckbox = new Checkbox(SelectTablesScreen.this.controller.getMessage("Include Foreign Key Parent Tables", new Object[0]));
            boolean bl2 = this.foreignKeysSupported = sourceEndpoint.getDatabasePlatform().getDatabaseInfo().isForeignKeysSupported() && targetEndpoint.getDatabasePlatform().getDatabaseInfo().isForeignKeysSupported();
            if (this.foreignKeysSupported) {
                if (sourceEndpoint.getSymmetricEngine() != null) {
                    this.createTableWithoutForeignKeys = sourceEndpoint.getSymmetricEngine().getParameterService().is("create.table.without.foreign.keys");
                }
                this.includeForeignKeyParentTablesCheckbox.setValue((Object)(!this.createTableWithoutForeignKeys ? 1 : 0));
                if (targetEndpoint.getType().isWriteOnly()) {
                    this.includeForeignKeyParentTablesCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        this.nextButton.setText(SelectTablesScreen.this.controller.getMessage((Boolean)event.getValue() != false ? "Next" : "Finish", new Object[0]));
                        this.nextTooltip.setText(SelectTablesScreen.this.controller.getMessage((Boolean)event.getValue() != false ? "Check foreign keys, then either proceed to the next screen or add the table(s) and close" : "Add the selected table(s) and close the dialog", new Object[0]));
                    });
                }
            } else {
                this.includeForeignKeyParentTablesCheckbox.setVisible(false);
            }
            FormLayout advancedOptionsForm = new FormLayout(new Component[]{this.captureIdPrefixField, this.includeForeignKeyParentTablesCheckbox});
            if (this.channelSelect != null) {
                advancedOptionsForm.addComponentAsFirst(this.channelSelect);
            }
            advancedOptionsForm.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 3)});
            advancedOptionsForm.setWidth("80%");
            advancedOptionsForm.getStyle().set("padding-left", "8px");
            advancedOptionsForm.setVisible(false);
            Button advancedOptionsButton = as.createLinkButton(SelectTablesScreen.this.controller.getMessage("Advanced options", new Object[0]));
            advancedOptionsButton.setHeight("26px");
            advancedOptionsButton.addClickListener((ComponentEventListener & Serializable)event -> {
                boolean advancedOptionsVisible = advancedOptionsForm.isVisible();
                if (advancedOptionsVisible) {
                    advancedOptionsButton.setText(SelectTablesScreen.this.controller.getMessage("Advanced options", new Object[0]));
                } else {
                    advancedOptionsButton.setText(SelectTablesScreen.this.controller.getMessage("Hide advanced options", new Object[0]));
                }
                advancedOptionsForm.setVisible(!advancedOptionsVisible);
            });
            HorizontalLayout advancedOptionsLayout = new HorizontalLayout(new Component[]{advancedOptionsForm});
            advancedOptionsLayout.addAndExpand(new Component[]{new Span()});
            advancedOptionsLayout.add(new Component[]{advancedOptionsButton});
            final List<String> sourceCatalogList = this.getCatalogs(true);
            Collections.sort(sourceCatalogList, String.CASE_INSENSITIVE_ORDER);
            final List<String> targetCatalogList = this.getCatalogs(false);
            Collections.sort(targetCatalogList, String.CASE_INSENSITIVE_ORDER);
            this.sourceToTargetLayout = new ConfigCanvasSourceToTargetLayout(SelectTablesScreen.this.controller, sourceEndpoint, targetEndpoint, null, null, true, true, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected void initCatalogSchemaFields(boolean source, Select<String> catalogSelect, Select<String> schemaSelect) {
                    if (source) {
                        if (sourceCatalogList != null && !sourceCatalogList.isEmpty() && sourceCatalogList.get(0) != null) {
                            catalogSelect.setItems((Collection)sourceCatalogList);
                        } else {
                            catalogSelect.setVisible(false);
                        }
                        String schema = sourceEndpoint.getDefaultSchema();
                        if (schema == null && schemaSelect.getListDataView().getItemCount() > 0) {
                            schema = (String)schemaSelect.getListDataView().getItem(0);
                        }
                        schemaSelect.setValue((Object)schema);
                        schemaSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                            if (event.isFromClient()) {
                                AddTablesDialog.this.refreshTableSelector(true);
                            }
                        });
                    } else {
                        if (targetCatalogList != null && !targetCatalogList.isEmpty() && targetCatalogList.get(0) != null) {
                            catalogSelect.setItems((Collection)targetCatalogList);
                        } else {
                            catalogSelect.setVisible(false);
                        }
                        schemaSelect.setValue((Object)targetEndpoint.getDefaultSchema());
                    }
                    if (catalogSelect.isVisible()) {
                        catalogSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                            AddTablesDialog.this.refreshSchemas(source, schemaSelect);
                            if (source) {
                                AddTablesDialog.this.refreshTableSelector(true);
                            }
                        });
                        String catalog = (source ? sourceEndpoint : targetEndpoint).getDefaultCatalog();
                        int catalogCount = catalogSelect.getListDataView().getItemCount();
                        if (catalog == null && catalogCount < 2) {
                            catalogSelect.setVisible(false);
                            AddTablesDialog.this.refreshSchemas(source, schemaSelect);
                            if (source) {
                                AddTablesDialog.this.refreshTableSelector(true);
                            }
                        } else {
                            if (catalog == null && catalogCount >= 2) {
                                catalog = (String)catalogSelect.getListDataView().getItem(0);
                            }
                            catalogSelect.setValue((Object)catalog);
                        }
                    } else {
                        AddTablesDialog.this.refreshSchemas(source, schemaSelect);
                    }
                }

                @Override
                protected void initFilterField(boolean source, TextField filterField, HorizontalLayout filterLayout) {
                    super.initFilterField(source, filterField, filterLayout);
                    filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        filterField.setValue((String)event.getValue());
                        AddTablesDialog.this.refreshTableSelector(false);
                    });
                    if (source) {
                        Button refreshTablesButton = new Button(this.controller.getMessage("Refresh tables", new Object[0]), (ComponentEventListener & Serializable)event -> {
                            sourceEndpoint.clearTableCache();
                            AddTablesDialog.this.refreshTableSelector(true);
                        });
                        refreshTablesButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                        refreshTablesButton.setTooltipText(this.controller.getMessage("Re-read the tables from the '%s' endpoint's database", sourceEndpoint.getId()));
                        filterLayout.add(new Component[]{refreshTablesButton});
                    }
                }
            };
            this.sourceToTargetLayout.init();
            this.tableSelector.setItems(this.viewableTables);
            this.tableSelector.setHeight(null);
            this.tableSelector.getStyle().set("padding", "0 8px 8px 8px");
            this.tableSelector.setItemLabelGenerator((ItemLabelGenerator & Serializable)table -> table.getName());
            TwinColSelect.TwinColSelectI18n tableSelectorI18n = TwinColSelect.TwinColSelectI18n.getDefault();
            tableSelectorI18n.setAddAllToSelected(SelectTablesScreen.this.controller.getMessage("Select all tables", new Object[0]));
            tableSelectorI18n.setAddToSelected(SelectTablesScreen.this.controller.getMessage("Select tables", new Object[0]));
            tableSelectorI18n.setRemoveFromSelected(SelectTablesScreen.this.controller.getMessage("Deselect tables", new Object[0]));
            tableSelectorI18n.setRemoveAllFromSelected(SelectTablesScreen.this.controller.getMessage("Deselect all tables", new Object[0]));
            tableSelectorI18n.setToggleSelection(SelectTablesScreen.this.controller.getMessage("Toggle table selection", new Object[0]));
            this.tableSelector.setI18n(tableSelectorI18n);
            this.tableSelectionLayout = new VerticalLayout(new Component[]{advancedOptionsLayout, this.sourceToTargetLayout, this.tableSelector});
            this.tableSelectionLayout.setSizeFull();
            this.tableSelectionLayout.setMargin(false);
            this.tableSelectionLayout.setPadding(false);
            this.tableSelectionLayout.setSpacing(false);
            this.tableSelectionLayout.expand(new Component[]{this.tableSelector});
            Span foreignKeyHeader = as.createSubHeader(SelectTablesScreen.this.controller, "Missing Foreign Key Parent Tables");
            Span foreignKeyDescription = new Span(SelectTablesScreen.this.controller.getMessage("The following parent tables are not configured for replication. These tables will be added to replication in order to prevent foreign key constraint errors.", new Object[0]));
            this.foreignKeyLayout = new VerticalLayout(new Component[]{foreignKeyHeader, foreignKeyDescription});
            this.foreignKeyLayout.setSizeFull();
            this.foreignKeyLayout.setVisible(false);
            Span bidirectionalSpan = new Span(SelectTablesScreen.this.controller.getMessage("Do you want to set up tables in one direction or bidirectionally?", new Object[0]));
            bidirectionalSpan.addClassName("less-contrast");
            bidirectionalSpan.getStyle().set("font-size", "var(--lumo-font-size-l)");
            RadioButtonGroup bidirectionalOptions = new RadioButtonGroup();
            bidirectionalOptions.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
            bidirectionalOptions.getStyle().set("padding", "16px");
            bidirectionalOptions.setItems((Object[])new String[]{SelectTablesScreen.this.controller.getMessage("In one direction", new Object[0]), SelectTablesScreen.this.controller.getMessage("Bidirectionally", new Object[0])});
            this.bidirectionalArrowLayout = new VerticalLayout();
            this.bidirectionalArrowLayout.setMargin(false);
            this.bidirectionalArrowLayout.setDefaultHorizontalComponentAlignment(FlexComponent.Alignment.CENTER);
            HorizontalLayout bidirectionalSummary = new HorizontalLayout(new Component[]{this.createSummaryLayout(true), this.bidirectionalArrowLayout, this.createSummaryLayout(false)});
            bidirectionalOptions.setValue((Object)SelectTablesScreen.this.controller.getMessage("In one direction", new Object[0]));
            bidirectionalOptions.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                this.bidirectionalSelected = ((String)event.getValue()).equals(SelectTablesScreen.this.controller.getMessage("Bidirectionally", new Object[0]));
                this.refreshBidirectionalSummary();
                this.nextTooltip.setText(SelectTablesScreen.this.controller.getMessage(this.bidirectionalSelected ? "Add the selected table(s) bidirectionally and close the dialog" : "Add the selected table(s) and close the dialog", new Object[0]));
            });
            this.bidirectionalLayout = new VerticalLayout(new Component[]{bidirectionalSpan, bidirectionalOptions, bidirectionalSummary});
            this.bidirectionalLayout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{bidirectionalSummary});
            this.bidirectionalLayout.setSpacing(false);
            this.bidirectionalLayout.setVisible(false);
            this.mainLayout.add(new Component[]{this.tableSelectionLayout, this.foreignKeyLayout, this.bidirectionalLayout});
            this.mainLayout.setSpacing(false);
            this.mainLayout.getStyle().set("margin", "0");
            this.add(new Component[]{this.mainLayout});
            Anchor helpAnchor = SelectTablesScreen.this.canvas.createHelpAnchor(SelectTablesScreen.this.getDocAnchor());
            helpAnchor.getStyle().set("margin-right", "auto");
            Button cancelButton = new Button(SelectTablesScreen.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
            cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            cancelButton.getStyle().set("margin-right", "10px");
            Tooltip.forComponent((Component)cancelButton).withPosition(Tooltip.TooltipPosition.TOP).setText(SelectTablesScreen.this.controller.getMessage("Close the dialog without adding any tables", new Object[0]));
            this.previousButton = new Button(SelectTablesScreen.this.controller.getMessage("Previous", new Object[0]), (ComponentEventListener & Serializable)event -> this.switchScreens(this.bidirectionalLayout.isVisible() && this.foreignKeysSupported && !this.missingParentTableSet.isEmpty(), false));
            this.previousButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            this.previousButton.getStyle().set("margin-right", "10px");
            this.previousButton.setVisible(false);
            Tooltip.forComponent((Component)this.previousButton).withPosition(Tooltip.TooltipPosition.TOP).setText(SelectTablesScreen.this.controller.getMessage("Go back to the previous screen", new Object[0]));
            this.nextButton = as.createPrimaryButton(SelectTablesScreen.this.controller.getMessage("Next", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                if (this.nextButton.getText().equals(SelectTablesScreen.this.controller.getMessage("Next", new Object[0]))) {
                    if (this.foreignKeyLayout.isVisible()) {
                        this.switchScreens(false, true);
                    } else if (this.includeForeignKeyParentTablesCheckbox.isVisible() && ((Boolean)this.includeForeignKeyParentTablesCheckbox.getValue()).booleanValue()) {
                        new M<Set<ConfigCanvasTable>>(SelectTablesScreen.this.controller.getMessage("Checking foreign keys...", new Object[0]), new M.a<Set<ConfigCanvasTable>>(){

                            @Override
                            public Set<ConfigCanvasTable> doWork() {
                                IDdlReader ddlReader = sourceEndpoint.getDatabasePlatform().getDdlReader();
                                HashSet<ConfigCanvasTable> missingParentTableSet = new HashSet<ConfigCanvasTable>();
                                ListIterator<ConfigCanvasTable> tablesToCheckIterator = new ArrayList<ConfigCanvasTable>(AddTablesDialog.this.selectedTables).listIterator();
                                while (tablesToCheckIterator.hasNext()) {
                                    ConfigCanvasTable table = tablesToCheckIterator.next();
                                    Table dbTable = ddlReader.readTable(table.getCatalog(), table.getSchema(), table.getName());
                                    if (dbTable == null) continue;
                                    for (ForeignKey fk2 : dbTable.getForeignKeys()) {
                                        String foreignCatalog = (String)StringUtils.defaultIfBlank((CharSequence)fk2.getForeignTableCatalog(), null);
                                        String foreignSchema = (String)StringUtils.defaultIfBlank((CharSequence)fk2.getForeignTableSchema(), null);
                                        ConfigCanvasTable foreignTable = new ConfigCanvasTable(foreignCatalog, foreignSchema, fk2.getForeignTableName());
                                        if (sourceEndpoint.hasTableBeenAdded(targetEndpoint.getGuid(), foreignTable) || AddTablesDialog.this.selectedTables.contains(foreignTable) || !missingParentTableSet.add(foreignTable)) continue;
                                        foreignTable.setSourceTableExists(true);
                                        tablesToCheckIterator.add(foreignTable);
                                        tablesToCheckIterator.previous();
                                    }
                                }
                                return missingParentTableSet;
                            }

                            @Override
                            public void doUI(Set<ConfigCanvasTable> missingParentTableSet) {
                                boolean missingParentTables;
                                AddTablesDialog.this.missingParentTableSet = missingParentTableSet;
                                boolean bl2 = missingParentTables = !missingParentTableSet.isEmpty();
                                if (!missingParentTables && targetEndpoint.getType().isWriteOnly()) {
                                    AddTablesDialog.this.finish();
                                } else {
                                    AddTablesDialog.this.switchScreens(missingParentTables, !missingParentTables);
                                }
                            }
                        }, SelectTablesScreen.this.controller.getBackgroundRefresherService(), null, false, false).show();
                    } else {
                        this.missingParentTableSet.clear();
                        this.switchScreens(false, true);
                    }
                } else {
                    this.finish();
                }
            });
            if (targetEndpoint.getType().isWriteOnly() && (!this.foreignKeysSupported || this.createTableWithoutForeignKeys)) {
                this.nextButton.setText(SelectTablesScreen.this.controller.getMessage("Finish", new Object[0]));
            }
            this.nextButton.setEnabled(false);
            Div nextDiv = new Div(new Component[]{this.nextButton});
            this.nextTooltip = Tooltip.forComponent((Component)nextDiv).withPosition(Tooltip.TooltipPosition.TOP).withText(SelectTablesScreen.this.controller.getMessage("Select at least one table first", new Object[0]));
            this.getFooter().add(new Component[]{helpAnchor, cancelButton, this.previousButton, nextDiv});
            this.tableSelector.addSelectionListener((MultiSelectionListener & Serializable)event -> {
                if (!this.refreshingTableSelector) {
                    this.selectedTables.addAll(event.getAddedSelection());
                    this.selectedTables.removeAll(event.getRemovedSelection());
                    if (!this.selectedTables.isEmpty()) {
                        this.nextButton.setEnabled(true);
                        if (this.nextButton.getText().equals(SelectTablesScreen.this.controller.getMessage("Next", new Object[0]))) {
                            this.nextTooltip.setText(SelectTablesScreen.this.controller.getMessage(targetEndpoint.getType().isWriteOnly() ? "Check foreign keys, then either proceed to the next screen or add the table(s) and close" : "Proceed to the next screen", new Object[0]));
                        } else {
                            this.nextTooltip.setText(SelectTablesScreen.this.controller.getMessage("Add the selected table(s) and close the dialog", new Object[0]));
                        }
                    } else {
                        this.nextButton.setEnabled(false);
                        this.nextTooltip.setText(SelectTablesScreen.this.controller.getMessage("Select at least one table first", new Object[0]));
                    }
                    this.tableSelector.setItems(this.viewableTables);
                }
            });
            this.refreshTableSelector(true);
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> SelectTablesScreen.this.canvas.toggleDeleteShortcut(!event.isOpened()));
        }

        private VerticalLayout createSummaryLayout(boolean source) {
            ConfigCanvasEndpoint endpoint = source ? this.sourceEndpoint : this.targetEndpoint;
            HtmlContainer endpointIcon = as.getEndpointIcon(SelectTablesScreen.this.controller.getContextPath(), endpoint.getType());
            endpointIcon.setWidth("48px");
            endpointIcon.setHeight("48px");
            Span endpointSpan = new Span(endpoint.getId());
            endpointSpan.getStyle().set("font-size", "var(--lumo-font-size-xl)");
            VerticalLayout summaryLayout = new VerticalLayout(new Component[]{endpointIcon, endpointSpan});
            summaryLayout.setMargin(false);
            summaryLayout.setDefaultHorizontalComponentAlignment(FlexComponent.Alignment.CENTER);
            return summaryLayout;
        }

        private void refreshBidirectionalSummary() {
            Icon arrowIcon = new Icon(this.bidirectionalSelected ? VaadinIcon.ARROWS_LONG_H : VaadinIcon.ARROWS_LONG_RIGHT);
            arrowIcon.setSize("64px");
            int tableCount = SetUtils.union(this.selectedTables, this.missingParentTableSet).size();
            Label tableLabel = new Label(tableCount == 1 ? SelectTablesScreen.this.controller.getMessage("<span style=\"color:green; font-weight:bold; padding-right:2px;\">1</span> table", new Object[0]) : SelectTablesScreen.this.controller.getMessage("<span style=\"color:green; font-weight:bold; padding-right:2px;\">%d</span> tables", tableCount));
            tableLabel.setWidth("max-content");
            tableLabel.getStyle().set("font-size", "var(--lumo-font-size-xl)");
            this.bidirectionalArrowLayout.removeAll();
            this.bidirectionalArrowLayout.add(new Component[]{arrowIcon, tableLabel});
        }

        private void switchScreens(boolean showForeignKeyScreen, boolean showBidirectionalScreen) {
            if (showForeignKeyScreen) {
                if (this.missingParentTableLayout == null) {
                    this.missingParentTableLayout = as.createItemLayout(SelectTablesScreen.this.controller, this.missingParentTableSet.stream().map(t2 -> t2.getFullyQualifiedSourceTableName()).distinct().collect(Collectors.toList()), null, 250);
                    this.foreignKeyLayout.add(new Component[]{this.missingParentTableLayout});
                }
            } else if (showBidirectionalScreen) {
                this.refreshBidirectionalSummary();
            } else if (this.missingParentTableLayout != null) {
                this.foreignKeyLayout.remove(new Component[]{this.missingParentTableLayout});
                this.missingParentTableLayout = null;
            }
            this.tableSelectionLayout.setVisible(!showForeignKeyScreen && !showBidirectionalScreen);
            this.foreignKeyLayout.setVisible(showForeignKeyScreen);
            this.bidirectionalLayout.setVisible(showBidirectionalScreen);
            this.previousButton.setVisible(showForeignKeyScreen || showBidirectionalScreen);
            if (showBidirectionalScreen || (showForeignKeyScreen || !this.foreignKeysSupported) && this.targetEndpoint.getType().isWriteOnly()) {
                this.nextButton.setText(SelectTablesScreen.this.controller.getMessage("Finish", new Object[0]));
                this.nextTooltip.setText(SelectTablesScreen.this.controller.getMessage(this.bidirectionalSelected ? "Add the selected table(s) bidirectionally and close the dialog" : "Add the selected table(s) and close the dialog", new Object[0]));
            } else {
                this.nextButton.setText(SelectTablesScreen.this.controller.getMessage("Next", new Object[0]));
                this.nextTooltip.setText(SelectTablesScreen.this.controller.getMessage(this.targetEndpoint.getType().isWriteOnly() ? "Check foreign keys, then either proceed to the next screen or add the table(s) and close" : "Proceed to the next screen", new Object[0]));
            }
            this.nextButton.setEnabled(true);
            this.nextButton.focus();
        }

        private void refreshTableSelector(boolean refreshTables) {
            String availableFilter = this.sourceToTargetLayout.getFilter(true);
            String selectedFilter = this.sourceToTargetLayout.getFilter(false);
            this.viewableTables.clear();
            if (refreshTables) {
                String catalog = this.sourceToTargetLayout.getSelectedCatalog(true);
                String schema = this.sourceToTargetLayout.getSelectedSchema(true);
                this.tables = this.getTables(catalog, schema);
            }
            for (ConfigCanvasTable table : this.tables) {
                String tableName = table.getName();
                if (Strings.CI.startsWith((CharSequence)tableName, (CharSequence)this.tablePrefix) || this.selectedTables.contains(table) || this.sourceEndpoint.hasTableBeenAdded(this.targetEndpoint.getGuid(), table) || CommonUiUtils.isFilteredOut((String)tableName, (String)availableFilter)) continue;
                this.viewableTables.add(table);
            }
            HashSet<ConfigCanvasTable> viewableSelectedTables = new HashSet<ConfigCanvasTable>();
            for (ConfigCanvasTable table : this.selectedTables) {
                String tableName = table.getName();
                if (Strings.CI.startsWith((CharSequence)tableName, (CharSequence)this.tablePrefix) || CommonUiUtils.isFilteredOut((String)tableName, (String)selectedFilter)) continue;
                this.viewableTables.add(table);
                viewableSelectedTables.add(table);
            }
            this.refreshingTableSelector = true;
            this.tableSelector.setValue(viewableSelectedTables);
            this.tableSelector.getListDataView().refreshAll();
            this.refreshingTableSelector = false;
        }

        public void refreshSchemas(boolean source, Select<String> schemaSelect) {
            String oldValue = (String)schemaSelect.getValue();
            List<String> schemaList = this.getSchemas(source);
            Collections.sort(schemaList, String.CASE_INSENSITIVE_ORDER);
            schemaSelect.setItems(schemaList);
            if (schemaList.size() == 0) {
                schemaSelect.setVisible(false);
            } else {
                schemaSelect.setVisible(true);
                schemaSelect.setValue((Object)(schemaList.contains(oldValue) ? oldValue : (source ? schemaList.get(0) : null)));
            }
        }

        public List<String> getSchemas(boolean source) {
            String catalog = this.sourceToTargetLayout.getSelectedCatalog(source);
            ArrayList<String> schemas = null;
            try {
                schemas = (source ? this.sourceEndpoint : this.targetEndpoint).getDatabasePlatform().getDdlReader().getSchemaNames(catalog);
            }
            catch (Exception e2) {
                this.log.debug("Unable to get schemas for catalog " + catalog, (Throwable)e2);
            }
            if (schemas != null) {
                schemas.removeIf(Objects::isNull);
            } else {
                schemas = new ArrayList<String>();
            }
            return schemas;
        }

        public List<String> getCatalogs(boolean source) {
            ArrayList<String> catalogs = (source ? this.sourceEndpoint : this.targetEndpoint).getDatabasePlatform().getDdlReader().getCatalogNames();
            if (catalogs != null) {
                catalogs.removeIf(Objects::isNull);
            } else {
                catalogs = new ArrayList<String>();
            }
            return catalogs;
        }

        public List<ConfigCanvasTable> getTables(String catalog, String schema) {
            String selectedSchema;
            ArrayList<ConfigCanvasTable> tables = new ArrayList<ConfigCanvasTable>();
            String selectedCatalog = this.sourceToTargetLayout.getSelectedCatalog(true);
            List<ConfigCanvasTable> cachedTables = this.sourceEndpoint.getTablesFromCache(selectedCatalog, selectedSchema = this.sourceToTargetLayout.getSelectedSchema(true));
            if (cachedTables != null) {
                for (ConfigCanvasTable cachedTable : cachedTables) {
                    ConfigCanvasTable table = new ConfigCanvasTable(cachedTable.getCatalog(), cachedTable.getSchema(), cachedTable.getName());
                    table.setSourceTableExists(true);
                    tables.add(table);
                }
                return tables;
            }
            List tableNames = this.sourceEndpoint.getDatabasePlatform().getDdlReader().getTableNames(Objects.toString(selectedCatalog, this.sourceEndpoint.getDefaultCatalog()), Objects.toString(selectedSchema, this.sourceEndpoint.getDefaultSchema()), new String[]{"TABLE"});
            Collections.sort(tableNames, String.CASE_INSENSITIVE_ORDER);
            for (String tableName : tableNames) {
                ConfigCanvasTable table = new ConfigCanvasTable(catalog, schema, tableName);
                table.setSourceTableExists(true);
                tables.add(table);
            }
            this.sourceEndpoint.cacheTables(selectedCatalog, selectedSchema, tables);
            return tables;
        }

        private void finish() {
            boolean advancedOptionsVisible = this.captureIdPrefixField.isAttached();
            String channelId = advancedOptionsVisible && this.channelSelect != null ? (String)this.channelSelect.getValue() : "default";
            String triggerIdPrefix = advancedOptionsVisible ? this.captureIdPrefixField.getValue() : null;
            String targetCatalog = Strings.CS.equals(this.sourceToTargetLayout.getSelectedCatalog(false), this.targetEndpoint.getDefaultCatalog()) ? null : this.sourceToTargetLayout.getSelectedCatalog(false);
            String targetSchema = Strings.CS.equals(this.sourceToTargetLayout.getSelectedSchema(false), this.targetEndpoint.getDefaultSchema()) ? null : this.sourceToTargetLayout.getSelectedSchema(false);
            String sourceEndpointGuid = this.sourceEndpoint.getGuid();
            String targetEndpointGuid = this.targetEndpoint.getGuid();
            boolean matchSourceCatalogSchema = this.sourceToTargetLayout.isMatchSourceCatalogSchema();
            String defaultSourceCatalog = this.sourceEndpoint.getDefaultCatalog();
            String defaultSourceSchema = this.sourceEndpoint.getDefaultSchema();
            boolean skippedForeignKeyCheck = this.foreignKeysSupported && (Boolean)this.includeForeignKeyParentTablesCheckbox.getValue() == false && !this.createTableWithoutForeignKeys;
            this.selectedTables.addAll(this.missingParentTableSet);
            SelectTablesScreen.this.canvas.showLicenseViolationWarningIfNecessary(SelectTablesScreen.this.canvas.getLicenseViolationLayout(0, this.selectedTables.stream().map(t2 -> t2.getName().toLowerCase()).collect(Collectors.toSet()), false, true, true, null));
            for (ConfigCanvasTable selectedTable : this.selectedTables) {
                if (Strings.CS.equals(selectedTable.getCatalog(), defaultSourceCatalog)) {
                    selectedTable.setCatalog(null);
                }
                if (Strings.CS.equals(selectedTable.getSchema(), defaultSourceSchema)) {
                    selectedTable.setSchema(null);
                }
                selectedTable.setTargetCatalog(matchSourceCatalogSchema ? selectedTable.getCatalog() : targetCatalog);
                selectedTable.setTargetSchema(matchSourceCatalogSchema ? selectedTable.getSchema() : targetSchema);
                selectedTable.setSkippedForeignKeyCheck(skippedForeignKeyCheck);
            }
            this.sourceEndpoint.addTables(this.targetEndpoint, this.selectedTables, channelId, triggerIdPrefix, targetCatalog, targetSchema, matchSourceCatalogSchema);
            this.targetEndpoint.setIncomingTableCountForLink(sourceEndpointGuid, this.sourceEndpoint.getTableCount(targetEndpointGuid));
            if (this.bidirectionalSelected) {
                Gson gson = new Gson();
                Type tableSetType = new TypeToken<Set<ConfigCanvasTable>>(){}.getType();
                Set selectedTablesCopy = (Set)gson.fromJson(gson.toJson(this.selectedTables, tableSetType), tableSetType);
                for (ConfigCanvasTable table : selectedTablesCopy) {
                    if (!matchSourceCatalogSchema) {
                        table.setCatalog(targetCatalog);
                        table.setSchema(targetSchema);
                    }
                    table.setTargetCatalog(matchSourceCatalogSchema ? table.getCatalog() : null);
                    table.setTargetSchema(matchSourceCatalogSchema ? table.getSchema() : null);
                }
                this.targetEndpoint.addTables(this.sourceEndpoint, selectedTablesCopy, channelId, triggerIdPrefix, null, null, matchSourceCatalogSchema);
                this.sourceEndpoint.setIncomingTableCountForLink(targetEndpointGuid, this.targetEndpoint.getTableCount(sourceEndpointGuid));
                SelectTablesScreen.this.incomingLayout.refresh();
                SelectTablesScreen.this.outgoingLayout.refresh();
            } else {
                this.selectTablesLayout.refresh();
            }
            SelectTablesScreen.this.canvas.getNextButton().setEnabled(true);
            SelectTablesScreen.this.canvas.setNextButtonTooltip(SelectTablesScreen.this.controller.getMessage("Proceed to the next screen", new Object[0]));
            SelectTablesScreen.this.canvas.refreshEndpoints();
            SelectTablesScreen.this.canvas.redrawDiagram();
            this.close();
        }
    }

    class RemoveTablesDialog
    extends X {
        private static final long serialVersionUID = 1L;
        private ConfigCanvasEndpoint sourceEndpoint;
        private List<ConfigCanvasTable> tables;
        private Set<ConfigCanvasTable> selectedTables;
        private Set<ConfigCanvasTable> viewableTables;
        private ConfigCanvasSourceToTargetLayout sourceToTargetLayout;
        private TwinColSelect<ConfigCanvasTable> tableSelector;
        private boolean refreshingTableSelector;

        public RemoveTablesDialog(SelectTablesLayout selectTablesLayout, ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint) {
            super(SelectTablesScreen.this.controller.getMessage("Remove Tables", new Object[0]), SelectTablesScreen.this.controller.getContextPath(), null, SelectTablesScreen.this.controller.getMessage("Close the dialog without removing any tables", new Object[0]));
            this.tables = new ArrayList<ConfigCanvasTable>();
            this.selectedTables = new HashSet<ConfigCanvasTable>();
            this.viewableTables = new TreeSet<ConfigCanvasTable>((t0, t1) -> this.getFullyQualifiedTableName((ConfigCanvasTable)t0).toLowerCase().compareTo(this.getFullyQualifiedTableName((ConfigCanvasTable)t1).toLowerCase()));
            this.tableSelector = new TwinColSelect();
            this.sourceEndpoint = sourceEndpoint;
            this.setHeight("770px");
            this.setWidth("1400px");
            this.setCloseOnOutsideClick(false);
            this.sourceToTargetLayout = new ConfigCanvasSourceToTargetLayout(SelectTablesScreen.this.controller, null, null, SelectTablesScreen.this.controller.getMessage("Tables to Keep", new Object[0]), SelectTablesScreen.this.controller.getMessage("Tables to Remove", new Object[0]), false, false, false){
                private static final long serialVersionUID = 1L;

                @Override
                protected void initFilterField(boolean source, TextField filterField, HorizontalLayout filterLayout) {
                    super.initFilterField(source, filterField, filterLayout);
                    filterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> RemoveTablesDialog.this.refreshTableSelector());
                }
            };
            this.sourceToTargetLayout.init();
            String targetEndpointGuid = targetEndpoint.getGuid();
            List<ConfigCanvasLink.ConfigCanvasTableGroup> tableGroupList = sourceEndpoint.getTableGroupList(targetEndpointGuid);
            for (ConfigCanvasLink.ConfigCanvasTableGroup tableGroup : tableGroupList) {
                this.tables.addAll(tableGroup.getTableSet());
            }
            this.tableSelector.setItems(this.viewableTables);
            this.tableSelector.setHeight(null);
            this.tableSelector.getStyle().set("padding", "0 8px 8px 8px");
            this.tableSelector.setItemLabelGenerator((ItemLabelGenerator & Serializable)table -> this.getFullyQualifiedTableName((ConfigCanvasTable)table));
            TwinColSelect.TwinColSelectI18n tableSelectorI18n = TwinColSelect.TwinColSelectI18n.getDefault();
            tableSelectorI18n.setAddAllToSelected(SelectTablesScreen.this.controller.getMessage("Select all tables", new Object[0]));
            tableSelectorI18n.setAddToSelected(SelectTablesScreen.this.controller.getMessage("Select tables", new Object[0]));
            tableSelectorI18n.setRemoveFromSelected(SelectTablesScreen.this.controller.getMessage("Deselect tables", new Object[0]));
            tableSelectorI18n.setRemoveAllFromSelected(SelectTablesScreen.this.controller.getMessage("Deselect all tables", new Object[0]));
            tableSelectorI18n.setToggleSelection(SelectTablesScreen.this.controller.getMessage("Toggle table selection", new Object[0]));
            this.tableSelector.setI18n(tableSelectorI18n);
            this.mainLayout.add(new Component[]{this.sourceToTargetLayout, this.tableSelector});
            this.mainLayout.expand(new Component[]{this.tableSelector});
            this.mainLayout.setSpacing(false);
            this.mainLayout.getStyle().set("margin", "0");
            Anchor helpAnchor = SelectTablesScreen.this.canvas.createHelpAnchor(SelectTablesScreen.this.getDocAnchor());
            helpAnchor.getStyle().set("margin-right", "auto");
            Button cancelButton = new Button(SelectTablesScreen.this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
            cancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
            cancelButton.getStyle().set("margin-right", "10px");
            cancelButton.setTooltipText(SelectTablesScreen.this.controller.getMessage("Close the dialog without removing any tables", new Object[0]));
            Button finishButton = as.createPrimaryButton(SelectTablesScreen.this.controller.getMessage("Finish", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                sourceEndpoint.getLink(targetEndpointGuid).removeTables(this.selectedTables);
                String sourceEndpointGuid = sourceEndpoint.getGuid();
                int outgoingTableCount = sourceEndpoint.getTableCount(targetEndpointGuid);
                targetEndpoint.setIncomingTableCountForLink(sourceEndpointGuid, outgoingTableCount);
                if (sourceEndpoint.getTransformList(targetEndpointGuid).isEmpty()) {
                    targetEndpoint.setIncomingTransformedForLink(sourceEndpointGuid, false);
                }
                selectTablesLayout.refresh();
                boolean anyTablesSelected = outgoingTableCount > 0 || targetEndpoint.getTableCount(sourceEndpointGuid) > 0;
                SelectTablesScreen.this.canvas.getNextButton().setEnabled(anyTablesSelected);
                SelectTablesScreen.this.canvas.setNextButtonTooltip(SelectTablesScreen.this.controller.getMessage(anyTablesSelected ? "Proceed to the next screen" : "Select at least one table first", new Object[0]));
                SelectTablesScreen.this.canvas.refreshEndpoints();
                SelectTablesScreen.this.canvas.redrawDiagram();
                this.close();
            });
            finishButton.setEnabled(false);
            Div finishDiv = new Div(new Component[]{finishButton});
            Tooltip finishTooltip = Tooltip.forComponent((Component)finishDiv).withText(SelectTablesScreen.this.controller.getMessage("Remove the selected table(s) and close the dialog", new Object[0]));
            this.getFooter().add(new Component[]{helpAnchor, cancelButton, finishDiv});
            this.tableSelector.addSelectionListener((MultiSelectionListener & Serializable)event -> {
                if (!this.refreshingTableSelector) {
                    this.selectedTables.addAll(event.getAddedSelection());
                    this.selectedTables.removeAll(event.getRemovedSelection());
                    if (!this.selectedTables.isEmpty()) {
                        finishButton.setEnabled(true);
                        finishTooltip.setText(SelectTablesScreen.this.controller.getMessage("Remove the selected table(s) and close the dialog", new Object[0]));
                    } else {
                        finishButton.setEnabled(false);
                        finishTooltip.setText(SelectTablesScreen.this.controller.getMessage("Select at least one table first", new Object[0]));
                    }
                    this.tableSelector.setItems(this.viewableTables);
                }
            });
            this.refreshTableSelector();
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> SelectTablesScreen.this.canvas.toggleDeleteShortcut(!event.isOpened()));
        }

        private String getFullyQualifiedTableName(ConfigCanvasTable table) {
            String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
            String schema = (String)StringUtils.defaultIfBlank((CharSequence)table.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
            return Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)table.getName());
        }

        private void refreshTableSelector() {
            String availableFilter = this.sourceToTargetLayout.getFilter(true);
            String selectedFilter = this.sourceToTargetLayout.getFilter(false);
            this.viewableTables.clear();
            for (ConfigCanvasTable table : this.tables) {
                if (this.selectedTables.contains(table) || CommonUiUtils.isFilteredOut((String)this.getFullyQualifiedTableName(table), (String)availableFilter)) continue;
                this.viewableTables.add(table);
            }
            HashSet<ConfigCanvasTable> viewableSelectedTables = new HashSet<ConfigCanvasTable>();
            for (ConfigCanvasTable table : this.selectedTables) {
                if (CommonUiUtils.isFilteredOut((String)this.getFullyQualifiedTableName(table), (String)selectedFilter)) continue;
                this.viewableTables.add(table);
                viewableSelectedTables.add(table);
            }
            this.refreshingTableSelector = true;
            this.tableSelector.setValue(viewableSelectedTables);
            this.tableSelector.getListDataView().refreshAll();
            this.refreshingTableSelector = false;
        }
    }

    class ViewTablesDialog
    extends X {
        private static final long serialVersionUID = 1L;
        private ConfigCanvasEndpoint sourceEndpoint;
        private List<ConfigCanvasTable> tables;
        private TextField catalogFilter;
        private TextField schemaFilter;
        private TextField tableFilter;
        private Grid<ConfigCanvasTable> tableGrid;

        public ViewTablesDialog(ConfigCanvasEndpoint sourceEndpoint, ConfigCanvasEndpoint targetEndpoint) {
            super(SelectTablesScreen.this.controller.getMessage("View Tables", new Object[0]), SelectTablesScreen.this.controller.getContextPath());
            this.tables = new ArrayList<ConfigCanvasTable>();
            this.tableGrid = new Grid();
            this.sourceEndpoint = sourceEndpoint;
            this.setHeight("770px");
            this.setWidth("1000px");
            this.setCloseOnOutsideClick(false);
            List<ConfigCanvasLink.ConfigCanvasTableGroup> tableGroupList = sourceEndpoint.getTableGroupList(targetEndpoint.getGuid());
            for (ConfigCanvasLink.ConfigCanvasTableGroup tableGroup : tableGroupList) {
                this.tables.addAll(tableGroup.getTableSet());
            }
            this.tableGrid.setWidthFull();
            this.tableGrid.setSelectionMode(Grid.SelectionMode.NONE);
            HeaderRow headerRow = this.tableGrid.appendHeaderRow();
            HeaderRow filterRow = this.tableGrid.appendHeaderRow();
            if (this.tables.stream().anyMatch(t2 -> StringUtils.isNotBlank((CharSequence)this.getCatalog((ConfigCanvasTable)t2)))) {
                this.tableGrid.addColumn((ValueProvider & Serializable)table -> this.getCatalog((ConfigCanvasTable)table)).setComparator((t1, t0) -> Strings.CI.compare(this.getCatalog((ConfigCanvasTable)t0), this.getCatalog((ConfigCanvasTable)t1))).setKey("catalog");
                this.catalogFilter = this.createFilterField();
                ((HeaderRow.HeaderCell)filterRow.getCell(this.tableGrid.getColumnByKey("catalog"))).setComponent((Component)this.catalogFilter);
                ((HeaderRow.HeaderCell)headerRow.getCell(this.tableGrid.getColumnByKey("catalog"))).setText(SelectTablesScreen.this.controller.getMessage("Source Catalog", new Object[0]));
            }
            if (this.tables.stream().anyMatch(t2 -> StringUtils.isNotBlank((CharSequence)this.getSchema((ConfigCanvasTable)t2)))) {
                this.tableGrid.addColumn((ValueProvider & Serializable)table -> this.getSchema((ConfigCanvasTable)table)).setComparator((t1, t0) -> Strings.CI.compare(this.getSchema((ConfigCanvasTable)t0), this.getSchema((ConfigCanvasTable)t1))).setKey("schema");
                this.schemaFilter = this.createFilterField();
                ((HeaderRow.HeaderCell)filterRow.getCell(this.tableGrid.getColumnByKey("schema"))).setComponent((Component)this.schemaFilter);
                ((HeaderRow.HeaderCell)headerRow.getCell(this.tableGrid.getColumnByKey("schema"))).setText(SelectTablesScreen.this.controller.getMessage("Source Schema", new Object[0]));
            }
            this.tableGrid.addColumn((ValueProvider & Serializable)table -> table.getName()).setComparator((t0, t1) -> t0.getName().compareToIgnoreCase(t1.getName())).setKey("name");
            this.tableFilter = this.createFilterField();
            ((HeaderRow.HeaderCell)filterRow.getCell(this.tableGrid.getColumnByKey("name"))).setComponent((Component)this.tableFilter);
            ((HeaderRow.HeaderCell)headerRow.getCell(this.tableGrid.getColumnByKey("name"))).setText(SelectTablesScreen.this.controller.getMessage("Source Table", new Object[0]));
            for (Grid.Column column : this.tableGrid.getColumns()) {
                ((Grid.Column)column.setAutoWidth(true).setResizable(true)).setSortable(true);
            }
            this.refreshGrid();
            GridSortOrder order = new GridSortOrder(this.tableGrid.getColumnByKey("name"), SortDirection.ASCENDING);
            ArrayList<GridSortOrder> orderList = new ArrayList<GridSortOrder>();
            orderList.add(order);
            this.tableGrid.sort(orderList);
            this.mainLayout.addAndExpand(new Component[]{this.tableGrid});
            Anchor helpAnchor = SelectTablesScreen.this.canvas.createHelpAnchor(SelectTablesScreen.this.getDocAnchor());
            helpAnchor.getStyle().set("margin-right", "auto");
            this.getFooter().add(new Component[]{helpAnchor});
            this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> SelectTablesScreen.this.canvas.toggleDeleteShortcut(!event.isOpened()));
        }

        private String getCatalog(ConfigCanvasTable table) {
            return (String)StringUtils.defaultIfBlank((CharSequence)table.getCatalog(), (CharSequence)this.sourceEndpoint.getDefaultCatalog());
        }

        private String getSchema(ConfigCanvasTable table) {
            return (String)StringUtils.defaultIfBlank((CharSequence)table.getSchema(), (CharSequence)this.sourceEndpoint.getDefaultSchema());
        }

        private TextField createFilterField() {
            TextField filter = new TextField();
            filter.addThemeVariants((ThemeVariant[])new TextFieldVariant[]{TextFieldVariant.LUMO_SMALL});
            filter.setWidthFull();
            filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.refreshGrid());
            filter.setValueChangeMode(ValueChangeMode.LAZY);
            filter.setValueChangeTimeout(200);
            return filter;
        }

        private void refreshGrid() {
            ArrayList<ConfigCanvasTable> filteredTableList = new ArrayList<ConfigCanvasTable>();
            for (ConfigCanvasTable table : this.tables) {
                if (this.isFilteredOut(this.getCatalog(table), this.catalogFilter) || this.isFilteredOut(this.getSchema(table), this.schemaFilter) || this.isFilteredOut(table.getName(), this.tableFilter)) continue;
                filteredTableList.add(table);
            }
            this.tableGrid.setItems(filteredTableList);
        }

        private boolean isFilteredOut(String text, TextField filterField) {
            if (filterField == null) {
                return false;
            }
            return CommonUiUtils.isFilteredOut((String)text, (String)filterField.getValue());
        }
    }
}

