/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.transform.ColumnPolicy;
import org.jumpmind.symmetric.io.data.transform.TargetDmlAction;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.util.FormatUtils;

public class ConfigCanvasTransformTable {
    private String id;
    private String originalSourceCatalogName;
    private String originalSourceSchemaName;
    private String sourceCatalogName;
    private String sourceSchemaName;
    private String sourceTableName;
    private String targetCatalogName;
    private String targetSchemaName;
    private String targetTableName;
    private TransformPoint transformPoint;
    private List<ConfigCanvasTransformColumn> transformColumns = new ArrayList<ConfigCanvasTransformColumn>();
    private transient Set<String> sourceColumnNames = new TreeSet<String>((c0, c1) -> c0.toLowerCase().compareTo(c1.toLowerCase()));
    private transient Set<String> targetColumnNames = new TreeSet<String>((c0, c1) -> c0.toLowerCase().compareTo(c1.toLowerCase()));
    private transient Set<String> addedColumnNames = new HashSet<String>();
    private transient Set<String> sourcePrimaryKeyColumnNames = new HashSet<String>();
    private transient Set<String> targetPrimaryKeyColumnNames = new HashSet<String>();
    private String updateAction = TargetDmlAction.UPD_ROW.name();
    private TargetDmlAction deleteAction = TargetDmlAction.DEL_ROW;
    private ColumnPolicy columnPolicy = ColumnPolicy.IMPLIED;
    private boolean updateFirst = false;
    private int transformOrder = 0;
    private Date createTime;
    private transient boolean isNew;
    private transient boolean removed;

    public ConfigCanvasTransformTable() {
    }

    public ConfigCanvasTransformTable(String sourceTableName, String targetTableName, TransformPoint transformPoint) {
        this.sourceTableName = sourceTableName;
        this.targetTableName = targetTableName;
        this.transformPoint = transformPoint;
    }

    public ConfigCanvasTransformTable(TransformTable transform, String originalSourceCatalogName, String originalSourceSchemaName) {
        this.id = transform.getTransformId();
        this.sourceCatalogName = transform.getSourceCatalogName();
        this.sourceSchemaName = transform.getSourceSchemaName();
        this.sourceTableName = transform.getSourceTableName();
        this.targetCatalogName = transform.getTargetCatalogName();
        this.targetSchemaName = transform.getTargetSchemaName();
        this.targetTableName = transform.getTargetTableName();
        this.transformPoint = transform.getTransformPoint();
        if (transform.getTransformColumns() != null) {
            for (TransformColumn transformColumn : transform.getTransformColumns()) {
                this.transformColumns.add(new ConfigCanvasTransformColumn(transformColumn));
            }
        }
        this.updateAction = transform.getUpdateAction();
        if (TargetDmlAction.UPDATE_COL.name().equals(this.updateAction)) {
            this.updateAction = TargetDmlAction.UPD_ROW.name();
        }
        this.deleteAction = transform.getDeleteAction();
        this.columnPolicy = transform.getColumnPolicy();
        this.updateFirst = transform.isUpdateFirst();
        this.transformOrder = transform.getTransformOrder();
        this.createTime = transform.getCreateTime();
        Date date = this.createTime;
        if (date instanceof Timestamp) {
            Timestamp createTimestamp = (Timestamp)date;
            this.createTime = new Date(createTimestamp.getTime());
        }
        this.originalSourceCatalogName = originalSourceCatalogName;
        this.originalSourceSchemaName = originalSourceSchemaName;
    }

    public String generateDefaultId() {
        return this.generateDefaultId(0);
    }

    public String generateDefaultId(int duplicateNumber) {
        Object prefix = this.sourceTableName + " to " + this.targetTableName;
        Object suffix = "";
        if (TransformPoint.LOAD.equals((Object)this.transformPoint)) {
            suffix = (String)suffix + " (LOAD)";
        }
        if (duplicateNumber > 0) {
            suffix = (String)suffix + " " + duplicateNumber;
        }
        if (((String)prefix + (String)suffix).length() <= 50) {
            return (String)prefix + (String)suffix;
        }
        if (((String)(prefix = FormatUtils.replaceCharsToShortenName((String)prefix)) + (String)suffix).length() <= 50) {
            return (String)prefix + (String)suffix;
        }
        return StringUtils.abbreviate((String)prefix, (int)(50 - ((String)suffix).length())) + (String)suffix;
    }

    public Set<String> getMappedColumnSet() {
        Set<String> mappedColumnSet = this.transformColumns.stream().filter(tc -> !"remove".equals(tc.getTransformType())).map(tc -> tc.getTargetColumnName()).collect(Collectors.toSet());
        if (ColumnPolicy.IMPLIED.equals((Object)this.columnPolicy)) {
            Set removedColumnSet = this.transformColumns.stream().filter(tc -> "remove".equals(tc.getTransformType())).map(tc -> tc.getSourceColumnName()).collect(Collectors.toSet());
            for (String columnName : this.sourceColumnNames) {
                if (!this.targetColumnNames.contains(columnName) || removedColumnSet.contains(columnName)) continue;
                mappedColumnSet.add(columnName);
            }
        }
        return mappedColumnSet;
    }

    public Set<Column> getImpliedColumnSet() {
        HashSet<Column> impliedColumnSet = new HashSet<Column>();
        if (ColumnPolicy.IMPLIED.equals((Object)this.columnPolicy)) {
            Set mappedColumnSet = this.transformColumns.stream().map(tc -> "remove".equals(tc.getTransformType()) ? tc.getSourceColumnName() : tc.getTargetColumnName()).collect(Collectors.toSet());
            for (String columnName : this.sourceColumnNames) {
                if (!this.targetColumnNames.contains(columnName) || mappedColumnSet.contains(columnName)) continue;
                impliedColumnSet.add(new Column(columnName, this.sourcePrimaryKeyColumnNames.contains(columnName)));
            }
        }
        return impliedColumnSet;
    }

    public String getFullyQualifiedOriginalSourceTableName() {
        return Table.getFullyQualifiedTableName((String)this.originalSourceCatalogName, (String)this.originalSourceSchemaName, (String)this.sourceTableName);
    }

    public String getFullyQualifiedSourceTableName() {
        return Table.getFullyQualifiedTableName((String)this.sourceCatalogName, (String)this.sourceSchemaName, (String)this.sourceTableName);
    }

    public String getFullyQualifiedTargetTableName() {
        return Table.getFullyQualifiedTableName((String)this.targetCatalogName, (String)this.targetSchemaName, (String)this.targetTableName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOriginalSourceCatalogName() {
        return this.originalSourceCatalogName;
    }

    public void setOriginalSourceCatalogName(String originalSourceCatalogName) {
        this.originalSourceCatalogName = originalSourceCatalogName;
    }

    public String getOriginalSourceSchemaName() {
        return this.originalSourceSchemaName;
    }

    public void setOriginalSourceSchemaName(String originalSourceSchemaName) {
        this.originalSourceSchemaName = originalSourceSchemaName;
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    public void setTargetCatalogName(String targetCatalogName) {
        this.targetCatalogName = targetCatalogName;
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public TransformPoint getTransformPoint() {
        return this.transformPoint;
    }

    public List<ConfigCanvasTransformColumn> getTransformColumns() {
        return this.transformColumns;
    }

    public void setTransformColumns(List<ConfigCanvasTransformColumn> transformColumns) {
        this.transformColumns = transformColumns;
    }

    public Set<String> getSourceColumnNames() {
        return this.sourceColumnNames;
    }

    public Set<String> getTargetColumnNames() {
        return this.targetColumnNames;
    }

    public Set<String> getAddedColumnNames() {
        return this.addedColumnNames;
    }

    public Set<String> getSourcePrimaryKeyColumnNames() {
        return this.sourcePrimaryKeyColumnNames;
    }

    public Set<String> getTargetPrimaryKeyColumnNames() {
        return this.targetPrimaryKeyColumnNames;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(String updateAction) {
        this.updateAction = updateAction;
    }

    public TargetDmlAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(TargetDmlAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    public ColumnPolicy getColumnPolicy() {
        return this.columnPolicy;
    }

    public void setColumnPolicy(ColumnPolicy columnPolicy) {
        this.columnPolicy = columnPolicy;
    }

    public boolean isUpdateFirst() {
        return this.updateFirst;
    }

    public void setUpdateFirst(boolean updateFirst) {
        this.updateFirst = updateFirst;
    }

    public int getTransformOrder() {
        return this.transformOrder;
    }

    public void setTransformOrder(int transformOrder) {
        this.transformOrder = transformOrder;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
        if (isNew) {
            this.removed = false;
        }
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
        if (removed) {
            this.isNew = false;
        }
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.id != null) {
            if (obj instanceof ConfigCanvasTransformTable) {
                return this.id.equals(((ConfigCanvasTransformTable)obj).id);
            }
            return false;
        }
        return super.equals(obj);
    }

    public class ConfigCanvasTransformColumn {
        private String sourceColumnName;
        private String targetColumnName;
        private boolean primaryKey;
        private String transformType = "copy";
        private String transformExpression;
        private int transformOrder;
        private TransformColumn.IncludeOnType includeOn = TransformColumn.IncludeOnType.ALL;

        public ConfigCanvasTransformColumn(TransformColumn transformColumn) {
            this(transformColumn.getSourceColumnName(), transformColumn.getTargetColumnName(), transformColumn.isPk());
            this.transformType = transformColumn.getTransformType();
            this.transformExpression = transformColumn.getTransformExpression();
            this.transformOrder = transformColumn.getTransformOrder();
            this.includeOn = transformColumn.getIncludeOn();
        }

        public ConfigCanvasTransformColumn(String sourceColumnName, String targetColumnName, boolean primaryKey) {
            this.sourceColumnName = sourceColumnName;
            this.targetColumnName = targetColumnName;
            this.primaryKey = primaryKey;
        }

        public String getSourceColumnName() {
            return this.sourceColumnName;
        }

        public void setSourceColumnName(String sourceColumnName) {
            this.sourceColumnName = sourceColumnName;
        }

        public String getTargetColumnName() {
            return this.targetColumnName;
        }

        public void setTargetColumnName(String targetColumnName) {
            this.targetColumnName = targetColumnName;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
        }

        public String getTransformType() {
            return this.transformType;
        }

        public void setTransformType(String transformType) {
            this.transformType = transformType;
        }

        public String getTransformExpression() {
            return this.transformExpression;
        }

        public void setTransformExpression(String transformExpression) {
            this.transformExpression = transformExpression;
        }

        public int getTransformOrder() {
            return this.transformOrder;
        }

        public void setTransformOrder(int transformOrder) {
            this.transformOrder = transformOrder;
        }

        public TransformColumn.IncludeOnType getIncludeOn() {
            return this.includeOn;
        }

        public void setIncludeOn(TransformColumn.IncludeOnType includeOn) {
            this.includeOn = includeOn;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.includeOn == null ? 0 : this.includeOn.hashCode());
            result = 31 * result + (this.targetColumnName == null ? 0 : this.targetColumnName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConfigCanvasTransformColumn)) {
                return false;
            }
            ConfigCanvasTransformColumn other = (ConfigCanvasTransformColumn)obj;
            if (this.includeOn != other.includeOn) {
                return false;
            }
            return !(this.targetColumnName == null ? other.targetColumnName != null : !this.targetColumnName.equals(other.targetColumnName));
        }
    }
}

