/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jumpmind.symmetric.console.impl.J;
import com.jumpmind.symmetric.console.impl.K;
import com.jumpmind.symmetric.console.impl.N;
import com.jumpmind.symmetric.console.impl.P;
import com.jumpmind.symmetric.console.impl.fG;
import com.jumpmind.symmetric.console.impl.fJ;
import com.jumpmind.symmetric.console.impl.fM;
import com.jumpmind.symmetric.console.impl.fN;
import com.jumpmind.symmetric.console.impl.fP;
import com.jumpmind.symmetric.console.impl.fR;
import com.jumpmind.symmetric.console.impl.fU;
import com.jumpmind.symmetric.console.impl.fV;
import com.jumpmind.symmetric.console.impl.fW;
import com.jumpmind.symmetric.console.impl.hc;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.MonitorSummary;
import com.jumpmind.symmetric.console.model.NodeGroupSummary;
import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.service.IProConsoleService;
import com.jumpmind.symmetric.console.service.impl.ExpandedTableResolver;
import com.jumpmind.symmetric.console.service.impl.ProConsoleServiceSqlMap;
import com.jumpmind.symmetric.db.ProBulkDataLoaderFactory;
import com.jumpmind.symmetric.db.ProDataLoaderFactory;
import com.jumpmind.symmetric.stage.a;
import com.jumpmind.symmetric.stage.b;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.extension.IProgressListener;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.StagingFileLock;
import org.jumpmind.symmetric.io.stage.StagingManager;
import org.jumpmind.symmetric.load.DefaultDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.TableReloadStatus;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.jumpmind.symmetric.util.CounterStat;
import org.jumpmind.symmetric.util.CounterStatComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProConsoleService
implements IProConsoleService,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine engine;
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISqlMap sql;
    private TypedProperties settings;
    private Map<String, TypedProperties> settingsMap = new HashMap<String, TypedProperties>();
    private File settingsDirectory;
    private static Set<String> systemCdcChannels = new HashSet<String>();

    protected String getSql(String ... keys) {
        return this.sql.getSql(keys);
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.sql = new ProConsoleServiceSqlMap(engine.getSymmetricDialect().getPlatform(), engine.getTablePrefix());
        IExtensionService extensionService = engine.getExtensionService();
        extensionService.addExtensionPoint((IExtensionPoint)new K());
        extensionService.addExtensionPoint((IExtensionPoint)new J());
        extensionService.addExtensionPoint((IExtensionPoint)new fM());
        extensionService.addExtensionPoint((IExtensionPoint)new fN());
        extensionService.addExtensionPoint((IExtensionPoint)new ExpandedTableResolver());
        extensionService.removeExtensionPoint((IExtensionPoint)new DefaultDataLoaderFactory());
        extensionService.addExtensionPoint((IExtensionPoint)new ProDataLoaderFactory(engine));
        extensionService.getExtensionPointMap(IDataLoaderFactory.class).remove("bulkLoaderFactory");
        extensionService.addExtensionPoint((IExtensionPoint)new ProBulkDataLoaderFactory());
        extensionService.addExtensionPoint((IExtensionPoint)new P());
        extensionService.addExtensionPoint((IExtensionPoint)new N());
        extensionService.addExtensionPoint((IExtensionPoint)new fW(engine));
        extensionService.addExtensionPoint((IExtensionPoint)new fU(engine));
        extensionService.addExtensionPoint((IExtensionPoint)new fV(engine));
        extensionService.addExtensionPoint((IExtensionPoint)new a());
        extensionService.addExtensionPoint((IExtensionPoint)new fG());
        extensionService.addExtensionPoint((IExtensionPoint)new hc());
        try {
            Class.forName("com.azure.storage.blob.BlobClient");
            extensionService.addExtensionPoint((IExtensionPoint)new fJ());
            extensionService.addExtensionPoint((IExtensionPoint)new fP());
        }
        catch (Exception e2) {
            this.log.debug("Unable to register Azure file tracker", (Throwable)e2);
        }
        try {
            Class.forName("com.amazonaws.services.s3.AmazonS3");
            Class.forName("com.amazonaws.auth.AWSCredentials");
            extensionService.addExtensionPoint((IExtensionPoint)new fR());
            extensionService.addExtensionPoint((IExtensionPoint)new fP());
        }
        catch (Exception e3) {
            this.log.debug("Unable to register S3 file tracker", (Throwable)e3);
        }
    }

    @Override
    public void cancelLoad(TableReloadStatus obj) {
        List infos = this.engine.getStatisticManager().getProcessInfos();
        ArrayList<Long> batchIds = new ArrayList<Long>();
        for (ProcessInfo info : infos) {
            if (info.getCurrentLoadId() != (long)obj.getLoadId() || info.getCurrentBatchId() <= 0L) continue;
            batchIds.add(info.getCurrentBatchId());
        }
        this.engine.getInitialLoadService().cancelLoad(obj);
        IRemoteStatusService remoteStatusService = (IRemoteStatusService)this.engine.getExtensionService().getExtensionPoint(IRemoteStatusService.class);
        if (remoteStatusService != null) {
            for (Long batchId : batchIds) {
                this.log.info("Sending interrupt remotely to " + obj.getTargetNodeId() + " for batch " + batchId);
                remoteStatusService.sendMessage(obj.getTargetNodeId(), "batchstop " + batchId);
            }
        }
    }

    @Override
    public TypedProperties getSettings(String user) {
        return this.loadSettings(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSettings(TypedProperties settings, String user) {
        this.settingsDirectory = new File(System.getProperty("java.io.tmpdir"), user);
        this.settingsDirectory.mkdirs();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            File file = new File(this.settingsDirectory, "console-service-settings.json");
            PrintWriter os = null;
            try {
                os = new PrintWriter(new FileOutputStream(file, false));
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                os.write(gson.toJson((Object)settings));
                this.settings = settings;
                this.settingsMap.remove(user);
            }
            catch (Exception ex2) {
                this.log.error(ex2.getMessage(), (Throwable)ex2);
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TypedProperties loadSettings(String user) {
        if (this.settingsMap.get(user) != null) {
            return this.settingsMap.get(user);
        }
        this.settingsDirectory = new File(System.getProperty("java.io.tmpdir"), user);
        this.settingsDirectory.mkdirs();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            block15: {
                File file = new File(this.settingsDirectory, "console-service-settings.json");
                if (file.exists() && file.length() > 0L) {
                    TypedProperties typedProperties;
                    InputStreamReader is = null;
                    try {
                        is = new InputStreamReader(new FileInputStream(file));
                        Gson gson = new GsonBuilder().create();
                        this.settings = (TypedProperties)gson.fromJson((Reader)is, TypedProperties.class);
                        this.settingsMap.put(user, this.settings);
                        typedProperties = this.settings;
                    }
                    catch (Exception e2) {
                        this.log.error("Failed to load settings", (Throwable)e2);
                        FileUtils.deleteQuietly((File)file);
                        break block15;
                    }
                    return typedProperties;
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.buildProperties();
            this.settingsMap.put(user, this.settings);
            return this.settings;
        }
    }

    private TypedProperties buildProperties() {
        this.settings = new TypedProperties();
        this.settings.put((Object)"pro.console.remind.interval", (Object)"86400000");
        this.settings.put((Object)"pro.console.last.remind.time", (Object)new Date(0L).toString());
        this.settings.put((Object)"pro.console.newest.version", (Object)"");
        this.settings.put((Object)"license.expire.remind.interval", (Object)"604800000");
        this.settings.put((Object)"license.expire.last.remind.time", (Object)new Date(0L).toString());
        this.settings.put((Object)"cert.expire.remind.interval", (Object)"604800000");
        this.settings.put((Object)"cert.expire.last.remind.time", (Object)new Date(0L).toString());
        this.settings.put((Object)"form.show.advanced.options", (Object)false);
        this.settings.put((Object)"display.appearance", (Object)"auto");
        this.settings.put((Object)"display.date.format", (Object)"yyyy-MM-dd");
        this.settings.put((Object)"display.time.format", (Object)"hh:mm:ss aaa");
        this.settings.put((Object)"display.time.zone", (Object)"auto");
        this.settings.put((Object)"user.default.configure.screen", (Object)"Canvas");
        return this.settings;
    }

    @Override
    public void balanceChannelsForInitialLoad(String sourceNodeGroupId, String targetNodeGroupId, int numChannels, String copyFromReloadChannelId, boolean splitExtractOfLargeTables, String userId, IProgressListener listener) {
        Trigger trigger;
        this.log.info("Balancing tables on group link from \"{}\" to \"{}\" for {} channels based on {} channel", new Object[]{sourceNodeGroupId, targetNodeGroupId, numChannels, copyFromReloadChannelId});
        String nodeId = this.engine.getNodeId();
        ((IConsoleEventService)this.engine.getExtensionService().getExtensionPoint(IConsoleEventService.class)).addEvent(new ConsoleEvent(userId, "Channel Created", nodeId, nodeId, null, "channel: " + copyFromReloadChannelId + ", num=" + numChannels));
        IDatabasePlatform platform = this.engine.getDatabasePlatform();
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        List triggerRouters = triggerRouterService.getAllTriggerRoutersForReloadForCurrentNode(sourceNodeGroupId, targetNodeGroupId);
        ArrayList<CounterStat> stats = new ArrayList<CounterStat>(triggerRouters.size());
        HashMap<String, Table> tablesByTriggerId = new HashMap<String, Table>();
        HashMap<String, TriggerRouter> triggerRoutersByTriggerId = new HashMap<String, TriggerRouter>();
        long totalRows = 0L;
        int stepNumber = 1;
        int totalSteps = triggerRouters.size() * 2;
        ArrayList<TriggerRouter> enabledTriggerRouters = new ArrayList<TriggerRouter>();
        for (TriggerRouter triggerRouter : triggerRouters) {
            trigger = triggerRouter.getTrigger();
            if (!triggerRouter.isEnabled() || triggerRouter.getInitialLoadOrder() < 0 || !trigger.isSyncOnInsert() && !trigger.isSyncOnUpdate() && !trigger.isSyncOnDelete()) continue;
            enabledTriggerRouters.add(triggerRouter);
        }
        this.log.info("Found {} tables to balance across {} channels", (Object)enabledTriggerRouters.size(), (Object)numChannels);
        for (TriggerRouter triggerRouter : enabledTriggerRouters) {
            trigger = triggerRouter.getTrigger();
            triggerRoutersByTriggerId.put(trigger.getTriggerId(), triggerRouter);
            String catalog = StringUtils.isNotBlank((CharSequence)trigger.getSourceCatalogName()) ? trigger.getSourceCatalogName() : platform.getDefaultCatalog();
            String schema = StringUtils.isNotBlank((CharSequence)trigger.getSourceSchemaName()) ? trigger.getSourceSchemaName() : platform.getDefaultSchema();
            Table table = platform.getTableFromCache(catalog, schema, trigger.getSourceTableName(), false);
            tablesByTriggerId.put(trigger.getTriggerId(), table);
            long rowCount = platform.getEstimatedRowCount(table);
            totalRows += rowCount;
            stats.add(new CounterStat((Object)triggerRouter, rowCount));
            if (listener == null) continue;
            listener.checkpoint(this.engine.getEngineName(), stepNumber++, totalSteps);
        }
        DecimalFormat formatter = new DecimalFormat("#,###");
        this.log.info("Total rows is {}", (Object)formatter.format(totalRows));
        stats.sort((Comparator<CounterStat>)new CounterStatComparator(false));
        long rowsPerChannel = totalRows / (long)numChannels;
        int currentChannelNum = 0;
        int currentChannelRows = 0;
        int currentChannelTables = 0;
        Map channels = this.engine.getConfigurationService().getChannels(true);
        Channel copyFromReloadChannel = (Channel)channels.get(copyFromReloadChannelId);
        String reloadChannelId = this.createReloadChannel(channels, copyFromReloadChannel, currentChannelNum);
        Iterator iter = stats.iterator();
        while (iter.hasNext()) {
            CounterStat stat = (CounterStat)iter.next();
            long rowCount = stat.getCount();
            TriggerRouter triggerRouter = (TriggerRouter)stat.getObject();
            Trigger trigger2 = triggerRouter.getTrigger();
            int channelsToUse = (int)((float)rowCount / (float)totalRows * (float)numChannels);
            if (splitExtractOfLargeTables && platform.supportsSliceTables() && channelsToUse > 1) {
                this.log.info("Splitting table {} with {} rows across {} channels", new Object[]{trigger2.getSourceTableName(), formatter.format(rowCount), channelsToUse});
                for (int i2 = 0; i2 < channelsToUse; ++i2) {
                    this.log.info("Channel {} has 1 partial table and {} rows", (Object)reloadChannelId, (Object)formatter.format(rowCount / (long)channelsToUse));
                    this.sliceTriggerRouter(triggerRoutersByTriggerId, triggerRouter, tablesByTriggerId, reloadChannelId, i2, channelsToUse);
                    if (i2 + 1 >= channelsToUse) continue;
                    reloadChannelId = this.createReloadChannel(channels, copyFromReloadChannel, ++currentChannelNum);
                }
            } else if (!trigger2.getReloadChannelId().equals(reloadChannelId)) {
                trigger2.setReloadChannelId(reloadChannelId);
                triggerRouterService.saveTrigger(trigger2);
            }
            if (this.engine.getParameterService().is("auto.create.channels.cleanup", true)) {
                this.cleanupOldTriggerRouters(triggerRoutersByTriggerId, trigger2.getTriggerId(), channelsToUse);
            }
            currentChannelRows = (int)((long)currentChannelRows + rowCount);
            ++currentChannelTables;
            if (iter.hasNext() && (long)currentChannelRows > rowsPerChannel) {
                this.log.info("Channel {} has {} tables and {} rows", new Object[]{reloadChannelId, currentChannelTables, currentChannelRows});
                currentChannelRows = 0;
                currentChannelTables = 0;
                reloadChannelId = this.createReloadChannel(channels, copyFromReloadChannel, ++currentChannelNum);
            }
            if (listener == null) continue;
            listener.checkpoint(this.engine.getEngineName(), stepNumber++, totalSteps);
        }
        this.log.info("Channel {} has {} tables and {} rows", new Object[]{reloadChannelId, currentChannelTables, currentChannelRows});
        this.log.info("Done balancing channels");
    }

    protected String createReloadChannel(Map<String, Channel> channels, Channel copyFromReloadChannel, int number) {
        Channel channelExisting;
        Object channelId = copyFromReloadChannel.getChannelId();
        if (number > 0) {
            channelId = (String)channelId + (number + 1);
        }
        if ((channelExisting = channels.get(channelId)) == null || !channelExisting.getChannelId().equals(channelExisting.getQueue())) {
            Channel channelCopy = copyFromReloadChannel.copy();
            channelCopy.setChannelId((String)channelId);
            channelCopy.setQueue((String)channelId);
            this.log.info("Saving channel {}", channelId);
            this.engine.getConfigurationService().saveChannel(channelCopy, true);
        } else {
            this.log.debug("Found existing channel {}", channelId);
        }
        return channelId;
    }

    protected void sliceTriggerRouter(Map<String, TriggerRouter> triggerRoutersByTriggerId, TriggerRouter triggerRouter, Map<String, Table> tablesByTriggerId, String reloadChannelId, int sliceNum, int totalSlices) {
        Object triggerId = triggerRouter.getTriggerId();
        if (sliceNum > 0) {
            triggerId = (String)triggerId + (sliceNum + 1);
        }
        Table table = tablesByTriggerId.get(triggerRouter.getTriggerId());
        String columnName = null;
        columnName = table.getPrimaryKeyColumnCount() > 0 ? table.getPrimaryKeyColumnNames()[0] : table.getColumnNames()[0];
        String initialLoadSelect = this.engine.getDatabasePlatform().getSliceTableSql(columnName, sliceNum, totalSlices);
        TriggerRouter triggerRouterExisting = triggerRoutersByTriggerId.get(triggerId);
        if (triggerRouterExisting == null || !Strings.CS.equals(triggerRouterExisting.getInitialLoadSelect(), initialLoadSelect)) {
            TriggerRouter triggerRouterCopy = triggerRouter.copy();
            triggerRouterCopy.setInitialLoadSelect(initialLoadSelect);
            Trigger triggerCopy = triggerRouterCopy.getTrigger();
            triggerCopy.setTriggerId((String)triggerId);
            if (sliceNum > 0) {
                triggerCopy.setSyncOnInsert(false);
                triggerCopy.setSyncOnUpdate(false);
                triggerCopy.setSyncOnDelete(false);
            }
            triggerCopy.setReloadChannelId(reloadChannelId);
            this.log.info("Saving trigger router {}", triggerId);
            this.engine.getTriggerRouterService().saveTriggerRouter(triggerRouterCopy);
        } else {
            this.log.debug("Found existing trigger router {}", triggerId);
        }
    }

    protected void cleanupOldTriggerRouters(Map<String, TriggerRouter> triggerRoutersByTriggerId, String triggerId, int maxChannels) {
        TriggerRouter triggerRouter;
        int i2;
        int n2 = i2 = maxChannels == 0 ? 2 : maxChannels + 1;
        while ((triggerRouter = triggerRoutersByTriggerId.get(triggerId + i2)) != null) {
            Trigger trigger = triggerRouter.getTrigger();
            if (!(trigger.isSyncOnInsert() || trigger.isSyncOnUpdate() || trigger.isSyncOnDelete())) {
                this.log.info("Clean up old trigger router {}", (Object)trigger.getTriggerId());
                this.engine.getTriggerRouterService().deleteTriggerRouter(triggerRouter);
                this.engine.getTriggerRouterService().deleteTrigger(trigger);
            }
            ++i2;
        }
    }

    @Override
    public void ignoreRowForOutgoingBatchByDataId(OutgoingBatch batch, long dataId) {
        long batchId = batch.getBatchId();
        int idType = this.engine.getSymmetricDialect().getSqlTypeForIds();
        this.engine.getSqlTemplate().update(this.getSql("ignoreRowSql"), new Object[]{dataId, batchId}, new int[]{idType, idType});
        StagingManager stagingManager = (StagingManager)this.engine.getStagingManager();
        String paddedBatchId = StringUtils.leftPad((String)String.valueOf(batchId), (int)10, (char)'0');
        String filePath = "outgoing/" + batch.getNodeId() + "/" + paddedBatchId;
        IStagedResource resource = stagingManager.find(filePath);
        if (resource != null) {
            stagingManager.removeResourcePath(filePath);
            resource.delete();
        }
    }

    @Override
    public void ignoreRowForOutgoingBatchByRowNumber(OutgoingBatch batch) {
        long batchId = batch.getBatchId();
        StagingManager stagingManager = (StagingManager)this.engine.getStagingManager();
        String paddedBatchId = StringUtils.leftPad((String)String.valueOf(batchId), (int)10, (char)'0');
        String filePath = "outgoing/" + batch.getNodeId() + "/" + paddedBatchId;
        IStagedResource resource = stagingManager.find(filePath);
        StagingFileLock lock = this.engine.getDataExtractorService().acquireStagingFileLock(batch);
        BufferedReader reader = resource.getReader();
        Object stagingText = "";
        List lines = reader.lines().collect(Collectors.toList());
        int rowCount = 0;
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            boolean isRow;
            String line = (String)lines.get(i2);
            boolean bl2 = isRow = line.startsWith("insert") || line.startsWith("update") || line.startsWith("delete");
            if (isRow) {
                ++rowCount;
            }
            if (isRow && (long)rowCount == batch.getFailedLineNumber()) continue;
            stagingText = (String)stagingText + line + "\n";
        }
        IParameterService parameterService = this.engine.getParameterService();
        try {
            if (resource instanceof b && (parameterService.is("stream.to.file.encrypt.enabled", false) || parameterService.is("stream.to.file.compression.enabled", false))) {
                writer = ((b)resource).getWriter(parameterService.getLong("stream.to.file.threshold.bytes"));
                writer.write((String)stagingText);
            } else {
                writer = new FileWriter(resource.getFile());
                writer.write((String)stagingText);
                ((OutputStreamWriter)writer).close();
                resource.refreshLastUpdateTime();
            }
        }
        catch (IOException e2) {
            this.log.error("Failed to write to " + resource.getFile().getName(), (Throwable)e2);
        }
        resource.close();
        lock.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTableStats(String tableName, String eventType, long extractedRows, long loadedRows, Date startTime, Date endTime) {
        block13: {
            this.log.debug("Saving table stats");
            try (ISqlTransaction transaction = null;){
                transaction = this.engine.getSqlTemplate().startSqlTransaction();
                int[] types = new int[]{12, 12, 93, 93, -5, -5};
                transaction.prepareAndExecute(this.getSql("insertTableStat"), new Object[]{tableName, eventType, startTime, endTime, loadedRows, extractedRows}, types);
                transaction.commit();
            }
        }
    }

    protected ISymmetricEngine getSymmetricEngine(List<ISymmetricEngine> engines) {
        ISymmetricEngine engine = null;
        for (ISymmetricEngine thisEngine : engines) {
            if (!thisEngine.getParameterService().isRegistrationServer()) continue;
            engine = thisEngine;
            break;
        }
        if (engine == null && engines.size() > 0) {
            engine = engines.get(0);
        }
        return engine;
    }

    @Override
    public long geAveragePurge() {
        return this.engine.getSqlTemplate().queryForLong(this.getSql("getAveragePurge"), new Object[0]);
    }

    @Override
    public List<Node> geSlowestPurgeNodes(int limit) {
        int i2 = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Row rs : this.engine.getSqlTemplate().query(this.getSql("getSlowestPurgeNodes"))) {
            if (i2 >= limit) break;
            nodes.add(ProConsoleService.mapNode(rs));
            ++i2;
        }
        return nodes;
    }

    @Override
    public List<Node> getOldestPurgeNodes(int limit) {
        int i2 = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Row rs : this.engine.getSqlTemplate().query(this.getSql("getOldestPurgeNodes"))) {
            if (i2 >= limit) break;
            nodes.add(ProConsoleService.mapNode(rs));
            ++i2;
        }
        return nodes;
    }

    @Override
    public long geAverageRouting() {
        return this.engine.getSqlTemplate().queryForLong(this.getSql("getAverageRouting"), new Object[0]);
    }

    @Override
    public List<Node> geSlowestRoutingNodes(int limit) {
        int i2 = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Row rs : this.engine.getSqlTemplate().query(this.getSql("getSlowestRoutingNodes"))) {
            if (i2 >= limit) break;
            nodes.add(ProConsoleService.mapNode(rs));
            ++i2;
        }
        return nodes;
    }

    @Override
    public List<Node> getOldestRoutingNodes(int limit) {
        int i2 = 0;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Row rs : this.engine.getSqlTemplate().query(this.getSql("getOldestRoutingNodes"))) {
            if (i2 >= limit) break;
            nodes.add(ProConsoleService.mapNode(rs));
            ++i2;
        }
        return nodes;
    }

    public static Node mapNode(Row rs) {
        Node node = new Node();
        node.setNodeId(rs.getString("node_id"));
        node.setNodeGroupId(rs.getString("node_group_id"));
        node.setExternalId(rs.getString("external_id"));
        node.setSyncEnabled(rs.getBoolean("sync_enabled"));
        node.setSyncUrl(rs.getString("sync_url"));
        node.setSchemaVersion(rs.getString("schema_version"));
        node.setDatabaseType(rs.getString("database_type"));
        node.setDatabaseVersion(rs.getString("database_version"));
        node.setDatabaseName(rs.getString("database_name"));
        node.setSymmetricVersion(rs.getString("symmetric_version"));
        node.setCreatedAtNodeId(rs.getString("created_at_node_id"));
        node.setBatchToSendCount(rs.getInt("batch_to_send_count"));
        node.setBatchInErrorCount(rs.getInt("batch_in_error_count"));
        node.setDeploymentType(rs.getString("deployment_type"));
        node.setDeploymentSubType(rs.getString("deployment_sub_type"));
        node.setConfigVersion(rs.getString("config_version"));
        node.setPurgeOutgoingAverageMs(rs.getLong("purge_outgoing_average_ms"));
        node.setPurgeOutgoingLastMs(rs.getLong("purge_outgoing_last_run_ms"));
        node.setPurgeOutgoingLastRun(rs.getDateTime("purge_outgoing_last_finish"));
        node.setRoutingAverageMs(rs.getLong("routing_average_run_ms"));
        node.setRoutingLastMs(rs.getLong("routing_last_run_ms"));
        node.setRoutingLastRun(rs.getDateTime("routing_last_finish"));
        node.setSymDataSize(rs.getLong("sym_data_size"));
        node.setMostRecentActiveTableSynced(rs.getString("most_recent_active_table"));
        node.setLastSuccessfulSyncDate(rs.getDateTime("batch_last_successful"));
        node.setDataRowsLoadedCount(rs.getInt("data_rows_loaded_count"));
        node.setDataRowsToSendCount(rs.getInt("data_rows_to_send_count"));
        return node;
    }

    @Override
    public List<MonitorSummary> getMonitorSummary() {
        return this.engine.getSqlTemplate().query(this.getSql("getMonitorSummary"), (ISqlRowMapper)new ISqlRowMapper<MonitorSummary>(){

            public MonitorSummary mapRow(Row rs) {
                MonitorSummary summary = new MonitorSummary();
                summary.setNodeCount(rs.getInt("node_count"));
                summary.setMonitorId(rs.getString("monitor_id"));
                summary.setSeverityLevel(rs.getInt("severity_level"));
                summary.setMaxEventCount(rs.getInt("max_event_count"));
                summary.setMaxEventTime(rs.getDateTime("max_event_time"));
                summary.setThreshold(rs.getLong("threshold"));
                summary.setType(rs.getString("type"));
                summary.setValue(rs.getLong("event_value"));
                summary.setPinned(rs.getBoolean("is_pinned"));
                return summary;
            }
        }, new Object[0]);
    }

    @Override
    public List<NodeGroupSummary> getNodeGroupSummary() {
        List<NodeGroupSummary> nodeGroupSummary = new ArrayList<NodeGroupSummary>();
        try {
            nodeGroupSummary = this.engine.getSqlTemplate().query(this.getSql("getNodeGroupSummary"), (ISqlRowMapper)new ISqlRowMapper<NodeGroupSummary>(){

                public NodeGroupSummary mapRow(Row rs) {
                    NodeGroupSummary summary = new NodeGroupSummary();
                    summary.setTargetTableCount(rs.getInt("target_table_count"));
                    summary.setSourceTableCount(rs.getInt("source_table_count"));
                    summary.setNodes(rs.getInt("nodes"));
                    summary.setNodeGroupId(rs.getString("node_group_id"));
                    summary.setDatabaseType(rs.getString("database_type"));
                    return summary;
                }
            }, new Object[0]);
        }
        catch (Throwable t2) {
            this.log.info("Unable to build node group summary panel on dashboard.", (Object)t2.getMessage());
        }
        return nodeGroupSummary;
    }

    @Override
    public List<Node> getNodeSyncSummary(boolean allTiers) {
        return this.engine.getSqlTemplate().query(this.getSql(allTiers ? "getNodeSyncSummary" : "getNodeSyncSummaryChildOnly"), (ISqlRowMapper)new ISqlRowMapper<Node>(){

            public Node mapRow(Row rs) {
                return ProConsoleService.mapNode(rs);
            }
        }, new Object[0]);
    }

    @Override
    public String getMostRecentActiveTableSynced() {
        Iterator iterator = this.engine.getSqlTemplate().query(this.getSql("getLastTableSynced")).iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            return row.getString("table_name");
        }
        return null;
    }

    @Override
    public Map<Integer, Date> getTotalLoadedRows() {
        HashMap<Integer, Date> totals = new HashMap<Integer, Date>();
        Iterator iterator = this.engine.getSqlTemplate().query(this.getSql("getTotalRowsLoaded")).iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            totals.put(row.getInt("total_rows"), row.getDateTime("oldest_load_time"));
            return totals;
        }
        return totals;
    }

    @Override
    public void pauseNode(String nodeId) {
        ISymmetricEngine engine = AbstractSymmetricEngine.findEngineByNodeId((String)nodeId);
        if (engine != null) {
            for (String channelId : engine.getConfigurationService().getChannels(false).keySet()) {
                if (systemCdcChannels.contains(channelId)) continue;
                NodeChannel nodeChannel = new NodeChannel(channelId);
                nodeChannel.setNodeId(nodeId);
                nodeChannel.setSuspendEnabled(true);
                engine.getConfigurationService().saveNodeChannelControl(nodeChannel, true);
            }
        }
    }

    @Override
    public void resumeNode(String nodeId) {
        ISymmetricEngine engine = AbstractSymmetricEngine.findEngineByNodeId((String)nodeId);
        if (engine != null) {
            for (String channelId : engine.getConfigurationService().getChannels(false).keySet()) {
                if (systemCdcChannels.contains(channelId)) continue;
                engine.getConfigurationService().deleteNodeChannelControl(nodeId, channelId);
            }
        }
    }

    @Override
    public Set<String> getPausedNodes() {
        HashSet<String> nodes = new HashSet<String>();
        for (ISymmetricEngine engine : AbstractSymmetricEngine.findEngines()) {
            for (NodeChannel nodeChannel : engine.getConfigurationService().getNodeChannels(false)) {
                if (!nodeChannel.getNodeId().equals(engine.getNodeId()) || !nodeChannel.isSuspendEnabled()) continue;
                nodes.add(engine.getNodeId());
            }
        }
        return nodes;
    }

    static {
        systemCdcChannels.add("config");
        systemCdcChannels.add("system");
        systemCdcChannels.add("heartbeat");
        systemCdcChannels.add("monitor");
        systemCdcChannels.add("dynamic");
    }
}

