/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jumpmind.symmetric.cache.a;
import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gA;
import com.jumpmind.symmetric.console.impl.gB;
import com.jumpmind.symmetric.console.impl.gC;
import com.jumpmind.symmetric.console.impl.gD;
import com.jumpmind.symmetric.console.impl.gE;
import com.jumpmind.symmetric.console.impl.gF;
import com.jumpmind.symmetric.console.impl.gG;
import com.jumpmind.symmetric.console.impl.gH;
import com.jumpmind.symmetric.console.impl.gI;
import com.jumpmind.symmetric.console.impl.gJ;
import com.jumpmind.symmetric.console.impl.gK;
import com.jumpmind.symmetric.console.impl.gL;
import com.jumpmind.symmetric.console.impl.gM;
import com.jumpmind.symmetric.console.impl.gN;
import com.jumpmind.symmetric.console.impl.gO;
import com.jumpmind.symmetric.console.impl.gP;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.impl.gS;
import com.jumpmind.symmetric.console.impl.ga;
import com.jumpmind.symmetric.console.impl.gb;
import com.jumpmind.symmetric.console.impl.gc;
import com.jumpmind.symmetric.console.impl.gd;
import com.jumpmind.symmetric.console.impl.ge;
import com.jumpmind.symmetric.console.impl.gf;
import com.jumpmind.symmetric.console.impl.gg;
import com.jumpmind.symmetric.console.impl.gh;
import com.jumpmind.symmetric.console.impl.gi;
import com.jumpmind.symmetric.console.impl.gj;
import com.jumpmind.symmetric.console.impl.gk;
import com.jumpmind.symmetric.console.impl.gl;
import com.jumpmind.symmetric.console.impl.gm;
import com.jumpmind.symmetric.console.impl.gn;
import com.jumpmind.symmetric.console.impl.go;
import com.jumpmind.symmetric.console.impl.gp;
import com.jumpmind.symmetric.console.impl.gq;
import com.jumpmind.symmetric.console.impl.gr;
import com.jumpmind.symmetric.console.impl.gs;
import com.jumpmind.symmetric.console.impl.gt;
import com.jumpmind.symmetric.console.impl.gu;
import com.jumpmind.symmetric.console.impl.gv;
import com.jumpmind.symmetric.console.impl.gw;
import com.jumpmind.symmetric.console.impl.gx;
import com.jumpmind.symmetric.console.impl.gy;
import com.jumpmind.symmetric.console.impl.gz;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.model.Notification;
import com.jumpmind.symmetric.console.service.IBackgroundNoHangupService;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.service.impl.MonitorServiceSqlMap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.notification.b;
import com.jumpmind.symmetric.notification.c;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.ICached;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.LogSummary;

public class MonitorService
extends AbstractService
implements IMonitorService,
ICached,
ISymmetricEngineAware {
    protected String hostName;
    protected INodeService nodeService;
    protected IExtensionService extensionService;
    protected IClusterService clusterService;
    protected IContextService contextService;
    protected IBackgroundNoHangupService backgroundNoHangupService;
    protected Map<String, Long> checkTimesByType = new HashMap<String, Long>();
    protected Map<String, List<Long>> averagesByType = new HashMap<String, List<Long>>();
    protected String typeColumnName;
    protected Set<String> invalidMonitorTypes = new HashSet<String>();
    private a proCacheManager;

    public MonitorService() {
    }

    public MonitorService(ISymmetricEngine engine, ISymmetricDialect symmetricDialect) {
        super(engine.getParameterService(), symmetricDialect);
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        com.jumpmind.symmetric.notification.a[] notificationExtensions;
        ga[] monitorExtensions;
        this.symmetricDialect = engine.getSymmetricDialect();
        this.parameterService = engine.getParameterService();
        this.nodeService = engine.getNodeService();
        this.extensionService = engine.getExtensionService();
        this.clusterService = engine.getClusterService();
        this.contextService = engine.getContextService();
        this.backgroundNoHangupService = (IBackgroundNoHangupService)this.extensionService.getExtensionPoint(IBackgroundNoHangupService.class);
        this.tablePrefix = this.parameterService.getTablePrefix();
        this.platform = this.symmetricDialect.getPlatform();
        this.sqlTemplate = this.symmetricDialect.getPlatform().getSqlTemplate();
        this.sqlTemplateDirty = this.symmetricDialect.getPlatform().getSqlTemplateDirty();
        MonitorServiceSqlMap sqlMap = new MonitorServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens());
        this.typeColumnName = sqlMap.getTypeColumnName();
        this.setSqlMap((ISqlMap)sqlMap);
        this.hostName = StringUtils.left((String)AppUtils.getHostName(), (int)60);
        for (ga ext : monitorExtensions = new ga[]{new gy(), new gz(), new gA(), new gC(), new gD(), new gE(), new gM(), new gP(), new gL(), new gN(), new gK(), new gF(), new gG(), new gI(), new gB(), new gJ(), new gO(), new gH(), new gi(), new gk(), new gl(), new gm(), new gn(), new gb(), new gu(), new gv(), new gd(), new gp(), new gs(), new gq(), new gr(), new gc(), new gt(), new ge(), new gj(), new gf(), new gg(), new go(), new gw(), new gx(), new gh()}) {
            this.extensionService.addExtensionPoint(ext.b(), (IExtensionPoint)ext);
        }
        for (com.jumpmind.symmetric.notification.a ext : notificationExtensions = new com.jumpmind.symmetric.notification.a[]{new c(), new b()}) {
            this.extensionService.addExtensionPoint(ext.a(), (IExtensionPoint)ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update() {
        Map monitorTypes = this.extensionService.getExtensionPointMap(ga.class);
        Node identity = this.nodeService.findIdentity();
        if (identity != null) {
            List<Monitor> activeMonitors = this.getActiveMonitorsForNode(identity.getNodeGroupId(), identity.getExternalId());
            Map<String, MonitorEvent> unresolved = this.getMonitorEventsNotResolvedForNode(identity.getNodeId());
            Map<String, List<MonitorEvent>> resolved = this.getMonitorEventsResolvedForNode(identity.getNodeId());
            for (Monitor monitor : activeMonitors) {
                ga monitorType = (ga)monitorTypes.get(monitor.getType());
                if (monitorType != null) {
                    long lastCheckTime;
                    if (monitorType.a()) continue;
                    boolean processedInsight = false;
                    if (monitorType instanceof fZ) {
                        processedInsight = this.processInsight(monitor.getMonitorId(), (fZ)monitorType, unresolved, resolved);
                    }
                    if (processedInsight) continue;
                    Long lastCheckTimeLong = this.checkTimesByType.get(monitor.getMonitorId());
                    long l2 = lastCheckTime = lastCheckTimeLong != null ? lastCheckTimeLong : 0L;
                    if (lastCheckTime != 0L && (System.currentTimeMillis() - lastCheckTime) / 1000L < (long)monitor.getRunPeriod()) continue;
                    this.checkTimesByType.put(monitor.getMonitorId(), System.currentTimeMillis());
                    this.updateMonitor(monitor, monitorType, identity, unresolved, lastCheckTime);
                    continue;
                }
                if (!this.invalidMonitorTypes.add(monitor.getType())) continue;
                this.log.warn("Could not find monitor of type '" + monitor.getType() + "'");
            }
            if (this.clusterService.lock("Monitor")) {
                try {
                    Gson gson = new Gson();
                    Type mapType = new TypeToken<Map<String, Long>>(){}.getType();
                    String json = this.contextService.getString("monitor.last.check.times");
                    Map<String, Long> clusteredCheckTimesByType = new HashMap();
                    if (json != null && json.length() > 0) {
                        clusteredCheckTimesByType = (Map)gson.fromJson(json, mapType);
                    }
                    for (Monitor monitor : activeMonitors) {
                        long lastCheckTime;
                        ga monitorType = (ga)monitorTypes.get(monitor.getType());
                        if (monitorType == null || !monitorType.a()) continue;
                        boolean processedInsight = false;
                        if (monitorType instanceof fZ) {
                            processedInsight = this.processInsight(monitor.getMonitorId(), (fZ)monitorType, unresolved, resolved);
                        }
                        if (processedInsight) continue;
                        Long lastCheckTimeLong = (Long)clusteredCheckTimesByType.get(monitor.getMonitorId());
                        long l3 = lastCheckTime = lastCheckTimeLong != null ? lastCheckTimeLong : 0L;
                        if (lastCheckTime != 0L && (System.currentTimeMillis() - lastCheckTime) / 1000L < (long)monitor.getRunPeriod()) continue;
                        clusteredCheckTimesByType.put(monitor.getMonitorId(), System.currentTimeMillis());
                        this.updateMonitor(monitor, monitorType, identity, unresolved, lastCheckTime);
                    }
                    json = gson.toJson(clusteredCheckTimesByType, mapType);
                    this.contextService.save("monitor.last.check.times", json);
                    int minSeverityLevel = Integer.MAX_VALUE;
                    List<Notification> notifications = this.getActiveNotificationsForNode(identity.getNodeGroupId(), identity.getExternalId());
                    if (notifications.size() > 0) {
                        for (Notification notification : notifications) {
                            if (notification.getSeverityLevel() >= minSeverityLevel) continue;
                            minSeverityLevel = notification.getSeverityLevel();
                        }
                        Map notificationTypes = this.extensionService.getExtensionPointMap(com.jumpmind.symmetric.notification.a.class);
                        List<MonitorEvent> allMonitorEvents = this.getMonitorEventsForNotification(minSeverityLevel);
                        for (Notification notification : notifications) {
                            ArrayList<MonitorEvent> monitorEvents = new ArrayList<MonitorEvent>();
                            List<String> filteredMonitorIds = notification.getExpression().getMonitorIds();
                            for (MonitorEvent monitorEvent : allMonitorEvents) {
                                if (monitorEvent.getSeverityLevel() < notification.getSeverityLevel() || !filteredMonitorIds.isEmpty() && !filteredMonitorIds.contains(monitorEvent.getMonitorId())) continue;
                                monitorEvents.add(monitorEvent);
                            }
                            if (monitorEvents.size() <= 0) continue;
                            com.jumpmind.symmetric.notification.a notificationType = (com.jumpmind.symmetric.notification.a)notificationTypes.get(notification.getType());
                            if (notificationType != null) {
                                notificationType.a(notification, monitorEvents);
                                this.updateMonitorEventAsNotified(monitorEvents);
                                continue;
                            }
                            this.log.warn("Could not find notification of type '" + notification.getType() + "'");
                        }
                    }
                }
                finally {
                    this.clusterService.unlock("Monitor");
                }
            }
        }
    }

    protected void updateMonitor(Monitor monitor, ga monitorType, Node identity, Map<String, MonitorEvent> unresolved, long lastCheckedTime) {
        MonitorEvent eventValue = monitorType.a(monitor);
        boolean readyToCompare = true;
        if (!monitorType.a() && monitor.getRunCount() > 0) {
            List<Long> averages = this.averagesByType.get(monitor.getType());
            if (averages == null) {
                averages = new ArrayList<Long>();
                this.averagesByType.put(monitor.getType(), averages);
            }
            averages.add(eventValue.getValue());
            while (averages.size() > monitor.getRunCount()) {
                averages.remove(0);
            }
            if (averages.size() == monitor.getRunCount()) {
                long accumValue = 0L;
                for (Long oneValue : averages) {
                    accumValue += oneValue.longValue();
                }
                eventValue.setValue(accumValue / (long)monitor.getRunCount());
            } else {
                readyToCompare = false;
            }
        }
        if (readyToCompare) {
            boolean checkAboveThreshold;
            MonitorEvent event = unresolved.get(monitor.getMonitorId());
            Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
            boolean bl2 = checkAboveThreshold = !monitor.getType().equals("maxDataToRoute");
            if (event != null && !event.isResolved() && (checkAboveThreshold && eventValue.getValue() < monitor.getThreshold() || !checkAboveThreshold && eventValue.getValue() > monitor.getThreshold())) {
                event.setLastUpdateTime(now);
                this.updateMonitorEventAsResolved(event);
            } else if ((checkAboveThreshold && eventValue.getValue() >= monitor.getThreshold() || !checkAboveThreshold && eventValue.getValue() <= monitor.getThreshold()) && (eventValue.getEventTime() == null || eventValue.getEventTime() != null && eventValue.getEventTime().getTime() > lastCheckedTime)) {
                if (event == null || event.isResolved()) {
                    if (monitor.getType().equals("log") && this.isLogMonitorEventResolved(monitor, eventValue, identity.getNodeId())) {
                        return;
                    }
                    event = new MonitorEvent();
                    event.setMonitorId(monitor.getMonitorId());
                    event.setNodeId(identity.getNodeId());
                    event.setEventTime(now);
                    event.setHostName(this.hostName);
                    event.setType(monitor.getType());
                    event.setValue(eventValue.getValue());
                    if (eventValue.getCount() == 0) {
                        event.setCount(1);
                    } else {
                        event.setCount(eventValue.getCount());
                    }
                    event.setThreshold(monitor.getThreshold());
                    event.setSeverityLevel(monitor.getSeverityLevel());
                    event.setLastUpdateTime(now);
                    event.setDetails(eventValue.getDetails());
                    event.setInsight(monitor.isInsight());
                } else {
                    event.setHostName(this.hostName);
                    event.setType(monitor.getType());
                    if (monitor.getType().equals("batchError") && monitor.getExpression() != null && monitor.getExpression().equals("notifyOnIncrease=true") && eventValue.getValue() > event.getValue()) {
                        event.setNotified(false);
                    }
                    event.setValue(eventValue.getValue());
                    if (eventValue.getCount() == 0) {
                        event.setCount(event.getCount() + 1);
                    } else {
                        event.setCount(eventValue.getCount());
                    }
                    event.setThreshold(monitor.getThreshold());
                    event.setSeverityLevel(monitor.getSeverityLevel());
                    event.setLastUpdateTime(now);
                    event.setDetails(eventValue.getDetails());
                    event.setInsight(monitor.isInsight());
                }
                this.saveMonitorEvent(event);
            }
        }
    }

    private boolean isLogMonitorEventResolved(Monitor monitor, MonitorEvent eventValue, String nodeId) {
        Gson gson = as.getMonitorEventGson();
        List eventLogSummaries = (List)gson.fromJson(eventValue.getDetails(), new TypeToken<List<LogSummary>>(){}.getType());
        if (eventLogSummaries == null) {
            return false;
        }
        List<MonitorEvent> resolvedEvents = this.getMonitorEventsResolvedForNode(nodeId).get(monitor.getMonitorId());
        for (LogSummary eventLogSummary : eventLogSummaries) {
            boolean logMessageResolved = false;
            if (resolvedEvents != null) {
                for (MonitorEvent resolvedEvent : resolvedEvents) {
                    if (resolvedEvent.getLastUpdateTime() == null || eventLogSummary.getMostRecentTime() > resolvedEvent.getLastUpdateTime().getTime()) continue;
                    List resolvedLogSummaries = (List)gson.fromJson(resolvedEvent.getDetails(), new TypeToken<List<LogSummary>>(){}.getType());
                    for (LogSummary resolvedLogSummary : resolvedLogSummaries) {
                        if (eventLogSummary.getMessage() == null || !eventLogSummary.getMessage().equals(resolvedLogSummary.getMessage())) continue;
                        logMessageResolved = true;
                        break;
                    }
                    if (!logMessageResolved) continue;
                    break;
                }
            }
            if (logMessageResolved) continue;
            return false;
        }
        return true;
    }

    private boolean processInsight(String insightId, fZ insightType, Map<String, MonitorEvent> unresolved, Map<String, List<MonitorEvent>> resolved) {
        List<MonitorEvent> resolvedList;
        boolean processed = false;
        MonitorEvent event = unresolved.get(insightId);
        if (event != null && event.getApprovedOption() > 0 && !event.isApprovalProcessed()) {
            this.processApproval(insightType, event);
            unresolved.remove(insightId);
            processed = true;
        }
        if ((resolvedList = resolved.get(insightId)) != null) {
            for (MonitorEvent resolvedEvent : resolvedList) {
                if (resolvedEvent.getApprovedOption() <= 0 || resolvedEvent.isApprovalProcessed()) continue;
                this.processApproval(insightType, resolvedEvent);
            }
        }
        return processed;
    }

    private void processApproval(final fZ insightType, final MonitorEvent event) {
        event.setApprovalProcessed(true);
        this.saveMonitorEvent(event);
        event.setLastUpdateTime(new Date(System.currentTimeMillis() / 1000L * 1000L));
        this.updateMonitorEventAsResolved(event);
        this.backgroundNoHangupService.queueWork((G<? extends Object>)new G<Void>(){

            @Override
            public Void onBackgroundDataRefresh(ISymmetricEngine engine) {
                if (!insightType.a(event, MonitorService.this.deserializeRecommendation(event))) {
                    List<MonitorEvent> eventList = MonitorService.this.getMonitorEventsByMonitorId(event.getMonitorId());
                    for (MonitorEvent existingEvent : eventList) {
                        if (!existingEvent.getNodeId().equals(event.getNodeId()) || !existingEvent.getEventTime().equals(event.getEventTime())) continue;
                        existingEvent.setApprovalProcessed(false);
                        MonitorService.this.saveMonitorEvent(existingEvent);
                        existingEvent.setLastUpdateTime(new Date(System.currentTimeMillis() / 1000L * 1000L));
                        MonitorService.this.updateMonitorEventAsUnresolved(existingEvent);
                        break;
                    }
                }
                return null;
            }

            @Override
            public void onBackgroundUIRefresh(Void backgroundData) {
            }

            @Override
            public void onUIError(Throwable ex2) {
            }
        }, null);
    }

    @Override
    public List<Monitor> getMonitors() {
        return this.sqlTemplate.query(this.getSql(new String[]{"selectMonitorSql"}), (ISqlRowMapper)new MonitorRowMapper(), new Object[0]);
    }

    @Override
    public List<Monitor> getActiveMonitorsForNode(String nodeGroupId, String externalId) {
        return this.getProCacheManager().getActiveMonitorsForNode(nodeGroupId, externalId);
    }

    @Override
    public List<Monitor> getActiveMonitorsForNodeFromDb(String nodeGroupId, String externalId) {
        return this.sqlTemplate.query(this.getSql(new String[]{"selectMonitorSql", "whereMonitorByNodeSql"}), (ISqlRowMapper)new MonitorRowMapper(), new Object[]{nodeGroupId, externalId});
    }

    @Override
    public List<Monitor> getActiveMonitorsUnresolvedForNode(String nodeGroupId, String externalId) {
        return this.getProCacheManager().getActiveMonitorsUnresolvedForNode(nodeGroupId, externalId);
    }

    @Override
    public List<Monitor> getActiveMonitorsUnresolvedForNodeFromDb(String nodeGroupId, String externalId) {
        return this.sqlTemplate.query(this.getSql(new String[]{"selectMonitorWhereNotResolved"}), (ISqlRowMapper)new MonitorRowMapper(), new Object[]{nodeGroupId, externalId});
    }

    @Override
    public void deleteMonitor(String monitorId) {
        this.sqlTemplate.update(this.getSql(new String[]{"deleteMonitorSql"}), new Object[]{monitorId});
    }

    @Override
    public void saveMonitor(Monitor monitor) {
        this.saveMonitor(monitor, false);
    }

    @Override
    public void saveMonitor(Monitor monitor, boolean insertOnly) {
        int count = insertOnly ? this.sqlTemplate.queryForInt(this.getSql(new String[]{"selectMonitorIdCountSql"}), new Object[]{monitor.getMonitorId()}) : this.sqlTemplate.update(this.getSql(new String[]{"updateMonitorSql"}), new Object[]{monitor.getExternalId(), monitor.getNodeGroupId(), monitor.getType(), monitor.getExpression(), monitor.isEnabled() ? 1 : 0, monitor.getThreshold(), monitor.getRunPeriod(), monitor.getRunCount(), monitor.getSeverityLevel(), monitor.getDisplayOrder(), monitor.isInsight() ? 1 : 0, monitor.isPinned() ? 1 : 0, monitor.getLastUpdateBy(), monitor.getLastUpdateTime(), monitor.getMonitorId()});
        if (count == 0) {
            this.sqlTemplate.update(this.getSql(new String[]{"insertMonitorSql"}), new Object[]{monitor.getMonitorId(), monitor.getExternalId(), monitor.getNodeGroupId(), monitor.getType(), monitor.getExpression(), monitor.isEnabled() ? 1 : 0, monitor.getThreshold(), monitor.getRunPeriod(), monitor.getRunCount(), monitor.getSeverityLevel(), monitor.getDisplayOrder(), monitor.isInsight() ? 1 : 0, monitor.isPinned() ? 1 : 0, monitor.getCreateTime(), monitor.getLastUpdateBy(), monitor.getLastUpdateTime()});
        }
    }

    @Override
    public void saveMonitorAsCopy(Monitor monitor) {
        String newId = monitor.getMonitorId();
        List monitors = this.sqlTemplate.query(this.getSql(new String[]{"selectMonitorSql", "whereMonitorIdLikeSql"}), (ISqlRowMapper)new MonitorRowMapper(), new Object[]{newId + "%"});
        List ids = monitors.stream().map(Monitor::getMonitorId).collect(Collectors.toList());
        Object suffix = "";
        int i2 = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i2;
            ++i2;
        }
        monitor.setMonitorId(newId + (String)suffix);
        this.saveMonitor(monitor);
    }

    @Override
    public void renameMonitor(String oldId, Monitor monitor) {
        this.deleteMonitor(oldId);
        this.saveMonitor(monitor);
    }

    @Override
    public List<MonitorEvent> getMonitorEvents() {
        return this.sqlTemplateDirty.query(this.getSql(new String[]{"selectMonitorEventSql"}), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[0]);
    }

    protected Map<String, List<MonitorEvent>> getMonitorEventsResolvedForNode(String nodeId) {
        List list = this.sqlTemplateDirty.query(this.getSql(new String[]{"selectMonitorEventSql", "whereMonitorEventResolvedSql"}), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{nodeId});
        HashMap<String, List<MonitorEvent>> map = new HashMap<String, List<MonitorEvent>>();
        for (MonitorEvent monitorEvent : list) {
            String monitorId = monitorEvent.getMonitorId();
            ArrayList<MonitorEvent> listByMonitorId = (ArrayList<MonitorEvent>)map.get(monitorId);
            if (listByMonitorId == null) {
                listByMonitorId = new ArrayList<MonitorEvent>();
            }
            listByMonitorId.add(monitorEvent);
            map.put(monitorId, listByMonitorId);
        }
        return map;
    }

    protected Map<String, MonitorEvent> getMonitorEventsNotResolvedForNode(String nodeId) {
        List list = this.sqlTemplateDirty.query(this.getSql(new String[]{"selectMonitorEventSql", "whereMonitorEventNotResolvedSql"}), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{nodeId});
        HashMap<String, MonitorEvent> map = new HashMap<String, MonitorEvent>();
        for (MonitorEvent monitorEvent : list) {
            map.put(monitorEvent.getMonitorId(), monitorEvent);
        }
        return map;
    }

    @Override
    public List<MonitorEvent> getMonitorEventsFiltered(int limit, String type, int severityLevel, String nodeId, Boolean isResolved) {
        Object sql = this.getSql(new String[]{"selectMonitorEventSql", "whereMonitorEventFilteredSql"});
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(severityLevel);
        if (isResolved != null) {
            sql = (String)sql + " and is_resolved = ?";
            args.add(isResolved != false ? 1 : 0);
        }
        if (type != null) {
            sql = (String)sql + " and " + this.typeColumnName + " = ?";
            args.add(type);
        }
        if (nodeId != null) {
            sql = (String)sql + " and node_id = ?";
            args.add(nodeId);
        }
        sql = (String)sql + " order by event_time desc";
        return this.sqlTemplateDirty.query((String)sql, limit, (ISqlRowMapper)new MonitorEventRowMapper(), args.toArray());
    }

    @Override
    public List<MonitorEvent> getMonitorEventsByMonitorId(String monitorId) {
        Object sql = this.getSql(new String[]{"selectMonitorEventSql", "whereMonitorEventIdSql"});
        sql = (String)sql + " order by event_time desc";
        return this.sqlTemplateDirty.query((String)sql, (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{monitorId});
    }

    protected List<MonitorEvent> getMonitorEventsForNotification(int severityLevel) {
        return this.sqlTemplateDirty.query(this.getSql(new String[]{"selectMonitorEventSql", "whereMonitorEventForNotificationBySeveritySql"}), (ISqlRowMapper)new MonitorEventRowMapper(), new Object[]{severityLevel});
    }

    @Override
    public void saveMonitorEvent(MonitorEvent event) {
        if (!this.updateMonitorEvent(event)) {
            this.insertMonitorEvent(event);
        }
    }

    protected void insertMonitorEvent(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql(new String[]{"insertMonitorEventSql"}), new Object[]{event.getMonitorId(), event.getNodeId(), event.getEventTime(), event.getHostName(), event.getType(), event.getValue(), event.getCount(), event.getThreshold(), event.getSeverityLevel(), event.isResolved() ? 1 : 0, event.isNotified() ? 1 : 0, event.isInsight() ? 1 : 0, event.getNotBefore(), event.getApprovedOption(), event.getApprovedBy(), event.isApprovalProcessed() ? 1 : 0, event.getDetails(), event.getLastUpdateTime()});
    }

    protected boolean updateMonitorEvent(MonitorEvent event) {
        int count = this.sqlTemplate.update(this.getSql(new String[]{"updateMonitorEventSql"}), new Object[]{event.getHostName(), event.getType(), event.getValue(), event.getCount(), event.getThreshold(), event.getSeverityLevel(), event.isNotified() ? 1 : 0, event.isInsight() ? 1 : 0, event.getNotBefore(), event.getApprovedOption(), event.getApprovedBy(), event.isApprovalProcessed() ? 1 : 0, event.getLastUpdateTime(), event.getDetails(), event.getMonitorId(), event.getNodeId(), event.getEventTime()});
        return count != 0;
    }

    @Override
    public void deleteMonitorEvent(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql(new String[]{"deleteMonitorEventSql"}), new Object[]{event.getMonitorId(), event.getNodeId(), event.getEventTime()});
    }

    protected void updateMonitorEventAsNotified(List<MonitorEvent> events) {
        for (MonitorEvent event : events) {
            this.updateMonitorEventAsNotified(event);
        }
    }

    protected void updateMonitorEventAsNotified(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql(new String[]{"updateMonitorEventNotifiedSql"}), new Object[]{event.getMonitorId(), event.getNodeId(), event.getEventTime()});
    }

    @Override
    public void updateMonitorEventAsResolved(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql(new String[]{"updateMonitorEventResolvedSql"}), new Object[]{event.getLastUpdateTime(), event.getMonitorId(), event.getNodeId(), event.getEventTime()});
    }

    public void updateMonitorEventAsUnresolved(MonitorEvent event) {
        this.sqlTemplate.update(this.getSql(new String[]{"updateMonitorEventUnresolvedSql"}), new Object[]{event.getLastUpdateTime(), event.getMonitorId(), event.getNodeId(), event.getEventTime()});
    }

    @Override
    public gS getRecommendations(boolean dismissed) {
        Date now = new Date();
        List<Monitor> monitorList = this.getMonitors();
        Map monitorTypes = this.extensionService.getExtensionPointMap(ga.class);
        gS recommendations = new gS();
        block0: for (MonitorEvent event : this.getMonitorEvents()) {
            ga monitorType;
            Date notBefore = event.getNotBefore();
            if (event.isResolved() || (!dismissed || notBefore == null || !notBefore.after(now)) && (dismissed || notBefore != null && notBefore.after(now)) || !((monitorType = (ga)monitorTypes.get(event.getType())) instanceof fZ)) continue;
            for (Monitor monitor : monitorList) {
                if (!monitor.getMonitorId().equals(event.getMonitorId())) continue;
                if (!monitor.isInsight()) continue block0;
                recommendations.a(this.deserializeRecommendation(event));
                continue block0;
            }
        }
        return recommendations;
    }

    private gR deserializeRecommendation(MonitorEvent event) {
        try {
            Gson gson = as.getMonitorEventGson();
            gR recommendation = (gR)gson.fromJson(event.getDetails(), gR.class);
            recommendation.d(event.getMonitorId());
            recommendation.e(event.getType());
            recommendation.a(event.getNodeId(), event.getEventTime());
            recommendation.c(event.getSeverityLevel());
            return recommendation;
        }
        catch (Exception ex2) {
            this.log.error("Failed to convert monitor event details from JSON to recommendation", (Throwable)ex2);
            return null;
        }
    }

    @Override
    public Map<String, Object> getRecommendationDetails(String monitorId, String nodeId, Date eventTime) {
        for (MonitorEvent event : this.getMonitorEventsByMonitorId(monitorId)) {
            gR recommendation;
            if (!event.getNodeId().equals(nodeId) || !event.getEventTime().equals(eventTime) || (recommendation = this.deserializeRecommendation(event)) == null) continue;
            return recommendation.c();
        }
        return null;
    }

    @Override
    public void approveRecommendation(String monitorId, String nodeId, Date eventTime, int optionId, String userId) {
        for (MonitorEvent event : this.getMonitorEventsByMonitorId(monitorId)) {
            if (!event.getNodeId().equals(nodeId) || !event.getEventTime().equals(eventTime)) continue;
            event.setApprovedOption(optionId);
            event.setApprovedBy(userId);
            event.setApprovalProcessed(false);
            event.setLastUpdateTime(new Date(System.currentTimeMillis() / 1000L * 1000L));
            this.saveMonitorEvent(event);
            return;
        }
    }

    @Override
    public void dismissRecommendation(String monitorId, String nodeId, Date eventTime, long duration) {
        for (MonitorEvent event : this.getMonitorEventsByMonitorId(monitorId)) {
            if (!event.getNodeId().equals(nodeId) || !event.getEventTime().equals(eventTime)) continue;
            long currentTimeMillis = System.currentTimeMillis() / 1000L * 1000L;
            if (duration > 0L) {
                event.setNotBefore(new Date(currentTimeMillis + duration));
            } else {
                event.setNotBefore(new Date(2147483647000L));
            }
            event.setLastUpdateTime(new Date(currentTimeMillis));
            this.saveMonitorEvent(event);
            return;
        }
    }

    @Override
    public void undoDismissalForRecommendation(String monitorId, String nodeId, Date eventTime) {
        for (MonitorEvent event : this.getMonitorEventsByMonitorId(monitorId)) {
            if (!event.getNodeId().equals(nodeId) || !event.getEventTime().equals(eventTime)) continue;
            event.setNotBefore(null);
            event.setLastUpdateTime(new Date(System.currentTimeMillis() / 1000L * 1000L));
            this.saveMonitorEvent(event);
            return;
        }
    }

    @Override
    public Date getLastApprovalTime(String monitorId, String insightName) {
        Date lastApprovalTime = new Date(0L);
        List<MonitorEvent> resolvedEventList = this.getMonitorEventsFiltered(Integer.MAX_VALUE, insightName, 0, this.nodeService.findIdentityNodeId(), true);
        for (MonitorEvent resolvedEvent : resolvedEventList) {
            Date lastUpdateTime = resolvedEvent.getLastUpdateTime();
            if (!resolvedEvent.getMonitorId().equals(monitorId) || resolvedEvent.getApprovedOption() <= 0 || !lastApprovalTime.before(lastUpdateTime)) continue;
            lastApprovalTime = lastUpdateTime;
        }
        return lastApprovalTime;
    }

    @Override
    public List<Notification> getNotifications() {
        return this.sqlTemplate.query(this.getSql(new String[]{"selectNotificationSql"}), (ISqlRowMapper)new NotificationRowMapper(), new Object[0]);
    }

    @Override
    public List<Notification> getActiveNotificationsForNode(String nodeGroupId, String externalId) {
        return this.getProCacheManager().getActiveNotificationsForNode(nodeGroupId, externalId);
    }

    @Override
    public List<Notification> getActiveNotificationsForNodeFromDb(String nodeGroupId, String externalId) {
        return this.sqlTemplate.query(this.getSql(new String[]{"selectNotificationSql", "whereNotificationByNodeSql"}), (ISqlRowMapper)new NotificationRowMapper(), new Object[]{nodeGroupId, externalId});
    }

    @Override
    public void saveNotification(Notification notification) {
        int count = this.sqlTemplate.update(this.getSql(new String[]{"updateNotificationSql"}), new Object[]{notification.getNodeGroupId(), notification.getExternalId(), notification.getSeverityLevel(), notification.getType(), notification.getExpressionString(), notification.isEnabled() ? 1 : 0, notification.getCreateTime(), notification.getLastUpdateBy(), notification.getLastUpdateTime(), notification.getNotificationId()});
        if (count == 0) {
            this.sqlTemplate.update(this.getSql(new String[]{"insertNotificationSql"}), new Object[]{notification.getNotificationId(), notification.getNodeGroupId(), notification.getExternalId(), notification.getSeverityLevel(), notification.getType(), notification.getExpressionString(), notification.isEnabled() ? 1 : 0, notification.getCreateTime(), notification.getLastUpdateBy(), notification.getLastUpdateTime()});
        }
    }

    @Override
    public void saveNotificationAsCopy(Notification notification) {
        String newId = notification.getNotificationId();
        List notifications = this.sqlTemplate.query(this.getSql(new String[]{"selectNotificationSql", "whereNotificationIdLikeSql"}), (ISqlRowMapper)new NotificationRowMapper(), new Object[]{newId + "%"});
        List ids = notifications.stream().map(Notification::getNotificationId).collect(Collectors.toList());
        Object suffix = "";
        int i2 = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i2;
            ++i2;
        }
        notification.setNotificationId(newId + (String)suffix);
        this.saveNotification(notification);
    }

    @Override
    public void renameNotification(String oldId, Notification notification) {
        this.deleteNotification(oldId);
        this.saveNotification(notification);
    }

    @Override
    public void deleteNotification(String notificationId) {
        this.sqlTemplate.update(this.getSql(new String[]{"deleteNotificationSql"}), new Object[]{notificationId});
    }

    @Override
    public void flushMonitorCache() {
        this.getProCacheManager().flushMonitorCache();
    }

    @Override
    public void flushNotificationCache() {
        this.getProCacheManager().flushNotificationCache();
    }

    public void flushCache() {
        this.flushMonitorCache();
        this.flushNotificationCache();
    }

    private a getProCacheManager() {
        if (this.proCacheManager == null) {
            this.proCacheManager = (a)this.extensionService.getExtensionPoint(a.class);
        }
        return this.proCacheManager;
    }

    static class MonitorRowMapper
    implements ISqlRowMapper<Monitor> {
        MonitorRowMapper() {
        }

        public Monitor mapRow(Row row) {
            Monitor m2 = new Monitor();
            m2.setMonitorId(row.getString("monitor_id"));
            m2.setExternalId(row.getString("external_id"));
            m2.setNodeGroupId(row.getString("node_group_id"));
            m2.setType(row.getString("type"));
            m2.setExpression(row.getString("expression"));
            m2.setEnabled(row.getBoolean("enabled"));
            m2.setThreshold(row.getLong("threshold"));
            m2.setRunPeriod(row.getInt("run_period"));
            m2.setRunCount(row.getInt("run_count"));
            m2.setSeverityLevel(row.getInt("severity_level"));
            m2.setDisplayOrder(row.getInt("display_order"));
            m2.setInsight(row.getBoolean("is_insight"));
            m2.setPinned(row.getBoolean("is_pinned"));
            m2.setCreateTime(row.getDateTime("create_time"));
            m2.setLastUpdateBy(row.getString("last_update_by"));
            m2.setLastUpdateTime(row.getDateTime("last_update_time"));
            return m2;
        }
    }

    public static class MonitorEventRowMapper
    implements ISqlRowMapper<MonitorEvent> {
        public MonitorEvent mapRow(Row row) {
            MonitorEvent m2 = new MonitorEvent();
            m2.setMonitorId(row.getString("monitor_id"));
            m2.setNodeId(row.getString("node_id"));
            m2.setEventTime(row.getDateTime("event_time"));
            m2.setHostName(row.getString("host_name"));
            m2.setType(row.getString("type"));
            m2.setThreshold(row.getLong("threshold"));
            m2.setValue(row.getLong("event_value"));
            m2.setCount(row.getInt("event_count"));
            m2.setSeverityLevel(row.getInt("severity_level"));
            m2.setResolved(row.getBoolean("is_resolved"));
            m2.setNotified(row.getBoolean("is_notified"));
            m2.setInsight(row.getBoolean("is_insight"));
            m2.setNotBefore(row.getDateTime("not_before"));
            m2.setApprovedOption(row.getInt("approved_option"));
            m2.setApprovedBy(row.getString("approved_by"));
            m2.setApprovalProcessed(row.getBoolean("is_approval_processed"));
            m2.setLastUpdateTime(row.getDateTime("last_update_time"));
            m2.setDetails(row.getString("details"));
            return m2;
        }
    }

    static class NotificationRowMapper
    implements ISqlRowMapper<Notification> {
        NotificationRowMapper() {
        }

        public Notification mapRow(Row row) {
            Notification n2 = new Notification();
            n2.setNotificationId(row.getString("notification_id"));
            n2.setNodeGroupId(row.getString("node_group_id"));
            n2.setExternalId(row.getString("external_id"));
            n2.setSeverityLevel(row.getInt("severity_level"));
            n2.setType(row.getString("type"));
            n2.setExpression(row.getString("expression"));
            n2.setEnabled(row.getBoolean("enabled"));
            n2.setCreateTime(row.getDateTime("create_time"));
            n2.setLastUpdateBy(row.getString("last_update_by"));
            n2.setLastUpdateTime(row.getDateTime("last_update_time"));
            return n2;
        }
    }
}

