/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.impl.F;
import com.jumpmind.symmetric.console.impl.I;
import com.jumpmind.symmetric.console.model.ConsolePrivilege;
import com.jumpmind.symmetric.console.model.ConsoleRole;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.model.ConsoleUserHist;
import com.jumpmind.symmetric.console.model.ValidationResult;
import com.jumpmind.symmetric.console.service.IConsoleUserAuthentication;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.service.impl.ConsoleUserServiceHelper;
import com.jumpmind.symmetric.console.service.impl.ConsoleUserServiceSqlMap;
import com.jumpmind.symmetric.console.service.impl.UserAuthenticationInternal;
import com.jumpmind.symmetric.console.service.impl.UserAuthenticationLDAP;
import com.jumpmind.symmetric.console.service.impl.UserAuthenticationOAUTH2;
import com.jumpmind.symmetric.console.service.impl.UserAuthenticationSAML;
import com.jumpmind.symmetric.db.a;
import com.vaadin.flow.server.VaadinSession;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.properties.DefaultParameterParser;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleUserService
implements IConsoleUserService,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISymmetricEngine engine;
    protected ISqlTemplate sqlTemplate;
    private ISqlMap sql;
    private int logErrorsCountdown = 10;

    @Override
    public ConsoleUser findConsoleUser(String userId) {
        ConsoleUser user = null;
        try {
            user = (ConsoleUser)this.engine.getSqlTemplate().queryForObject(this.getSql("findConsoleUserSqlPrefix", "findConsoleUserSqlWhere"), (ISqlRowMapper)new ConsoleUserRowMapper(), new Object[]{userId});
            if (user != null) {
                List<ConsolePrivilege> privileges = this.findConsolePrivileges(user.getRole());
                user.setPrivileges(this.findConsolePrivilegesForServer(user.getRole(), privileges));
            }
        }
        catch (Exception ex2) {
            if (this.logErrorsCountdown > 0) {
                this.log.debug("Failed to lookup the console user", (Throwable)ex2);
                --this.logErrorsCountdown;
            }
            this.log.error("Failed to lookup the console user", (Throwable)ex2);
        }
        return user;
    }

    @Override
    public ConsoleRole findConsoleRole(String roleId) {
        try {
            return (ConsoleRole)this.engine.getSqlTemplate().queryForObject(this.getSql("findConsoleRoleSqlPrefix", "findConsoleRoleSqlWhere"), (ISqlRowMapper)new ConsoleRoleRowMapper(), new Object[]{roleId});
        }
        catch (Exception ex2) {
            if (this.logErrorsCountdown > 0) {
                this.log.debug("Failed to lookup the console role", (Throwable)ex2);
                --this.logErrorsCountdown;
            } else {
                this.log.error("Failed to lookup the console role", (Throwable)ex2);
            }
            return null;
        }
    }

    @Override
    public List<ConsoleUser> findConsoleUsers() {
        try {
            return this.engine.getSqlTemplate().query(this.getSql("findConsoleUserSqlPrefix"), (ISqlRowMapper)new ConsoleUserRowMapper(), new Object[0]);
        }
        catch (Exception ex2) {
            if (this.logErrorsCountdown > 0) {
                this.log.debug("Failed to lookup the console users", (Throwable)ex2);
                --this.logErrorsCountdown;
            } else {
                this.log.error("Failed to lookup the console users", (Throwable)ex2);
            }
            return null;
        }
    }

    @Override
    public List<ConsoleRole> findConsoleRoles() {
        try {
            return this.engine.getSqlTemplate().query(this.getSql("findConsoleRoleSqlPrefix"), (ISqlRowMapper)new ConsoleRoleRowMapper(), new Object[0]);
        }
        catch (Exception ex2) {
            if (this.logErrorsCountdown > 0) {
                this.log.debug("Failed to lookup the console roles", (Throwable)ex2);
                --this.logErrorsCountdown;
            } else {
                this.log.error("Failed to lookup the console roles", (Throwable)ex2);
            }
            return null;
        }
    }

    @Override
    public List<ConsolePrivilege> findConsolePrivileges(String roleId) {
        try {
            if (roleId.equalsIgnoreCase("ADMIN")) {
                return I.f();
            }
            if (roleId.equalsIgnoreCase("WRITE")) {
                return I.g();
            }
            if (roleId.equalsIgnoreCase("READ")) {
                return I.h();
            }
            return this.engine.getSqlTemplate().query(this.getSql("findConsolePrivilegeSqlPrefix", "findConsolePrivilegeSqlWhere"), (ISqlRowMapper)new ConsolePrivilegeRowMapper(), new Object[]{roleId});
        }
        catch (Exception ex2) {
            if (this.logErrorsCountdown > 0) {
                this.log.debug("Failed to lookup the console user hist table", (Throwable)ex2);
                --this.logErrorsCountdown;
            } else {
                this.log.error("Failed to lookup the console user hist table", (Throwable)ex2);
            }
            return null;
        }
    }

    @Override
    public Map<String, ConsolePrivilege> findConsolePrivilegesForServer(String roleId, List<ConsolePrivilege> privileges) {
        IParameterService parameterService = this.engine.getParameterService();
        boolean clientConfig = parameterService.is("console.auth.config.client", false);
        boolean isOnRegServer = parameterService.isRegistrationServer();
        for (ISymmetricEngine engine : AbstractSymmetricEngine.findEngines()) {
            if (!engine.getParameterService().isRegistrationServer()) continue;
            isOnRegServer = true;
        }
        boolean override = !isOnRegServer && !clientConfig;
        HashMap<String, ConsolePrivilege> privMap = new HashMap<String, ConsolePrivilege>();
        for (ConsolePrivilege priv : privileges) {
            if (override && priv.isWriteFlag()) {
                if (I.e().contains(priv.getPrivilegeId())) {
                    if (roleId.equalsIgnoreCase("ADMIN")) {
                        priv.setWriteFlag(true);
                        priv.setReadFlag(false);
                    } else if (roleId.equalsIgnoreCase("WRITE")) {
                        if (I.b().contains(priv.getPrivilegeId())) {
                            priv.setWriteFlag(false);
                            priv.setReadFlag(true);
                        } else {
                            priv.setWriteFlag(true);
                            priv.setReadFlag(false);
                        }
                    } else {
                        priv.setWriteFlag(false);
                        priv.setReadFlag(true);
                    }
                } else {
                    priv.setWriteFlag(false);
                    priv.setReadFlag(true);
                }
            }
            privMap.put(priv.getPrivilegeId(), priv);
        }
        return privMap;
    }

    public List<ConsoleUserHist> findConsoleUserHist(String userId) {
        try {
            return this.engine.getSqlTemplate().query(this.getSql("findConsoleUserHistSqlPrefix", "findConsoleUserHistSqlWhere"), (ISqlRowMapper)new ConsoleUserHistRowMapper(), new Object[]{userId});
        }
        catch (Exception ex2) {
            if (this.logErrorsCountdown > 0) {
                this.log.debug("Failed to lookup the console user hist table", (Throwable)ex2);
                --this.logErrorsCountdown;
            } else {
                this.log.error("Failed to lookup the console user hist table", (Throwable)ex2);
            }
            return null;
        }
    }

    @Override
    public void delete(ConsoleUser user) {
        this.engine.getSqlTemplate().update(this.getSql("deleteConsoleUserSql"), new Object[]{user.getUserId()});
        this.deleteHist(user);
    }

    protected void deleteHist(ConsoleUser user, int histCutoff) {
        this.engine.getSqlTemplate().update(this.getSql("deleteConsoleUserHistCutoffSql"), new Object[]{user.getUserId(), histCutoff});
    }

    protected void deleteHist(ConsoleUser user) {
        this.engine.getSqlTemplate().update(this.getSql("deleteConsoleUserHistSql"), new Object[]{user.getUserId()});
    }

    @Override
    public void save(ConsoleUser user) {
        user.setLastUpdateTime(new Date());
        user.cleanupClearTextPassword();
        if (0 >= this.engine.getSqlTemplate().update(this.getSql("updateConsoleUserSql"), new Object[]{user.getFirstName(), user.getLastName(), user.getEmail(), user.getHashedPassword(), user.getSalt(), user.getEncryptionMethod(), user.getFailedLoginAttempts(), user.getAuthenticationMethod(), user.getRole(), user.getLastLoginTime(), user.getLastLoginIpAddr(), user.getLastLoginNodeId(), user.getLastUpdateTime(), user.getLastUpdateBy(), user.getLastPasswordTime(), user.getOtpKey(), user.isResetRequired() ? 1 : 0, user.getConfirmCode(), user.getConfirmCreateTime(), user.isGlassBreakRequired() ? 1 : 0, user.getBreakGlassStartTime(), user.getBreakGlassEndTime(), user.getBreakGlassUserId(), user.isEnabled() ? 1 : 0, user.getUserId()})) {
            this.engine.getSqlTemplate().update(this.getSql("insertConsoleUserSql"), new Object[]{user.getFirstName(), user.getLastName(), user.getEmail(), user.getHashedPassword(), user.getSalt(), user.getEncryptionMethod(), user.getFailedLoginAttempts(), user.getUserId(), user.getAuthenticationMethod(), user.getRole(), user.getLastLoginTime(), user.getLastLoginIpAddr(), user.getLastLoginNodeId(), user.getLastUpdateTime(), user.getLastUpdateBy(), user.getCreateTime(), user.getLastPasswordTime(), user.isResetRequired() ? 1 : 0, user.isGlassBreakRequired() ? 1 : 0, user.getBreakGlassStartTime(), user.getBreakGlassEndTime(), user.getBreakGlassUserId(), user.isEnabled() ? 1 : 0});
        }
    }

    @Override
    public void saveAsCopy(ConsoleUser user) {
        String newId = user.getUserId();
        List users = this.engine.getSqlTemplate().query(this.getSql("findConsoleUserSqlPrefix", "findConsoleUserSqlWhereLike"), (ISqlRowMapper)new ConsoleUserRowMapper(), new Object[]{newId + "%"});
        List ids = users.stream().map(ConsoleUser::getUserId).collect(Collectors.toList());
        Object suffix = "";
        int i2 = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i2;
            ++i2;
        }
        user.setUserId(newId + (String)suffix);
        this.save(user);
    }

    @Override
    public void rename(String oldId, ConsoleUser user) {
        ConsoleUser oldUser = new ConsoleUser();
        oldUser.setUserId(oldId);
        this.delete(oldUser);
        this.save(user);
    }

    @Override
    public void login(ConsoleUser user) {
        user.setLastLoginTime(new Date());
        String ip = VaadinSession.getCurrent().getBrowser().getAddress();
        if (ip.startsWith("[") && ip.endsWith("]")) {
            ip = ip.substring(1, ip.length() - 1);
        }
        user.setLastLoginIpAddr(ip);
        user.setLastLoginNodeId(this.engine.getNodeId());
        this.engine.getSqlTemplate().update(this.getSql("loginConsoleUserSql"), new Object[]{user.getLastLoginTime(), user.getLastLoginIpAddr(), user.getLastLoginNodeId(), user.getUserId()});
    }

    protected String getSql(String ... keys) {
        return this.sql.getSql(keys);
    }

    @Override
    public void save(ConsoleRole role) {
        role.setLastUpdateTime(new Date());
        if (0 >= this.engine.getSqlTemplate().update(this.getSql("updateConsoleRoleSql"), new Object[]{role.getRoleDescription(), role.getLastUpdateTime(), role.getLastUpdateBy(), role.getParentRoleId(), role.getRoleId()})) {
            this.engine.getSqlTemplate().update(this.getSql("insertConsoleRoleSql"), new Object[]{role.getRoleId(), role.getRoleDescription(), role.getCreateTime(), role.getLastUpdateBy(), role.getLastUpdateTime(), role.getParentRoleId()});
        }
    }

    @Override
    public void saveAsCopy(String originalId, ConsoleRole role) {
        String newId = role.getRoleId();
        List roles = this.engine.getSqlTemplate().query(this.getSql("findConsoleRoleSqlPrefix", "findConsoleRoleSqlWhereLike"), (ISqlRowMapper)new ConsoleRoleRowMapper(), new Object[]{newId + "%"});
        List ids = roles.stream().map(ConsoleRole::getRoleId).collect(Collectors.toList());
        Object suffix = "";
        int i2 = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i2;
            ++i2;
        }
        role.setRoleId(newId + (String)suffix);
        this.save(role);
        try (ISqlTransaction transaction = null;){
            transaction = this.engine.getSqlTemplate().startSqlTransaction();
            for (ConsolePrivilege privilege : this.findConsolePrivileges(originalId)) {
                transaction.prepareAndExecute(this.getSql("insertConsolePrivilegeSql"), new Object[]{newId + (String)suffix, privilege.getPrivilegeId(), privilege.isReadFlag() ? 1 : 0, privilege.isWriteFlag() ? 1 : 0});
            }
            transaction.commit();
        }
    }

    @Override
    public void rename(String oldId, ConsoleRole role) {
        this.save(role);
        try (ISqlTransaction transaction = null;){
            transaction = this.engine.getSqlTemplate().startSqlTransaction();
            transaction.prepareAndExecute(this.getSql("updateConsoleUserRoleIdSql"), new Object[]{role.getRoleId(), oldId});
            transaction.prepareAndExecute(this.getSql("updateConsolePrivilegeRoleIdSql"), new Object[]{role.getRoleId(), oldId});
            transaction.commit();
        }
        role.setRoleId(oldId);
        this.delete(role);
    }

    @Override
    public void save(List<ConsolePrivilege> privilegeList, String roleId) {
        try (ISqlTransaction transaction = null;){
            transaction = this.engine.getSqlTemplate().startSqlTransaction();
            transaction.prepareAndExecute(this.getSql("deleteConsolePrivilegeSql"), new Object[]{roleId});
            if (privilegeList.size() != 0) {
                for (ConsolePrivilege privilege : privilegeList) {
                    transaction.prepareAndExecute(this.getSql("insertConsolePrivilegeSql"), new Object[]{privilege.getRoleId(), privilege.getPrivilegeId(), privilege.isReadFlag() ? 1 : 0, privilege.isWriteFlag() ? 1 : 0});
                }
            }
            transaction.commit();
        }
    }

    @Override
    public void delete(String privilegeRoleId) {
        this.engine.getSqlTemplate().update(this.getSql("deleteConsolePrivilegeSql"), new Object[]{privilegeRoleId});
    }

    @Override
    public void delete(ConsoleRole role) {
        this.engine.getSqlTemplate().update(this.getSql("deleteConsolePrivilegeSql"), new Object[]{role.getRoleId()});
        this.engine.getSqlTemplate().update(this.getSql("deleteConsoleRoleSql"), new Object[]{role.getRoleId()});
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.sql = new ConsoleUserServiceSqlMap(engine.getSymmetricDialect().getPlatform(), engine.getTablePrefix());
        engine.getExtensionService().addExtensionPoint((IExtensionPoint)new a());
        TypedProperties serverProperties = new TypedProperties(System.getProperties());
        String host = serverProperties.get("host.bind.name", System.getProperty("host.bind.name", null));
        engine.getSecurityService().installDefaultSamlSslCert(host, engine.getParameterService().getInt("console.auth.saml.sp.cert.lifetime.days", 9125));
    }

    @Override
    public void updateUserEncryption(ConsoleUser user) {
        IParameterService parameterService = this.engine.getParameterService();
        parameterService.rereadParameters();
        Map<String, DefaultParameterParser.ParameterMetaData> map = F.a();
        DefaultParameterParser.ParameterMetaData saltParam = map.get("console.password.salt");
        DefaultParameterParser.ParameterMetaData encryptParam = map.get("console.password.encrypt.method");
        TypedProperties params = parameterService.getDatabaseParameters("ALL", "ALL");
        String value = params.get(saltParam.getKey(), saltParam.getDefaultValue());
        boolean useSalt = Boolean.parseBoolean(value);
        String encryptionMethod = params.get(encryptParam.getKey(), encryptParam.getDefaultValue());
        user.updateEncryption(useSalt, encryptionMethod);
    }

    @Override
    public ValidationResult validatePasswordComplexity(ConsoleUser user, String password, String newPassword) {
        int minChangeChars;
        IParameterService parameterService = this.engine.getParameterService();
        boolean symbol = parameterService.is("console.password.require.symbol");
        boolean alphanum = parameterService.is("console.password.require.alphanum");
        boolean mixedCase = parameterService.is("console.password.require.mixed.case");
        int minLength = parameterService.getInt("console.password.min.length");
        boolean prohibitCommon = parameterService.is("console.password.prohibit.common.words");
        ConsoleUserServiceHelper service = new ConsoleUserServiceHelper();
        ValidationResult result = service.validatePasswordComplexity(user, symbol, alphanum, mixedCase, prohibitCommon, minLength);
        if (parameterService.getInt("console.password.prohibit.previous") != 0 && this.isPreviousPassword(user)) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, "Previous passwords are prohibited");
        }
        if ((minChangeChars = parameterService.getInt("console.password.min.change.chars")) > 0 && password != null && !this.minCharsHaveChanged(minChangeChars, password, newPassword)) {
            result = new ValidationResult(ValidationResult.ValidationStatus.INVALID, String.format("A minimum of %s characters must be changed from your old password", minChangeChars));
        }
        return result;
    }

    protected boolean isPreviousPassword(ConsoleUser user) {
        ConsoleUser lastUser = this.findConsoleUser(user.getUserId());
        IParameterService parameterService = this.engine.getParameterService();
        parameterService.rereadParameters();
        TypedProperties params = parameterService.getDatabaseParameters("ALL", "ALL");
        Map<String, DefaultParameterParser.ParameterMetaData> map = F.a();
        DefaultParameterParser.ParameterMetaData histParam = map.get("console.password.prohibit.previous");
        String value = params.get(histParam.getKey(), histParam.getDefaultValue());
        int prohibitPrevious = Integer.parseInt(value);
        boolean result = false;
        if (prohibitPrevious != 0 && lastUser != null) {
            List<ConsoleUserHist> history = this.findConsoleUserHist(user.getUserId());
            ConsoleUserHist lastUserHist = new ConsoleUserHist(lastUser, 0);
            history.add(lastUserHist);
            for (int histIndex = 0; histIndex < history.size() && (histIndex < prohibitPrevious || prohibitPrevious == -1); ++histIndex) {
                ConsoleUserHist userHist = history.get(histIndex);
                String newHashedPassword = ConsoleUser.hashPassword(user.getPassword(), userHist.getEncryptionMethod(), userHist.getSalt());
                if (!userHist.getHashedPassword().equals(newHashedPassword)) continue;
                result = true;
            }
        }
        return result;
    }

    protected boolean minCharsHaveChanged(int minChangeChars, String password, String newPassword) {
        HashSet<Integer> matches = new HashSet<Integer>();
        for (int i2 = 0; i2 < password.length() - 1; ++i2) {
            String searchString = password.substring(i2, i2 + 2);
            for (int j2 = 0; j2 < newPassword.length() - 1; ++j2) {
                if (!searchString.equals(newPassword.substring(j2, j2 + 2))) continue;
                matches.add(j2);
                matches.add(j2 + 1);
            }
        }
        return newPassword.length() - matches.size() >= minChangeChars;
    }

    @Override
    public void updateUserHistory(ConsoleUser user) {
        ConsoleUser lastUser = this.findConsoleUser(user.getUserId());
        IParameterService parameterService = this.engine.getParameterService();
        parameterService.rereadParameters();
        TypedProperties params = parameterService.getDatabaseParameters("ALL", "ALL");
        Map<String, DefaultParameterParser.ParameterMetaData> map = F.a();
        DefaultParameterParser.ParameterMetaData histParam = map.get("console.password.prohibit.previous");
        String value = params.get(histParam.getKey(), histParam.getDefaultValue());
        int prohibitPrevious = Integer.parseInt(value);
        if (prohibitPrevious != 0 && lastUser != null) {
            List<ConsoleUserHist> history = this.findConsoleUserHist(user.getUserId());
            Collections.sort(history, new Comparator<ConsoleUserHist>(){

                @Override
                public int compare(ConsoleUserHist user1, ConsoleUserHist user2) {
                    return user2.getHistId() - user1.getHistId();
                }
            });
            int nextHistId = 0;
            if (history.size() > 0) {
                nextHistId = history.get(0).getHistId() + 1;
            }
            ConsoleUserHist lastUserHist = new ConsoleUserHist(lastUser, nextHistId);
            history.add(0, lastUserHist);
            this.engine.getSqlTemplate().update(this.getSql("insertConsoleUserHistSql"), new Object[]{lastUserHist.getHistId(), lastUserHist.getHashedPassword(), lastUserHist.getSalt(), lastUserHist.getEncryptionMethod(), lastUserHist.getUserId(), lastUserHist.getAuthenticationMethod()});
            if (prohibitPrevious != -1 && history.size() >= prohibitPrevious) {
                int histCutoff = history.get(prohibitPrevious - 1).getHistId();
                this.deleteHist(user, histCutoff);
            }
        }
    }

    @Override
    public boolean isUserPasswordExpired(ConsoleUser user) {
        int expireDays = this.engine.getParameterService().getInt("console.password.expire.days");
        boolean result = false;
        if (expireDays > 0) {
            Calendar userCal = Calendar.getInstance();
            if (user.getLastPasswordTime() != null) {
                userCal.setTime(user.getLastPasswordTime());
                userCal.add(5, expireDays);
                Calendar nowCal = Calendar.getInstance();
                nowCal.setTime(new Date());
                if (nowCal.after(userCal)) {
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public IConsoleUserAuthentication getConsoleUserAuthentication(ConsoleUser user) {
        IConsoleUserAuthentication authenticationMethod = null;
        if ("INTERNAL".equals(user.getAuthenticationMethod())) {
            authenticationMethod = new UserAuthenticationInternal();
        } else if ("LDAP".equals(user.getAuthenticationMethod())) {
            authenticationMethod = new UserAuthenticationLDAP();
        } else if ("SAML".equals(user.getAuthenticationMethod())) {
            authenticationMethod = new UserAuthenticationSAML();
        } else if ("OAUTH2".equals(user.getAuthenticationMethod())) {
            authenticationMethod = new UserAuthenticationOAUTH2();
        }
        return authenticationMethod;
    }

    class ConsoleUserRowMapper
    implements ISqlRowMapper<ConsoleUser> {
        ConsoleUserRowMapper() {
        }

        public ConsoleUser mapRow(Row rs) {
            ConsoleUser user = new ConsoleUser();
            user.setUserId(rs.getString("user_id"));
            user.setFirstName(rs.getString("first_name"));
            user.setLastName(rs.getString("last_name"));
            user.setEmail(rs.getString("email"));
            user.setHashedPassword(rs.getString("hashed_password"));
            user.setSalt(rs.getString("salt"));
            user.setEncryptionMethod(rs.getString("encrypt_meth"));
            user.setFailedLoginAttempts(rs.getInt("failed_logins"));
            user.setAuthenticationMethod(rs.getString("auth_meth"));
            user.setRole(rs.getString("user_role"));
            user.setLastLoginTime(rs.getDateTime("last_login_time"));
            user.setLastLoginIpAddr(rs.getString("last_login_ip_addr"));
            user.setLastLoginNodeId(rs.getString("last_login_node_id"));
            user.setLastUpdateBy(rs.getString("last_update_by"));
            user.setLastUpdateTime(rs.getDateTime("last_update_time"));
            user.setCreateTime(rs.getDateTime("create_time"));
            user.setLastPasswordTime(rs.getDateTime("last_password_time"));
            user.setOtpKey(rs.getString("otp_key"));
            user.setResetRequired(rs.getBoolean("is_reset_required"));
            user.setConfirmCode(rs.getString("confirm_code"));
            user.setConfirmCreateTime(rs.getDateTime("confirm_create_time"));
            user.setGlassBreakRequired(rs.getBoolean("is_glass_break_required"));
            user.setBreakGlassStartTime(rs.getDateTime("break_glass_start_time"));
            user.setBreakGlassEndTime(rs.getDateTime("break_glass_end_time"));
            user.setBreakGlassUserId(rs.getString("break_glass_user_id"));
            user.setEnabled(rs.getBoolean("enabled"));
            return user;
        }
    }

    class ConsoleRoleRowMapper
    implements ISqlRowMapper<ConsoleRole> {
        ConsoleRoleRowMapper() {
        }

        public ConsoleRole mapRow(Row rs) {
            ConsoleRole role = new ConsoleRole(null, null);
            role.setRoleId(rs.getString("role_id"));
            role.setRoleDescription(rs.getString("role_description"));
            role.setParentRoleId(rs.getString("parent_role_id"));
            role.setLastUpdateBy(rs.getString("last_update_by"));
            role.setLastUpdateTime(rs.getDateTime("last_update_time"));
            role.setCreateTime(rs.getDateTime("create_time"));
            return role;
        }
    }

    class ConsolePrivilegeRowMapper
    implements ISqlRowMapper<ConsolePrivilege> {
        ConsolePrivilegeRowMapper() {
        }

        public ConsolePrivilege mapRow(Row rs) {
            ConsolePrivilege privilege = new ConsolePrivilege(null, null, false, false);
            privilege.setPrivilegeId(rs.getString("privilege_name"));
            privilege.setReadFlag(rs.getBoolean("is_read"));
            privilege.setWriteFlag(rs.getBoolean("is_write"));
            privilege.setRoleId(rs.getString("role_id"));
            return privilege;
        }
    }

    class ConsoleUserHistRowMapper
    implements ISqlRowMapper<ConsoleUserHist> {
        ConsoleUserHistRowMapper() {
        }

        public ConsoleUserHist mapRow(Row rs) {
            ConsoleUserHist userHist = new ConsoleUserHist();
            userHist.setHistId(rs.getInt("hist_id"));
            userHist.setUserId(rs.getString("user_id"));
            userHist.setHashedPassword(rs.getString("hashed_password"));
            userHist.setSalt(rs.getString("salt"));
            userHist.setEncryptionMethod(rs.getString("encrypt_meth"));
            userHist.setAuthenticationMethod(rs.getString("auth_meth"));
            return userHist;
        }
    }
}

