/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.service.impl.ConsolePurgeListenerSqlMap;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.IPurgeListener;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolePurgeListener
implements IBuiltInExtensionPoint,
IPurgeListener,
ISymmetricEngineAware {
    protected final Logger log = LoggerFactory.getLogger(ConsolePurgeListener.class);
    private ISymmetricEngine engine;
    private ISqlMap sqlMap;
    private FastDateFormat fastFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private final int MINS_IN_ONE_WEEK = 10080;

    public long beforePurgeOutgoing(boolean force) {
        return 0L;
    }

    public long beforePurgeIncoming(boolean force) {
        return 0L;
    }

    public long purgeOutgoing(boolean force) {
        return 0L;
    }

    public long purgeIncoming(boolean force) {
        long rowsPurged = 0L;
        rowsPurged += (long)this.disableInactiveConsoleUsers();
        rowsPurged += (long)this.purgeConsoleEvents();
        rowsPurged += this.purgeTableStats();
        rowsPurged += (long)this.purgeSnapshotFiles();
        rowsPurged += this.purgeMonitorEvents();
        rowsPurged += this.purgeCompareRequests();
        return rowsPurged += (long)this.rotateSamlCertificate();
    }

    protected int disableInactiveConsoleUsers() {
        long maxMsInactive = (long)this.engine.getParameterService().getInt("console.user.disable.inactive.days") * 86400000L;
        int rows = 0;
        if (maxMsInactive > 0L) {
            Date purgeBefore = new Date(System.currentTimeMillis() - maxMsInactive);
            this.log.info("Disabling inactive console users older than {}", (Object)this.fastFormat.format(purgeBefore));
            if ((rows += this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"purgeConsoleUserSql"}), new Object[]{purgeBefore})) > 0) {
                this.log.info("Disabled {} inactive console users", (Object)rows);
            }
        }
        return rows;
    }

    protected int purgeConsoleEvents() {
        String nodeId = this.engine.getNodeService().findIdentityNodeId();
        int rowsPurged = 0;
        if (nodeId != null) {
            int retentionTimeInMinutes = this.engine.getParameterService().getInt("console.events.purge.retention.period", 1);
            Date purgeBefore = DateUtils.addMinutes((Date)new Date(), (int)(-retentionTimeInMinutes));
            this.log.info("Purging console events older than {}", (Object)this.fastFormat.format(purgeBefore));
            if ((rowsPurged += this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"purgeConsoleEventSql"}), new Object[]{nodeId, purgeBefore})) > 0) {
                this.log.info("Purged {} console events", (Object)rowsPurged);
            }
        }
        return rowsPurged;
    }

    protected long purgeTableStats() {
        long maxMsInactive = (long)Integer.max(this.engine.getParameterService().getInt("purge.stats.retention.minutes"), 10080) * 60000L;
        long rowsPurged = 0L;
        Date purgeBefore = new Date(System.currentTimeMillis() - maxMsInactive);
        this.log.info("Purging table stats older than {}", (Object)this.fastFormat.format(purgeBefore));
        if ((rowsPurged += (long)this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"purgeTableStatSql"}), new Object[]{purgeBefore})) > 0L) {
            this.log.info("Purged {} table stats", (Object)rowsPurged);
        }
        return rowsPurged;
    }

    protected int purgeSnapshotFiles() {
        int snapshotMinutes = this.engine.getParameterService().getInt("purge.snapshot.file.retention.minutes");
        long snapshotOldestTime = System.currentTimeMillis() - (long)snapshotMinutes * 60000L;
        this.log.info("Purging support snapshot files older than {}", (Object)this.fastFormat.format(snapshotOldestTime));
        File snapshotsDir = new File(this.engine.getParameterService().getTempDirectory(), "snapshots");
        int snapshotPurgeCount = 0;
        if (snapshotsDir.isDirectory()) {
            Collection files = FileUtils.listFiles((File)snapshotsDir, (String[])new String[]{"zip"}, (boolean)false);
            for (File file : files) {
                if (file.lastModified() >= snapshotOldestTime) continue;
                file.delete();
                ++snapshotPurgeCount;
            }
        }
        if (snapshotPurgeCount > 0) {
            this.log.info("Purged {} support snapshot files", (Object)snapshotPurgeCount);
        }
        return snapshotPurgeCount;
    }

    protected long purgeMonitorEvents() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.engine.getParameterService().getInt("purge.monitor.event.retention.minutes"));
        this.log.info("Purging monitor events that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        long count = this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"deleteMonitorEventSql"}), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} monitor events", (Object)count);
        }
        return count;
    }

    protected long purgeCompareRequests() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.engine.getParameterService().getInt("purge.compare.request.retention.minutes"));
        this.log.info("Purging compare requests that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        long count = this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"deleteCompareRequestSql"}), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} compare requests", (Object)count);
        }
        this.log.info("Purging compare statuses that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        count = this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"deleteCompareStatusSql"}), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} compare statuses", (Object)count);
        }
        this.log.info("Purging compare table statuses that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        count = this.engine.getSqlTemplate().update(this.sqlMap.getSql(new String[]{"deleteCompareTableStatusSql"}), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} compare table statuses", (Object)count);
        }
        return count;
    }

    protected int rotateSamlCertificate() {
        boolean deleteCert = false;
        boolean installCert = true;
        IParameterService parameterService = this.engine.getParameterService();
        int lifetimeInDays = parameterService.getInt("console.auth.saml.sp.cert.lifetime.days", 9125);
        int maxDaysBeforeRotation = parameterService.getInt("console.auth.saml.sp.cert.rotate.days", 30);
        ISecurityService securityService = this.engine.getSecurityService();
        X509Certificate samlCert = securityService.getCurrentSamlSslCert();
        Date expirationDate = null;
        if (maxDaysBeforeRotation > 0) {
            this.log.info("Rotating SAML certificate if it expires within {} day" + (maxDaysBeforeRotation == 1 ? "" : "s"), (Object)maxDaysBeforeRotation);
        } else if (maxDaysBeforeRotation == 0) {
            this.log.info("Rotating SAML certificate if it has expired");
        } else {
            this.log.info("Rotating SAML certificate if it expired more than {} day" + (maxDaysBeforeRotation == -1 ? "" : "s") + " ago", (Object)(-maxDaysBeforeRotation));
        }
        if (samlCert != null) {
            long createdMs = samlCert.getNotBefore().getTime() + 86400000L;
            expirationDate = samlCert.getNotAfter();
            long expiresMs = expirationDate.getTime();
            long lifetimeInMs = (long)lifetimeInDays * 86400000L;
            long maxMsBeforeRotation = (long)maxDaysBeforeRotation * 86400000L;
            deleteCert = installCert = expiresMs - System.currentTimeMillis() <= maxMsBeforeRotation || lifetimeInMs > 0L && expiresMs - createdMs > lifetimeInMs;
        }
        if (installCert) {
            if (deleteCert) {
                try {
                    securityService.deleteKeystoreEntry("saml");
                    if (expirationDate.after(new Date())) {
                        this.log.info("Deleted SAML certificate set to expire on {}", (Object)this.fastFormat.format(expirationDate));
                    } else {
                        this.log.info("Deleted SAML certificate which expired on {}", (Object)this.fastFormat.format(expirationDate));
                    }
                }
                catch (Exception e2) {
                    this.log.error("SAML certificate rotation failed: Failed to delete certificate", (Throwable)e2);
                    return 0;
                }
            }
            String host = new TypedProperties(System.getProperties()).get("host.bind.name", System.getProperty("host.bind.name", null));
            securityService.installDefaultSamlSslCert(host, lifetimeInDays);
            this.log.info("Installed new SAML certificate which will expire in {} day" + (lifetimeInDays == 1 ? "" : "s"), (Object)(lifetimeInDays > 0 ? lifetimeInDays : 9125));
            return 1;
        }
        return 0;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.sqlMap = new ConsolePurgeListenerSqlMap(engine.getSymmetricDialect().getPlatform(), engine.getTablePrefix());
    }
}

