/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.service.impl.ConsoleEventServiceSqlMap;
import com.jumpmind.symmetric.security.IConsoleEventListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleEventService
implements IConsoleEventService,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private static final Logger log = LoggerFactory.getLogger((String)new hh(new long[]{-7353458468856323309L, 7941929854060598215L, -2552897967334104473L, -8449927540523469209L, 1105776391076428325L, 809730597367687498L, -8536628459715892648L, -122062713139223652L, -741345542917284546L}).toString());
    private ISymmetricEngine engine;
    private ISqlMap sql;
    private final AtomicLong lastAddTime = new AtomicLong(this.currentTimeRoundedMillis());

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
        this.sql = new ConsoleEventServiceSqlMap(engine.getSymmetricDialect().getPlatform(), engine.getTablePrefix());
    }

    @Override
    public void addEvent(ConsoleEvent event) {
        long addTime = this.getUniqueAddTime();
        if (event.getTargetNode() != null) {
            log.info("Event \"{}\" from user \"{}\" at node \"{}\" (source=\"{}\", target=\"{}\") [ {} ]", new Object[]{event.getEventCode(), event.getUserId(), event.getEventNode(), event.getSourceNode(), event.getTargetNode() == null ? "" : event.getTargetNode(), event.getValue()});
        } else {
            log.info("Event \"{}\" from user \"{}\" at node \"{}\" [ {} ]", new Object[]{event.getEventCode(), event.getUserId(), event.getEventNode(), event.getValue()});
        }
        try {
            this.engine.getSqlTemplate().update(this.getSql("insertConsoleEventSql"), new Object[]{event.getUserId(), event.getEventCode(), new Date(addTime), event.getEventNode(), event.getSourceNode(), event.getTargetNode(), event.getValue()});
        }
        catch (RuntimeException e2) {
            log.warn("Unable to save console event because {}. {}", (Object)(e2.getClass().getSimpleName() + (String)(e2.getMessage() == null ? "" : ": " + e2.getMessage())), (Object)event);
        }
        for (IConsoleEventListener listener : this.engine.getExtensionService().getExtensionPointList(IConsoleEventListener.class)) {
            listener.handleEvent(event);
        }
    }

    protected long getUniqueAddTime() {
        int sanityCounter = 10;
        while (this.currentTimeRoundedMillis() == this.lastAddTime.get() && sanityCounter-- > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        long addTime = this.currentTimeRoundedMillis();
        this.lastAddTime.set(addTime);
        return addTime;
    }

    protected long currentTimeRoundedMillis() {
        return System.currentTimeMillis() / 1000L * 1000L;
    }

    @Override
    public List<ConsoleEvent> getEvents(List<FilterCriterion> filter) {
        String where = filter != null ? this.buildWhere(filter) : null;
        Map<Object, Object> params = filter != null ? this.buildParams(filter) : new HashMap();
        String sql = this.getSql("findConsoleEventSqlPrefix", where, " order by create_time desc");
        return this.engine.getSqlTemplate().query(sql, (ISqlRowMapper)new ConsoleEventRowMapper(), params);
    }

    protected String buildWhere(List<FilterCriterion> filter) {
        StringBuilder where = new StringBuilder();
        boolean needsAnd = false;
        int id = 0;
        for (FilterCriterion criterion : filter) {
            if (needsAnd) {
                where.append(" and ");
            } else {
                needsAnd = true;
            }
            FilterCriterion.FilterOption option = criterion.getOption();
            String optionSql = option.toSql();
            String prefix = null;
            switch (criterion.getPropertyId()) {
                case "eventCode": {
                    prefix = "event_code " + optionSql;
                    break;
                }
                case "eventNode": {
                    prefix = "event_node_id " + optionSql;
                    break;
                }
                case "sourceNode": {
                    prefix = "source_node_id " + optionSql;
                    break;
                }
                case "targetNode": {
                    prefix = "target_node_id " + optionSql;
                    break;
                }
                case "value": {
                    prefix = "event_value " + optionSql;
                    break;
                }
                case "userId": {
                    prefix = "user_id " + optionSql;
                    break;
                }
                case "createTime": {
                    prefix = "create_time " + optionSql;
                }
            }
            if (prefix == null) continue;
            if (option.equals((Object)FilterCriterion.FilterOption.IN_LIST) || option.equals((Object)FilterCriterion.FilterOption.NOT_IN_LIST)) {
                where.append(prefix + " (:" + id++ + ")");
                continue;
            }
            where.append(prefix + " :" + id++);
            if (!option.equals((Object)FilterCriterion.FilterOption.BETWEEN)) continue;
            where.append(" and :" + id++);
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        return where.toString();
    }

    protected Map<String, Object> buildParams(List<FilterCriterion> filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int id = 0;
        for (FilterCriterion criterion : filter) {
            FilterCriterion.FilterOption option = criterion.getOption();
            List values = criterion.getValues();
            if (criterion.getPropertyId().equals("createTime")) {
                if (option.equals((Object)FilterCriterion.FilterOption.IN_LIST) || option.equals((Object)FilterCriterion.FilterOption.NOT_IN_LIST)) {
                    params.put(String.valueOf(id++), values);
                    continue;
                }
                params.put(String.valueOf(id++), new Timestamp(((Date)values.get(0)).getTime()));
                if (!option.equals((Object)FilterCriterion.FilterOption.BETWEEN)) continue;
                params.put(String.valueOf(id++), new Timestamp(((Date)values.get(1)).getTime()));
                continue;
            }
            if (option.equals((Object)FilterCriterion.FilterOption.IN_LIST) || option.equals((Object)FilterCriterion.FilterOption.NOT_IN_LIST)) {
                params.put(String.valueOf(id++), values);
                continue;
            }
            if (option.equals((Object)FilterCriterion.FilterOption.CONTAINS) || option.equals((Object)FilterCriterion.FilterOption.NOT_CONTAINS)) {
                params.put(String.valueOf(id++), "%" + String.valueOf(values.get(0)) + "%");
                continue;
            }
            params.put(String.valueOf(id++), values.get(0));
            if (!option.equals((Object)FilterCriterion.FilterOption.BETWEEN)) continue;
            params.put(String.valueOf(id++), values.get(1));
        }
        return params;
    }

    protected String getSql(String ... keys) {
        return this.sql.getSql(keys);
    }

    class ConsoleEventRowMapper
    implements ISqlRowMapper<ConsoleEvent> {
        ConsoleEventRowMapper() {
        }

        public ConsoleEvent mapRow(Row rs) {
            ConsoleEvent event = new ConsoleEvent();
            event.setUserId(rs.getString("user_id"));
            event.setEventCode(rs.getString("event_code"));
            event.setEventNode(rs.getString("event_node_id"));
            event.setSourceNode(rs.getString("source_node_id"));
            event.setTargetNode(rs.getString("target_node_id"));
            event.setValue(rs.getString("event_value"));
            event.setCreateTime(rs.getDateTime("create_time"));
            return event;
        }
    }
}

