/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import java.util.Iterator;
import java.util.List;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleAlterDatabaseInterceptor
implements IAlterDatabaseInterceptor,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private static final Logger log = LoggerFactory.getLogger(ConsoleAlterDatabaseInterceptor.class);
    ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public List<IModelChange> intercept(List<IModelChange> detectedChanges, Database currentModel, Database desiredModel) {
        this.checkForRoleColumnUpgrade(detectedChanges);
        return detectedChanges;
    }

    protected void checkForRoleColumnUpgrade(List<IModelChange> detectedChanges) {
        Iterator<IModelChange> it = detectedChanges.iterator();
        RemoveColumnChange roleRemovalChange = null;
        AddColumnChange roleUserAddChange = null;
        while (it.hasNext()) {
            AddColumnChange addColumnChange;
            RemoveColumnChange removeColumnChange;
            IModelChange modelChange = it.next();
            if (modelChange instanceof RemoveColumnChange && (removeColumnChange = (RemoveColumnChange)modelChange).getChangedTable().getName().toLowerCase().endsWith("console_user") && removeColumnChange.getColumn().getName().equalsIgnoreCase("role")) {
                roleRemovalChange = removeColumnChange;
                it.remove();
            }
            if (!(modelChange instanceof AddColumnChange) || !(addColumnChange = (AddColumnChange)modelChange).getChangedTable().getName().toLowerCase().endsWith("console_user") || !addColumnChange.getNewColumn().getName().equalsIgnoreCase("user_role")) continue;
            roleUserAddChange = addColumnChange;
            it.remove();
        }
        if (roleUserAddChange != null) {
            log.info("Detected role column rename to user_role");
            String tableName = roleUserAddChange.getChangedTable().getName();
            log.info("Removing triggers for the console user table for upgrade");
            try {
                this.engine.getSymmetricDialect().removeTrigger(null, null, null, "SYM_ON_I_FOR_SYM_CNSL_SR_SRVR  ", tableName);
                this.engine.getSymmetricDialect().removeTrigger(null, null, null, "SYM_ON_U_FOR_SYM_CNSL_SR_SRVR  ", tableName);
                this.engine.getSymmetricDialect().removeTrigger(null, null, null, "SYM_ON_D_FOR_SYM_CNSL_SR_SRVR  ", tableName);
            }
            catch (Exception ex2) {
                log.error("Error while trying to remove triggers for %s", (Object)tableName, (Object)ex2);
            }
            detectedChanges.add((IModelChange)roleUserAddChange);
        }
        if (roleRemovalChange != null && roleUserAddChange != null) {
            detectedChanges.add((IModelChange)new CopyColumnValueChange(roleUserAddChange.getChangedTable(), roleRemovalChange.getColumn(), roleUserAddChange.getNewColumn()));
            detectedChanges.add((IModelChange)roleRemovalChange);
        }
    }
}

