/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jumpmind.symmetric.console.remote.RemoteStatusCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.service.INodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTableMetaDataCommand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RemoteStatusCommand remoteStatusCommand;
    private Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();

    public RemoteTableMetaDataCommand(RemoteStatusCommand RemoteStatusCommand2) {
        this.remoteStatusCommand = RemoteStatusCommand2;
    }

    public String execute() throws Exception {
        ISymmetricEngine engine = this.remoteStatusCommand.getEngine();
        INodeService nodeService = engine.getNodeService();
        String tablePrefix = engine.getTablePrefix();
        HashMap<String, Map<String, List<String>>> metaMap = new HashMap<String, Map<String, List<String>>>();
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("c", "catalog", true, "Get all schemas based on catalog provided");
        options.addOption("l", "list-catalogs", false, "Get all catalogs");
        options.addOption("s", "schema", true, "Get all tables based on catalog and schema provided");
        CommandLine cmd = parser.parse(options, this.remoteStatusCommand.getCommand().split(" "));
        String catalog = cmd.getOptionValue('c');
        String schema = cmd.getOptionValue('s');
        boolean catalogsOnly = cmd.hasOption('l');
        String defaultCatalog = engine.getTargetDialect().getPlatform().getDefaultCatalog();
        String defaultSchema = engine.getTargetDialect().getPlatform().getDefaultSchema();
        if (nodeService.getCachedIdentity() != null) {
            HashSet<String> symTables = null;
            if (tablePrefix != null) {
                symTables = new HashSet<String>(TableConstants.getTables((String)tablePrefix));
            }
            if (defaultCatalog == null && catalog == null) {
                if (metaMap.get(defaultCatalog) == null) {
                    metaMap.put(defaultCatalog, new HashMap());
                }
                this.addSchemas(metaMap, engine, symTables, null, schema, defaultSchema);
            } else {
                for (String c2 : engine.getTargetDialect().getPlatform().getDdlReader().getCatalogNames()) {
                    if (metaMap.get(c2) == null) {
                        metaMap.put(c2, new HashMap());
                    }
                    if (catalogsOnly || (catalog == null || !c2.equals(catalog)) && catalog != null) continue;
                    this.addSchemas(metaMap, engine, symTables, c2, schema, defaultSchema);
                }
            }
        }
        return this.formatResponse(metaMap, catalogsOnly, catalog, schema, defaultCatalog, defaultSchema);
    }

    protected void addSchemas(Map<String, Map<String, List<String>>> metaMap, ISymmetricEngine engine, Set<String> symTables, String c2, String schema, String defaultSchema) {
        try {
            if (defaultSchema == null) {
                if (metaMap.get(c2).get(defaultSchema) == null) {
                    metaMap.get(c2).put(defaultSchema, new ArrayList());
                }
                this.addTables(metaMap, engine, symTables, c2, defaultSchema);
            } else {
                for (String s2 : engine.getTargetDialect().getPlatform().getDdlReader().getSchemaNames(c2)) {
                    if (metaMap.get(c2).get(s2) == null) {
                        metaMap.get(c2).put(s2, new ArrayList());
                    }
                    if ((schema == null || !s2.equals(schema)) && schema != null) continue;
                    this.addTables(metaMap, engine, symTables, c2, s2);
                }
            }
        }
        catch (Exception e2) {
            this.logger.debug("Unable to determine meta data for the catalog " + c2 + ", " + String.valueOf(e2));
        }
    }

    protected void addTables(Map<String, Map<String, List<String>>> metaMap, ISymmetricEngine engine, Set<String> symTables, String catalog, String schema) {
        for (String tableName : engine.getTargetDialect().getPlatform().getDdlReader().getTableNames(catalog, schema, new String[]{"TABLE"})) {
            if (symTables == null || tableName == null || symTables.contains(tableName.toLowerCase()) || tableName.toLowerCase().startsWith(engine.getTablePrefix())) continue;
            metaMap.get(catalog).get(schema).add(tableName);
        }
    }

    protected String formatResponse(Map<String, Map<String, List<String>>> metaMap, boolean catalogsOnly, String catalog, String schema, String defaultCatalog, String defaultSchema) {
        JsonObject json = new JsonObject();
        JsonObject catalogs = new JsonObject();
        JsonObject schemas = new JsonObject();
        JsonObject tables = new JsonObject();
        if (metaMap.isEmpty()) {
            json.addProperty("message", "No table meta data found.");
        } else if (catalogsOnly) {
            JsonArray catalogsArray = new JsonArray();
            for (Map.Entry<String, Map<String, List<String>>> catalogEntry : metaMap.entrySet()) {
                catalogsArray.add(catalogEntry.getKey());
            }
            catalogs.add("catalogs", (JsonElement)catalogsArray);
            json.add("metadata", (JsonElement)catalogs);
        } else if (catalog != null && schema == null) {
            JsonArray schemasArray = new JsonArray();
            for (Map.Entry<String, Map<String, List<String>>> catalogEntry : metaMap.entrySet()) {
                for (Map.Entry<String, List<String>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    schemasArray.add(schemaEntry.getKey());
                }
            }
            schemas.add("schemas", (JsonElement)schemasArray);
            json.add("metadata", (JsonElement)schemas);
        } else if (catalog != null && schema != null) {
            JsonArray tablesArray = new JsonArray();
            for (Map.Entry<String, Map<String, List<String>>> catalogEntry : metaMap.entrySet()) {
                for (Map.Entry<String, List<String>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    for (String table : schemaEntry.getValue()) {
                        tablesArray.add(table);
                    }
                }
            }
            tables.add("tables", (JsonElement)tablesArray);
            json.add("metadata", (JsonElement)tables);
        } else {
            JsonArray catalogsArray = new JsonArray();
            catalogs.addProperty("default-catalog", defaultCatalog);
            catalogs.addProperty("default-schema", defaultSchema);
            for (Map.Entry<String, Map<String, List<String>>> catalogEntry : metaMap.entrySet()) {
                if (defaultCatalog == null) {
                    defaultCatalog = catalogEntry.getKey();
                }
                JsonObject catalogObj = new JsonObject();
                catalogObj.addProperty("catalog", catalogEntry.getKey());
                JsonArray schemasArray = new JsonArray();
                for (Map.Entry<String, List<String>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    JsonObject schemaObj = new JsonObject();
                    schemaObj.addProperty("schema", schemaEntry.getKey());
                    JsonArray tablesArray = new JsonArray();
                    for (String table : schemaEntry.getValue()) {
                        tablesArray.add(table);
                    }
                    schemaObj.add("tables", (JsonElement)tablesArray);
                    schemasArray.add((JsonElement)schemaObj);
                }
                catalogObj.add("schemas", (JsonElement)schemasArray);
                catalogsArray.add((JsonElement)catalogObj);
            }
            catalogs.addProperty("default-catalog", defaultCatalog);
            catalogs.addProperty("default-schema", defaultSchema);
            catalogs.add("catalogs", (JsonElement)catalogsArray);
            json.add("metadata", (JsonElement)catalogs);
        }
        this.logger.debug(this.gsonPretty.toJson((JsonElement)json));
        return this.remoteStatusCommand.getGson().toJson((JsonElement)json);
    }
}

