/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.model;

import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConsoleUser user;
    private String remoteAddress;
    private String remoteHost;
    private String userAgent;
    private VaadinSession vaadinSession;
    private Date loginTime;

    public AppSession(String remoteAddress, String remoteHost, VaadinSession vaadinSession, String userAgent, Date createTime) {
        this.remoteAddress = remoteAddress;
        this.remoteHost = remoteHost;
        this.vaadinSession = vaadinSession;
        this.loginTime = createTime;
        this.userAgent = userAgent;
    }

    public boolean equals(Object o2) {
        if (o2 != null && o2 instanceof AppSession) {
            AppSession appSession = (AppSession)o2;
            if (this.vaadinSession.getSession() == null || appSession.getVaadinSession().getSession() == null) {
                return this.user.getUserId().equals(appSession.user.getUserId()) && this.remoteAddress.equals(appSession.remoteAddress) && this.loginTime.equals(appSession.loginTime);
            }
            return this.vaadinSession.getSession().getId().equals(((AppSession)o2).vaadinSession.getSession().getId());
        }
        return false;
    }

    public void setUser(ConsoleUser user) {
        this.user = user;
    }

    public ConsoleUser getUser() {
        return this.user;
    }

    public String getUserId() {
        return this.user.getUserId();
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public Date getLastActivity() {
        return new Date(this.vaadinSession.getLastRequestTimestamp());
    }

    public String getLastActivityString() {
        Date date = new Date(this.vaadinSession.getLastRequestTimestamp());
        SimpleDateFormat DateFor = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aa");
        String formattedDate = DateFor.format(date);
        return formattedDate;
    }

    public Date getLoginTime() {
        return this.loginTime;
    }

    public String getLoginTimeString() {
        Date date = this.loginTime;
        SimpleDateFormat DateFor = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss aa");
        String formattedDate = DateFor.format(date);
        return formattedDate;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public VaadinSession getVaadinSession() {
        return this.vaadinSession;
    }

    public String getName() {
        return this.user.getLastName() + ", " + this.user.getFirstName();
    }
}

