/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.r;
import com.jumpmind.symmetric.console.impl.x;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class p
extends e {
    protected final Logger a = LoggerFactory.getLogger(p.class);
    protected r b;
    protected x c;

    public p(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
        this.b = new r(engine, compareService);
        this.c = new x(engine, compareService);
    }

    public void a(CompareTableStatus status, ProcessInfo processInfo) {
        IStagedResource resourceRemote;
        boolean statusNeedsUpdate = false;
        IStagedResource resource = this.findResource(status, "table");
        if (resource == null || !resource.exists() || resource.getState() != IStagedResource.State.DONE) {
            if (this.isInitiator(status.getCompareRequest())) {
                this.b.a(status);
                status.setStatus("NE");
                this.c.a(status, this.isSource(status), processInfo);
                resource = this.findResource(status, "table");
                statusNeedsUpdate = true;
            } else if (status.getStatus().equals("NE") || status.getStatus().equals("SE")) {
                this.c.a(status, this.isSource(status), processInfo);
                resource = this.findResource(status, "table");
                statusNeedsUpdate = true;
            }
        }
        RuntimeException e2 = null;
        if (status.getStatus().equals("NE")) {
            try {
                this.b.a(status, "table", status.getTargetNodeId(), status.getSourceNodeId());
            }
            catch (RuntimeException ex2) {
                e2 = ex2;
            }
        }
        if (this.isSource(status) && (resourceRemote = this.findResource(status, "table-remote")) != null && resourceRemote.exists() && resourceRemote.getState() == IStagedResource.State.DONE && resource != null && resource.exists() && resource.getState() == IStagedResource.State.DONE) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
            this.setStatusIfNotSet(status, "SE");
            this.a(status, resource, resourceRemote);
            statusNeedsUpdate = false;
        }
        if (this.isSource(status) && statusNeedsUpdate) {
            this.compareService.updateCompareTableStatus(status);
        }
        if (e2 != null) {
            throw e2;
        }
    }

    protected void a(CompareTableStatus status, IStagedResource resource, IStagedResource resourceRemote) {
        long checksumRemote;
        long checksum;
        HashMap<String, Object> statMap = new HashMap<String, Object>();
        try {
            checksum = this.a(resource, statMap);
            checksumRemote = this.a(resourceRemote, statMap);
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
        try {
            BeanUtils.populate((Object)status, statMap);
        }
        catch (Exception e3) {
            this.a.warn("Unable to update statistics for compare request {}-{} step {} because: {}: {}", new Object[]{status.getSourceNodeId(), status.getCompareId(), status.getStepNumber(), e3.getClass().getName(), e3.getMessage()});
        }
        if (checksum == checksumRemote) {
            status.setStatus("CO");
            status.setMatchFlag(true);
            status.setRowMatchCount(status.getSourceRowCount());
            status.setErrorFlag(false);
            status.setErrorMessage(null);
            this.cleanUp(status);
        } else if (!(status.getCompareRequest().isUseRowLevel() || status.getCompareRequest().isUseScript() || status.getCompareRequest().isUseRepair())) {
            status.setStatus("CO");
            status.setMatchFlag(false);
            status.setErrorFlag(false);
            status.setErrorMessage(null);
            if (status.getSourceRowCount() > status.getTargetRowCount()) {
                status.setRowMissingCount(status.getSourceRowCount() - status.getTargetRowCount());
            } else if (status.getSourceRowCount() < status.getTargetRowCount()) {
                status.setRowExtraCount(status.getTargetRowCount() - status.getSourceRowCount());
            }
            this.cleanUp(status);
        } else if (status.getCompareRequest().isUseChunking() && status.getSourceRowCount() / this.getChunkSize(status.getSourceRowCount()) > 1L) {
            status.setLevel("C");
            status.setStatus("NE");
        } else {
            status.setLevel("R");
            status.setStatus("NE");
        }
        this.compareService.updateCompareTableStatus(status);
        this.a.info("Compared table {} for compare request {}: {}", new Object[]{this.isSource(status) ? status.getSourceTableName() : status.getTargetTableName(), status.getNodeCompareIdStep(), checksum == checksumRemote ? "MATCHED" : "DIFFERENT"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long a(IStagedResource resource, Map<String, Object> statMap) throws IOException {
        long checksum = 0L;
        try (CsvReader reader = CsvUtils.getCsvReaderDquote((Reader)new InputStreamReader(resource.getInputStream()));){
            String[] statsColumns = null;
            while (reader.readRecord()) {
                String[] tokens = reader.getValues();
                if (tokens.length <= 1) continue;
                if ("stats_columns".equals(tokens[0])) {
                    statsColumns = tokens;
                    continue;
                }
                if ("stats".equals(tokens[0]) && statMap != null) {
                    for (int i2 = 1; i2 < tokens.length; ++i2) {
                        statMap.put(statsColumns[i2], tokens[i2]);
                    }
                    continue;
                }
                if (!"cs".equals(tokens[0])) continue;
                checksum = Long.parseLong(tokens[1]);
            }
        }
        finally {
            resource.close();
        }
        return checksum;
    }
}

