/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2000DatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.symmetric.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class gi
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private Logger a = LoggerFactory.getLogger(this.getClass());
    private ISymmetricEngine b;

    @Override
    public MonitorEvent a(Monitor monitor) {
        gR recommendation;
        IDatabasePlatform platform = this.b.getDatabasePlatform();
        if (!(platform instanceof MsSql2000DatabasePlatform)) {
            return this.a(0L);
        }
        String url = this.b.getParameterService().getString("db.url", "");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.a.info("Aborting insight check due to null or blank url.");
            return this.a(0L);
        }
        HashMap tablesMap = SnapshotUtil.getTablesForCaptureByCatalogSchema((ISymmetricEngine)this.b);
        List<Column> datetimeColumns = this.a(tablesMap.values());
        if (datetimeColumns.isEmpty()) {
            return this.a(0L);
        }
        List<Column> datetime2Columns = this.b(tablesMap.values());
        if (!datetime2Columns.isEmpty() && this.b.getParameterService().is("db.treat.date.time.as.varchar.enabled")) {
            return this.a(0L);
        }
        if (datetime2Columns.isEmpty() && this.c(url)) {
            return this.a(0L);
        }
        String problemDescription = this.a(datetimeColumns.size(), datetime2Columns.size());
        String actionDescription = this.a(!datetime2Columns.isEmpty());
        String optionDescription = this.b(!datetime2Columns.isEmpty());
        gR gR2 = recommendation = new gR(problemDescription, actionDescription, true);
        Objects.requireNonNull(gR2);
        List<gR.a> options = List.of(gR2.new gR.a(1, optionDescription));
        recommendation.a(options);
        MonitorEvent event = this.a(datetimeColumns.size() + datetime2Columns.size());
        event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        String engineName = this.b.getEngineName();
        String userId = event.getApprovedBy();
        IParameterService parameterService = this.b.getParameterService();
        String selectedOptionDescription = recommendation.b(event.getApprovedOption());
        if (selectedOptionDescription != null && selectedOptionDescription.contains("db.treat.date.time.as.varchar.enabled")) {
            parameterService.saveParameter("db.treat.date.time.as.varchar.enabled", (Object)true, userId);
            this.a(event, "db.treat.date.time.as.varchar.enabled");
            return true;
        }
        File propFile = PropertiesUtil.findPropertiesFileForEngineWithName((String)engineName, (Map)parameterService.getReplacementValues());
        if (propFile == null) {
            this.a.error("Failed to open or find properties file for " + engineName);
            return false;
        }
        if (!propFile.canWrite()) {
            this.a.error("Failed to write to properties file for " + engineName);
            return false;
        }
        String parameterName = "db.url";
        try {
            ITypedPropertiesFactory typedPropertiesFactory = PropertiesUtil.createTypedPropertiesFactory((File)propFile, null);
            TypedProperties prop = typedPropertiesFactory.reload(propFile);
            String currentUrl = prop.get(parameterName);
            prop.put((Object)parameterName, (Object)this.a(currentUrl));
            typedPropertiesFactory.save((Properties)prop, propFile, "Updated by SymmetricDS");
            this.a(event, parameterName);
        }
        catch (IOException ex2) {
            String msg = ex2.getMessage();
            if (msg != null) {
                this.a.error(msg, (Throwable)ex2);
            } else {
                this.a.error("Failed to read properties file for " + engineName, (Throwable)ex2);
            }
            return false;
        }
        as.restartSymmetric(this.b, userId, "Incompatible datetime insight approval");
        return true;
    }

    @Override
    public boolean a() {
        return false;
    }

    @Override
    public String b() {
        return "incompatibleDatetime";
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.b = engine;
    }

    protected String a(int numOfDatetimeColumns, int numOfDatetime2Columns) {
        if (numOfDatetime2Columns > 0) {
            return "Detected " + numOfDatetimeColumns + " datetime and " + numOfDatetime2Columns + " datetime2 table columns. The JDBC driver will not properly handle both types.";
        }
        return "Detected " + numOfDatetimeColumns + " datetime table column(s). This may result in data incompatibility issues with the current JDBC URL settings.";
    }

    protected String a(boolean hasDatetime2) {
        return hasDatetime2 ? "Modify the db.treat.date.time.as.varchar.enabled SymmetricDS parameter." : "Change the settings on the db.url property.";
    }

    protected String b(boolean hasDatetime2) {
        return hasDatetime2 ? "Set the db.treat.date.time.as.varchar.enabled parameter to \"true\"." : "Set the \"datetimeParameterType\" property to \"datetime\" in the db.url, and restart SymmetricDS.";
    }

    protected String a(String url) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("URL cannot be updated due to null or empty value");
        }
        return this.b(url);
    }

    protected String b(String url) {
        Optional<String> datetimeParameterType = this.e(url);
        if (datetimeParameterType.isPresent()) {
            if (this.f(datetimeParameterType.get())) {
                return url.replaceAll("(?i)datetimeParameterType=[^&;]*", "datetimeParameterType=datetime");
            }
            return url;
        }
        return url + ";datetimeParameterType=datetime";
    }

    protected boolean c(String url) {
        if (this.g(url)) {
            Optional<String> datetimeParameterType = this.e(url);
            return datetimeParameterType.isPresent() ? this.d(datetimeParameterType.get()) : false;
        }
        return false;
    }

    protected boolean d(String param) {
        return "datetime".equals(param.substring(param.indexOf("=") + 1).trim());
    }

    protected Optional<String> e(String url) {
        return Arrays.stream(url.split("[;?]")).map(String::trim).map(String::toLowerCase).filter(param -> param.startsWith("datetimeparametertype=")).findFirst();
    }

    protected boolean f(String param) {
        return "datetime".equals(param.substring(param.indexOf("=") + 1).trim());
    }

    protected boolean g(String url) {
        return url.toLowerCase().startsWith("jdbc:sqlserver");
    }

    protected List<Column> a(Collection<List<Table>> tableLists) {
        return tableLists.stream().flatMap(Collection::stream).flatMap(table -> table.getColumnsAsList().stream()).filter(column -> this.a((Column)column)).collect(Collectors.toList());
    }

    protected List<Column> b(Collection<List<Table>> tableLists) {
        return tableLists.stream().flatMap(Collection::stream).flatMap(table -> table.getColumnsAsList().stream()).filter(column -> this.b((Column)column)).collect(Collectors.toList());
    }

    protected boolean a(Column column) {
        return "datetime".equals(column.getJdbcTypeName());
    }

    protected boolean b(Column column) {
        return "datetime2".equals(column.getJdbcTypeName());
    }

    private MonitorEvent a(long value) {
        MonitorEvent event = new MonitorEvent();
        event.setValue(value);
        return event;
    }

    private void a(MonitorEvent event, String updatedParam) {
        IConsoleEventService consoleEventService = (IConsoleEventService)this.b.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        String nodeId = this.b.getNodeId();
        consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Edit Parameter", nodeId, nodeId, null, updatedParam));
    }
}

