/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class gf
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;
    private Logger b = LoggerFactory.getLogger(this.getClass());

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        ISymmetricDialect dialect = this.a.getSymmetricDialect();
        BasicDataSource dataSource = (BasicDataSource)dialect.getTargetPlatform().getDataSource();
        boolean allConnectionsInUse = dataSource != null && dataSource.getNumActive() == dataSource.getMaxTotal();
        event.setValue(allConnectionsInUse ? 1L : 0L);
        if (allConnectionsInUse) {
            String problemDescription = "All " + dataSource.getMaxTotal() + " connections in the database connection pool are in use.";
            String actionDescription = "Increase the size of the database connection pool.";
            gR recommendation = new gR(problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            String optionDescription = dialect.equals(this.a.getTargetDialect()) ? "Increase the db.pool.max.active parameter by 10 and restart SymmetricDS." : "Increase the target.db.pool.max.active parameter by 10 and restart SymmetricDS.";
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, optionDescription));
            recommendation.a(options);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        String engineName = this.a.getEngineName();
        File propFile = PropertiesUtil.findPropertiesFileForEngineWithName((String)engineName, (Map)this.a.getParameterService().getReplacementValues());
        if (propFile == null) {
            this.b.error("Failed to open or find properties file for " + engineName);
            return false;
        }
        if (!propFile.canWrite()) {
            this.b.error("Failed to write to properties file for " + engineName);
            return false;
        }
        String selectedOptionDescription = recommendation.b(event.getApprovedOption());
        Object parameterName = "db.pool.max.active";
        if (selectedOptionDescription != null && selectedOptionDescription.contains("target.")) {
            parameterName = "target." + (String)parameterName;
        }
        String userId = event.getApprovedBy();
        try {
            ITypedPropertiesFactory typedPropertiesFactory = PropertiesUtil.createTypedPropertiesFactory((File)propFile, null);
            TypedProperties prop = typedPropertiesFactory.reload(propFile);
            int currentValue = Integer.parseInt(prop.get((String)parameterName, "50"));
            prop.put(parameterName, (Object)String.valueOf(currentValue + 10));
            typedPropertiesFactory.save((Properties)prop, propFile, "Updated by SymmetricDS");
            IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
            String nodeId = this.a.getNodeId();
            consoleEventService.addEvent(new ConsoleEvent(userId, "Edit Parameter", nodeId, nodeId, null, (String)parameterName));
        }
        catch (IOException ex2) {
            String msg = ex2.getMessage();
            if (msg != null) {
                this.b.error(msg, (Throwable)ex2);
            } else {
                this.b.error("Failed to read properties file for " + engineName, (Throwable)ex2);
            }
            return false;
        }
        as.restartSymmetric(this.a, userId, "Connection Pool insight approval");
        return true;
    }

    @Override
    public String b() {
        return "connectionPool";
    }

    @Override
    public boolean a() {
        return false;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

