/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class fB
extends DmlStatement {
    public fB(DmlStatementOptions options) {
        super(options);
    }

    protected void appendColumnParameter(StringBuilder sql, Column column) {
        String name = column.getJdbcTypeName();
        if (column.isTimestampWithTimezone()) {
            sql.append("TO_TIMESTAMP_TZ(?, 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM')").append(",");
        } else if (name != null && (name.toUpperCase().contains("GEOMETRY") || name.toUpperCase().contains("GEOGRAPHY"))) {
            sql.append("SYM_WKT2GEOM(?)").append(",");
        } else {
            super.appendColumnParameter(sql, column);
        }
    }

    protected void appendColumnEquals(StringBuilder sql, Column column) {
        if (column.isTimestampWithTimezone()) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = TO_TIMESTAMP_TZ(?, 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM')");
        } else if (column.getJdbcTypeName().toUpperCase().contains("GEOMETRY") || column.getJdbcTypeName().toUpperCase().contains("GEOGRAPHY")) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = ").append("SYM_WKT2GEOM(?)");
        } else {
            super.appendColumnEquals(sql, column);
        }
    }

    protected int getTypeCode(Column column, boolean isDateOverrideToTimestamp) {
        int typeCode = super.getTypeCode(column, isDateOverrideToTimestamp);
        if (column.getJdbcTypeName().startsWith("XML")) {
            typeCode = 12;
        } else if (typeCode == -1) {
            typeCode = 2005;
        }
        return typeCode;
    }

    protected void appendColumnNameForSql(StringBuilder sql, Column column, boolean select) {
        String columnName = column.getName();
        if (select && column.isTimestampWithTimezone()) {
            sql.append("to_char(").append(this.quote).append(columnName).append(this.quote).append(", 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM') as ").append(columnName);
        } else {
            super.appendColumnNameForSql(sql, column, select);
        }
    }
}

