/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.db2.Db2DdlReader;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class eX
extends Db2DdlReader {
    public eX(IDatabasePlatform platform) {
        super(platform);
    }

    public List<String> getSchemaNames(String catalog) {
        try {
            return super.getSchemaNames(catalog);
        }
        catch (Exception ex2) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)this.platform.getSqlTemplate().queryForObject("select CURRENT SCHEMA from sysibm.sysdummy1", String.class, new Object[0]));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        HashSet<String> pkColNames = new HashSet<String>();
        try (ResultSet pkData = null;){
            pkData = metaData.getPrimaryKeys(table.getName());
            while (pkData.next()) {
                Map values = this.readMetaData(pkData, this.getColumnsForPK());
                pkColNames.add((String)values.get("COLUMN_NAME"));
            }
        }
        boolean indexMatchesPk = true;
        for (int i2 = 0; i2 < index.getColumnCount(); ++i2) {
            if (pkColNames.contains(index.getColumn(i2).getName())) continue;
            indexMatchesPk = false;
            break;
        }
        return indexMatchesPk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enhanceTableMetaData(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        this.log.debug("about to read additional column data");
        Object sql = "SELECT NAME, IDENTITY, DEFAULT, DFTVALUE FROM QSYS2.SYSCOLUMNS WHERE TBNAME=?";
        if (StringUtils.isNotBlank((CharSequence)metaData.getSchemaPattern())) {
            sql = (String)sql + " AND DBNAME=?";
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement((String)sql);
            pstmt.setString(1, table.getName());
            if (StringUtils.isNotBlank((CharSequence)metaData.getSchemaPattern())) {
                pstmt.setString(2, metaData.getSchemaPattern());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String hasDefault;
                String columnName = rs.getString(1);
                Column column = table.getColumnWithName(columnName);
                if (column == null) continue;
                String isIdentity = rs.getString(2);
                if (isIdentity != null && isIdentity.startsWith("Y")) {
                    column.setAutoIncrement(true);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Found identity column {} on {}", (Object)columnName, (Object)table.getName());
                    }
                }
                if ((hasDefault = rs.getString(3)) != null && hasDefault.startsWith("Y")) {
                    column.setDefaultValue(rs.getString(4));
                    continue;
                }
                column.setDefaultValue(null);
            }
        }
        catch (Throwable throwable) {
            JdbcSqlTemplate.close(rs);
            JdbcSqlTemplate.close((PreparedStatement)pstmt);
            throw throwable;
        }
        JdbcSqlTemplate.close((ResultSet)rs);
        JdbcSqlTemplate.close((PreparedStatement)pstmt);
        this.log.debug("done reading additional column data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        LinkedHashMap indices = new LinkedHashMap();
        if (this.getPlatformInfo().isIndicesSupported()) {
            ResultSet indexData = null;
            try {
                indexData = metaData.getIndices(this.getTableNamePatternForConstraints(tableName), false, false);
                Collection columns = this.readColumns(metaData, tableName);
                while (indexData.next()) {
                    Map values = this.readMetaData(indexData, this.getColumnsForIndex());
                    String columnName = (String)values.get("COLUMN_NAME");
                    if (!this.a(columns, columnName)) continue;
                    this.readIndex(metaData, values, indices);
                }
            }
            catch (Throwable throwable) {
                this.close(indexData);
                throw throwable;
            }
            this.close(indexData);
        }
        return indices.values();
    }

    private boolean a(Collection<Column> columns, String targetColumn) {
        if (targetColumn == null || columns == null || columns.size() == 0) {
            return false;
        }
        boolean found = false;
        for (Column column : columns) {
            if (!targetColumn.equals(column.getName())) continue;
            found = true;
        }
        return found;
    }

    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT TRIGGER_NAME, TRIGGER_SCHEMA, EVENT_OBJECT_TABLE as TABLE_NAME, ACTION_TIMING as TRIGGER_TIME, EVENT_MANIPULATION as TRIGGER_TYPE, CREATED, ENABLED FROM QSYS2.SYSTRIGGERS WHERE EVENT_OBJECT_TABLE=? and EVENT_OBJECT_SCHEMA=?";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger a(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setSchemaName(row.getString("TRIGGER_SCHEMA"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(row.getString("ENABLED").equals("Y"));
                trigger.setTriggerType(Trigger.TriggerType.valueOf((String)row.getString("TRIGGER_TYPE")));
                trigger.setMetaData((Map)row);
                return trigger;
            }

            public /* synthetic */ Object mapRow(Row row) {
                return this.a(row);
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }

    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        boolean isIncludeRowIdentifierAsColumn = false;
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        if (sqlTemplate instanceof JdbcSqlTemplate) {
            isIncludeRowIdentifierAsColumn = ((JdbcSqlTemplate)sqlTemplate).getSettings().isIncludeRowIdentifierAsColumn();
        }
        if (isIncludeRowIdentifierAsColumn) {
            Column rrnColumn = new Column();
            rrnColumn.setName("RRN");
            rrnColumn.setMappedTypeCode(-5);
            table.addColumn(0, rrnColumn);
        }
        return table;
    }
}

