/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.ui.common.H;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.K;
import com.jumpmind.symmetric.console.ui.common.ap;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.vaadin.ui.common.ColumnVisibilityToggler;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class cR
extends ap
implements G<Object>,
H,
J {
    private static final long f = 1L;
    protected Button a;
    protected ComboBox<ProcessType> b;
    protected Checkbox c;
    protected Checkbox d;
    protected Grid<ProcessInfo> e;

    public cR(I controller) {
        super(controller, null, "The following table shows activity that is currently happening or has recently happened in this SymmetricDS node instance.");
    }

    @Override
    public void init() {
        if (this.e == null) {
            HorizontalLayout topLayout = new HorizontalLayout();
            Button refreshNow = as.createIconButton(K.REFRESH);
            refreshNow.addClickListener((ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]));
            topLayout.add(new Component[]{refreshNow});
            topLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{refreshNow});
            this.b = new ComboBox("Process Type");
            List<ProcessType> types = Arrays.asList(ProcessType.values());
            Collections.sort(types, (p1, p2) -> p1.toString().compareTo(p2.toString()));
            this.b.setItems((ComboBox.ItemFilter & Serializable)(type, filter) -> !CommonUiUtils.isFilteredOut((String)Objects.toString(type, null), (String)filter), types);
            this.b.setWidth("250px");
            this.b.setValue((Object)ProcessType.ANY);
            this.b.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e2 -> this.onRefresh(new Object[0]));
            topLayout.add(new Component[]{this.b});
            topLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.b});
            Span separator = new Span("");
            separator.setClassName("vrule");
            separator.setWidth(null);
            separator.setHeight("44px");
            topLayout.add(new Component[]{separator});
            topLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{separator});
            this.a = new Button(this.controller.getMessage("Interrupt", new Object[0]));
            this.a.addClickListener((ComponentEventListener & Serializable)event -> {
                String message = this.controller.getMessage("Interrupt this process?", new Object[0]);
                new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), message, this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                    for (ProcessInfo processInfo : this.e.getSelectedItems()) {
                        Thread thread = processInfo.getThread();
                        if (thread == null || !thread.isAlive()) continue;
                        this.log.info("Sending interrupt to " + String.valueOf(processInfo.getProcessType()) + " thread name " + thread.getName());
                        thread.interrupt();
                        String nodeId = this.controller.getSymmetricEngine().getNodeId();
                        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Interrupt Process", nodeId, processInfo.getSourceNodeId(), processInfo.getTargetNodeId(), processInfo.getProcessType().toString()));
                    }
                }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
            });
            this.a.setEnabled(false);
            topLayout.add(new Component[]{this.a});
            topLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.a});
            topLayout.addAndExpand(new Component[]{new Span()});
            this.c = new Checkbox("Active Only");
            this.c.setValue((Object)true);
            this.c.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e2 -> this.onRefresh(new Object[0]));
            topLayout.add(new Component[]{this.c});
            topLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.c});
            this.d = new Checkbox(this.controller.getMessage("Auto Refresh", new Object[0]));
            this.d.setValue((Object)true);
            this.d.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e2 -> this.onRefresh(new Object[0]));
            topLayout.add(new Component[]{this.d});
            topLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.d});
            ColumnVisibilityToggler columnVisibilityToggler = new ColumnVisibilityToggler();
            topLayout.add(new Component[]{columnVisibilityToggler});
            topLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{columnVisibilityToggler});
            this.content.add(new Component[]{topLayout});
            this.e = new Grid(ProcessInfo.class);
            this.e.setSizeFull();
            this.e.setPartNameGenerator((SerializableFunction & Serializable)item -> {
                if (item.getStatus() == ProcessInfo.ProcessStatus.ERROR) {
                    return "v-grid-row-marked";
                }
                return null;
            });
            Grid.Column type2 = this.e.getColumnByKey("processType").setFlexGrow(2);
            Grid.Column sourceNode = this.e.getColumnByKey("sourceNodeId");
            Grid.Column targetNode = this.e.getColumnByKey("targetNodeId");
            Grid.Column queue = this.e.getColumnByKey("queue");
            columnVisibilityToggler.addColumn(queue, "Queue").setVisible(false);
            this.e.removeColumnByKey("key");
            this.e.removeColumnByKey("thread");
            this.e.removeColumnByKey("threadData");
            this.e.removeColumnByKey("lastStatusChangeTime");
            columnVisibilityToggler.addColumn(this.e.getColumnByKey("currentLoadId"), "Current Load Id").setVisible(false);
            columnVisibilityToggler.addColumn(this.e.getColumnByKey("currentChannelId"), "Current Channel Id").setVisible(false);
            this.e.removeColumnByKey("currentBatchStartTime");
            columnVisibilityToggler.addColumn(this.e.addColumn((ValueProvider & Serializable)info -> as.formatDate(this.controller, info.getCurrentBatchStartTime())).setComparator((ValueProvider & Serializable)info -> info.getCurrentBatchStartTime()).setKey("currentBatchStartTime").setHeader("Current Batch Start Time"), "Current Batch Start Time").setVisible(false);
            this.e.removeColumnByKey("startTime");
            this.e.removeColumnByKey("endTime");
            Grid.Column startTime = this.e.addColumn((ValueProvider & Serializable)info -> as.formatDate(this.controller, info.getStartTime(), true)).setComparator((ValueProvider & Serializable)info -> info.getStartTime()).setHeader(this.controller.getMessage("Start Time", new Object[0])).setFlexGrow(1);
            Grid.Column endTime = this.e.addColumn((ValueProvider & Serializable)info -> as.formatDate(this.controller, info.getEndTime(), true)).setComparator((ValueProvider & Serializable)info -> info.getEndTime()).setHeader(this.controller.getMessage("End Time", new Object[0]));
            columnVisibilityToggler.addColumn(endTime, this.controller.getMessage("End Time", new Object[0])).setVisible(false);
            Grid.Column status = this.e.getColumnByKey("status").setFlexGrow(1);
            Grid.Column currentDataCount = this.e.getColumnByKey("currentDataCount");
            Grid.Column totalDataCount = this.e.getColumnByKey("totalDataCount");
            Grid.Column currentBatchCount = this.e.getColumnByKey("currentBatchCount");
            columnVisibilityToggler.addColumn(currentBatchCount, "Current Batch Count").setVisible(false);
            Grid.Column totalBatchCount = this.e.getColumnByKey("totalBatchCount");
            columnVisibilityToggler.addColumn(totalBatchCount, "Total Batch Count").setVisible(false);
            Grid.Column currentRowCount = this.e.getColumnByKey("currentRowCount");
            columnVisibilityToggler.addColumn(currentRowCount, "Current Row Count").setVisible(false);
            Grid.Column currentTableName = this.e.getColumnByKey("currentTableName").setHeader("Table").setFlexGrow(1);
            Grid.Column duration = this.e.addColumn((ValueProvider & Serializable)item -> {
                Date startDate = item.getStartTime();
                Date endDate = item.getEndTime();
                if (endDate == null) {
                    endDate = new Date();
                }
                return as.formatDuration(endDate.getTime() - startDate.getTime());
            }).setHeader("Duration").setFlexGrow(1);
            Grid.Column rowsPerSec = this.e.addColumn((ValueProvider & Serializable)info -> {
                Date startDate = info.getCurrentBatchStartTime();
                Date endDate = info.getEndTime();
                long dataCount = info.getCurrentDataCount();
                if (startDate == null) {
                    startDate = info.getStartTime();
                }
                if (endDate == null) {
                    endDate = new Date();
                }
                String value = "0";
                if (dataCount > 0L) {
                    try {
                        BigDecimal count = new BigDecimal(dataCount);
                        BigDecimal processingTime = new BigDecimal(endDate.getTime() - startDate.getTime());
                        MathContext mc = new MathContext(2, RoundingMode.HALF_UP);
                        DecimalFormat format = new DecimalFormat("#.##");
                        value = format.format(count.divide(processingTime, mc).multiply(new BigDecimal(1000), mc));
                    }
                    catch (ArithmeticException ex2) {
                        value = "div by 0";
                    }
                    catch (Exception ex3) {
                        this.log.error(ex3.getMessage(), (Throwable)ex3);
                        value = "err";
                    }
                }
                return value;
            }).setHeader("Rows/sec");
            Grid.Column threadName = this.e.addColumn((ValueProvider & Serializable)item -> {
                ProcessInfo.ThreadData threadData = item.getThreadData();
                if (threadData != null) {
                    return threadData.getThreadName();
                }
                return "";
            }).setHeader("Thread Name");
            columnVisibilityToggler.addColumn(threadName, "Thread Name").setVisible(false);
            Grid.Column threadTrace = this.e.addColumn((ValueProvider & Serializable)item -> {
                ProcessInfo.ThreadData threadData = item.getThreadData();
                if (threadData != null) {
                    return threadData.getStackTrace();
                }
                return "";
            }).setHeader("Thread Trace");
            columnVisibilityToggler.addColumn(threadTrace, "Thread Trace").setVisible(false);
            for (Grid.Column column : this.e.getColumns()) {
                column.setResizable(true);
            }
            this.e.setColumnOrder(new Grid.Column[]{type2, sourceNode, targetNode, queue, status, startTime, endTime, currentDataCount, totalDataCount, currentBatchCount, totalBatchCount, currentRowCount, currentTableName, duration, rowsPerSec, threadName, threadTrace, this.e.getColumnByKey("currentBatchId"), this.e.getColumnByKey("currentBatchStartTime"), this.e.getColumnByKey("currentChannelId"), this.e.getColumnByKey("currentLoadId"), this.e.getColumnByKey("bulkLoadFlag")});
            this.e.addSelectionListener((SelectionListener & Serializable)event -> {
                if (this.controller.getConsoleUser().hasPrivilegeWrite("Processes Screen")) {
                    ProcessInfo selectedItem = event.getFirstSelectedItem().orElse(null);
                    if (selectedItem != null) {
                        Thread thread = selectedItem.getThread();
                        this.a.setEnabled(thread != null && thread.isAlive());
                    } else {
                        this.a.setEnabled(false);
                    }
                    this.a.getElement().removeAttribute("title");
                } else {
                    this.a.setEnabled(false);
                    this.a.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                }
            });
            this.content.addAndExpand(new Component[]{this.e});
        }
    }

    @Override
    public Object onBackgroundDataRefresh(ISymmetricEngine engine) {
        return null;
    }

    @Override
    public void onBackgroundUIRefresh(Object backgroundData) {
        if (((Boolean)this.d.getValue()).booleanValue()) {
            this.a(this.controller.getSymmetricEngine());
        }
    }

    @Override
    public void onUIError(Throwable ex2) {
    }

    protected void a(ISymmetricEngine engine) {
        try {
            ArrayList<ProcessInfo> filteredInfos = new ArrayList<ProcessInfo>();
            List infos = engine.getStatisticManager().getProcessInfos();
            INodeService nodeService = engine.getNodeService();
            ProcessType selected = (ProcessType)this.b.getValue();
            for (ProcessInfo processInfo : infos) {
                if ((!((Boolean)this.c.getValue()).booleanValue() || processInfo.getEndTime() != null) && ((Boolean)this.c.getValue()).booleanValue() || selected != processInfo.getProcessType() && selected != ProcessType.ANY) continue;
                boolean show = true;
                if (processInfo.getStatus() == ProcessInfo.ProcessStatus.ERROR) {
                    Node node;
                    if (StringUtils.isNotBlank((CharSequence)processInfo.getSourceNodeId())) {
                        node = nodeService.findNode(processInfo.getSourceNodeId(), true);
                        boolean bl2 = show = node != null && node.isSyncEnabled();
                    }
                    if (show && StringUtils.isNotBlank((CharSequence)processInfo.getTargetNodeId()) && !"?".equals(processInfo.getTargetNodeId())) {
                        node = nodeService.findNode(processInfo.getTargetNodeId(), true);
                        boolean bl3 = show = node != null && node.isSyncEnabled();
                    }
                }
                if (!show) continue;
                filteredInfos.add(processInfo);
            }
            Set selectedItems = this.e.getSelectedItems();
            this.e.setItems(filteredInfos);
            if (!selectedItems.isEmpty()) {
                this.e.select((Object)((ProcessInfo)selectedItems.iterator().next()));
            }
        }
        catch (Exception ex2) {
            this.log.error(ex2.getMessage(), (Throwable)ex2);
        }
    }

    @Override
    public boolean onExit(Runnable exitClosure) {
        return true;
    }

    @Override
    public String getTitleKey() {
        return "Process Info";
    }

    @Override
    public void onRefresh(Object ... params) {
        this.a(this.controller.getSymmetricEngine());
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_processes";
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$init$9b1b5227$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$9b1b5227$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$ConfirmEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {
                    for (ProcessInfo processInfo : this.e.getSelectedItems()) {
                        Thread thread = processInfo.getThread();
                        if (thread == null || !thread.isAlive()) continue;
                        this.log.info("Sending interrupt to " + String.valueOf(processInfo.getProcessType()) + " thread name " + thread.getName());
                        thread.interrupt();
                        String nodeId = this.controller.getSymmetricEngine().getNodeId();
                        this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Interrupt Process", nodeId, processInfo.getSourceNodeId(), processInfo.getTargetNodeId(), processInfo.getProcessType().toString()));
                    }
                };
            }
            case "lambda$init$9b1b5227$3": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/confirmdialog/ConfirmDialog$CancelEvent;)V")) break;
                return (ComponentEventListener & Serializable)e2 -> {};
            }
            case "lambda$init$ba6e7b7d$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)info -> info.getCurrentBatchStartTime();
            }
            case "lambda$init$9b1b5227$4": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    String message = this.controller.getMessage("Interrupt this process?", new Object[0]);
                    new ConfirmDialog(this.controller.getMessage("Confirm", new Object[0]), message, this.controller.getMessage("Ok", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                        for (ProcessInfo processInfo : this.e.getSelectedItems()) {
                            Thread thread = processInfo.getThread();
                            if (thread == null || !thread.isAlive()) continue;
                            this.log.info("Sending interrupt to " + String.valueOf(processInfo.getProcessType()) + " thread name " + thread.getName());
                            thread.interrupt();
                            String nodeId = this.controller.getSymmetricEngine().getNodeId();
                            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(this.controller.getConsoleUser().getUserId(), "Interrupt Process", nodeId, processInfo.getSourceNodeId(), processInfo.getTargetNodeId(), processInfo.getProcessType().toString()));
                        }
                    }, this.controller.getMessage("Cancel", new Object[0]), (ComponentEventListener & Serializable)e2 -> {}).open();
                };
            }
            case "lambda$init$ba6e7b7d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)info -> as.formatDate(this.controller, info.getCurrentBatchStartTime());
            }
            case "lambda$init$3fab9f70$3": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)e2 -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$3fed5817$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/String;")) break;
                return (SerializableFunction & Serializable)item -> {
                    if (item.getStatus() == ProcessInfo.ProcessStatus.ERROR) {
                        return "v-grid-row-marked";
                    }
                    return null;
                };
            }
            case "lambda$init$19678d72$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)info -> as.formatDate(this.controller, info.getEndTime(), true);
            }
            case "lambda$init$19678d72$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)info -> info.getEndTime();
            }
            case "lambda$init$51cd864c$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)item -> {
                    Date startDate = item.getStartTime();
                    Date endDate = item.getEndTime();
                    if (endDate == null) {
                        endDate = new Date();
                    }
                    return as.formatDuration(endDate.getTime() - startDate.getTime());
                };
            }
            case "lambda$init$a325738b$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)item -> {
                    ProcessInfo.ThreadData threadData = item.getThreadData();
                    if (threadData != null) {
                        return threadData.getThreadName();
                    }
                    return "";
                };
            }
            case "lambda$init$3b648113$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)info -> {
                    Date startDate = info.getCurrentBatchStartTime();
                    Date endDate = info.getEndTime();
                    long dataCount = info.getCurrentDataCount();
                    if (startDate == null) {
                        startDate = info.getStartTime();
                    }
                    if (endDate == null) {
                        endDate = new Date();
                    }
                    String value = "0";
                    if (dataCount > 0L) {
                        try {
                            BigDecimal count = new BigDecimal(dataCount);
                            BigDecimal processingTime = new BigDecimal(endDate.getTime() - startDate.getTime());
                            MathContext mc = new MathContext(2, RoundingMode.HALF_UP);
                            DecimalFormat format = new DecimalFormat("#.##");
                            value = format.format(count.divide(processingTime, mc).multiply(new BigDecimal(1000), mc));
                        }
                        catch (ArithmeticException ex2) {
                            value = "div by 0";
                        }
                        catch (Exception ex3) {
                            this.log.error(ex3.getMessage(), (Throwable)ex3);
                            value = "err";
                        }
                    }
                    return value;
                };
            }
            case "lambda$init$ccb02a3f$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)item -> {
                    ProcessInfo.ThreadData threadData = item.getThreadData();
                    if (threadData != null) {
                        return threadData.getStackTrace();
                    }
                    return "";
                };
            }
            case "lambda$init$3fab9f70$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)e2 -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$3fab9f70$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/HasValue$ValueChangeListener") || !lambda.getFunctionalInterfaceMethodName().equals("valueChanged") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/HasValue$ValueChangeEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;)V")) break;
                return (HasValue.ValueChangeListener & Serializable)e2 -> this.onRefresh(new Object[0]);
            }
            case "lambda$init$ea965d97$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/combobox/ComboBox$ItemFilter") || !lambda.getFunctionalInterfaceMethodName().equals("test") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;Ljava/lang/String;)Z") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessType;Ljava/lang/String;)Z")) break;
                return (ComboBox.ItemFilter & Serializable)(type, filter) -> !CommonUiUtils.isFilteredOut((String)Objects.toString(type, null), (String)filter);
            }
            case "lambda$init$4017c30b$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/lang/Object;")) break;
                return (ValueProvider & Serializable)info -> as.formatDate(this.controller, info.getStartTime(), true);
            }
            case "lambda$init$4017c30b$2": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/ProcessInfo;)Ljava/util/Date;")) break;
                return (ValueProvider & Serializable)info -> info.getStartTime();
            }
            case "lambda$init$bfb64eaf$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/data/selection/SelectionListener") || !lambda.getFunctionalInterfaceMethodName().equals("selectionChange") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/ProcessInfoPanel") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/data/selection/SelectionEvent;)V")) break;
                return (SelectionListener & Serializable)event -> {
                    if (this.controller.getConsoleUser().hasPrivilegeWrite("Processes Screen")) {
                        ProcessInfo selectedItem = event.getFirstSelectedItem().orElse(null);
                        if (selectedItem != null) {
                            Thread thread = selectedItem.getThread();
                            this.a.setEnabled(thread != null && thread.isAlive());
                        } else {
                            this.a.setEnabled(false);
                        }
                        this.a.getElement().removeAttribute("title");
                    } else {
                        this.a.setEnabled(false);
                        this.a.getElement().setAttribute("title", String.format("Your role '%s' does not have the privileges needed for this action.", this.controller.getConsoleUser().getRole()));
                    }
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

