/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class ao
extends R<TriggerRouter> {
    private static final long serialVersionUID = 1L;
    private static final String CAPTURE_ID = "captureId";
    Select<String> captureId;
    Select<String> routerId;
    String oldTriggerId;
    String oldRouterId;

    public ao(I controller, Set<TriggerRouter> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            TriggerRouter triggerRouter = (TriggerRouter)this.itemSet.iterator().next();
            this.oldTriggerId = triggerRouter.getTriggerId();
            this.oldRouterId = triggerRouter.getRouterId();
        }
        this.binder = new Binder(TriggerRouter.class);
        ArrayList<String> triggerIdList = new ArrayList<String>();
        ITriggerRouterService triggerRouterService = this.controller.getSymmetricEngine().getTriggerRouterService();
        for (Trigger trigger : triggerRouterService.getTriggers()) {
            triggerIdList.add(trigger.getTriggerId());
        }
        this.captureId = new Select();
        this.captureId.setItems(triggerIdList);
        this.captureId.setId(CAPTURE_ID);
        this.formatComboBox(this.captureId);
        this.binder.forField(this.captureId).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Table Capture")).bind("triggerId");
        this.captureId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)this.captureId, this.controller.getMessage("Table Capture", new Object[0])));
        ArrayList<String> routerIdList = new ArrayList<String>();
        String firstRouterId = null;
        for (Router router : triggerRouterService.getRouters()) {
            routerIdList.add(router.getRouterId());
            if (firstRouterId != null) continue;
            firstRouterId = router.getRouterId();
        }
        this.routerId = new Select();
        this.routerId.setItems(routerIdList);
        this.routerId.setId("routerId");
        this.formatComboBox(this.routerId);
        this.binder.forField(this.routerId).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Router")).bind("routerId");
        this.routerId.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (!routerIdList.contains(event.getValue()) && routerIdList.contains(event.getOldValue())) {
                this.routerId.setValue((Object)((String)event.getOldValue()));
            }
        });
        this.routerId.setValue((Object)firstRouterId);
        this.routerId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)this.routerId, this.controller.getMessage("Router", new Object[0])));
        TextArea initialLoadSelect = new TextArea();
        initialLoadSelect.setId("initialLoadSelect");
        initialLoadSelect.setWidth("80%");
        initialLoadSelect.setHeight("124px");
        this.binder.forField((HasValue)initialLoadSelect).bind("initialLoadSelect");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)initialLoadSelect, this.controller.getMessage("Initial Load Select", new Object[0])));
        this.advancedFieldList = new ArrayList();
        TextArea initialLoadDeleteStmt = new TextArea();
        initialLoadDeleteStmt.setId("initialLoadDeleteStmt");
        initialLoadDeleteStmt.setWidth("80%");
        initialLoadDeleteStmt.setHeight("124px");
        this.binder.forField((HasValue)initialLoadDeleteStmt).bind("initialLoadDeleteStmt");
        initialLoadDeleteStmt.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)initialLoadDeleteStmt, this.controller.getMessage("Initial Load Delete", new Object[0])));
        TextField initialLoadOrder = new TextField();
        initialLoadOrder.setWidth("8em");
        if (this.isBulk) {
            initialLoadOrder.getStyle().set("padding-left", "16px");
        }
        initialLoadOrder.setId("initialLoadOrder");
        this.binder.forField((HasValue)initialLoadOrder).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Initial Load Order must be an integer", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Initial Load Order")).bind("initialLoadOrder");
        initialLoadOrder.setRequiredIndicatorVisible(!this.isBulk);
        boolean isInitialLoadOrderSet = this.newItemFlag || this.isBulk || ((TriggerRouter)this.itemSet.iterator().next()).getInitialLoadOrder() > -1;
        initialLoadOrder.setEnabled(isInitialLoadOrderSet);
        Checkbox enabledForInitialLoad = new Checkbox(this.controller.getMessage("Enabled for initial load", new Object[0]));
        enabledForInitialLoad.setValue((Object)isInitialLoadOrderSet);
        enabledForInitialLoad.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (((Boolean)event.getValue()).booleanValue()) {
                initialLoadOrder.setEnabled(true);
                String initialLoadOrderValue = initialLoadOrder.getValue();
                if (initialLoadOrderValue != null && initialLoadOrderValue.equals("-1")) {
                    initialLoadOrder.setValue("50");
                }
            } else {
                initialLoadOrder.setEnabled(false);
                initialLoadOrder.setValue("-1");
            }
        });
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)initialLoadOrder, this.controller.getMessage("Initial Load Order", new Object[0]), (Component)enabledForInitialLoad));
        Checkbox enabled = new Checkbox();
        enabled.setId("enabled");
        this.binder.forField((HasValue)enabled).bind("enabled");
        enabled.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)enabled, this.controller.getMessage("Enabled", new Object[0])));
        Checkbox pingBackEnabled = new Checkbox();
        pingBackEnabled.setId("pingBackEnabled");
        this.binder.forField((HasValue)pingBackEnabled).bind("pingBackEnabled");
        pingBackEnabled.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)pingBackEnabled, this.controller.getMessage("Ping Back Enabled", new Object[0])));
        Select dataRefreshType = new Select();
        dataRefreshType.setItems(Arrays.asList("auto", "differences", "full"));
        dataRefreshType.setId("dataRefreshType");
        dataRefreshType.setRequiredIndicatorVisible(false);
        dataRefreshType.setEmptySelectionAllowed(true);
        this.binder.forField((HasValue)dataRefreshType).bind("dataRefreshType");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)dataRefreshType, this.controller.getMessage("Data Refresh Type", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        TriggerRouter triggerRouter = new TriggerRouter();
        triggerRouter.setCreateTime(new Date());
        triggerRouter.setLastUpdateTime(new Date());
        triggerRouter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        this.newItem = triggerRouter;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            if (!this.isBulk) {
                TriggerRouter triggerRouter;
                if (!this.newItemFlag) {
                    boolean isRename;
                    TriggerRouter tr = (TriggerRouter)this.itemSet.iterator().next();
                    boolean bl2 = isRename = !tr.getTriggerId().equals(this.captureId.getValue()) || !tr.getRouterId().equals(this.routerId.getValue());
                    if (isRename) {
                        this.generateNewItem();
                        triggerRouter = (TriggerRouter)this.newItem;
                    } else {
                        triggerRouter = (TriggerRouter)this.itemSet.iterator().next();
                    }
                    try {
                        this.binder.writeBean((Object)triggerRouter);
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((TriggerRouter)this.newItem));
                    }
                    catch (ValidationException e4) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    triggerRouter = (TriggerRouter)this.newItem;
                }
                if (!triggerRouter.isEnabled()) {
                    this.formListener.getFormLayout().enableCancelShortcut(false);
                    new ConfirmDialog(this.controller.getMessage("Disable Table Routing?", new Object[0]), this.controller.getMessage("Disabled table routing means that changes will no longer be captured or routed for this table capture/router combination.  Are you sure it should be disabled?", new Object[0]), this.controller.getMessage("Yes", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                        this.saveTriggerRouters(Collections.singleton(triggerRouter));
                        if (this.formListener != null) {
                            this.formListener.closeForm(true);
                        }
                    }, this.controller.getMessage("No", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.formListener.getFormLayout().enableCancelShortcut(true)).open();
                    return false;
                }
                this.saveTriggerRouters(Collections.singleton(triggerRouter));
            } else {
                for (TriggerRouter triggerRouter : this.itemSet) {
                    this.saveFieldsToTriggerRouter(this.fieldList, triggerRouter);
                    this.saveFieldsToTriggerRouter(this.advancedFieldList, triggerRouter);
                }
                this.saveTriggerRouters(this.itemSet);
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToTriggerRouter(List<R.a> fields, TriggerRouter triggerRouter) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "initialLoadSelect": {
                    triggerRouter.setInitialLoadSelect((String)field.getValue());
                    break;
                }
                case "initialLoadDeleteStmt": {
                    triggerRouter.setInitialLoadDeleteStmt((String)field.getValue());
                    break;
                }
                case "initialLoadOrder": {
                    triggerRouter.setInitialLoadOrder(Integer.parseInt((String)field.getValue()));
                    break;
                }
                case "enabled": {
                    triggerRouter.setEnabled(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "pingBackEnabled": {
                    triggerRouter.setPingBackEnabled(((Boolean)field.getValue()).booleanValue());
                }
                case "dataRefreshType": {
                    triggerRouter.setDataRefreshType((String)field.getValue());
                }
            }
        }
    }

    private void saveTriggerRouters(final Set<TriggerRouter> triggerRouters) {
        M<Object> dialog = new M<Object>("Saving Table Routing...", new M.a<Object>(){
            boolean lockNotAcquired;
            Lock lock;

            @Override
            public Object doWork() {
                ITriggerRouterService triggerRouterService = ao.this.controller.getSymmetricEngine().getTriggerRouterService();
                boolean syncTriggers = !ao.this.controller.getSymmetricEngine().getParameterService().is("auto.sync.triggers.after.config.change");
                HashSet<Trigger> savedTriggers = new HashSet<Trigger>();
                String myGroupId = ao.this.controller.getSymmetricEngine().getParameterService().getNodeGroupId();
                boolean isRename = false;
                for (TriggerRouter triggerRouter : triggerRouters) {
                    triggerRouter.setLastUpdateBy(ao.this.controller.getConsoleUser().getUserId());
                    if (!(ao.this.oldTriggerId == null || ao.this.oldRouterId == null || ao.this.oldTriggerId.equals(triggerRouter.getTriggerId()) && ao.this.oldRouterId.equals(triggerRouter.getRouterId()))) {
                        triggerRouterService.renameTriggerRouter(ao.this.oldTriggerId, ao.this.oldRouterId, triggerRouter);
                        isRename = true;
                    }
                    if (!syncTriggers || !myGroupId.equals(triggerRouter.getRouter().getNodeGroupLink().getSourceNodeGroupId())) continue;
                    savedTriggers.add(triggerRouter.getTrigger());
                }
                if (!isRename) {
                    if (ao.this.newItemFlag || !ao.this.isBulk && ao.this.oldTriggerId == null && ao.this.oldRouterId == null) {
                        triggerRouterService.insertTriggerRouters((Collection)triggerRouters);
                    } else {
                        triggerRouterService.updateTriggerRouters((Collection)triggerRouters);
                    }
                }
                if (syncTriggers && savedTriggers.size() > 0 && !triggerRouterService.syncTriggers(new ArrayList(savedTriggers), null, false, true)) {
                    this.lockNotAcquired = true;
                    this.lock = (Lock)ao.this.controller.getSymmetricEngine().getClusterService().findLocks().get("SyncTriggers");
                }
                ao.this.addEvent(ao.this.newItemFlag ? "Table Routing Created" : "Table Routing Modified", triggerRouters.stream().map(TriggerRouter::toString).collect(Collectors.toSet()));
                return null;
            }

            @Override
            public void doUI(Object data) {
                if (this.lockNotAcquired) {
                    as.notifySyncTriggersLockNotAcquired(this.lock);
                }
                if (ao.this.formListener != null) {
                    ao.this.formListener.formSaved();
                }
            }
        }, this.controller.getBackgroundRefresherService());
        dialog.show();
    }

    @Override
    public void delete() {
        M<Object> dialog = new M<Object>("Deleting Table Routing...", new M.a<Object>(){
            boolean lockNotAcquired;
            Lock lock;

            @Override
            public Object doWork() {
                boolean syncTriggers = !ao.this.controller.getSymmetricEngine().getParameterService().is("auto.sync.triggers.after.config.change");
                HashSet<Trigger> savedTriggers = new HashSet<Trigger>();
                String myGroupId = ao.this.controller.getSymmetricEngine().getParameterService().getNodeGroupId();
                ITriggerRouterService triggerRouterService = ao.this.controller.getSymmetricEngine().getTriggerRouterService();
                triggerRouterService.deleteTriggerRouters((Collection)ao.this.itemSet);
                for (TriggerRouter triggerRouter : ao.this.itemSet) {
                    if (!syncTriggers || !myGroupId.equals(triggerRouter.getRouter().getNodeGroupLink().getSourceNodeGroupId())) continue;
                    savedTriggers.add(triggerRouter.getTrigger());
                }
                if (syncTriggers && savedTriggers.size() > 0 && !triggerRouterService.syncTriggers(new ArrayList(savedTriggers), null, false, true)) {
                    this.lockNotAcquired = true;
                    this.lock = (Lock)ao.this.controller.getSymmetricEngine().getClusterService().findLocks().get("SyncTriggers");
                }
                ao.this.addEvent("Table Routing Deleted", ao.this.itemSet.stream().map(TriggerRouter::toString).collect(Collectors.toSet()));
                return null;
            }

            @Override
            public void doUI(Object data) {
                if (this.lockNotAcquired) {
                    as.notifySyncTriggersLockNotAcquired(this.lock);
                }
                if (ao.this.formListener != null) {
                    ao.this.formListener.formDeleted();
                }
            }
        }, this.controller.getBackgroundRefresherService());
        dialog.show();
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        if (!this.isBulk) {
            orderedFields.add(CAPTURE_ID);
            orderedFields.add("routerId");
        } else {
            orderedFields.add("initialLoadOrder");
        }
        orderedFields.add("initialLoadSelect");
        orderedFields.add("initialLoadDeleteStmt");
        if (!this.isBulk) {
            orderedFields.add("initialLoadOrder");
            orderedFields.add("enabled");
        }
        orderedFields.add("pingBackEnabled");
        if (this.isBulk) {
            orderedFields.add("enabled");
        }
        orderedFields.add("dataRefreshType");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return CAPTURE_ID;
    }

    @Override
    public String getHelpSectionName() {
        return "_table_routing";
    }
}

