/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.LoadFilter;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ILoadFilterService;
import org.jumpmind.symmetric.service.impl.LoadFilterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class ae
extends R<LoadFilterService.LoadFilterNodeGroupLink> {
    private static final long serialVersionUID = 1L;
    private String originalId;

    public ae(I controller, Set<LoadFilterService.LoadFilterNodeGroupLink> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((LoadFilterService.LoadFilterNodeGroupLink)this.itemSet.iterator().next()).getLoadFilterId();
        }
        this.binder = new Binder(LoadFilterService.LoadFilterNodeGroupLink.class);
        TextField loadFilterId = new TextField();
        loadFilterId.setId("loadFilterId");
        loadFilterId.setClassName("input-long");
        this.binder.forField((HasValue)loadFilterId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Filter Id")).bind("loadFilterId");
        loadFilterId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)loadFilterId, this.controller.getMessage("Filter Id", new Object[0])));
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        Select nodeGroupLink = new Select();
        nodeGroupLink.setItems((Collection)configService.getNodeGroupLinks(false));
        nodeGroupLink.setId("nodeGroupLink");
        this.formatComboBox(nodeGroupLink);
        this.binder.forField((HasValue)nodeGroupLink).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Group Link")).bind("nodeGroupLink");
        nodeGroupLink.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)nodeGroupLink, this.controller.getMessage("Group Link", new Object[0])));
        Select loadFilterType = new Select();
        loadFilterType.setItems((Object[])LoadFilter.LoadFilterType.values());
        loadFilterType.setId("loadFilterType");
        this.formatComboBox(loadFilterType);
        this.binder.forField((HasValue)loadFilterType).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Type")).bind("loadFilterType");
        loadFilterType.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)loadFilterType, this.controller.getMessage("Type", new Object[0])));
        this.advancedFieldList = new ArrayList();
        TextField targetCatalogName = new TextField();
        targetCatalogName.setId("targetCatalogName");
        targetCatalogName.setClassName("input-long");
        this.binder.forField((HasValue)targetCatalogName).bind("targetCatalogName");
        targetCatalogName.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)targetCatalogName, this.controller.getMessage("Target Catalog", new Object[0])));
        TextField targetSchemaName = new TextField();
        targetSchemaName.setId("targetSchemaName");
        targetSchemaName.setClassName("input-long");
        this.binder.forField((HasValue)targetSchemaName).bind("targetSchemaName");
        targetSchemaName.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)targetSchemaName, this.controller.getMessage("Target Schema", new Object[0])));
        TextField targetTableName = new TextField();
        targetTableName.setId("targetTableName");
        targetTableName.setClassName("input-long");
        this.binder.forField((HasValue)targetTableName).withValidator((SerializablePredicate & Serializable)value -> !value.equals(targetTableName.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Target Table")).bind("targetTableName");
        targetTableName.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)targetTableName, this.controller.getMessage("Target Table", new Object[0])));
        Checkbox filterOnUpdate = new Checkbox();
        filterOnUpdate.setId("filterOnUpdate");
        this.binder.forField((HasValue)filterOnUpdate).bind("filterOnUpdate");
        filterOnUpdate.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)filterOnUpdate, this.controller.getMessage("Filter on Update", new Object[0])));
        Checkbox filterOnInsert = new Checkbox();
        filterOnInsert.setId("filterOnInsert");
        this.binder.forField((HasValue)filterOnInsert).bind("filterOnInsert");
        filterOnInsert.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)filterOnInsert, this.controller.getMessage("Filter on Insert", new Object[0])));
        Checkbox filterOnDelete = new Checkbox();
        filterOnDelete.setId("filterOnDelete");
        this.binder.forField((HasValue)filterOnDelete).bind("filterOnDelete");
        filterOnDelete.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)filterOnDelete, this.controller.getMessage("Filter on Delete", new Object[0])));
        TextField loadFilterOrder = new TextField();
        loadFilterOrder.setId("loadFilterOrder");
        loadFilterOrder.setClassName("input-long");
        this.binder.forField((HasValue)loadFilterOrder).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Filter Order must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Filter Order")).bind("loadFilterOrder");
        loadFilterOrder.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)loadFilterOrder, this.controller.getMessage("Filter Order", new Object[0])));
        Checkbox failOnError = new Checkbox();
        failOnError.setId("failOnError");
        this.binder.forField((HasValue)failOnError).bind("failOnError");
        failOnError.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)failOnError, this.controller.getMessage("Fail On Error", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        this.newItem = new LoadFilterService.LoadFilterNodeGroupLink();
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            ILoadFilterService loadFilterService = this.controller.getSymmetricEngine().getLoadFilterService();
            if (!this.isBulk) {
                LoadFilterService.LoadFilterNodeGroupLink loadFilter;
                if (!this.newItemFlag) {
                    try {
                        this.binder.writeBean((Object)((LoadFilterService.LoadFilterNodeGroupLink)this.itemSet.iterator().next()));
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    loadFilter = (LoadFilterService.LoadFilterNodeGroupLink)this.itemSet.iterator().next();
                    loadFilter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    if (saveAsCopy) {
                        loadFilterService.saveLoadFilterAsCopy(loadFilter);
                    } else if (this.originalId == null || this.originalId.equals(loadFilter.getLoadFilterId())) {
                        loadFilterService.saveLoadFilter(loadFilter);
                    } else {
                        loadFilterService.renameLoadFilter(this.originalId, loadFilter);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((LoadFilterService.LoadFilterNodeGroupLink)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    loadFilter = (LoadFilterService.LoadFilterNodeGroupLink)this.newItem;
                    loadFilter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    loadFilterService.saveLoadFilter(loadFilter);
                }
                this.addEvent(this.newItemFlag ? "Load Filter Created" : "Load Filter Modified", loadFilter.getLoadFilterId());
            } else {
                for (LoadFilterService.LoadFilterNodeGroupLink loadFilter : this.itemSet) {
                    this.saveFieldsToLoadFilter(this.fieldList, loadFilter);
                    this.saveFieldsToLoadFilter(this.advancedFieldList, loadFilter);
                    loadFilter.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    loadFilterService.saveLoadFilter(loadFilter);
                }
                this.addEvent("Load Filter Modified", this.itemSet.stream().map(LoadFilter::getLoadFilterId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToLoadFilter(List<R.a> fields, LoadFilterService.LoadFilterNodeGroupLink loadFilter) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "nodeGroupLink": {
                    loadFilter.setNodeGroupLink((NodeGroupLink)field.getValue());
                    break;
                }
                case "loadFilterType": {
                    loadFilter.setLoadFilterType((LoadFilter.LoadFilterType)field.getValue());
                    break;
                }
                case "targetCatalogName": {
                    loadFilter.setTargetCatalogName((String)field.getValue());
                    break;
                }
                case "targetSchemaName": {
                    loadFilter.setTargetSchemaName((String)field.getValue());
                    break;
                }
                case "targetTableName": {
                    loadFilter.setTargetTableName((String)field.getValue());
                    break;
                }
                case "filterOnUpdate": {
                    loadFilter.setFilterOnUpdate(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "filterOnInsert": {
                    loadFilter.setFilterOnInsert(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "filterOnDelete": {
                    loadFilter.setFilterOnDelete(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "loadFilterOrder": {
                    loadFilter.setLoadFilterOrder(Integer.parseInt((String)field.getValue()));
                    break;
                }
                case "failOnError": {
                    loadFilter.setFailOnError(((Boolean)field.getValue()).booleanValue());
                }
            }
        }
    }

    @Override
    public void delete() {
        ILoadFilterService loadFilterService = this.controller.getSymmetricEngine().getLoadFilterService();
        for (LoadFilterService.LoadFilterNodeGroupLink groupLink : this.itemSet) {
            loadFilterService.deleteLoadFilter(groupLink.getLoadFilterId());
        }
        this.addEvent("Load Filter Deleted", this.itemSet.stream().map(LoadFilter::getLoadFilterId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("loadFilterId");
        orderedFields.add("nodeGroupLink");
        orderedFields.add("loadFilterType");
        orderedFields.add("targetCatalogName");
        orderedFields.add("targetSchemaName");
        orderedFields.add("targetTableName");
        orderedFields.add("filterOnUpdate");
        orderedFields.add("filterOnInsert");
        orderedFields.add("filterOnDelete");
        orderedFields.add("loadFilterOrder");
        orderedFields.add("failOnError");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "loadFilterId";
    }

    @Override
    public String getHelpSectionName() {
        return "_load_filters";
    }
}

