/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.google.gson.Gson;
import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Grouplet;
import org.jumpmind.symmetric.service.IGroupletService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class ab
extends R<Grouplet> {
    private static final long serialVersionUID = 1L;
    private Grouplet originalGrouplet;

    public ab(I controller, Set<Grouplet> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            Gson gson = new Gson();
            this.originalGrouplet = (Grouplet)gson.fromJson(gson.toJson(this.itemSet.iterator().next(), Grouplet.class), Grouplet.class);
        }
        this.binder = new Binder(Grouplet.class);
        TextField groupletId = new TextField();
        groupletId.setId("groupletId");
        this.binder.forField((HasValue)groupletId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Grouplet Id")).bind("groupletId");
        groupletId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)groupletId, this.controller.getMessage("Grouplet Id", new Object[0])));
        ArrayList<Grouplet.GroupletLinkPolicy> policyList = new ArrayList<Grouplet.GroupletLinkPolicy>();
        policyList.add(Grouplet.GroupletLinkPolicy.I);
        policyList.add(Grouplet.GroupletLinkPolicy.E);
        Select groupletLinkPolicy = new Select();
        groupletLinkPolicy.setItems(policyList);
        groupletLinkPolicy.setItemLabelGenerator((ItemLabelGenerator & Serializable)policy -> {
            if (policy == Grouplet.GroupletLinkPolicy.I) {
                return "Inclusive";
            }
            if (policy == Grouplet.GroupletLinkPolicy.E) {
                return "Exclusive";
            }
            return "";
        });
        groupletLinkPolicy.setId("groupletLinkPolicy");
        this.formatComboBox(groupletLinkPolicy);
        this.binder.forField((HasValue)groupletLinkPolicy).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Link Policy")).bind("groupletLinkPolicy");
        groupletLinkPolicy.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)groupletLinkPolicy, this.controller.getMessage("Link Policy", new Object[0])));
        this.advancedFieldList = new ArrayList();
        TextArea description = new TextArea();
        description.setId("description");
        description.setHeight("102px");
        description.setWidth("30em");
        this.binder.forField((HasValue)description).bind("description");
        description.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)description, this.controller.getMessage("Description", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        this.newItem = new Grouplet();
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            IGroupletService groupletService = this.controller.getSymmetricEngine().getGroupletService();
            if (!this.isBulk) {
                Grouplet grouplet;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((Grouplet)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((Grouplet)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    grouplet = saveAsCopy ? (Grouplet)this.newItem : (Grouplet)this.itemSet.iterator().next();
                    grouplet.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    if (saveAsCopy) {
                        groupletService.saveGroupletAsCopy(grouplet);
                    } else if (this.originalGrouplet == null || this.originalGrouplet.getGroupletId().equals(grouplet.getGroupletId())) {
                        groupletService.saveGrouplet(grouplet);
                    } else {
                        groupletService.renameGrouplet(this.originalGrouplet, grouplet);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((Grouplet)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    grouplet = (Grouplet)this.newItem;
                    grouplet.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    groupletService.saveGrouplet(grouplet);
                }
                this.addEvent(this.newItemFlag ? "Grouplet Created" : "Grouplet Modified", grouplet.getGroupletId());
            } else {
                for (Grouplet grouplet : this.itemSet) {
                    this.saveFieldsToGrouplet(this.fieldList, grouplet);
                    this.saveFieldsToGrouplet(this.advancedFieldList, grouplet);
                    grouplet.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    groupletService.saveGrouplet(grouplet);
                }
                this.addEvent("Grouplet Modified", this.itemSet.stream().map(Grouplet::getGroupletId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToGrouplet(List<R.a> fields, Grouplet grouplet) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "groupletLinkPolicy": {
                    grouplet.setGroupletLinkPolicy((Grouplet.GroupletLinkPolicy)field.getValue());
                    break;
                }
                case "description": {
                    grouplet.setDescription((String)field.getValue());
                }
            }
        }
    }

    @Override
    public void delete() {
        IGroupletService groupletService = this.controller.getSymmetricEngine().getGroupletService();
        for (Grouplet grouplet : this.itemSet) {
            groupletService.deleteGrouplet(grouplet);
        }
        this.addEvent("Grouplet Deleted", this.itemSet.stream().map(Grouplet::getGroupletId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("groupletId");
        orderedFields.add("groupletLinkPolicy");
        orderedFields.add("description");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "groupletId";
    }
}

