/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.aa;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class Z
extends R<NodeGroup> {
    private static final long serialVersionUID = 1L;
    private TextField nodeGroupId;
    private boolean canDelete;

    public Z(I controller, Set<NodeGroup> itemSet, boolean newItemFlag, boolean deleteFlag, boolean canDelete) {
        super(controller, itemSet, newItemFlag, deleteFlag);
        this.canDelete = canDelete;
    }

    @Override
    public void initFields() {
        this.binder = new Binder(NodeGroup.class);
        this.nodeGroupId = new TextField();
        this.nodeGroupId.setId("nodeGroupId");
        this.binder.forField((HasValue)this.nodeGroupId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Group Id")).bind("nodeGroupId");
        this.nodeGroupId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)this.nodeGroupId, this.controller.getMessage("Group Id", new Object[0])));
        this.advancedFieldList = new ArrayList();
        TextArea description = new TextArea();
        description.setId("description");
        description.setHeight("102px");
        description.setWidth("30em");
        this.binder.forField((HasValue)description).bind("description");
        description.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)description, this.controller.getMessage("Description", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        NodeGroup group = new NodeGroup();
        group.setNodeGroupId("");
        group.setDescription("");
        this.newItem = group;
    }

    private boolean canEditName() {
        if (!this.isBulk && !this.newItemFlag) {
            IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
            Set oldGroupList = this.itemSet;
            NodeGroup oldNode = (NodeGroup)this.newItem;
            for (NodeGroup old : oldGroupList) {
                oldNode = new NodeGroup(old.getNodeGroupId());
            }
            Boolean canEditName = this.canDelete;
            String groupId = oldNode.getNodeGroupId();
            String newId = this.nodeGroupId.getValue();
            if (!canEditName.booleanValue()) {
                if (!groupId.equals(newId)) {
                    this.groupIdWarning();
                } else {
                    canEditName = true;
                }
            } else {
                configService.deleteNodeGroup(oldNode.getNodeGroupId());
            }
            return canEditName;
        }
        return true;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        Boolean editName = this.canEditName();
        if (editName.booleanValue() && this.binder.validate().isOk()) {
            IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
            if (!this.isBulk) {
                NodeGroup nodeGroup;
                if (!this.newItemFlag) {
                    try {
                        this.binder.writeBean((Object)((NodeGroup)this.itemSet.iterator().next()));
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    nodeGroup = (NodeGroup)this.itemSet.iterator().next();
                } else {
                    try {
                        this.binder.writeBean((Object)((NodeGroup)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    nodeGroup = (NodeGroup)this.newItem;
                }
                nodeGroup.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                configService.saveNodeGroup(nodeGroup);
                this.addEvent(this.newItemFlag ? "Group Created" : "Group Modified", nodeGroup.getNodeGroupId());
            } else {
                for (NodeGroup nodeGroup : this.itemSet) {
                    R.a descriptionField = (R.a)this.advancedFieldList.get(0);
                    Checkbox checkbox = descriptionField.getCheckbox();
                    if (checkbox != null && ((Boolean)checkbox.getValue()).booleanValue()) {
                        nodeGroup.setDescription(descriptionField.getField().getValue().toString());
                    }
                    nodeGroup.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    configService.saveNodeGroup(nodeGroup);
                }
                this.addEvent("Group Modified", this.itemSet.stream().map(NodeGroup::getNodeGroupId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void groupIdWarning() {
        aa dialog = new aa(this.controller, "Group Id Error", null, "Group Id cannot be modified. Group has a group link");
        dialog.setHeight("20em");
        dialog.show();
    }

    @Override
    public void delete() {
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        for (NodeGroup nodeGroup : this.itemSet) {
            configService.deleteNodeGroup(nodeGroup.getNodeGroupId());
        }
        this.addEvent("Group Deleted", this.itemSet.stream().map(NodeGroup::getNodeGroupId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("nodeGroupId");
        orderedFields.add("description");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "nodeGroupId";
    }

    @Override
    public String getHelpSectionName() {
        return "_groups";
    }
}

