/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.hb;
import com.jumpmind.symmetric.console.model.ConsoleRole;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class U
extends R<ConsoleRole> {
    private static final long serialVersionUID = 1L;
    private String originalId;

    public U(I controller, Set<ConsoleRole> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((ConsoleRole)this.itemSet.iterator().next()).getRoleId();
        }
        this.binder = new Binder(ConsoleRole.class);
        TextField roleId = new TextField();
        roleId.setId("roleId");
        this.binder.forField((HasValue)roleId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Role Id")).bind("roleId");
        roleId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)roleId, this.controller.getMessage("Role Id", new Object[0])));
        TextField roleDescription = new TextField();
        roleDescription.setId("roleDescription");
        this.binder.forField((HasValue)roleDescription).withValidator((SerializablePredicate & Serializable)value -> !value.equals(roleDescription.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Role Description")).bind("roleDescription");
        roleDescription.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)roleDescription, this.controller.getMessage("Role Description", new Object[0])));
        hb roleHierarchyUtils = new hb(this.controller.getConsoleUserService());
        List<String> roleIds = roleHierarchyUtils.a();
        if (this.originalId != null || this.isBulk) {
            for (ConsoleRole role : this.itemSet) {
                roleIds.remove(role.getRoleId());
                roleIds.removeAll(roleHierarchyUtils.e(role.getRoleId()));
            }
        }
        Collections.sort(roleIds, String.CASE_INSENSITIVE_ORDER);
        Select parentRoleId = new Select();
        parentRoleId.setItems(roleIds);
        parentRoleId.setEmptySelectionAllowed(true);
        parentRoleId.setId("parentRoleId");
        this.binder.forField((HasValue)parentRoleId).bind("parentRoleId");
        this.fieldList.add(new R.a((HasValue<?, ?>)parentRoleId, this.controller.getMessage("Parent Role Id", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        this.newItem = new ConsoleRole("", "");
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            if (!this.isBulk) {
                ConsoleRole role;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((ConsoleRole)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((ConsoleRole)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    role = saveAsCopy ? (ConsoleRole)this.newItem : (ConsoleRole)this.itemSet.iterator().next();
                } else {
                    try {
                        this.binder.writeBean((Object)((ConsoleRole)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    role = (ConsoleRole)this.newItem;
                }
                this.updateConsoleRole(role, saveAsCopy);
                this.addEvent(this.newItemFlag ? "Console Role Created" : "Console Role Modified", role.getRoleId());
            } else {
                for (ConsoleRole role : this.itemSet) {
                    for (R.a formField : this.fieldList) {
                        HasValue<?, ?> field = formField.getField();
                        Checkbox checkbox = formField.getCheckbox();
                        if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component) || ((Component)field).getId().orElse(null) != "roleDescription") continue;
                        role.setRoleDescription((String)field.getValue());
                        break;
                    }
                    this.updateConsoleRole(role, saveAsCopy);
                }
                this.addEvent("Console Role Modified", this.itemSet.stream().map(ConsoleRole::getRoleId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    protected void updateConsoleRole(ConsoleRole role, boolean saveAsCopy) {
        IConsoleUserService userService = this.controller.getConsoleUserService();
        role.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        if (role.getCreateTime() == null) {
            role.setCreateTime(new Date());
        }
        if (saveAsCopy) {
            userService.saveAsCopy(this.originalId, role);
        } else if (this.isBulk || this.newItemFlag || this.originalId == null || this.originalId.equals(role.getRoleId())) {
            userService.save(role);
        } else {
            userService.rename(this.originalId, role);
        }
    }

    @Override
    public void delete() {
        IConsoleUserService userService = this.controller.getConsoleUserService();
        for (ConsoleRole role : this.itemSet) {
            userService.delete(role);
        }
        this.addEvent("Console Role Deleted", this.itemSet.stream().map(ConsoleRole::getRoleId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("roleId");
        orderedFields.add("roleDescription");
        orderedFields.add("parentRoleId");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "roleId";
    }

    @Override
    public String getHelpSectionName() {
        return "_roles";
    }
}

