/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.authentication;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.Collections;
import org.json.JSONObject;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OAuth2Servlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    IParameterService parameterService;
    ISymmetricEngine engine;
    private String oAuth2ClientID;
    private String oAuth2ClientSecret;
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String endpointName;
        this.engine = ServletUtils.findEngine((HttpServletRequest)request, (ServletContext)this.getServletContext());
        this.parameterService = this.engine.getParameterService();
        this.oAuth2ClientID = this.parameterService.getString("console.auth.oauth2.client.id");
        if (this.oAuth2ClientID != null && this.oAuth2ClientID.startsWith("enc:")) {
            this.oAuth2ClientID = this.engine.getSecurityService().decrypt(this.oAuth2ClientID.substring("enc:".length()));
        }
        this.oAuth2ClientSecret = this.parameterService.getString("console.auth.oauth2.client.secret");
        if (this.oAuth2ClientSecret != null && this.oAuth2ClientSecret.startsWith("enc:")) {
            this.oAuth2ClientSecret = this.engine.getSecurityService().decrypt(this.oAuth2ClientSecret.substring("enc:".length()));
        }
        if ((endpointName = ServletUtils.getEndpointNameFromUrl((HttpServletRequest)request)) != null && endpointName.equals("sso")) {
            this.handleSsoEndpoint(request, response, this.engine);
        }
    }

    private String callback(String code, HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap tokenRequest = new LinkedMultiValueMap();
        tokenRequest.add((Object)"code", (Object)code);
        tokenRequest.add((Object)"client_id", (Object)this.oAuth2ClientID);
        tokenRequest.add((Object)"client_secret", (Object)this.oAuth2ClientSecret);
        String redirectUri = this.engine.getSyncUrl().replace("sync", "openid") + "/sso";
        tokenRequest.add((Object)"redirect_uri", (Object)redirectUri);
        tokenRequest.add((Object)"grant_type", (Object)"authorization_code");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity tokenEntity = new HttpEntity((Object)tokenRequest, (MultiValueMap)headers);
        String tokenURL = this.parameterService.getString("console.auth.oauth2.token.endpoint");
        ResponseEntity tokenResponse = restTemplate.exchange(tokenURL, HttpMethod.POST, tokenEntity, String.class, new Object[0]);
        String tokenResponseBody = (String)tokenResponse.getBody();
        JSONObject jsonResponse = new JSONObject(tokenResponseBody);
        String idToken = jsonResponse.getString("id_token");
        request.getSession().setAttribute("id_token", (Object)idToken);
        String[] parts = idToken.split("\\.");
        String json = new String(Base64.getUrlDecoder().decode(parts[1]));
        return json;
    }

    private void setRoles(JsonObject callback, HttpServletRequest request) {
        String[] roles = null;
        if (callback.get("roles") != null) {
            JsonArray jsonRoles = callback.get("roles").getAsJsonArray();
            roles = new String[jsonRoles.size()];
            for (int i2 = 0; i2 < jsonRoles.size(); ++i2) {
                roles[i2] = jsonRoles.get(i2).getAsString();
            }
        }
        if (roles != null) {
            request.getSession().setAttribute("roles", roles);
        }
    }

    private void setSessionAttribute(JsonObject callback, HttpServletRequest request, String name) {
        if (callback.get(name) != null) {
            String value = callback.get(name).getAsString();
            request.getSession().setAttribute(name, (Object)value);
        }
    }

    private void handleSsoEndpoint(HttpServletRequest request, HttpServletResponse response, ISymmetricEngine engine) throws IOException {
        String providerCallbackString;
        String decodedAuthorizationCode = URLDecoder.decode(ServletUtils.getParameter((HttpServletRequest)request, (String)"code"), "UTF-8");
        if (decodedAuthorizationCode == null) {
            decodedAuthorizationCode = "null";
        }
        if ((providerCallbackString = this.callback(decodedAuthorizationCode, request)) == null) {
            this.log.error("No token was returned from the OAuth 2.0/OpenID Connect Provider.");
            return;
        }
        JsonObject providerCallbackJson = JsonParser.parseString((String)providerCallbackString).getAsJsonObject();
        this.setSessionAttribute(providerCallbackJson, request, "aud");
        this.setSessionAttribute(providerCallbackJson, request, "exp");
        this.setSessionAttribute(providerCallbackJson, request, "sub");
        this.setSessionAttribute(providerCallbackJson, request, "iss");
        this.setRoles(providerCallbackJson, request);
        String username = null;
        if (providerCallbackJson.get("preferred_username") != null) {
            username = providerCallbackJson.get("preferred_username").getAsString();
        } else if (providerCallbackJson.get("email") != null) {
            username = providerCallbackJson.get("email").getAsString();
        } else if (providerCallbackJson.get("name") != null) {
            username = providerCallbackJson.get("name").getAsString();
        }
        request.getSession().setAttribute("username", (Object)username);
        if (!response.isCommitted()) {
            response.sendRedirect("/app");
        }
    }
}

