/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class TraceTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/services/psk/TraceTreeCellRenderer.java, jms, j600, j600-201-061220 1.4.1.1 05/05/25 15:11:17";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean selected;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon entryIcon;
    protected transient Icon exitIcon;
    protected transient Icon threadIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public TraceTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"), true);
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.textSelectionColor"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textNonSelectionColor"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.backgroundSelectionColor"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.backgroundNonSelectionColor"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.borderSelectionColor"));
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultLeafIcon() {
        return this.leafIcon;
    }

    public Icon getDefaultOpenIcon() {
        return this.openIcon;
    }

    public Icon getEntryIcon() {
        return this.entryIcon;
    }

    public Icon getExitIcon() {
        return this.exitIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public Icon getThreadIcon() {
        return this.threadIcon;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setFont(jTree.getFont());
        this.setText(string);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        String string2 = ((DefaultMutableTreeNode)object).toString();
        if (string2.indexOf("entry") > -1) {
            this.setIcon(this.getEntryIcon());
        } else if (string2.indexOf("exit") > -1) {
            this.setIcon(this.getExitIcon());
        } else if (string2.indexOf("Thread") > -1 && (string2.indexOf("created") > -1 || string2.indexOf("interupted") > -1)) {
            this.setIcon(this.getThreadIcon());
        } else if (bl3) {
            this.setIcon(this.getLeafIcon());
        } else if (bl2) {
            this.setForeground(Color.blue);
            this.setIcon(this.getOpenIcon());
        } else {
            this.setForeground(Color.blue);
            this.setIcon(this.getClosedIcon());
        }
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        if (color != null) {
            Icon icon = this.getIcon();
            graphics.setColor(color);
            if (icon != null && this.getText() != null) {
                int n = icon.getIconWidth() + this.getIconTextGap();
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
        if (this.selected) {
            graphics.setColor(this.getBorderSelectionColor());
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(graphics);
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public void setEntryIcon(Icon icon) {
        this.entryIcon = icon;
    }

    public void setExitIcon(Icon icon) {
        this.exitIcon = icon;
    }

    public void setLeafIcon(Icon icon, boolean bl) {
        this.leafIcon = icon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public void setThreadIcon(Icon icon) {
        this.threadIcon = icon;
    }
}

