/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.CommandLineParser;
import com.ibm.mq.jms.services.psk.FileLogServiceProvider;
import com.ibm.mq.jms.services.psk.InvalidCommandLineArgument;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import com.ibm.mq.jms.services.psk.MessageCatalogue;
import com.ibm.mq.jms.services.psk.NLSServices;
import com.ibm.mq.jms.services.psk.PSK;
import com.ibm.mq.jms.services.psk.PrintWriterLogServiceProvider;
import com.ibm.mq.jms.services.psk.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogFormatter {
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/services/psk/LogFormatter.java, jms, j600, j600-201-061220 1.5.1.1 05/05/25 15:11:02";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private File inputFile = null;
    private File outputFile = null;
    private RandomAccessFile randAccess = null;
    private RandomAccessFile randAccessOut = null;
    private FileInputStream fileInputStream = null;
    private ObjectInputStream unformattedIn = null;
    private FileOutputStream fileOutputStream = null;
    private PrintWriter printWriter = null;
    private PrintWriterLogServiceProvider formattedOut = null;
    private boolean msgNmbrFilter = false;
    private boolean dateFilter = false;
    private Date startDate;
    private Date stopDate;
    private int startMsgNmbr = 0;
    private int stopMsgNmbr = 0;
    private static String NoInputFile;
    private static String FileHeaderCorrupted;
    private static String NoMoreMessages;
    private static String WrappingThrough;
    private static String NoMessageCatalogue;
    private static String LatestMessageReached;
    private MessageCatalogue[] messageCatalogue = null;
    private long numberOfMessages = 0L;
    private long latestMessage = 0L;
    private Date msgDate;
    private String msgNumber;

    public LogFormatter(File file, File file2, MessageCatalogue[] messageCatalogueArray) throws IOException {
        Trace.entry(this, "LogFormatter");
        Trace.trace(2, this, sccsid);
        this.inputFile = file;
        this.outputFile = file2;
        if (messageCatalogueArray == null) {
            throw new IOException(NoMessageCatalogue);
        }
        this.messageCatalogue = messageCatalogueArray;
        if (!this.inputFile.exists()) {
            throw new IOException(NoInputFile + this.inputFile.getName());
        }
        Trace.exit(this, "LogFormatter");
    }

    private void closeLogFiles() throws IOException {
        Trace.entry(this, "closeLogFiles");
        this.unformattedIn.close();
        this.fileInputStream.close();
        this.randAccess.close();
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
        }
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        this.formattedOut.closeLog();
        Trace.exit(this, "closeLogFiles");
    }

    public void format() throws IOException, ClassNotFoundException, LogException {
        Trace.entry(this, "format");
        LogMessage logMessage = null;
        int n = 0;
        this.openLogFiles();
        this.randAccess.seek(this.latestMessage);
        this.randAccess.seek(this.latestMessage + this.unformattedIn.readLong() + 10L);
        boolean bl = false;
        while (!bl) {
            block17: {
                try {
                    logMessage = this.readLogMessage();
                }
                catch (IOException iOException) {
                    if (iOException.getLocalizedMessage().equals(NoMoreMessages)) {
                        Trace.trace(2, this, "noMoreMessages");
                        this.randAccess.seek(100L);
                        try {
                            logMessage = this.readLogMessage();
                        }
                        catch (IOException iOException2) {
                            if (iOException2.getLocalizedMessage().equals(LatestMessageReached)) {
                                logMessage = this.readLatestLogMessage();
                                bl = true;
                            }
                            break block17;
                        }
                    }
                    if (iOException.getLocalizedMessage().equals(WrappingThrough)) {
                        Trace.trace(2, this, "wrapping");
                        this.randAccess.seek(100L);
                        try {
                            logMessage = this.readLogMessage();
                        }
                        catch (IOException iOException3) {
                            if (iOException3.getLocalizedMessage().equals(LatestMessageReached)) {
                                logMessage = this.readLatestLogMessage();
                                bl = true;
                            }
                            break block17;
                        }
                    }
                    if (iOException.getLocalizedMessage().equals(LatestMessageReached)) {
                        Trace.trace(2, this, "latest message reached");
                        logMessage = this.readLatestLogMessage();
                        bl = true;
                    }
                    throw new IOException(iOException.getLocalizedMessage());
                }
            }
            if (this.msgNmbrFilter && !this.dateFilter) {
                Trace.trace(2, this, "filter for message numbers active");
                this.msgNumber = logMessage.getKey();
                while (!Character.isDigit(this.msgNumber.charAt(0))) {
                    this.msgNumber = this.msgNumber.substring(1);
                }
                n = new Integer(this.msgNumber);
                if (n < this.startMsgNmbr || n > this.stopMsgNmbr) continue;
                this.writeMessage(logMessage);
                continue;
            }
            if (this.dateFilter && !this.msgNmbrFilter) {
                Trace.trace(2, this, "filter for date active");
                this.msgDate = logMessage.getDate();
                if ((!this.msgDate.after(this.startDate) || !this.msgDate.before(this.stopDate)) && !this.msgDate.equals(this.startDate) && !this.msgDate.equals(this.stopDate)) continue;
                this.writeMessage(logMessage);
                continue;
            }
            if (this.dateFilter && this.msgNmbrFilter) {
                Trace.trace(2, this, "filters for message numbers and dates active");
                this.msgNumber = logMessage.getKey();
                while (!Character.isDigit(this.msgNumber.charAt(0))) {
                    this.msgNumber = this.msgNumber.substring(1);
                }
                n = new Integer(this.msgNumber);
                this.msgDate = logMessage.getDate();
                if (n < this.startMsgNmbr || n > this.stopMsgNmbr || (!this.msgDate.after(this.startDate) || !this.msgDate.before(this.stopDate)) && !this.msgDate.equals(this.startDate) && !this.msgDate.equals(this.stopDate)) continue;
                this.writeMessage(logMessage);
                continue;
            }
            Trace.trace(2, this, "no active filters");
            this.writeMessage(logMessage);
        }
        this.closeLogFiles();
        Trace.exit(this, "format");
    }

    public static void main(String[] stringArray) {
        Object object;
        Object[] objectArray;
        CommandLineParser commandLineParser = new CommandLineParser();
        commandLineParser.setOptions("src,tgt,cat,trace,t");
        commandLineParser.setFlags("trace,t");
        try {
            commandLineParser.parseCommandLine(stringArray);
        }
        catch (InvalidCommandLineArgument invalidCommandLineArgument) {
            System.out.println(PSK.getPSKMessage("LFusage", "USAGE: java LogFormatter -src logFile [-tgt outFile] -cat \"cat1,cat2,cat3,...\""));
            return;
        }
        if (commandLineParser.isOptionSet("trace") || commandLineParser.isOptionSet("t") || commandLineParser.isFlagSet("trace") || commandLineParser.isFlagSet("t")) {
            Trace.turnTracingOn(3);
        }
        Trace.entry("LogFormatter", "main");
        if (!commandLineParser.isOptionSet("src") || !commandLineParser.isOptionSet("cat")) {
            Trace.trace(0, "LogFormatter", "Missing command line argument(s)");
            System.out.println(PSK.getPSKMessage("LFusage", "USAGE: java LogFormatter -src logFile [-tgt outFile] -cat \"cat1,cat2,cat3,...\""));
            return;
        }
        File file = new File(commandLineParser.getOption("src"));
        File file2 = null;
        if (commandLineParser.isOptionSet("tgt")) {
            file2 = new File(commandLineParser.getOption("tgt"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(commandLineParser.getOption("cat"), ",");
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            Trace.trace(3, "LogFormatter", "Looking for catalogue: " + (String)objectArray);
            try {
                object = NLSServices.getMessageCatalogue((String)objectArray);
                vector.addElement(object);
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(PSK.getPSKMessage("missingCatalogue", (String)objectArray, "Unable to locate message catalogue: " + (String)objectArray));
                return;
            }
        }
        objectArray = new MessageCatalogue[vector.size()];
        vector.copyInto(objectArray);
        try {
            object = new LogFormatter(file, file2, (MessageCatalogue[])objectArray);
            ((LogFormatter)object).format();
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals(NoInputFile)) {
                System.out.println(PSK.getPSKMessage("noSuchFile", commandLineParser.getOption("src"), "No such file: " + commandLineParser.getOption("src")));
            } else {
                System.out.println(PSK.getPSKMessage("unexpectedError", iOException.getMessage(), "An unexpected error occurred whilst processing the log file: " + iOException.getMessage()));
            }
        }
        catch (LogException logException) {
            Trace.trace(0, "LogFormatter", logException.getMessage());
            System.out.println(PSK.getPSKMessage("headerCorrupted", "The binary log file is corrupted."));
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(PSK.getPSKMessage("classLoad", classNotFoundException.getMessage(), "Unable to load class: " + classNotFoundException.getMessage()));
        }
        Trace.exit("LogFormatter", "main");
    }

    private void openLogFiles() throws IOException, ClassNotFoundException, LogException {
        Trace.entry(this, "openLogFiles");
        this.randAccess = new RandomAccessFile(this.inputFile, "r");
        this.fileInputStream = new FileInputStream(this.randAccess.getFD());
        this.unformattedIn = new ObjectInputStream(this.fileInputStream);
        this.randAccess.seek(16L);
        this.unformattedIn.readBoolean();
        this.latestMessage = this.unformattedIn.readLong();
        this.numberOfMessages = this.unformattedIn.readLong();
        Trace.trace(2, this, "openLogFiles - numberOfMessages : " + this.numberOfMessages);
        this.unformattedIn.readLong();
        this.unformattedIn.readBoolean();
        this.randAccess.seek(100L);
        if (this.outputFile != null) {
            if (this.outputFile.exists()) {
                this.outputFile.delete();
            }
            this.randAccessOut = new RandomAccessFile(this.outputFile, "rw");
            this.fileOutputStream = new FileOutputStream(this.randAccessOut.getFD());
            this.printWriter = new PrintWriter(this.fileOutputStream, true);
            this.formattedOut = new PrintWriterLogServiceProvider("LogFormatter", this.printWriter);
        } else {
            this.printWriter = new PrintWriter(System.out);
            this.formattedOut = new PrintWriterLogServiceProvider("LogFormatter", this.printWriter);
        }
        this.formattedOut.setLogCatalogueSearchOrder(this.messageCatalogue);
        Trace.exit(this, "openLogFiles");
    }

    private LogMessage readLatestLogMessage() throws IOException, ClassNotFoundException {
        LogMessage logMessage = (LogMessage)this.unformattedIn.readObject();
        return logMessage;
    }

    private LogMessage readLogMessage() throws IOException, ClassNotFoundException {
        Trace.entry(this, "readLogMessage");
        long l = 0L;
        long l2 = this.unformattedIn.readLong();
        Trace.trace(3, this, "readLogMessage - pointer to next message : " + l2);
        this.randAccess.seek(l2);
        long l3 = this.randAccess.getFilePointer();
        l = this.unformattedIn.readLong();
        if (l == FileLogServiceProvider.m_messageEmpty) {
            throw new IOException(NoMoreMessages);
        }
        if (l == FileLogServiceProvider.m_wrapAround) {
            throw new IOException(WrappingThrough);
        }
        if (l3 == this.latestMessage) {
            throw new IOException(LatestMessageReached);
        }
        LogMessage logMessage = (LogMessage)this.unformattedIn.readObject();
        this.randAccess.seek(l3 + l + 10L);
        Trace.exit(this, "readLogMessages");
        return logMessage;
    }

    public void setDateFilter(Date date, Date date2) {
        Trace.entry(this, "setDateFilter");
        this.startDate = date;
        this.stopDate = date2;
        Trace.exit(this, "setDateFilter");
    }

    public void setDateFilterActive(boolean bl) {
        Trace.entry(this, "setDateFilterActive");
        this.dateFilter = bl;
        Trace.exit(this, "setDateFilterActive");
    }

    public void setMsgNmbrFilter(int n, int n2) {
        Trace.entry(this, "setmsgNmbrFilter");
        this.startMsgNmbr = n;
        this.stopMsgNmbr = n2;
        Trace.exit(this, "setmsgNmbrFilter");
    }

    public void setMsgNmbrFilterActive(boolean bl) {
        Trace.entry(this, "setmsgNmbrFilterActive");
        this.msgNmbrFilter = bl;
        Trace.exit(this, "setmsgNmbrFilterActive");
    }

    private void writeMessage(LogMessage logMessage) throws IOException {
        Trace.entry(this, "writeMessage");
        Trace.trace(3, this, "\nKey       : " + logMessage.getKey() + "\nLevel     : " + logMessage.getLevel() + "Date      : " + logMessage.getDate());
        Object[] objectArray = logMessage.getInserts();
        if (objectArray != null) {
            Trace.trace(3, this, "Inserts   : " + objectArray[0]);
        }
        this.formattedOut.log(logMessage);
        this.formattedOut.logExplanation(logMessage);
        Trace.exit(this, "writeMessage");
    }

    static {
        PSK.validateRunTimeLicence();
        NoInputFile = "The given input file does not exist : ";
        FileHeaderCorrupted = "The file header is corrupted !";
        NoMoreMessages = "No more messages left in the file !";
        WrappingThrough = "Wrappin through the file !";
        NoMessageCatalogue = "Message catalogue is missing !";
        LatestMessageReached = "Latest Message reached !";
    }
}

