/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.ibm.mq.jms.MQXAQueueConnectionFactory;
import com.ibm.mq.jms.MQXATopicConnectionFactory;
import com.ibm.mq.jms.admin.AdminObject;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class AdminService {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/AdminService.java, jms, j600, j600-201-061220 1.38.1.1 05/05/25 15:48:11";
    private static final String CLASSNAME = "com.ibm.mq.jms.admin.AdminService";
    private static final int SYSTEM_NONE = -1;
    private static final int SYSTEM_FS = 0;
    private static final int SYSTEM_LDAP = 1;
    private static final int SYSTEM_WEBSPHERE = 2;
    private static final String DEFAULT_PREFIX = "cn=";
    static final int AUTH_NONE = 0;
    static final int AUTH_SIMPLE = 1;
    static final int AUTH_CRAM_MD5 = 2;
    static final String CTX_INIT = "=INIT";
    static final String CTX_UP = "=UP";
    protected boolean active = false;
    protected Context ictx = null;
    protected Context cctx = null;
    private String cctxString = null;
    private Vector parentChain = null;
    private Vector parentChainString = null;
    private String initialContextFactory = null;
    private String providerURL = null;
    private int authentication = 0;
    protected Hashtable properties;
    protected static final String USE_INITIAL_DIR_CONTEXT = "USE_INITIAL_DIR_CONTEXT";
    protected static final String NAME_PREFIX = "NAME_PREFIX";
    protected static final String NAME_READABILITY = "NAME_READABILITY_MARKER";
    protected static final String ICF_CONFIG_TRUE = "TRUE";
    protected static final String ICF_CONFIG_FALSE = "FALSE";

    AdminService(String string, String string2, String string3, Hashtable hashtable) throws JMSSecurityException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.properties = hashtable;
        this.initialContextFactory = string;
        this.providerURL = string2;
        if (string3.toUpperCase().equals("NONE")) {
            this.authentication = 0;
        } else if (string3.toUpperCase().equals("SIMPLE")) {
            this.authentication = 1;
        } else if (string3.toUpperCase().equals("CRAM_MD5") || string3.toUpperCase().equals("CRAM-MD5")) {
            this.authentication = 2;
        } else {
            this.authentication = 0;
            if (Trace.isOn) {
                Trace.exit(this, "constructor - invalid authentication, defaulting to none");
            }
            throw new JMSSecurityException(ConfigEnvironment.getMessage("MQJMS4139"));
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    void initJNDI(String string, String string2) throws NamingException, JMSException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "initJNDI");
        }
        if (!this.active) {
            Hashtable hashtable = (Hashtable)this.properties.clone();
            hashtable.put("java.naming.factory.initial", this.initialContextFactory);
            hashtable.put("java.naming.provider.url", this.providerURL);
            hashtable.put("java.naming.security.authentication", this.authentication == 0 ? "none" : (this.authentication == 1 ? "simple" : (this.authentication == 2 ? "CRAM_MD5" : null)));
            hashtable.put("java.naming.referral", "throw");
            if (this.needsAuthorization()) {
                hashtable.put("java.naming.security.principal", string);
                hashtable.put("java.naming.security.credentials", string2);
            }
            try {
                this.setICFProperties();
                this.ictx = ((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE) ? new InitialDirContext(hashtable) : new InitialContext(hashtable);
            }
            catch (NamingException namingException) {
                Exception exception = (Exception)namingException.getRootCause();
                if (exception instanceof ClassNotFoundException) {
                    ClassNotFoundException classNotFoundException = (ClassNotFoundException)exception;
                    this.cctxString = ConfigEnvironment.getMessage("MQJMS4142");
                    System.out.println(this.cctxString + "\n");
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Throwing " + classNotFoundException);
                        Trace.exit(CLASSNAME, "initJNDI");
                    }
                    throw classNotFoundException;
                }
                this.cctxString = ConfigEnvironment.getMessage("MQJMS4110");
                System.out.println(this.cctxString + "\n");
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Throwing " + namingException);
                    Trace.exit(CLASSNAME, "initJNDI");
                }
                throw namingException;
            }
            this.parentChain = new Vector();
            this.parentChain.addElement(this.cctx);
            this.parentChainString = new Vector();
            this.parentChainString.addElement(ConfigEnvironment.getMessage("MQJMS4007"));
            this.cctx = this.ictx;
            this.cctxString = ConfigEnvironment.getMessage("MQJMS4007");
            this.active = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "initJNDI");
        }
    }

    boolean needsAuthorization() {
        return this.authentication != 0;
    }

    void stopJNDI() throws NamingException {
        if (Trace.isOn) {
            Trace.entry(this, "stopJNDI");
        }
        if (this.active) {
            try {
                this.ictx.close();
                this.active = false;
                this.parentChain = null;
                this.ictx = null;
                this.cctx = null;
            }
            catch (NamingException namingException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + namingException);
                    Trace.exit(this, "stopJNDI");
                }
                throw namingException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "stopJNDI");
        }
    }

    AdminObject get(String string) throws NamingException, JMSException {
        int n;
        String string2;
        if (Trace.isOn) {
            Trace.entry(this, "get");
        }
        if (!this.active) {
            JMSException jMSException = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "get");
            }
            throw jMSException;
        }
        Object object = null;
        try {
            string2 = string;
            if (this.properties.get(NAME_PREFIX) != null && !string2.startsWith((String)this.properties.get(NAME_PREFIX))) {
                string2 = this.properties.get(NAME_PREFIX) + string2;
            }
            object = this.cctx.lookup(string2);
        }
        catch (NamingException namingException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "get");
            }
            throw namingException;
        }
        string2 = object.getClass().getName();
        if (string2.equals("com.ibm.ejs.jms.mq.JMSWrapXAQueueConnectionFactory")) {
            n = 6;
        } else if (string2.equals("com.ibm.ejs.jms.mq.JMSWrapXATopicConnectionFactory")) {
            n = 7;
        } else if (object instanceof MQXAQueueConnectionFactory) {
            n = 4;
        } else if (object instanceof MQXATopicConnectionFactory) {
            n = 5;
        } else if (object instanceof MQXAConnectionFactory) {
            n = 9;
        } else if (object instanceof MQQueueConnectionFactory) {
            n = 0;
        } else if (object instanceof MQQueue) {
            n = 1;
        } else if (object instanceof MQTopicConnectionFactory) {
            n = 2;
        } else if (object instanceof MQTopic) {
            n = 3;
        } else if (object instanceof MQConnectionFactory) {
            n = 8;
        } else {
            String string3 = null;
            if (object instanceof Reference) {
                string3 = ((Reference)object).getClassName();
            }
            JMSException jMSException = string3 != null && string3.startsWith("com.ibm.ejs") ? new JMSException(ConfigEnvironment.getMessage("MQJMS4137")) : new JMSException(ConfigEnvironment.getMessage("MQJMS4106"));
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "get");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "get");
        }
        return new AdminObject(n, object, string);
    }

    Vector getContents() throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getContents");
        }
        if (!this.active) {
            JMSException jMSException = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "getContents");
            }
            throw jMSException;
        }
        Vector<String> vector = new Vector<String>();
        NamingEnumeration<NameClassPair> namingEnumeration = null;
        try {
            namingEnumeration = this.cctx.list("");
            while (namingEnumeration.hasMore()) {
                int n;
                NameClassPair nameClassPair = namingEnumeration.next();
                String string = nameClassPair.getClassName();
                String string2 = nameClassPair.getName();
                if (this.properties.get(NAME_READABILITY) != null && (n = string2.indexOf((String)this.properties.get(NAME_READABILITY))) != -1) {
                    string2 = string2.substring(0, n);
                }
                vector.addElement(string);
                vector.addElement(string2);
            }
        }
        catch (NamingException namingException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "getContents");
            }
            throw namingException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getContents");
        }
        return vector;
    }

    void bind(String string, AdminObject adminObject) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "bind");
        }
        if (!this.active) {
            JMSException jMSException = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "bind");
            }
            throw jMSException;
        }
        if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
            BasicAttributes basicAttributes = new BasicAttributes();
            basicAttributes.put("objectclass", "javaContainer");
            basicAttributes.put("cn", string);
            try {
                String string2 = string;
                if (this.properties.get(NAME_PREFIX) != null && !string2.startsWith((String)this.properties.get(NAME_PREFIX))) {
                    string2 = this.properties.get(NAME_PREFIX) + string2;
                }
                ((DirContext)this.cctx).bind(string2, adminObject.getObject(), (Attributes)basicAttributes);
            }
            catch (NamingException namingException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + namingException);
                    Trace.exit(this, "get");
                }
                throw namingException;
            }
        }
        try {
            this.cctx.bind(string, adminObject.getObject());
        }
        catch (NamingException namingException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "bind");
            }
            throw namingException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "bind");
        }
    }

    void rebind(String string, AdminObject adminObject) throws NamingException, JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "rebind");
        }
        if (!this.active) {
            object = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.exception(this, "rebind", (Throwable)object);
                Trace.exit(this, "rebind");
            }
        }
        if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
            object = new BasicAttributes();
            ((BasicAttributes)object).put("objectclass", "javaContainer");
            ((BasicAttributes)object).put("cn", string);
            try {
                String string2 = string;
                if (this.properties.get(NAME_PREFIX) != null && !string2.startsWith((String)this.properties.get(NAME_PREFIX))) {
                    string2 = this.properties.get(NAME_PREFIX) + string2;
                }
                ((DirContext)this.cctx).rebind(string2, adminObject.getObject(), (Attributes)object);
            }
            catch (NamingException namingException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + namingException);
                    Trace.exit(this, "rebind");
                }
                throw namingException;
            }
        }
        try {
            this.cctx.rebind(string, adminObject.getObject());
        }
        catch (NamingException namingException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "rebind");
            }
            throw namingException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "rebind");
        }
    }

    void unbind(String string) throws NamingException, JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "unbind");
        }
        if (!this.active) {
            object = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.exception(this, "unbind", (Throwable)object);
                Trace.exit(this, "unbind");
            }
        }
        try {
            object = string;
            if (this.properties.get(NAME_PREFIX) != null && !((String)object).startsWith((String)this.properties.get(NAME_PREFIX))) {
                object = this.properties.get(NAME_PREFIX) + (String)object;
            }
            this.cctx.unbind((String)object);
        }
        catch (NamingException namingException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "unbind");
            }
            throw namingException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "unbind");
        }
    }

    void mkContext(String string) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "mkContext");
        }
        if (!this.active) {
            JMSException jMSException = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "mkContext");
            }
            throw jMSException;
        }
        try {
            if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                String string2 = string;
                if (string2.indexOf("=") == -1) {
                    string2 = this.properties.get(NAME_PREFIX) != null ? this.properties.get(NAME_PREFIX) + string : DEFAULT_PREFIX + string;
                }
                try {
                    ((DirContext)this.cctx).createSubcontext(string2, (Attributes)new BasicAttributes("objectclass", "top"));
                }
                catch (NamingException namingException) {
                    this.cctx.createSubcontext(string2);
                }
            } else if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_FALSE)) {
                this.cctx.createSubcontext(string);
            }
        }
        catch (NamingException namingException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "mkContext");
            }
            throw namingException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "mkContext");
        }
    }

    void rmContext(String string) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "rmContext");
        }
        if (!this.active) {
            JMSException jMSException = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "rmContext");
            }
            throw jMSException;
        }
        String string2 = string;
        Context context = null;
        try {
            context = (Context)this.cctx.lookup(string);
        }
        catch (ClassCastException classCastException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + classCastException);
                Trace.exit(this, "rmContext");
            }
            throw classCastException;
        }
        catch (NamingException namingException) {
            if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                try {
                    string2 = this.properties.get(NAME_PREFIX) != null ? this.properties.get(NAME_PREFIX) + string : DEFAULT_PREFIX + string;
                    context = (Context)this.cctx.lookup(string2);
                }
                catch (NamingException namingException2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + namingException2);
                        Trace.exit(this, "rmContext");
                    }
                    throw namingException2;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "rmContext");
            }
            throw namingException;
        }
        try {
            this.cctx.destroySubcontext(string2);
        }
        catch (NamingException namingException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + namingException);
                Trace.exit(this, "rmContext");
            }
            throw namingException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "rmContext");
        }
    }

    void chContext(String string) throws NamingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "chContext");
        }
        if (!this.active) {
            JMSException jMSException = new JMSException(ConfigEnvironment.getMessage("MQJMS4104"));
            if (Trace.isOn) {
                Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "chContext");
            }
            throw jMSException;
        }
        if (string.toUpperCase().equals(CTX_INIT)) {
            this.cctx = this.ictx;
            this.cctxString = ConfigEnvironment.getMessage("MQJMS4007");
            this.parentChain = new Vector();
            this.parentChain.addElement(this.cctx);
            this.parentChainString = new Vector();
            this.parentChainString.addElement(ConfigEnvironment.getMessage("MQJMS4007"));
        } else if (string.toUpperCase().equals(CTX_UP)) {
            if (!this.cctx.equals(this.ictx)) {
                this.cctx = (Context)this.parentChain.elementAt(0);
                this.cctxString = (String)this.parentChainString.elementAt(0);
                this.parentChain.removeElementAt(0);
                this.parentChainString.removeElementAt(0);
            }
        } else {
            try {
                if (string.length() == 0 || string.equals(".") || string.equals("..")) {
                    JMSException jMSException = new JMSException("null context");
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
                        Trace.exit(this, "chContext");
                    }
                    throw jMSException;
                }
                Context context = this.cctx;
                this.cctx = (Context)this.cctx.lookup(string);
                this.parentChain.insertElementAt(context, 0);
                this.parentChainString.insertElementAt(string, 0);
            }
            catch (NamingException namingException) {
                if (((String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                    try {
                        String string2 = (String)this.properties.get(NAME_PREFIX);
                        if (string2 == null) {
                            string2 = DEFAULT_PREFIX;
                        }
                        Context context = this.cctx;
                        this.cctx = (Context)this.cctx.lookup(string2 + string);
                        this.parentChain.insertElementAt(context, 0);
                        this.parentChainString.insertElementAt(string2 + string, 0);
                    }
                    catch (NamingException namingException2) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Throwing " + namingException2);
                            Trace.exit(this, "chContext");
                        }
                        throw namingException2;
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + namingException);
                    Trace.exit(this, "chContext");
                }
                throw namingException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "chContext");
        }
    }

    boolean isActive() {
        if (Trace.isOn) {
            Trace.entry(this, "isActive");
        }
        if (Trace.isOn) {
            Trace.exit(this, "isActive");
        }
        return this.active;
    }

    String getCctxString() {
        if (Trace.isOn) {
            Trace.entry(this, "getCctxString");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getCctxString");
        }
        return this.cctxString;
    }

    String getPathString() {
        if (Trace.isOn) {
            Trace.entry(this, "getPathString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.parentChainString.size() - 1; i >= 0; --i) {
            if (i != this.parentChainString.size() - 1) {
                stringBuffer.append("/");
            }
            stringBuffer.append((String)this.parentChainString.elementAt(i));
        }
        if (Trace.isOn) {
            Trace.exit(this, "getPathString");
        }
        return new String(stringBuffer);
    }

    Context getIctx() {
        if (Trace.isOn) {
            Trace.entry(this, "getIctx");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getIctx");
        }
        return this.ictx;
    }

    String getICF() {
        if (Trace.isOn) {
            Trace.entry(this, "getICF");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getICF");
        }
        return this.initialContextFactory;
    }

    String getPURL() {
        if (Trace.isOn) {
            Trace.entry(this, "getPURL");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getPURL");
        }
        return this.providerURL;
    }

    int getAuth() {
        if (Trace.isOn) {
            Trace.entry(this, "getAuth");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getAuth");
        }
        return this.authentication;
    }

    public void setICFProperties() {
        if (Trace.isOn) {
            Trace.entry(this, "setICFProperties");
        }
        String[] stringArray = new String[]{ICF_CONFIG_TRUE, DEFAULT_PREFIX, null};
        String[] stringArray2 = new String[]{ICF_CONFIG_FALSE, null, ".."};
        String[] stringArray3 = new String[]{ICF_CONFIG_FALSE, null, null};
        String[] stringArray4 = null;
        if (this.initialContextFactory.equals("com.sun.jndi.ldap.LdapCtxFactory") || this.initialContextFactory.equals("com.ibm.jndi.LDAPCtxFactory")) {
            stringArray4 = stringArray;
        } else if (this.initialContextFactory.equals("com.sun.jndi.fscontext.RefFSContextFactory")) {
            stringArray4 = stringArray3;
        } else if (this.initialContextFactory.equals("com.ibm.ejs.ns.jndi.CNInitialContextFactory") || this.initialContextFactory.equals("com.ibm.websphere.naming.WsnInitialContextFactory") || this.initialContextFactory.equals("com.ibm.ws.naming.ldap.WsnLdapInitialContextFactory")) {
            stringArray4 = stringArray2;
        } else if (this.initialContextFactory.toUpperCase().indexOf("LDAP") > -1) {
            stringArray4 = stringArray;
        }
        if (stringArray4 != null) {
            if (this.properties.get(USE_INITIAL_DIR_CONTEXT) == null) {
                this.properties.put(USE_INITIAL_DIR_CONTEXT, stringArray4[0]);
            }
            if (this.properties.get(NAME_PREFIX) == null && stringArray4[1] != null) {
                this.properties.put(NAME_PREFIX, stringArray4[1]);
            }
            if (this.properties.get(NAME_READABILITY) == null && stringArray4[2] != null) {
                this.properties.put(NAME_READABILITY, stringArray4[2]);
            }
        } else {
            String string;
            if (this.properties.get(USE_INITIAL_DIR_CONTEXT) == null) {
                this.properties.put(USE_INITIAL_DIR_CONTEXT, ICF_CONFIG_FALSE);
            }
            if (this.properties.get(NAME_PREFIX) == null && (string = (String)this.properties.get(USE_INITIAL_DIR_CONTEXT)).toUpperCase().equals(ICF_CONFIG_TRUE)) {
                this.properties.put(NAME_PREFIX, DEFAULT_PREFIX);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "setICFProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNamePrefix() {
        if (Trace.isOn) {
            Trace.entry(this, "getNamePrefix");
        }
        try {
            String string = (String)this.properties.get(NAME_PREFIX);
            return string;
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getNamePrefix");
            }
        }
    }
}

