/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APTCM
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APTCM.java, jms, j600, j600-201-061220 1.5.1.1 05/05/25 16:04:43";
    public static final String LONGNAME = "TARGCLIENTMATCHING";
    public static final String SHORTNAME = "TCM";
    public static final String YES = "YES";
    public static final String NO = "NO";

    public static String valToString(boolean bl) throws JMSException {
        String string = bl ? YES : NO;
        return string;
    }

    public static boolean stringToVal(String string) throws BAOException {
        boolean bl;
        String string2 = string.toUpperCase();
        if (string2.equals(NO)) {
            bl = false;
        } else if (string2.equals(YES)) {
            bl = true;
        } else {
            throw new BAOException(4, SHORTNAME, string2);
        }
        return bl;
    }

    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        block13: {
            try {
                String string;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                Object object2 = APTCM.getProperty(SHORTNAME, hashtable);
                boolean bl = false;
                if (object2 == null) break block13;
                if (object2 instanceof String) {
                    string = (String)object2;
                    bl = APTCM.stringToVal(string);
                } else if (object2 instanceof Boolean) {
                    bl = (Boolean)object2;
                } else {
                    String string2 = "value supplied as an unexpected object type " + object2.getClass();
                    String string3 = "MQJMS1016";
                    String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                    JMSException jMSException = new JMSException(string4, string3);
                    throw jMSException;
                }
                if (object instanceof MQConnectionFactory) {
                    ((MQConnectionFactory)object).setTargetClientMatching(bl);
                    break block13;
                }
                string = "object supplied as an unexpected type " + object.getClass();
                String string5 = "MQJMS1016";
                String string6 = ConfigEnvironment.getErrorMessage(string5, string);
                JMSException jMSException = new JMSException(string6, string5);
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setObjectFromProperty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQConnectionFactory)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            boolean bl = ((MQConnectionFactory)object).getTargetClientMatching();
            String string = APTCM.valToString(bl);
            if (string != null) {
                hashtable.put(LONGNAME, string);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }
}

