/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APFIQ
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APFIQ.java, jms, j600, j600-201-061220 1.7.1.1 05/05/25 15:55:18";
    public static final String LONGNAME = "FAILIFQUIESCE";
    public static final String SHORTNAME = "FIQ";
    public static final String YES = "YES";
    public static final String NO = "NO";

    public static String valToString(int n) throws JMSException {
        String string = n == 1 ? YES : NO;
        return string;
    }

    public static int stringToVal(String string) throws BAOException {
        int n;
        String string2 = string.toUpperCase();
        if (string2.equals(NO)) {
            n = 0;
        } else if (string2.equals(YES)) {
            n = 1;
        } else {
            throw new BAOException(4, SHORTNAME, string2);
        }
        return n;
    }

    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        block16: {
            try {
                String string;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                Object object2 = APFIQ.getProperty(SHORTNAME, hashtable);
                int n = 0;
                if (object2 == null) break block16;
                if (object2 instanceof Integer) {
                    n = (Integer)object2;
                } else if (object2 instanceof String) {
                    string = (String)object2;
                    n = APFIQ.stringToVal(string);
                } else if (object2 instanceof Boolean) {
                    boolean bl = (Boolean)object2;
                    n = bl ? 1 : 0;
                } else {
                    String string2 = "value supplied as an unexpected object type " + object2.getClass();
                    String string3 = "MQJMS1016";
                    String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                    JMSException jMSException = new JMSException(string4, string3);
                    throw jMSException;
                }
                if (object instanceof MQConnectionFactory) {
                    ((MQConnectionFactory)object).setFailIfQuiesce(n);
                    break block16;
                }
                if (object instanceof MQDestination) {
                    ((MQDestination)object).setFailIfQuiesce(n);
                    break block16;
                }
                string = "object supplied as an unexpected type" + object.getClass();
                String string5 = "MQJMS1016";
                String string6 = ConfigEnvironment.getErrorMessage(string5, string);
                JMSException jMSException = new JMSException(string6, string5);
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setObjectFromProperty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            String string;
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (object instanceof MQConnectionFactory) {
                int n = ((MQConnectionFactory)object).getFailIfQuiesce();
                string = APFIQ.valToString(n);
            } else if (object instanceof MQDestination) {
                int n = ((MQDestination)object).getFailIfQuiesce();
                string = APFIQ.valToString(n);
            } else {
                String string2 = "object is an unexpected type";
                String string3 = "MQJMS1016";
                String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                JMSException jMSException = new JMSException(string4, string3);
                throw jMSException;
            }
            if (string != null) {
                hashtable.put(LONGNAME, string);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }
}

