/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.JMSException;

public class APCNOPT
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2004, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APCNOPT.java, jms, j600, j600-201-061220 1.5.1.1 05/05/25 15:59:51";
    public static final String LONGNAME = "CONNOPT";
    public static final String SHORTNAME = "CNOPT";
    private static final String RESTRICTQM = "RESTRICTQM";
    private static final String RESTRICTQSG = "RESTRICTQSG";
    private static final String SERIALQM = "SERIALQM";
    private static final String SERIALQSG = "SERIALQSG";
    private static final String STANDARD = "STANDARD";
    private static final String FASTPATH = "FASTPATH";
    private static final String SHARED = "SHARED";
    private static final String ISOLATED = "ISOLATED";

    public static String valToString(int n) throws JMSException {
        String string = "";
        if ((n & 8) != 0) {
            string = string + "RESTRICTQM ";
        }
        if ((n & 0x10) != 0) {
            string = string + "RESTRICTQSG ";
        }
        if ((n & 2) != 0) {
            string = string + "SERIALQM ";
        }
        if ((n & 4) != 0) {
            string = string + "SERIALQSG ";
        }
        if ((n & 1) != 0) {
            string = string + "FASTPATH ";
        }
        if ((n & 0x100) != 0) {
            string = string + "SHARED ";
        }
        if ((n & 0x200) != 0) {
            string = string + "ISOLATED ";
        }
        if (string.indexOf(FASTPATH) == -1 && string.indexOf(SHARED) == -1 && string.indexOf(ISOLATED) == -1) {
            string = string + STANDARD;
        }
        return string;
    }

    public static int stringToVal(String string) throws BAOException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(RESTRICTQM)) {
                n |= 8;
                continue;
            }
            if (string2.equals(RESTRICTQSG)) {
                n |= 0x10;
                continue;
            }
            if (string2.equals(SERIALQM)) {
                n |= 2;
                continue;
            }
            if (string2.equals(SERIALQSG)) {
                n |= 4;
                continue;
            }
            if (string2.equals(STANDARD)) {
                n |= 0;
                continue;
            }
            if (string2.equals(FASTPATH)) {
                n |= 1;
                continue;
            }
            if (string2.equals(SHARED)) {
                n |= 0x100;
                continue;
            }
            if (string2.equals(ISOLATED)) {
                n |= 0x200;
                continue;
            }
            throw new BAOException(4, SHORTNAME, string2);
        }
        return n;
    }

    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        block17: {
            try {
                String string;
                int n;
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = APCNOPT.getProperty(SHORTNAME, hashtable)) == null) break block17;
                if (object2 instanceof Integer) {
                    n = (Integer)object2;
                } else if (object2 instanceof String) {
                    string = (String)object2;
                    n = APCNOPT.stringToVal(string);
                } else {
                    String string2 = "value supplied as an unexpected object type " + object2.getClass();
                    String string3 = "MQJMS1016";
                    String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                    JMSException jMSException = new JMSException(string4, string3);
                    throw jMSException;
                }
                if (object instanceof MQConnectionFactory) {
                    try {
                        ((MQConnectionFactory)object).setMQConnectionOptions(n);
                        break block17;
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, APCNOPT.valToString(n));
                        throw bAOException;
                    }
                }
                string = "object supplied as an unexpected type " + object.getClass();
                String string5 = "MQJMS1016";
                String string6 = ConfigEnvironment.getErrorMessage(string5, string);
                JMSException jMSException = new JMSException(string6, string5);
                throw jMSException;
            }
            catch (BAOException bAOException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + bAOException);
                }
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setObjectFromProperty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQConnectionFactory)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n = ((MQConnectionFactory)object).getMQConnectionOptions();
            String string = APCNOPT.valToString(n);
            if (string != null && string != "") {
                hashtable.put(LONGNAME, string);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }
}

